/*
 * Decompiled with CFR 0.152.
 */
package javafx.geometry;

import javafx.animation.Interpolatable;
import javafx.beans.NamedArg;

public class Point3D
implements Interpolatable<Point3D> {
    public static final Point3D ZERO = new Point3D(0.0, 0.0, 0.0);
    private final double x;
    private final double y;
    private final double z;
    private int hash = 0;

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getZ() {
        return this.z;
    }

    public Point3D(@NamedArg(value="x") double d2, @NamedArg(value="y") double d3, @NamedArg(value="z") double d4) {
        this.x = d2;
        this.y = d3;
        this.z = d4;
    }

    public double distance(double d2, double d3, double d4) {
        double d5 = this.getX() - d2;
        double d6 = this.getY() - d3;
        double d7 = this.getZ() - d4;
        double d8 = d5;
        double d9 = d6;
        double d10 = d7;
        return Math.sqrt(d8 * d8 + d9 * d9 + d10 * d10);
    }

    public double distance(Point3D point3D) {
        return this.distance(point3D.getX(), point3D.getY(), point3D.getZ());
    }

    public Point3D add(double d2, double d3, double d4) {
        return new Point3D(this.getX() + d2, this.getY() + d3, this.getZ() + d4);
    }

    public Point3D add(Point3D point3D) {
        return this.add(point3D.getX(), point3D.getY(), point3D.getZ());
    }

    public Point3D subtract(double d2, double d3, double d4) {
        return new Point3D(this.getX() - d2, this.getY() - d3, this.getZ() - d4);
    }

    public Point3D subtract(Point3D point3D) {
        return this.subtract(point3D.getX(), point3D.getY(), point3D.getZ());
    }

    public Point3D multiply(double d2) {
        return new Point3D(this.getX() * d2, this.getY() * d2, this.getZ() * d2);
    }

    public Point3D normalize() {
        double d2 = this.magnitude();
        if (d2 == 0.0) {
            return new Point3D(0.0, 0.0, 0.0);
        }
        return new Point3D(this.getX() / d2, this.getY() / d2, this.getZ() / d2);
    }

    public Point3D midpoint(double d2, double d3, double d4) {
        return new Point3D(d2 + (this.getX() - d2) / 2.0, d3 + (this.getY() - d3) / 2.0, d4 + (this.getZ() - d4) / 2.0);
    }

    public Point3D midpoint(Point3D point3D) {
        return this.midpoint(point3D.getX(), point3D.getY(), point3D.getZ());
    }

    public double angle(double d2, double d3, double d4) {
        double d5;
        double d6 = this.getX();
        double d7 = this.getY();
        double d8 = this.getZ();
        double d9 = d6;
        double d10 = d7;
        double d11 = d8;
        double d12 = d2;
        double d13 = d3;
        double d14 = d4;
        double d15 = (d6 * d2 + d7 * d3 + d8 * d4) / Math.sqrt((d9 * d9 + d10 * d10 + d11 * d11) * (d12 * d12 + d13 * d13 + d14 * d14));
        if (d5 > 1.0) {
            return 0.0;
        }
        if (d15 < -1.0) {
            return 180.0;
        }
        return Math.toDegrees(Math.acos(d15));
    }

    public double angle(Point3D point3D) {
        return this.angle(point3D.getX(), point3D.getY(), point3D.getZ());
    }

    public double angle(Point3D point3D, Point3D point3D2) {
        double d2;
        double d3 = this.getX();
        double d4 = this.getY();
        double d5 = this.getZ();
        double d6 = point3D.getX() - d3;
        double d7 = point3D.getY() - d4;
        double d8 = point3D.getZ() - d5;
        double d9 = point3D2.getX() - d3;
        double d10 = point3D2.getY() - d4;
        double d11 = point3D2.getZ() - d5;
        double d12 = d6;
        double d13 = d7;
        double d14 = d8;
        double d15 = d9;
        double d16 = d10;
        double d17 = d11;
        double d18 = (d6 * d9 + d7 * d10 + d8 * d11) / Math.sqrt((d12 * d12 + d13 * d13 + d14 * d14) * (d15 * d15 + d16 * d16 + d17 * d17));
        if (d2 > 1.0) {
            return 0.0;
        }
        if (d18 < -1.0) {
            return 180.0;
        }
        return Math.toDegrees(Math.acos(d18));
    }

    public double magnitude() {
        double d2 = this.getX();
        double d3 = this.getY();
        double d4 = this.getZ();
        double d5 = d2;
        double d6 = d3;
        double d7 = d4;
        return Math.sqrt(d5 * d5 + d6 * d6 + d7 * d7);
    }

    public double dotProduct(double d2, double d3, double d4) {
        return this.getX() * d2 + this.getY() * d3 + this.getZ() * d4;
    }

    public double dotProduct(Point3D point3D) {
        return this.dotProduct(point3D.getX(), point3D.getY(), point3D.getZ());
    }

    public Point3D crossProduct(double d2, double d3, double d4) {
        double d5 = this.getX();
        double d6 = this.getY();
        double d7 = this.getZ();
        return new Point3D(d6 * d4 - d7 * d3, d7 * d2 - d5 * d4, d5 * d3 - d6 * d2);
    }

    public Point3D crossProduct(Point3D point3D) {
        return this.crossProduct(point3D.getX(), point3D.getY(), point3D.getZ());
    }

    @Override
    public Point3D interpolate(Point3D point3D, double d2) {
        if (d2 <= 0.0) {
            return this;
        }
        if (d2 >= 1.0) {
            return point3D;
        }
        return new Point3D(this.getX() + (point3D.getX() - this.getX()) * d2, this.getY() + (point3D.getY() - this.getY()) * d2, this.getZ() + (point3D.getZ() - this.getZ()) * d2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Point3D) {
            object = (Point3D)object;
            return this.getX() == ((Point3D)object).getX() && this.getY() == ((Point3D)object).getY() && this.getZ() == ((Point3D)object).getZ();
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == 0) {
            long l2 = 217L + Double.doubleToLongBits(this.getX());
            l2 = 31L * l2 + Double.doubleToLongBits(this.getY());
            long l3 = l2 = 31L * l2 + Double.doubleToLongBits(this.getZ());
            this.hash = (int)(l3 ^ l3 >> 32);
        }
        return this.hash;
    }

    public String toString() {
        return "Point3D [x = " + this.getX() + ", y = " + this.getY() + ", z = " + this.getZ() + "]";
    }
}

