/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.BoxBounds;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.Vec3d;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.GeneralTransform3D;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.scene.CameraHelper;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.transform.TransformHelper;
import com.sun.javafx.sg.prism.NGCamera;
import javafx.beans.InvalidationListener;
import javafx.beans.property.DoubleProperty;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.Camera$1;
import javafx.scene.Camera$2;
import javafx.scene.Camera$3;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.SubScene;
import javafx.scene.transform.Transform;

public abstract class Camera
extends Node {
    private Affine3D localToSceneTx = new Affine3D();
    private double farClipInScene;
    private double nearClipInScene;
    private Scene ownerScene;
    private SubScene ownerSubScene;
    private GeneralTransform3D projViewTx;
    private GeneralTransform3D projTx;
    private Affine3D viewTx;
    private double viewWidth;
    private double viewHeight;
    private Vec3d position;
    private boolean clipInSceneValid;
    private boolean projViewTxValid;
    private boolean localToSceneValid;
    private boolean sceneToLocalValid;
    private Affine3D sceneToLocalTx;
    private DoubleProperty nearClip;
    private DoubleProperty farClip;

    protected Camera() {
        CameraHelper.initHelper(this);
        this.ownerScene = null;
        this.ownerSubScene = null;
        this.projViewTx = new GeneralTransform3D();
        this.projTx = new GeneralTransform3D();
        this.viewTx = new Affine3D();
        this.viewWidth = 1.0;
        this.viewHeight = 1.0;
        this.position = new Vec3d();
        this.clipInSceneValid = false;
        this.projViewTxValid = false;
        this.localToSceneValid = false;
        this.sceneToLocalValid = false;
        this.sceneToLocalTx = new Affine3D();
        InvalidationListener invalidationListener = observable -> NodeHelper.markDirty(this, DirtyBits.NODE_CAMERA_TRANSFORM);
        this.localToSceneTransformProperty().addListener(invalidationListener);
        this.sceneProperty().addListener(invalidationListener);
    }

    double getFarClipInScene() {
        this.updateClipPlane();
        return this.farClipInScene;
    }

    double getNearClipInScene() {
        this.updateClipPlane();
        return this.nearClipInScene;
    }

    private void updateClipPlane() {
        if (!this.clipInSceneValid) {
            Transform transform = this.getLocalToSceneTransform();
            this.nearClipInScene = transform.transform(0.0, 0.0, this.getNearClip()).getZ();
            this.farClipInScene = transform.transform(0.0, 0.0, this.getFarClip()).getZ();
            this.clipInSceneValid = true;
        }
    }

    Affine3D getSceneToLocalTransform() {
        if (!this.sceneToLocalValid) {
            ((BaseTransform)this.sceneToLocalTx).setTransform(this.getCameraTransform());
            try {
                ((BaseTransform)this.sceneToLocalTx).invert();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                String string = Camera.class.getName();
                PlatformLogger.getLogger(string).severe("getSceneToLocalTransform", noninvertibleTransformException);
                ((BaseTransform)this.sceneToLocalTx).setToIdentity();
            }
            this.sceneToLocalValid = true;
        }
        return this.sceneToLocalTx;
    }

    public final void setNearClip(double d2) {
        this.nearClipProperty().set(d2);
    }

    public final double getNearClip() {
        if (this.nearClip == null) {
            return 0.1;
        }
        return this.nearClip.get();
    }

    public final DoubleProperty nearClipProperty() {
        if (this.nearClip == null) {
            Camera camera = this;
            this.nearClip = new Camera$2(camera, camera, "nearClip", 0.1);
        }
        return this.nearClip;
    }

    public final void setFarClip(double d2) {
        this.farClipProperty().set(d2);
    }

    public final double getFarClip() {
        if (this.farClip == null) {
            return 100.0;
        }
        return this.farClip.get();
    }

    public final DoubleProperty farClipProperty() {
        if (this.farClip == null) {
            Camera camera = this;
            this.farClip = new Camera$3(camera, camera, "farClip", 100.0);
        }
        return this.farClip;
    }

    Camera copy() {
        return this;
    }

    private void doUpdatePeer() {
        NGCamera nGCamera = (NGCamera)this.getPeer();
        if (!NodeHelper.isDirtyEmpty(this)) {
            if (this.isDirty(DirtyBits.NODE_CAMERA)) {
                nGCamera.setNearClip((float)this.getNearClip());
                nGCamera.setFarClip((float)this.getFarClip());
                nGCamera.setViewWidth(this.getViewWidth());
                nGCamera.setViewHeight(this.getViewHeight());
            }
            if (this.isDirty(DirtyBits.NODE_CAMERA_TRANSFORM)) {
                nGCamera.setWorldTransform(this.getCameraTransform());
            }
            nGCamera.setProjViewTransform(this.getProjViewTransform());
            this.position = this.computePosition(this.position);
            ((BaseTransform)this.getCameraTransform()).transform(this.position, this.position);
            nGCamera.setPosition(this.position);
        }
    }

    void setViewWidth(double d2) {
        this.viewWidth = d2;
        NodeHelper.markDirty(this, DirtyBits.NODE_CAMERA);
    }

    double getViewWidth() {
        return this.viewWidth;
    }

    void setViewHeight(double d2) {
        this.viewHeight = d2;
        NodeHelper.markDirty(this, DirtyBits.NODE_CAMERA);
    }

    double getViewHeight() {
        return this.viewHeight;
    }

    void setOwnerScene(Scene scene) {
        if (scene == null) {
            this.ownerScene = null;
            return;
        }
        if (scene != this.ownerScene) {
            if (this.ownerScene != null || this.ownerSubScene != null) {
                throw new IllegalArgumentException(String.valueOf(this) + "is already set as camera in other scene or subscene");
            }
            this.ownerScene = scene;
            this.markOwnerDirty();
        }
    }

    void setOwnerSubScene(SubScene subScene) {
        if (subScene == null) {
            this.ownerSubScene = null;
            return;
        }
        if (subScene != this.ownerSubScene) {
            if (this.ownerScene != null || this.ownerSubScene != null) {
                throw new IllegalArgumentException(String.valueOf(this) + "is already set as camera in other scene or subscene");
            }
            this.ownerSubScene = subScene;
            this.markOwnerDirty();
        }
    }

    private void doMarkDirty(DirtyBits dirtyBits) {
        if (dirtyBits == DirtyBits.NODE_CAMERA_TRANSFORM) {
            this.localToSceneValid = false;
            this.sceneToLocalValid = false;
            this.clipInSceneValid = false;
            this.projViewTxValid = false;
        } else if (dirtyBits == DirtyBits.NODE_CAMERA) {
            this.projViewTxValid = false;
        }
        this.markOwnerDirty();
    }

    private void markOwnerDirty() {
        if (this.ownerScene != null) {
            this.ownerScene.markCameraDirty();
        }
        if (this.ownerSubScene != null) {
            this.ownerSubScene.markContentDirty();
        }
    }

    Affine3D getCameraTransform() {
        if (!this.localToSceneValid) {
            ((BaseTransform)this.localToSceneTx).setToIdentity();
            TransformHelper.apply(this.getLocalToSceneTransform(), this.localToSceneTx);
            this.localToSceneValid = true;
        }
        return this.localToSceneTx;
    }

    abstract void computeProjectionTransform(GeneralTransform3D var1);

    abstract void computeViewTransform(Affine3D var1);

    GeneralTransform3D getProjViewTransform() {
        if (!this.projViewTxValid) {
            Camera camera = this;
            camera.computeProjectionTransform(camera.projTx);
            Camera camera2 = this;
            camera2.computeViewTransform(camera2.viewTx);
            this.projViewTx.set(this.projTx);
            this.projViewTx.mul(this.viewTx);
            this.projViewTx.mul(this.getSceneToLocalTransform());
            this.projViewTxValid = true;
        }
        return this.projViewTx;
    }

    private Point2D project(Point3D object) {
        object = this.getProjViewTransform().transform(new Vec3d(((Point3D)object).getX(), ((Point3D)object).getY(), ((Point3D)object).getZ()));
        double d2 = this.getViewWidth() / 2.0;
        double d3 = this.getViewHeight() / 2.0;
        return new Point2D(d2 * (1.0 + ((Vec3d)object).x), d3 * (1.0 - ((Vec3d)object).y));
    }

    private Point2D pickNodeXYPlane(Node object, double d2, double d3) {
        Object object2 = this.computePickRay(d2, d3, null);
        Affine3D affine3D = new Affine3D();
        TransformHelper.apply(((Node)object).getLocalToSceneTransform(), affine3D);
        object = ((PickRay)object2).getOriginNoClone();
        object2 = ((PickRay)object2).getDirectionNoClone();
        try {
            Object object3 = object;
            ((BaseTransform)affine3D).inverseTransform((Vec3d)object3, (Vec3d)object3);
            Object object4 = object2;
            ((BaseTransform)affine3D).inverseDeltaTransform((Vec3d)object4, (Vec3d)object4);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return null;
        }
        if (Camera.almostZero(((Vec3d)object2).z)) {
            return null;
        }
        double d4 = -((Vec3d)object).z / ((Vec3d)object2).z;
        return new Point2D(((Vec3d)object).x + ((Vec3d)object2).x * d4, ((Vec3d)object).y + ((Vec3d)object2).y * d4);
    }

    Point3D pickProjectPlane(double d2, double d3) {
        PickRay pickRay = this.computePickRay(d2, d3, null);
        Vec3d vec3d = new Vec3d();
        vec3d.add(pickRay.getOriginNoClone(), pickRay.getDirectionNoClone());
        return new Point3D(vec3d.x, vec3d.y, vec3d.z);
    }

    abstract PickRay computePickRay(double var1, double var3, PickRay var5);

    abstract Vec3d computePosition(Vec3d var1);

    private BaseBounds doComputeGeomBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        return new BoxBounds(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    private boolean doComputeContains(double d2, double d3) {
        return false;
    }

    static {
        CameraHelper.setCameraAccessor(new Camera$1());
    }
}

