/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene;

import com.sun.javafx.cursor.CursorFrame;
import com.sun.javafx.cursor.CursorType;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import javafx.scene.Cursor$StandardCursor;
import javafx.scene.ImageCursor;
import javafx.scene.image.Image;

public abstract class Cursor {
    public static final Cursor DEFAULT = new Cursor$StandardCursor("DEFAULT", CursorType.DEFAULT);
    public static final Cursor CROSSHAIR = new Cursor$StandardCursor("CROSSHAIR", CursorType.CROSSHAIR);
    public static final Cursor TEXT = new Cursor$StandardCursor("TEXT", CursorType.TEXT);
    public static final Cursor WAIT = new Cursor$StandardCursor("WAIT", CursorType.WAIT);
    public static final Cursor SW_RESIZE = new Cursor$StandardCursor("SW_RESIZE", CursorType.SW_RESIZE);
    public static final Cursor SE_RESIZE = new Cursor$StandardCursor("SE_RESIZE", CursorType.SE_RESIZE);
    public static final Cursor NW_RESIZE = new Cursor$StandardCursor("NW_RESIZE", CursorType.NW_RESIZE);
    public static final Cursor NE_RESIZE = new Cursor$StandardCursor("NE_RESIZE", CursorType.NE_RESIZE);
    public static final Cursor N_RESIZE = new Cursor$StandardCursor("N_RESIZE", CursorType.N_RESIZE);
    public static final Cursor S_RESIZE = new Cursor$StandardCursor("S_RESIZE", CursorType.S_RESIZE);
    public static final Cursor W_RESIZE = new Cursor$StandardCursor("W_RESIZE", CursorType.W_RESIZE);
    public static final Cursor E_RESIZE = new Cursor$StandardCursor("E_RESIZE", CursorType.E_RESIZE);
    public static final Cursor OPEN_HAND = new Cursor$StandardCursor("OPEN_HAND", CursorType.OPEN_HAND);
    public static final Cursor CLOSED_HAND = new Cursor$StandardCursor("CLOSED_HAND", CursorType.CLOSED_HAND);
    public static final Cursor HAND = new Cursor$StandardCursor("HAND", CursorType.HAND);
    public static final Cursor MOVE = new Cursor$StandardCursor("MOVE", CursorType.MOVE);
    public static final Cursor DISAPPEAR = new Cursor$StandardCursor("DISAPPEAR", CursorType.DISAPPEAR);
    public static final Cursor H_RESIZE = new Cursor$StandardCursor("H_RESIZE", CursorType.H_RESIZE);
    public static final Cursor V_RESIZE = new Cursor$StandardCursor("V_RESIZE", CursorType.V_RESIZE);
    public static final Cursor NONE = new Cursor$StandardCursor("NONE", CursorType.NONE);
    private String name = "CUSTOM";

    Cursor() {
    }

    Cursor(String string) {
        this.name = string;
    }

    abstract CursorFrame getCurrentFrame();

    void activate() {
    }

    void deactivate() {
    }

    public String toString() {
        return this.name;
    }

    public static Cursor cursor(String string) {
        if (string == null) {
            throw new NullPointerException("The cursor identifier must not be null");
        }
        if (Cursor.isUrl(string)) {
            return new ImageCursor(new Image(string));
        }
        if ((string = string.toUpperCase(Locale.ROOT)).equals(Cursor.DEFAULT.name)) {
            return DEFAULT;
        }
        if (string.equals(Cursor.CROSSHAIR.name)) {
            return CROSSHAIR;
        }
        if (string.equals(Cursor.TEXT.name)) {
            return TEXT;
        }
        if (string.equals(Cursor.WAIT.name)) {
            return WAIT;
        }
        if (string.equals(Cursor.MOVE.name)) {
            return MOVE;
        }
        if (string.equals(Cursor.SW_RESIZE.name)) {
            return SW_RESIZE;
        }
        if (string.equals(Cursor.SE_RESIZE.name)) {
            return SE_RESIZE;
        }
        if (string.equals(Cursor.NW_RESIZE.name)) {
            return NW_RESIZE;
        }
        if (string.equals(Cursor.NE_RESIZE.name)) {
            return NE_RESIZE;
        }
        if (string.equals(Cursor.N_RESIZE.name)) {
            return N_RESIZE;
        }
        if (string.equals(Cursor.S_RESIZE.name)) {
            return S_RESIZE;
        }
        if (string.equals(Cursor.W_RESIZE.name)) {
            return W_RESIZE;
        }
        if (string.equals(Cursor.E_RESIZE.name)) {
            return E_RESIZE;
        }
        if (string.equals(Cursor.OPEN_HAND.name)) {
            return OPEN_HAND;
        }
        if (string.equals(Cursor.CLOSED_HAND.name)) {
            return CLOSED_HAND;
        }
        if (string.equals(Cursor.HAND.name)) {
            return HAND;
        }
        if (string.equals(Cursor.H_RESIZE.name)) {
            return H_RESIZE;
        }
        if (string.equals(Cursor.V_RESIZE.name)) {
            return V_RESIZE;
        }
        if (string.equals(Cursor.DISAPPEAR.name)) {
            return DISAPPEAR;
        }
        if (string.equals(Cursor.NONE.name)) {
            return NONE;
        }
        throw new IllegalArgumentException("Invalid cursor specification");
    }

    private static boolean isUrl(String string) {
        try {
            new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        return true;
    }
}

