/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene;

import com.sun.javafx.css.StyleManager;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;
import com.sun.javafx.scene.CssFlags;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.LayoutFlags;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.ParentHelper;
import com.sun.javafx.scene.input.PickResultChooser;
import com.sun.javafx.scene.traversal.ParentTraversalEngine;
import com.sun.javafx.sg.prism.NGGroup;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.util.TempState;
import com.sun.javafx.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Selector;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.Parent$1;
import javafx.scene.Parent$2;
import javafx.scene.Parent$3;
import javafx.scene.Parent$4;
import javafx.scene.PropertyHelper;
import javafx.scene.Scene;
import javafx.scene.SubScene;

public abstract class Parent
extends Node {
    static final int DIRTY_CHILDREN_THRESHOLD = 10;
    private static final boolean warnOnAutoMove = PropertyHelper.getBooleanProperty("javafx.sg.warn");
    private static final int REMOVED_CHILDREN_THRESHOLD = 20;
    private boolean removedChildrenOptimizationDisabled = false;
    private final Set<Node> childSet = new HashSet<Node>();
    private int startIdx = 0;
    private int pgChildrenSize = 0;
    private final List<Node> viewOrderChildren = new ArrayList<Node>(1);
    private boolean childrenTriggerPermutation = false;
    private List<Node> removed;
    private boolean geomChanged;
    private boolean childSetModified;
    private final ObservableList<Node> children = new Parent$3(this, new Parent$2(this));
    private final ObservableList<Node> unmodifiableChildren = FXCollections.unmodifiableObservableList(this.children);
    private List<Node> unmodifiableManagedChildren = null;
    private ParentTraversalEngine traversalEngine;
    private ReadOnlyBooleanWrapper needsLayout;
    LayoutFlags layoutFlag = LayoutFlags.CLEAN;
    private boolean performingLayout = false;
    private boolean sizeCacheClear = true;
    private double prefWidthCache = -1.0;
    private double prefHeightCache = -1.0;
    private double minWidthCache = -1.0;
    private double minHeightCache = -1.0;
    private boolean forceParentLayout = false;
    private Node currentLayoutChild = null;
    private boolean sceneRoot = false;
    boolean layoutRoot = false;
    private final ObservableList<String> stylesheets = new Parent$4(this);
    private BaseBounds tmp;
    private BaseBounds cachedBounds;
    private boolean cachedBoundsInvalid;
    private int dirtyChildrenCount;
    private ArrayList<Node> dirtyChildren;
    private Node top;
    private Node left;
    private Node bottom;
    private Node right;
    private Node near;
    private Node far;
    private static final int LEFT_INVALID = 1;
    private static final int TOP_INVALID = 2;
    private static final int NEAR_INVALID = 4;
    private static final int RIGHT_INVALID = 8;
    private static final int BOTTOM_INVALID = 16;
    private static final int FAR_INVALID = 32;
    private Node currentlyProcessedChild;

    private void doUpdatePeer() {
        List<NGNode> list;
        NGGroup nGGroup = (NGGroup)this.getPeer();
        if (Utils.assertionEnabled() && (list = nGGroup.getChildren()).size() != this.pgChildrenSize) {
            System.err.println("*** pgnodes.size() [" + list.size() + "] != pgChildrenSize [" + this.pgChildrenSize + "]");
        }
        if (this.isDirty(DirtyBits.PARENT_CHILDREN)) {
            int n2;
            nGGroup.clearFrom(this.startIdx);
            for (n2 = this.startIdx; n2 < this.children.size(); ++n2) {
                nGGroup.add(n2, (NGNode)((Node)this.children.get(n2)).getPeer());
            }
            if (this.removedChildrenOptimizationDisabled) {
                nGGroup.markDirty();
                this.removedChildrenOptimizationDisabled = false;
            } else if (this.removed != null && !this.removed.isEmpty()) {
                for (n2 = 0; n2 < this.removed.size(); ++n2) {
                    nGGroup.addToRemoved((NGNode)this.removed.get(n2).getPeer());
                }
            }
            if (this.removed != null) {
                this.removed.clear();
            }
            this.startIdx = this.pgChildrenSize = this.children.size();
        }
        if (this.isDirty(DirtyBits.PARENT_CHILDREN_VIEW_ORDER)) {
            this.computeViewOrderChildren();
            nGGroup.setViewOrderChildren(this.viewOrderChildren);
        }
        if (Utils.assertionEnabled()) {
            this.validatePG();
        }
    }

    void validatePG() {
        boolean bl2 = false;
        Object object = (NGGroup)this.getPeer();
        if ((object = ((NGGroup)object).getChildren()).size() != this.children.size()) {
            System.err.println("*** pgnodes.size validatePG() [" + object.size() + "] != children.size() [" + this.children.size() + "]");
            bl2 = true;
        } else {
            for (int i2 = 0; i2 < this.children.size(); ++i2) {
                Node node = (Node)this.children.get(i2);
                if (node.getParent() != this) {
                    System.err.println("*** this=" + String.valueOf(this) + " validatePG children[" + i2 + "].parent= " + String.valueOf(node.getParent()));
                    bl2 = true;
                }
                if (node.getPeer() == object.get(i2)) continue;
                int n2 = i2;
                System.err.println("*** pgnodes[" + n2 + "] validatePG != children[" + n2 + "]");
                bl2 = true;
            }
        }
        if (bl2) {
            throw new AssertionError((Object)"validation of PGGroup children failed");
        }
    }

    void printSeq(String object, List<Node> object2) {
        object2 = object2.iterator();
        while (object2.hasNext()) {
            Node node = (Node)object2.next();
            object = (String)object + String.valueOf(node) + " ";
        }
        System.out.println((String)object);
    }

    void markViewOrderChildrenDirty() {
        this.viewOrderChildren.clear();
        NodeHelper.markDirty(this, DirtyBits.PARENT_CHILDREN_VIEW_ORDER);
    }

    private void computeViewOrderChildren() {
        boolean bl2 = false;
        for (Node node3 : this.children) {
            double d2 = node3.getViewOrder();
            if (bl2 || d2 == 0.0) continue;
            bl2 = true;
        }
        this.viewOrderChildren.clear();
        if (bl2) {
            this.viewOrderChildren.addAll(this.children);
            Collections.sort(this.viewOrderChildren, (node, node2) -> {
                if (node.getViewOrder() < node2.getViewOrder()) {
                    return 1;
                }
                if (node.getViewOrder() == node2.getViewOrder()) {
                    return 0;
                }
                return -1;
            });
        }
    }

    private List<Node> getOrderedChildren() {
        if (this.isDirty(DirtyBits.PARENT_CHILDREN_VIEW_ORDER)) {
            this.computeViewOrderChildren();
        }
        if (!this.viewOrderChildren.isEmpty()) {
            return this.viewOrderChildren;
        }
        return this.children;
    }

    protected ObservableList<Node> getChildren() {
        return this.children;
    }

    public ObservableList<Node> getChildrenUnmodifiable() {
        return this.unmodifiableChildren;
    }

    protected <E extends Node> List<E> getManagedChildren() {
        if (this.unmodifiableManagedChildren == null) {
            this.unmodifiableManagedChildren = new ArrayList<Node>();
            int n2 = this.children.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Node node = (Node)this.children.get(i2);
                if (!node.isManaged()) continue;
                this.unmodifiableManagedChildren.add(node);
            }
        }
        return this.unmodifiableManagedChildren;
    }

    final void managedChildChanged() {
        this.requestLayout();
        this.unmodifiableManagedChildren = null;
    }

    final void toFront(Node node) {
        if (Utils.assertionEnabled() && !this.childSet.contains(node)) {
            throw new AssertionError((Object)"specified node is not in the list of children");
        }
        if (this.children.get(this.children.size() - 1) != node) {
            this.childrenTriggerPermutation = true;
            try {
                this.children.remove(node);
                this.children.add(node);
                return;
            }
            finally {
                this.childrenTriggerPermutation = false;
            }
        }
    }

    final void toBack(Node node) {
        if (Utils.assertionEnabled() && !this.childSet.contains(node)) {
            throw new AssertionError((Object)"specified node is not in the list of children");
        }
        if (this.children.get(0) != node) {
            this.childrenTriggerPermutation = true;
            try {
                this.children.remove(node);
                this.children.add(0, node);
                return;
            }
            finally {
                this.childrenTriggerPermutation = false;
            }
        }
    }

    @Override
    void scenesChanged(Scene scene, SubScene subScene, Scene scene2, SubScene subScene2) {
        int n2;
        if (scene2 != null && scene == null) {
            StyleManager.getInstance().forget(this);
            if (this.removed != null) {
                this.removed.clear();
            }
        }
        for (n2 = 0; n2 < this.children.size(); ++n2) {
            ((Node)this.children.get(n2)).setScenes(scene, subScene);
        }
        n2 = this.layoutFlag != LayoutFlags.CLEAN ? 1 : 0;
        this.sceneRoot = subScene != null && subScene.getRoot() == this || scene != null && scene.getRoot() == this;
        boolean bl2 = this.layoutRoot = !this.isManaged() || this.sceneRoot;
        if (n2 != 0 && scene != null && this.layoutRoot && subScene != null) {
            subScene.setDirtyLayout(this);
        }
    }

    @Override
    void setDerivedDepthTest(boolean n2) {
        super.setDerivedDepthTest(n2 != 0);
        int n3 = this.children.size();
        for (n2 = 0; n2 < n3; ++n2) {
            Node node = (Node)this.children.get(n2);
            node.computeDerivedDepthTest();
        }
    }

    boolean pickChildrenNode(PickRay pickRay, PickResultChooser pickResultChooser) {
        List<Node> list = this.getOrderedChildren();
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            list.get(i2).pickNode(pickRay, pickResultChooser);
            if (!pickResultChooser.isClosed()) continue;
            return false;
        }
        return true;
    }

    private void doPickNodeLocal(PickRay pickRay, PickResultChooser pickResultChooser) {
        double d2 = this.intersectsBounds(pickRay);
        if (!Double.isNaN(d2) && this.pickChildrenNode(pickRay, pickResultChooser) && this.isPickOnBounds()) {
            pickResultChooser.offer(this, d2, PickResultChooser.computePoint(pickRay, d2));
        }
    }

    @Override
    boolean isConnected() {
        return super.isConnected() || this.sceneRoot;
    }

    @Override
    public Node lookup(String string) {
        Node node = super.lookup(string);
        if (node == null) {
            int n2 = this.children.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                node = (Node)this.children.get(i2);
                if ((node = node.lookup(string)) == null) continue;
                return node;
            }
        }
        return node;
    }

    @Override
    List<Node> lookupAll(Selector selector, List<Node> list) {
        list = super.lookupAll(selector, list);
        int n2 = this.children.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = (Node)this.children.get(i2);
            list = node.lookupAll(selector, list);
        }
        return list;
    }

    private final void setTraversalEngine(ParentTraversalEngine parentTraversalEngine) {
        this.traversalEngine = parentTraversalEngine;
    }

    private final ParentTraversalEngine getTraversalEngine() {
        return this.traversalEngine;
    }

    protected final void setNeedsLayout(boolean bl2) {
        if (bl2) {
            this.markDirtyLayout(true, false);
            return;
        }
        if (this.layoutFlag == LayoutFlags.NEEDS_LAYOUT) {
            bl2 = false;
            int n2 = this.children.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Node node = (Node)this.children.get(i2);
                if (!(node instanceof Parent) || ((Parent)node).layoutFlag == LayoutFlags.CLEAN) continue;
                bl2 = true;
                break;
            }
            this.setLayoutFlag(bl2 ? LayoutFlags.DIRTY_BRANCH : LayoutFlags.CLEAN);
        }
    }

    public final boolean isNeedsLayout() {
        return this.layoutFlag == LayoutFlags.NEEDS_LAYOUT;
    }

    public final ReadOnlyBooleanProperty needsLayoutProperty() {
        if (this.needsLayout == null) {
            this.needsLayout = new ReadOnlyBooleanWrapper(this, "needsLayout", this.layoutFlag == LayoutFlags.NEEDS_LAYOUT);
        }
        return this.needsLayout;
    }

    boolean isPerformingLayout() {
        return this.performingLayout;
    }

    void setLayoutFlag(LayoutFlags layoutFlags) {
        if (this.needsLayout != null) {
            this.needsLayout.set(layoutFlags == LayoutFlags.NEEDS_LAYOUT);
        }
        this.layoutFlag = layoutFlags;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void markDirtyLayout(boolean bl2, boolean bl3) {
        this.setLayoutFlag(LayoutFlags.NEEDS_LAYOUT);
        if (bl2 || this.layoutRoot) {
            if (this.sceneRoot) {
                Toolkit.getToolkit().requestNextPulse();
                if (this.getSubScene() == null) return;
                this.getSubScene().setDirtyLayout(this);
                return;
            }
            this.markDirtyLayoutBranch();
            return;
        }
        this.requestParentLayout(bl3);
    }

    public void requestLayout() {
        this.clearSizeCache();
        this.markDirtyLayout(false, this.forceParentLayout);
    }

    void requestLayout(boolean bl2) {
        boolean bl3 = this.forceParentLayout;
        this.forceParentLayout = bl2;
        this.requestLayout();
        this.forceParentLayout = bl3;
    }

    protected final void requestParentLayout() {
        this.requestParentLayout(false);
    }

    void requestParentLayout(boolean bl2) {
        Parent parent;
        if (!(this.layoutRoot || (parent = this.getParent()) == null || parent.performingLayout && !bl2)) {
            parent.requestLayout();
        }
    }

    void clearSizeCache() {
        if (this.sizeCacheClear) {
            return;
        }
        this.sizeCacheClear = true;
        this.prefWidthCache = -1.0;
        this.prefHeightCache = -1.0;
        this.minWidthCache = -1.0;
        this.minHeightCache = -1.0;
    }

    @Override
    public double prefWidth(double d2) {
        if (d2 == -1.0) {
            if (this.prefWidthCache == -1.0) {
                this.prefWidthCache = this.computePrefWidth(-1.0);
                if (Double.isNaN(this.prefWidthCache) || this.prefWidthCache < 0.0) {
                    this.prefWidthCache = 0.0;
                }
                this.sizeCacheClear = false;
            }
            return this.prefWidthCache;
        }
        double d3 = this.computePrefWidth(d2);
        if (Double.isNaN(d3) || d3 < 0.0) {
            return 0.0;
        }
        return d3;
    }

    @Override
    public double prefHeight(double d2) {
        if (d2 == -1.0) {
            if (this.prefHeightCache == -1.0) {
                this.prefHeightCache = this.computePrefHeight(-1.0);
                if (Double.isNaN(this.prefHeightCache) || this.prefHeightCache < 0.0) {
                    this.prefHeightCache = 0.0;
                }
                this.sizeCacheClear = false;
            }
            return this.prefHeightCache;
        }
        double d3 = this.computePrefHeight(d2);
        if (Double.isNaN(d3) || d3 < 0.0) {
            return 0.0;
        }
        return d3;
    }

    @Override
    public double minWidth(double d2) {
        if (d2 == -1.0) {
            if (this.minWidthCache == -1.0) {
                this.minWidthCache = this.computeMinWidth(-1.0);
                if (Double.isNaN(this.minWidthCache) || this.minWidthCache < 0.0) {
                    this.minWidthCache = 0.0;
                }
                this.sizeCacheClear = false;
            }
            return this.minWidthCache;
        }
        double d3 = this.computeMinWidth(d2);
        if (Double.isNaN(d3) || d3 < 0.0) {
            return 0.0;
        }
        return d3;
    }

    @Override
    public double minHeight(double d2) {
        if (d2 == -1.0) {
            if (this.minHeightCache == -1.0) {
                this.minHeightCache = this.computeMinHeight(-1.0);
                if (Double.isNaN(this.minHeightCache) || this.minHeightCache < 0.0) {
                    this.minHeightCache = 0.0;
                }
                this.sizeCacheClear = false;
            }
            return this.minHeightCache;
        }
        double d3 = this.computeMinHeight(d2);
        if (Double.isNaN(d3) || d3 < 0.0) {
            return 0.0;
        }
        return d3;
    }

    protected double computePrefWidth(double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        int n2 = this.children.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = (Node)this.children.get(i2);
            if (!node.isManaged()) continue;
            double d5 = node.getLayoutBounds().getMinX() + node.getLayoutX();
            d3 = Math.min(d3, d5);
            d4 = Math.max(d4, d5 + this.boundedSize(node.prefWidth(-1.0), node.minWidth(-1.0), node.maxWidth(-1.0)));
        }
        return d4 - d3;
    }

    protected double computePrefHeight(double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        int n2 = this.children.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = (Node)this.children.get(i2);
            if (!node.isManaged()) continue;
            double d5 = node.getLayoutBounds().getMinY() + node.getLayoutY();
            d3 = Math.min(d3, d5);
            d4 = Math.max(d4, d5 + this.boundedSize(node.prefHeight(-1.0), node.minHeight(-1.0), node.maxHeight(-1.0)));
        }
        return d4 - d3;
    }

    protected double computeMinWidth(double d2) {
        return ((Node)this).prefWidth(d2);
    }

    protected double computeMinHeight(double d2) {
        return ((Node)this).prefHeight(d2);
    }

    @Override
    public double getBaselineOffset() {
        int n2 = this.children.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            double d2;
            Node node = (Node)this.children.get(i2);
            if (!node.isManaged() || (d2 = node.getBaselineOffset()) == Double.NEGATIVE_INFINITY) continue;
            return node.getLayoutBounds().getMinY() + node.getLayoutY() + d2;
        }
        return super.getBaselineOffset();
    }

    boolean isCurrentLayoutChild(Node node) {
        return node == this.currentLayoutChild;
    }

    public final void layout() {
        LayoutFlags layoutFlags = this.layoutFlag;
        this.setLayoutFlag(LayoutFlags.CLEAN);
        switch (layoutFlags) {
            case CLEAN: {
                return;
            }
            case NEEDS_LAYOUT: {
                if (this.performingLayout) break;
                this.performingLayout = true;
                this.layoutChildren();
            }
            case DIRTY_BRANCH: {
                int n2 = this.children.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Node node;
                    this.currentLayoutChild = node = (Node)this.children.get(i2);
                    if (node instanceof Parent) {
                        ((Parent)node).layout();
                        continue;
                    }
                    if (!(node instanceof SubScene)) continue;
                    ((SubScene)node).layoutPass();
                }
                this.currentLayoutChild = null;
                this.performingLayout = false;
            }
        }
    }

    protected void layoutChildren() {
        int n2 = this.children.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node;
            this.currentLayoutChild = node = (Node)this.children.get(i2);
            if (!node.isResizable() || !node.isManaged()) continue;
            node.autosize();
        }
        this.currentLayoutChild = null;
    }

    @Override
    final void notifyManagedChanged() {
        this.layoutRoot = !this.isManaged() || this.sceneRoot;
    }

    final boolean isSceneRoot() {
        return this.sceneRoot;
    }

    public final ObservableList<String> getStylesheets() {
        return this.stylesheets;
    }

    private List<String> doGetAllParentStylesheets() {
        List<String> list = null;
        Parent parent = this.getParent();
        if (parent != null) {
            list = ParentHelper.getAllParentStylesheets(parent);
        }
        if (this.stylesheets != null && !this.stylesheets.isEmpty()) {
            if (list == null) {
                list = new ArrayList<String>(this.stylesheets.size());
            }
            int n2 = this.stylesheets.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                list.add((String)this.stylesheets.get(i2));
            }
        }
        return list;
    }

    private void doProcessCSS() {
        if (this.cssFlag == CssFlags.CLEAN) {
            return;
        }
        if (this.cssFlag == CssFlags.DIRTY_BRANCH) {
            super.processCSS();
            return;
        }
        ParentHelper.superProcessCSS(this);
        if (this.children.isEmpty()) {
            return;
        }
        Node[] nodeArray = this.children.toArray(new Node[this.children.size()]);
        for (int i2 = 0; i2 < nodeArray.length; ++i2) {
            Node node = nodeArray[i2];
            Parent parent = node.getParent();
            if (parent == null || parent != this) continue;
            if (CssFlags.UPDATE.compareTo(node.cssFlag) > 0) {
                node.cssFlag = CssFlags.UPDATE;
            }
            NodeHelper.processCSS(node);
        }
    }

    protected Parent() {
        ParentHelper.initHelper(this);
        this.tmp = new RectBounds();
        this.cachedBounds = new RectBounds();
        this.layoutFlag = LayoutFlags.NEEDS_LAYOUT;
        this.setAccessibleRole(AccessibleRole.PARENT);
    }

    private NGNode doCreatePeer() {
        return new NGGroup();
    }

    @Override
    void nodeResolvedOrientationChanged() {
        int n2 = this.children.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ((Node)this.children.get(i2)).parentResolvedOrientationInvalidated();
        }
    }

    private BaseBounds doComputeGeomBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        if (this.children.isEmpty()) {
            return baseBounds.makeEmpty();
        }
        if (baseTransform.isTranslateOrIdentity()) {
            if (this.cachedBoundsInvalid) {
                this.recomputeBounds();
                if (this.dirtyChildren != null) {
                    this.dirtyChildren.clear();
                }
                this.cachedBoundsInvalid = false;
                this.dirtyChildrenCount = 0;
            }
            baseBounds = !baseTransform.isIdentity() ? baseBounds.deriveWithNewBounds((float)((double)this.cachedBounds.getMinX() + baseTransform.getMxt()), (float)((double)this.cachedBounds.getMinY() + baseTransform.getMyt()), (float)((double)this.cachedBounds.getMinZ() + baseTransform.getMzt()), (float)((double)this.cachedBounds.getMaxX() + baseTransform.getMxt()), (float)((double)this.cachedBounds.getMaxY() + baseTransform.getMyt()), (float)((double)this.cachedBounds.getMaxZ() + baseTransform.getMzt())) : baseBounds.deriveWithNewBounds(this.cachedBounds);
            return baseBounds;
        }
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        double d4 = Double.MAX_VALUE;
        double d5 = Double.MIN_VALUE;
        double d6 = Double.MIN_VALUE;
        double d7 = Double.MIN_VALUE;
        boolean bl2 = true;
        int n2 = this.children.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = (Node)this.children.get(i2);
            if (!node.isVisible() || (baseBounds = this.getChildTransformedBounds(node, baseTransform, baseBounds)).isEmpty()) continue;
            if (bl2) {
                d2 = baseBounds.getMinX();
                d3 = baseBounds.getMinY();
                d4 = baseBounds.getMinZ();
                d5 = baseBounds.getMaxX();
                d6 = baseBounds.getMaxY();
                d7 = baseBounds.getMaxZ();
                bl2 = false;
                continue;
            }
            d2 = Math.min((double)baseBounds.getMinX(), d2);
            d3 = Math.min((double)baseBounds.getMinY(), d3);
            d4 = Math.min((double)baseBounds.getMinZ(), d4);
            d5 = Math.max((double)baseBounds.getMaxX(), d5);
            d6 = Math.max((double)baseBounds.getMaxY(), d6);
            d7 = Math.max((double)baseBounds.getMaxZ(), d7);
        }
        if (bl2) {
            baseBounds.makeEmpty();
        } else {
            baseBounds = baseBounds.deriveWithNewBounds((float)d2, (float)d3, (float)d4, (float)d5, (float)d6, (float)d7);
        }
        return baseBounds;
    }

    private void setChildDirty(Node node, boolean bl2) {
        if (node.boundsChanged == bl2) {
            return;
        }
        node.boundsChanged = bl2;
        if (bl2) {
            if (this.dirtyChildren != null) {
                this.dirtyChildren.add(node);
            }
            ++this.dirtyChildrenCount;
            return;
        }
        if (this.dirtyChildren != null) {
            this.dirtyChildren.remove(node);
        }
        --this.dirtyChildrenCount;
    }

    private void childIncluded(Node node) {
        this.cachedBoundsInvalid = true;
        this.setChildDirty(node, true);
    }

    private void childExcluded(Node node) {
        if (node == this.left) {
            this.left = null;
            this.cachedBoundsInvalid = true;
        }
        if (node == this.top) {
            this.top = null;
            this.cachedBoundsInvalid = true;
        }
        if (node == this.near) {
            this.near = null;
            this.cachedBoundsInvalid = true;
        }
        if (node == this.right) {
            this.right = null;
            this.cachedBoundsInvalid = true;
        }
        if (node == this.bottom) {
            this.bottom = null;
            this.cachedBoundsInvalid = true;
        }
        if (node == this.far) {
            this.far = null;
            this.cachedBoundsInvalid = true;
        }
        this.setChildDirty(node, false);
    }

    private void recomputeBounds() {
        block7: {
            block6: {
                if (this.children.isEmpty()) {
                    this.cachedBounds.makeEmpty();
                    return;
                }
                if (this.children.size() == 1) {
                    Node node = (Node)this.children.get(0);
                    ((Node)this.children.get(0)).boundsChanged = false;
                    if (node.isVisible()) {
                        this.cachedBounds = this.getChildTransformedBounds(node, BaseTransform.IDENTITY_TRANSFORM, this.cachedBounds);
                        Parent parent = this;
                        Parent parent2 = this;
                        Parent parent3 = this;
                        parent3.near = parent3.far = node;
                        parent2.right = parent3.far;
                        parent2.bottom = parent3.far;
                        parent.left = parent3.far;
                        parent.top = parent3.far;
                        return;
                    }
                    this.cachedBounds.makeEmpty();
                    return;
                }
                if (this.dirtyChildrenCount == 0) break block6;
                Parent parent = this;
                if (parent.updateCachedBounds(parent.dirtyChildren != null ? this.dirtyChildren : this.children, this.dirtyChildrenCount)) break block7;
            }
            Parent parent = this;
            parent.createCachedBounds(parent.children);
        }
    }

    private boolean updateCachedBounds(List<Node> list, int n2) {
        if (this.cachedBounds.isEmpty()) {
            this.createCachedBounds(list);
            return true;
        }
        int n3 = 0;
        if (this.left == null || this.left.boundsChanged) {
            n3 = 1;
        }
        if (this.top == null || this.top.boundsChanged) {
            n3 |= 2;
        }
        if (this.near == null || this.near.boundsChanged) {
            n3 |= 4;
        }
        if (this.right == null || this.right.boundsChanged) {
            n3 |= 8;
        }
        if (this.bottom == null || this.bottom.boundsChanged) {
            n3 |= 0x10;
        }
        if (this.far == null || this.far.boundsChanged) {
            n3 |= 0x20;
        }
        float f2 = this.cachedBounds.getMinX();
        float f3 = this.cachedBounds.getMinY();
        float f4 = this.cachedBounds.getMinZ();
        float f5 = this.cachedBounds.getMaxX();
        float f6 = this.cachedBounds.getMaxY();
        float f7 = this.cachedBounds.getMaxZ();
        int n4 = list.size() - 1;
        while (n2 > 0) {
            Node node = list.get(n4);
            if (node.boundsChanged) {
                node.boundsChanged = false;
                --n2;
                this.tmp = this.getChildTransformedBounds(node, BaseTransform.IDENTITY_TRANSFORM, this.tmp);
                if (!this.tmp.isEmpty()) {
                    float f8 = this.tmp.getMinX();
                    float f9 = this.tmp.getMinY();
                    float f10 = this.tmp.getMinZ();
                    float f11 = this.tmp.getMaxX();
                    float f12 = this.tmp.getMaxY();
                    float f13 = this.tmp.getMaxZ();
                    if (f8 <= f2) {
                        f2 = f8;
                        this.left = node;
                        n3 &= 0xFFFFFFFE;
                    }
                    if (f9 <= f3) {
                        f3 = f9;
                        this.top = node;
                        n3 &= 0xFFFFFFFD;
                    }
                    if (f10 <= f4) {
                        f4 = f10;
                        this.near = node;
                        n3 &= 0xFFFFFFFB;
                    }
                    if (f11 >= f5) {
                        f5 = f11;
                        this.right = node;
                        n3 &= 0xFFFFFFF7;
                    }
                    if (f12 >= f6) {
                        f6 = f12;
                        this.bottom = node;
                        n3 &= 0xFFFFFFEF;
                    }
                    if (f13 >= f7) {
                        f7 = f13;
                        this.far = node;
                        n3 &= 0xFFFFFFDF;
                    }
                }
            }
            --n4;
        }
        if (n3 != 0) {
            return false;
        }
        this.cachedBounds = this.cachedBounds.deriveWithNewBounds(f2, f3, f4, f5, f6, f7);
        return true;
    }

    private void createCachedBounds(List<Node> list) {
        Node node;
        int n2;
        int n3 = list.size();
        for (n2 = 0; n2 < n3; ++n2) {
            node = list.get(n2);
            list.get(n2).boundsChanged = false;
            if (!node.isVisible()) continue;
            this.tmp = node.getTransformedBounds(this.tmp, BaseTransform.IDENTITY_TRANSFORM);
            if (this.tmp.isEmpty()) continue;
            Parent parent = this;
            Parent parent2 = this;
            Parent parent3 = this;
            parent3.bottom = parent3.far = node;
            parent2.right = parent3.far;
            parent2.near = parent3.far;
            parent.top = parent3.far;
            parent.left = parent3.far;
            break;
        }
        if (n2 == n3) {
            Parent parent = this;
            Parent parent4 = this;
            Parent parent5 = this;
            parent5.far = null;
            parent5.bottom = null;
            parent4.right = null;
            parent4.near = null;
            parent.top = null;
            parent.left = null;
            this.cachedBounds.makeEmpty();
            return;
        }
        float f2 = this.tmp.getMinX();
        float f3 = this.tmp.getMinY();
        float f4 = this.tmp.getMinZ();
        float f5 = this.tmp.getMaxX();
        float f6 = this.tmp.getMaxY();
        float f7 = this.tmp.getMaxZ();
        ++n2;
        while (n2 < n3) {
            node = list.get(n2);
            list.get(n2).boundsChanged = false;
            if (node.isVisible()) {
                this.tmp = node.getTransformedBounds(this.tmp, BaseTransform.IDENTITY_TRANSFORM);
                if (!this.tmp.isEmpty()) {
                    float f8 = this.tmp.getMinX();
                    float f9 = this.tmp.getMinY();
                    float f10 = this.tmp.getMinZ();
                    float f11 = this.tmp.getMaxX();
                    float f12 = this.tmp.getMaxY();
                    float f13 = this.tmp.getMaxZ();
                    if (f8 < f2) {
                        f2 = f8;
                        this.left = node;
                    }
                    if (f9 < f3) {
                        f3 = f9;
                        this.top = node;
                    }
                    if (f10 < f4) {
                        f4 = f10;
                        this.near = node;
                    }
                    if (f11 > f5) {
                        f5 = f11;
                        this.right = node;
                    }
                    if (f12 > f6) {
                        f6 = f12;
                        this.bottom = node;
                    }
                    if (f13 > f7) {
                        f7 = f13;
                        this.far = node;
                    }
                }
            }
            ++n2;
        }
        this.cachedBounds = this.cachedBounds.deriveWithNewBounds(f2, f3, f4, f5, f6, f7);
    }

    @Override
    protected void updateBounds() {
        int n2 = this.children.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ((Node)this.children.get(i2)).updateBounds();
        }
        super.updateBounds();
    }

    private BaseBounds getChildTransformedBounds(Node node, BaseTransform baseTransform, BaseBounds baseBounds) {
        this.currentlyProcessedChild = node;
        baseBounds = node.getTransformedBounds(baseBounds, baseTransform);
        this.currentlyProcessedChild = null;
        return baseBounds;
    }

    void childBoundsChanged(Node node) {
        if (node == this.currentlyProcessedChild) {
            return;
        }
        this.cachedBoundsInvalid = true;
        this.setChildDirty(node, true);
        NodeHelper.geomChanged(this);
    }

    void childVisibilityChanged(Node node) {
        if (node.isVisible()) {
            this.childIncluded(node);
        } else {
            this.childExcluded(node);
        }
        NodeHelper.geomChanged(this);
    }

    private boolean doComputeContains(double d2, double d3) {
        Point2D point2D = TempState.getInstance().point;
        int n2 = this.children.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = (Node)this.children.get(i2);
            point2D.x = (float)d2;
            point2D.y = (float)d3;
            try {
                node.parentToLocal(point2D);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                continue;
            }
            if (!node.contains(point2D.x, point2D.y)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objectArray) {
        switch (accessibleAttribute) {
            case CHILDREN: {
                return this.getChildrenUnmodifiable();
            }
        }
        return super.queryAccessibleAttribute(accessibleAttribute, objectArray);
    }

    @Override
    void releaseAccessible() {
        int n2 = this.children.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = (Node)this.children.get(i2);
            node.releaseAccessible();
        }
        super.releaseAccessible();
    }

    List<Node> test_getRemoved() {
        return this.removed;
    }

    List<Node> test_getViewOrderChildren() {
        return this.viewOrderChildren;
    }

    static {
        ParentHelper.setParentAccessor(new Parent$1());
    }
}

