/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene;

import com.sun.javafx.scene.input.ClipboardHelper;
import com.sun.javafx.scene.input.DragboardHelper;
import com.sun.javafx.tk.TKClipboard;
import com.sun.javafx.tk.Toolkit;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.scene.Scene;
import javafx.scene.Scene$DragDetectedState;
import javafx.scene.Scene$DragSourceListener;
import javafx.scene.Scene$TargetWrapper;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;

class Scene$DnDGesture {
    private final double hysteresisSizeX = Toolkit.getToolkit().getMultiClickMaxX();
    private final double hysteresisSizeY = Toolkit.getToolkit().getMultiClickMaxY();
    private EventTarget source = null;
    private Set<TransferMode> sourceTransferModes = null;
    private TransferMode acceptedTransferMode = null;
    private Dragboard dragboard = null;
    private EventTarget potentialTarget = null;
    private EventTarget target = null;
    private Scene$DragDetectedState dragDetected = Scene$DragDetectedState.NOT_YET;
    private double pressedX;
    private double pressedY;
    private List<EventTarget> currentTargets = new ArrayList<EventTarget>();
    private List<EventTarget> newTargets = new ArrayList<EventTarget>();
    private EventTarget fullPDRSource = null;
    final /* synthetic */ Scene this$0;

    Scene$DnDGesture(Scene scene) {
        this.this$0 = scene;
    }

    private void fireEvent(EventTarget eventTarget, Event event) {
        if (eventTarget != null) {
            Event.fireEvent(eventTarget, event);
        }
    }

    private void processingDragDetected() {
        this.dragDetected = Scene$DragDetectedState.PROCESSING;
    }

    private void dragDetectedProcessed() {
        this.dragDetected = Scene$DragDetectedState.DONE;
        boolean bl2 = this.dragboard != null && ClipboardHelper.contentPut(this.dragboard);
        if (bl2) {
            Toolkit.getToolkit().startDrag(this.this$0.peer, this.sourceTransferModes, new Scene$DragSourceListener(this.this$0), this.dragboard);
        } else if (this.fullPDRSource != null) {
            this.this$0.mouseHandler.enterFullPDR(this.fullPDRSource);
        }
        this.fullPDRSource = null;
    }

    /*
     * Unable to fully structure code
     */
    private void processDragDetection(MouseEvent var1_1) {
        block5: {
            block4: {
                if (this.dragDetected != Scene$DragDetectedState.NOT_YET) {
                    var1_1.setDragDetect(false);
                    return;
                }
                if (var1_1.getEventType() != MouseEvent.MOUSE_PRESSED) break block4;
                this.pressedX = var1_1.getSceneX();
                this.pressedY = var1_1.getSceneY();
                v0 = var1_1;
                ** GOTO lbl-1000
            }
            if (var1_1.getEventType() == MouseEvent.MOUSE_DRAGGED) {
                var2_2 = Math.abs(var1_1.getSceneX() - this.pressedX);
                var4_3 = Math.abs(var1_1.getSceneY() - this.pressedY);
                v0 = var1_1;
                ** if (!(var2_2 > this.hysteresisSizeX) && !(var4_3 > this.hysteresisSizeY)) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    v1 = true;
                    ** GOTO lbl19
                }
            }
            break block5;
lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
lbl19:
            // 2 sources

            v0.setDragDetect(v1);
        }
    }

    private boolean process(MouseEvent mouseEvent, EventTarget eventTarget) {
        boolean bl2 = true;
        if (this.dragDetected != Scene$DragDetectedState.DONE && (((Event)mouseEvent).getEventType() == MouseEvent.MOUSE_PRESSED || ((Event)mouseEvent).getEventType() == MouseEvent.MOUSE_DRAGGED) && mouseEvent.isDragDetect()) {
            this.processingDragDetected();
            if (eventTarget != null) {
                MouseEvent mouseEvent2 = mouseEvent;
                MouseEvent mouseEvent3 = mouseEvent2.copyFor(mouseEvent2.getSource(), eventTarget, MouseEvent.DRAG_DETECTED);
                try {
                    this.fireEvent(eventTarget, mouseEvent3);
                }
                finally {
                    if (this.dragboard != null) {
                        DragboardHelper.setDataAccessRestriction(this.dragboard, true);
                    }
                }
            }
            this.dragDetectedProcessed();
        }
        if (((Event)mouseEvent).getEventType() == MouseEvent.MOUSE_RELEASED) {
            bl2 = false;
        }
        return bl2;
    }

    private boolean processRecognized(DragEvent object) {
        MouseEvent mouseEvent = new MouseEvent(MouseEvent.DRAG_DETECTED, ((DragEvent)object).getX(), ((DragEvent)object).getY(), ((DragEvent)object).getSceneX(), ((DragEvent)object).getScreenY(), MouseButton.PRIMARY, 1, false, false, false, false, false, true, false, false, false, false, ((DragEvent)object).getPickResult());
        this.processingDragDetected();
        object = ((DragEvent)object).getPickResult().getIntersectedNode();
        try {
            this.fireEvent((EventTarget)(object != null ? object : this.this$0), mouseEvent);
        }
        finally {
            if (this.dragboard != null) {
                DragboardHelper.setDataAccessRestriction(this.dragboard, true);
            }
        }
        this.dragDetectedProcessed();
        boolean bl2 = this.dragboard != null && !this.dragboard.getContentTypes().isEmpty();
        return bl2;
    }

    private void processDropEnd(DragEvent dragEvent) {
        if (this.source == null) {
            System.out.println("Scene.DnDGesture.processDropEnd() - UNEXPECTED - source is NULL");
            return;
        }
        dragEvent = new DragEvent(dragEvent.getSource(), this.source, DragEvent.DRAG_DONE, dragEvent.getDragboard(), dragEvent.getSceneX(), dragEvent.getSceneY(), dragEvent.getScreenX(), dragEvent.getScreenY(), dragEvent.getTransferMode(), this.source, this.target, dragEvent.getPickResult());
        Event.fireEvent(this.source, dragEvent);
        this.this$0.tmpTargetWrapper.clear();
        this.handleExitEnter(dragEvent, this.this$0.tmpTargetWrapper);
        Toolkit.getToolkit().stopDrag(this.dragboard);
    }

    private TransferMode processTargetEnterOver(DragEvent dragEvent) {
        this.this$0.pick(this.this$0.tmpTargetWrapper, dragEvent.getSceneX(), dragEvent.getSceneY());
        Object object = this.this$0.tmpTargetWrapper.getEventTarget();
        if (this.dragboard == null) {
            this.dragboard = this.createDragboard(dragEvent, false);
        }
        dragEvent = new DragEvent(dragEvent.getSource(), (EventTarget)object, ((Event)dragEvent).getEventType(), this.dragboard, dragEvent.getSceneX(), dragEvent.getSceneY(), dragEvent.getScreenX(), dragEvent.getScreenY(), dragEvent.getTransferMode(), this.source, this.potentialTarget, dragEvent.getPickResult());
        this.handleExitEnter(dragEvent, this.this$0.tmpTargetWrapper);
        dragEvent = new DragEvent(dragEvent.getSource(), (EventTarget)object, DragEvent.DRAG_OVER, dragEvent.getDragboard(), dragEvent.getSceneX(), dragEvent.getSceneY(), dragEvent.getScreenX(), dragEvent.getScreenY(), dragEvent.getTransferMode(), this.source, this.potentialTarget, dragEvent.getPickResult());
        this.fireEvent((EventTarget)object, dragEvent);
        object = dragEvent.getAcceptingObject();
        this.potentialTarget = object instanceof EventTarget ? (EventTarget)object : null;
        this.acceptedTransferMode = dragEvent.getAcceptedTransferMode();
        return this.acceptedTransferMode;
    }

    private void processTargetActionChanged(DragEvent dragEvent) {
    }

    private void processTargetExit(DragEvent dragEvent) {
        if (this.dragboard == null) {
            throw new NullPointerException("dragboard is null in processTargetExit()");
        }
        if (this.currentTargets.size() > 0) {
            this.potentialTarget = null;
            this.this$0.tmpTargetWrapper.clear();
            this.handleExitEnter(dragEvent, this.this$0.tmpTargetWrapper);
        }
    }

    private TransferMode processTargetDrop(DragEvent dragEvent) {
        this.this$0.pick(this.this$0.tmpTargetWrapper, dragEvent.getSceneX(), dragEvent.getSceneY());
        Object object = this.this$0.tmpTargetWrapper.getEventTarget();
        dragEvent = new DragEvent(dragEvent.getSource(), (EventTarget)object, DragEvent.DRAG_DROPPED, dragEvent.getDragboard(), dragEvent.getSceneX(), dragEvent.getSceneY(), dragEvent.getScreenX(), dragEvent.getScreenY(), this.acceptedTransferMode, this.source, this.potentialTarget, dragEvent.getPickResult());
        if (this.dragboard == null) {
            throw new NullPointerException("dragboard is null in processTargetDrop()");
        }
        this.handleExitEnter(dragEvent, this.this$0.tmpTargetWrapper);
        this.fireEvent((EventTarget)object, dragEvent);
        object = dragEvent.getAcceptingObject();
        this.target = this.potentialTarget = object instanceof EventTarget ? (EventTarget)object : null;
        object = dragEvent.isDropCompleted() ? dragEvent.getAcceptedTransferMode() : null;
        this.this$0.tmpTargetWrapper.clear();
        this.handleExitEnter(dragEvent, this.this$0.tmpTargetWrapper);
        return object;
    }

    private void handleExitEnter(DragEvent dragEvent, Scene$TargetWrapper scene$TargetWrapper) {
        EventTarget eventTarget;
        EventTarget eventTarget2 = eventTarget = this.currentTargets.size() > 0 ? this.currentTargets.get(0) : null;
        if (scene$TargetWrapper.getEventTarget() != eventTarget) {
            EventTarget eventTarget3;
            int n2;
            scene$TargetWrapper.fillHierarchy(this.newTargets);
            int n3 = this.currentTargets.size() - 1;
            for (n2 = this.newTargets.size() - 1; n3 >= 0 && n2 >= 0 && this.currentTargets.get(n3) == this.newTargets.get(n2); --n3, --n2) {
            }
            while (n3 >= 0) {
                eventTarget3 = this.currentTargets.get(n3);
                if (this.potentialTarget == eventTarget3) {
                    this.potentialTarget = null;
                }
                DragEvent dragEvent2 = dragEvent;
                dragEvent = dragEvent2.copyFor(dragEvent2.getSource(), eventTarget3, this.source, this.potentialTarget, DragEvent.DRAG_EXITED_TARGET);
                Event.fireEvent(eventTarget3, dragEvent);
                --n3;
            }
            this.potentialTarget = null;
            while (n2 >= 0) {
                eventTarget3 = this.newTargets.get(n2);
                DragEvent dragEvent3 = dragEvent;
                dragEvent = dragEvent3.copyFor(dragEvent3.getSource(), eventTarget3, this.source, this.potentialTarget, DragEvent.DRAG_ENTERED_TARGET);
                Object object = dragEvent.getAcceptingObject();
                if (object instanceof EventTarget) {
                    this.potentialTarget = (EventTarget)object;
                }
                Event.fireEvent(eventTarget3, dragEvent);
                --n2;
            }
            this.currentTargets.clear();
            this.currentTargets.addAll(this.newTargets);
            this.newTargets.clear();
        }
    }

    private boolean processKey(KeyEvent inputEvent) {
        if (((Event)inputEvent).getEventType() == KeyEvent.KEY_PRESSED && inputEvent.getCode() == KeyCode.ESCAPE) {
            inputEvent = new DragEvent(this.source, this.source, DragEvent.DRAG_DONE, this.dragboard, 0.0, 0.0, 0.0, 0.0, null, this.source, null, null);
            if (this.source != null) {
                Event.fireEvent(this.source, inputEvent);
            }
            this.this$0.tmpTargetWrapper.clear();
            this.handleExitEnter((DragEvent)inputEvent, this.this$0.tmpTargetWrapper);
            return false;
        }
        return true;
    }

    private Dragboard startDrag(EventTarget eventTarget, Set<TransferMode> set) {
        if (this.dragDetected != Scene$DragDetectedState.PROCESSING) {
            throw new IllegalStateException("Cannot start drag and drop outside of DRAG_DETECTED event handler");
        }
        if (set.isEmpty()) {
            this.dragboard = null;
        } else if (this.dragboard == null) {
            this.dragboard = this.createDragboard(null, true);
        }
        DragboardHelper.setDataAccessRestriction(this.dragboard, false);
        this.source = eventTarget;
        this.potentialTarget = eventTarget;
        this.sourceTransferModes = set;
        return this.dragboard;
    }

    private void startFullPDR(EventTarget eventTarget) {
        this.fullPDRSource = eventTarget;
    }

    private Dragboard createDragboard(DragEvent object, boolean bl2) {
        if (object != null && (object = ((DragEvent)object).getDragboard()) != null) {
            return object;
        }
        object = this.this$0.peer.createDragboard(bl2);
        return DragboardHelper.createDragboard((TKClipboard)object);
    }
}

