/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene;

import com.sun.javafx.cursor.CursorFrame;
import com.sun.javafx.event.EventQueue;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.scene.input.PickResultChooser;
import com.sun.javafx.tk.Toolkit;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.Scene$DnDGesture;
import javafx.scene.Scene$MouseHandler$1;
import javafx.scene.Scene$TargetWrapper;
import javafx.scene.input.MouseDragEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.PickResult;

class Scene$MouseHandler {
    private Scene$TargetWrapper pdrEventTarget = new Scene$TargetWrapper();
    private boolean pdrInProgress = false;
    private boolean fullPDREntered = false;
    private EventTarget currentEventTarget = null;
    private MouseEvent lastEvent;
    private boolean hover = false;
    private boolean primaryButtonDown = false;
    private boolean secondaryButtonDown = false;
    private boolean middleButtonDown = false;
    private boolean backButtonDown = false;
    private boolean forwardButtonDown = false;
    private EventTarget fullPDRSource = null;
    private Scene$TargetWrapper fullPDRTmpTargetWrapper = new Scene$TargetWrapper();
    private final List<EventTarget> pdrEventTargets = new ArrayList<EventTarget>();
    private final List<EventTarget> currentEventTargets = new ArrayList<EventTarget>();
    private final List<EventTarget> newEventTargets = new ArrayList<EventTarget>();
    private final List<EventTarget> fullPDRCurrentEventTargets = new ArrayList<EventTarget>();
    private final List<EventTarget> fullPDRNewEventTargets = new ArrayList<EventTarget>();
    private EventTarget fullPDRCurrentTarget = null;
    private Cursor currCursor;
    private CursorFrame currCursorFrame;
    private EventQueue queue = new EventQueue();
    private Runnable pickProcess = new Scene$MouseHandler$1(this);
    final /* synthetic */ Scene this$0;

    Scene$MouseHandler(Scene scene) {
        this.this$0 = scene;
    }

    private void pulse() {
        if (this.hover && this.lastEvent != null) {
            Platform.runLater(this.pickProcess);
        }
    }

    private void clearPDREventTargets() {
        this.pdrInProgress = false;
        this.currentEventTarget = this.currentEventTargets.size() > 0 ? this.currentEventTargets.get(0) : null;
        this.pdrEventTarget.clear();
        this.pdrEventTargets.clear();
        this.fullPDRTmpTargetWrapper.clear();
    }

    public void enterFullPDR(EventTarget eventTarget) {
        this.fullPDREntered = true;
        this.fullPDRSource = eventTarget;
        this.fullPDRCurrentTarget = null;
        this.fullPDRCurrentEventTargets.clear();
    }

    public void exitFullPDR(MouseEvent mouseEvent) {
        if (!this.fullPDREntered) {
            return;
        }
        this.fullPDREntered = false;
        for (int i2 = this.fullPDRCurrentEventTargets.size() - 1; i2 >= 0; --i2) {
            EventTarget eventTarget;
            EventTarget eventTarget2 = eventTarget = this.fullPDRCurrentEventTargets.get(i2);
            Event.fireEvent(eventTarget, MouseEvent.copyForMouseDragEvent(mouseEvent, eventTarget2, eventTarget2, MouseDragEvent.MOUSE_DRAG_EXITED_TARGET, this.fullPDRSource, mouseEvent.getPickResult()));
        }
        this.fullPDRSource = null;
        this.fullPDRCurrentEventTargets.clear();
        this.fullPDRCurrentTarget = null;
    }

    private void handleNodeRemoval(Node object) {
        EventTarget eventTarget;
        int n2;
        if (this.lastEvent == null) {
            return;
        }
        if (this.currentEventTargets.contains(object)) {
            n2 = 0;
            eventTarget = null;
            while (eventTarget != object) {
                EventTarget eventTarget2 = eventTarget = this.currentEventTargets.get(n2++);
                this.queue.postEvent(this.lastEvent.copyFor(eventTarget2, eventTarget2, MouseEvent.MOUSE_EXITED_TARGET));
            }
            this.currentEventTargets.subList(0, n2).clear();
        }
        if (this.fullPDREntered && this.fullPDRCurrentEventTargets.contains(object)) {
            n2 = 0;
            eventTarget = null;
            while (eventTarget != object) {
                EventTarget eventTarget3 = eventTarget = this.fullPDRCurrentEventTargets.get(n2++);
                this.queue.postEvent(MouseEvent.copyForMouseDragEvent(this.lastEvent, eventTarget3, eventTarget3, MouseDragEvent.MOUSE_DRAG_EXITED_TARGET, this.fullPDRSource, this.lastEvent.getPickResult()));
            }
            this.fullPDRCurrentEventTargets.subList(0, n2).clear();
        }
        this.queue.fire();
        if (this.pdrInProgress && this.pdrEventTargets.contains(object)) {
            n2 = 0;
            eventTarget = null;
            while (eventTarget != object) {
                eventTarget = this.pdrEventTargets.get(n2++);
                ((Node)eventTarget).setPressed(false);
            }
            this.pdrEventTargets.subList(0, n2).clear();
            eventTarget = this.pdrEventTargets.get(0);
            object = this.pdrEventTarget.getResult();
            if (eventTarget instanceof Node) {
                this.pdrEventTarget.setNodeResult(new PickResult((Node)eventTarget, ((PickResult)object).getIntersectedPoint(), ((PickResult)object).getIntersectedDistance()));
                return;
            }
            this.pdrEventTarget.setSceneResult(new PickResult(null, ((PickResult)object).getIntersectedPoint(), ((PickResult)object).getIntersectedDistance()), (Scene)eventTarget);
        }
    }

    private void handleEnterExit(MouseEvent mouseEvent, Scene$TargetWrapper scene$TargetWrapper) {
        if (scene$TargetWrapper.getEventTarget() != this.currentEventTarget || ((Event)mouseEvent).getEventType() == MouseEvent.MOUSE_EXITED) {
            EventTarget eventTarget;
            if (((Event)mouseEvent).getEventType() == MouseEvent.MOUSE_EXITED) {
                this.newEventTargets.clear();
            } else {
                scene$TargetWrapper.fillHierarchy(this.newEventTargets);
            }
            int n2 = this.newEventTargets.size();
            int n3 = this.currentEventTargets.size() - 1;
            int n4 = n2 - 1;
            int n5 = this.pdrEventTargets.size() - 1;
            while (n3 >= 0 && n4 >= 0 && this.currentEventTargets.get(n3) == this.newEventTargets.get(n4)) {
                --n3;
                --n4;
                --n5;
            }
            int n6 = n5;
            while (n3 >= 0) {
                eventTarget = this.currentEventTargets.get(n3);
                if (this.pdrInProgress && (n5 < 0 || eventTarget != this.pdrEventTargets.get(n5))) break;
                EventTarget eventTarget2 = eventTarget;
                this.queue.postEvent(mouseEvent.copyFor(eventTarget2, eventTarget2, MouseEvent.MOUSE_EXITED_TARGET));
                --n3;
                --n5;
            }
            n5 = n6;
            while (n4 >= 0) {
                eventTarget = this.newEventTargets.get(n4);
                if (this.pdrInProgress && (n5 < 0 || eventTarget != this.pdrEventTargets.get(n5))) break;
                EventTarget eventTarget3 = eventTarget;
                this.queue.postEvent(mouseEvent.copyFor(eventTarget3, eventTarget3, MouseEvent.MOUSE_ENTERED_TARGET));
                --n4;
                --n5;
            }
            this.currentEventTarget = scene$TargetWrapper.getEventTarget();
            this.currentEventTargets.clear();
            ++n4;
            while (n4 < n2) {
                this.currentEventTargets.add(this.newEventTargets.get(n4));
                ++n4;
            }
        }
        this.queue.fire();
    }

    private void process(MouseEvent mouseEvent, boolean bl2) {
        Toolkit.getToolkit().checkFxUserThread();
        Scene.inMousePick = true;
        this.this$0.cursorScreenPos = new Point2D(mouseEvent.getScreenX(), mouseEvent.getScreenY());
        this.this$0.cursorScenePos = new Point2D(mouseEvent.getSceneX(), mouseEvent.getSceneY());
        boolean bl3 = false;
        if (!bl2) {
            if (((Event)mouseEvent).getEventType() == MouseEvent.MOUSE_PRESSED) {
                if (!(this.primaryButtonDown || this.secondaryButtonDown || this.middleButtonDown || this.backButtonDown || this.forwardButtonDown || this.this$0.dndGesture != null)) {
                    bl3 = true;
                    this.this$0.dndGesture = new Scene$DnDGesture(this.this$0);
                    this.clearPDREventTargets();
                }
            } else if (((Event)mouseEvent).getEventType() == MouseEvent.MOUSE_MOVED) {
                this.clearPDREventTargets();
            } else if (((Event)mouseEvent).getEventType() == MouseEvent.MOUSE_ENTERED) {
                this.hover = true;
            } else if (((Event)mouseEvent).getEventType() == MouseEvent.MOUSE_EXITED) {
                this.hover = false;
            }
            this.primaryButtonDown = mouseEvent.isPrimaryButtonDown();
            this.secondaryButtonDown = mouseEvent.isSecondaryButtonDown();
            this.middleButtonDown = mouseEvent.isMiddleButtonDown();
            this.backButtonDown = mouseEvent.isBackButtonDown();
            this.forwardButtonDown = mouseEvent.isForwardButtonDown();
        }
        this.this$0.pick(this.this$0.tmpTargetWrapper, mouseEvent.getSceneX(), mouseEvent.getSceneY());
        Object object = this.this$0.tmpTargetWrapper.getResult();
        if (object != null) {
            mouseEvent = new MouseEvent(((Event)mouseEvent).getEventType(), mouseEvent.getSceneX(), mouseEvent.getSceneY(), mouseEvent.getScreenX(), mouseEvent.getScreenY(), mouseEvent.getButton(), mouseEvent.getClickCount(), mouseEvent.isShiftDown(), mouseEvent.isControlDown(), mouseEvent.isAltDown(), mouseEvent.isMetaDown(), mouseEvent.isPrimaryButtonDown(), mouseEvent.isMiddleButtonDown(), mouseEvent.isSecondaryButtonDown(), mouseEvent.isBackButtonDown(), mouseEvent.isForwardButtonDown(), mouseEvent.isSynthesized(), mouseEvent.isPopupTrigger(), mouseEvent.isStillSincePress(), (PickResult)object);
        }
        if (((Event)mouseEvent).getEventType() == MouseEvent.MOUSE_EXITED) {
            this.this$0.tmpTargetWrapper.clear();
        }
        object = this.pdrInProgress ? this.pdrEventTarget : this.this$0.tmpTargetWrapper;
        if (bl3) {
            this.pdrEventTarget.copy((Scene$TargetWrapper)object);
            this.pdrEventTarget.fillHierarchy(this.pdrEventTargets);
        }
        if (!bl2) {
            mouseEvent = this.this$0.clickGenerator.preProcess(mouseEvent);
        }
        this.handleEnterExit(mouseEvent, this.this$0.tmpTargetWrapper);
        if (this.this$0.dndGesture != null) {
            this.this$0.dndGesture.processDragDetection(mouseEvent);
        }
        if (this.fullPDREntered && ((Event)mouseEvent).getEventType() == MouseEvent.MOUSE_RELEASED) {
            this.processFullPDR(mouseEvent, bl2);
        }
        if (((Scene$TargetWrapper)object).getEventTarget() != null && ((Event)mouseEvent).getEventType() != MouseEvent.MOUSE_ENTERED && ((Event)mouseEvent).getEventType() != MouseEvent.MOUSE_EXITED && !bl2) {
            Event.fireEvent(((Scene$TargetWrapper)object).getEventTarget(), mouseEvent);
        }
        if (this.fullPDREntered && ((Event)mouseEvent).getEventType() != MouseEvent.MOUSE_RELEASED) {
            this.processFullPDR(mouseEvent, bl2);
        }
        if (!bl2) {
            this.this$0.clickGenerator.postProcess(mouseEvent, (Scene$TargetWrapper)object, this.this$0.tmpTargetWrapper);
        }
        if (!bl2 && this.this$0.dndGesture != null && !this.this$0.dndGesture.process(mouseEvent, ((Scene$TargetWrapper)object).getEventTarget())) {
            this.this$0.dndGesture = null;
        }
        Cursor cursor = ((Scene$TargetWrapper)object).getCursor();
        if (((Event)mouseEvent).getEventType() != MouseEvent.MOUSE_EXITED) {
            if (cursor == null && this.hover) {
                cursor = this.this$0.getCursor();
            }
            this.updateCursor(cursor);
            this.updateCursorFrame();
        }
        if (bl3) {
            this.pdrInProgress = true;
        }
        if (!(!this.pdrInProgress || this.primaryButtonDown || this.secondaryButtonDown || this.middleButtonDown || this.backButtonDown || this.forwardButtonDown)) {
            this.clearPDREventTargets();
            this.exitFullPDR(mouseEvent);
            this.this$0.pick(this.this$0.tmpTargetWrapper, mouseEvent.getSceneX(), mouseEvent.getSceneY());
            this.handleEnterExit(mouseEvent, this.this$0.tmpTargetWrapper);
        }
        this.lastEvent = ((Event)mouseEvent).getEventType() == MouseEvent.MOUSE_EXITED ? null : mouseEvent;
        Scene.inMousePick = false;
    }

    private void processFullPDR(MouseEvent mouseEvent, boolean bl2) {
        this.this$0.pick(this.fullPDRTmpTargetWrapper, mouseEvent.getSceneX(), mouseEvent.getSceneY());
        PickResult pickResult = this.fullPDRTmpTargetWrapper.getResult();
        EventTarget eventTarget = this.fullPDRTmpTargetWrapper.getEventTarget();
        if (eventTarget != this.fullPDRCurrentTarget) {
            EventTarget eventTarget2;
            int n2;
            this.fullPDRTmpTargetWrapper.fillHierarchy(this.fullPDRNewEventTargets);
            int n3 = this.fullPDRNewEventTargets.size();
            --n3;
            for (n2 = this.fullPDRCurrentEventTargets.size() - 1; n2 >= 0 && n3 >= 0 && this.fullPDRCurrentEventTargets.get(n2) == this.fullPDRNewEventTargets.get(n3); --n2, --n3) {
            }
            while (n2 >= 0) {
                EventTarget eventTarget3 = eventTarget2 = this.fullPDRCurrentEventTargets.get(n2);
                Event.fireEvent(eventTarget2, MouseEvent.copyForMouseDragEvent(mouseEvent, eventTarget3, eventTarget3, MouseDragEvent.MOUSE_DRAG_EXITED_TARGET, this.fullPDRSource, pickResult));
                --n2;
            }
            while (n3 >= 0) {
                EventTarget eventTarget4 = eventTarget2 = this.fullPDRNewEventTargets.get(n3);
                Event.fireEvent(eventTarget2, MouseEvent.copyForMouseDragEvent(mouseEvent, eventTarget4, eventTarget4, MouseDragEvent.MOUSE_DRAG_ENTERED_TARGET, this.fullPDRSource, pickResult));
                --n3;
            }
            this.fullPDRCurrentTarget = eventTarget;
            this.fullPDRCurrentEventTargets.clear();
            this.fullPDRCurrentEventTargets.addAll(this.fullPDRNewEventTargets);
            this.fullPDRNewEventTargets.clear();
        }
        if (eventTarget != null && !bl2) {
            if (((Event)mouseEvent).getEventType() == MouseEvent.MOUSE_DRAGGED) {
                EventTarget eventTarget5 = eventTarget;
                Event.fireEvent(eventTarget, MouseEvent.copyForMouseDragEvent(mouseEvent, eventTarget5, eventTarget5, MouseDragEvent.MOUSE_DRAG_OVER, this.fullPDRSource, pickResult));
            }
            if (((Event)mouseEvent).getEventType() == MouseEvent.MOUSE_RELEASED) {
                EventTarget eventTarget6 = eventTarget;
                Event.fireEvent(eventTarget, MouseEvent.copyForMouseDragEvent(mouseEvent, eventTarget6, eventTarget6, MouseDragEvent.MOUSE_DRAG_RELEASED, this.fullPDRSource, pickResult));
            }
        }
    }

    private void updateCursor(Cursor cursor) {
        if (this.currCursor != cursor) {
            if (this.currCursor != null) {
                this.currCursor.deactivate();
            }
            if (cursor != null) {
                cursor.activate();
            }
            this.currCursor = cursor;
        }
    }

    public void updateCursorFrame() {
        CursorFrame cursorFrame;
        CursorFrame cursorFrame2 = cursorFrame = this.currCursor != null ? this.currCursor.getCurrentFrame() : Cursor.DEFAULT.getCurrentFrame();
        if (this.currCursorFrame != cursorFrame) {
            if (this.this$0.peer != null) {
                this.this$0.peer.setCursor(cursorFrame);
            }
            this.currCursorFrame = cursorFrame;
        }
    }

    private PickResult pickNode(PickRay pickRay) {
        PickResultChooser pickResultChooser = new PickResultChooser();
        this.this$0.getRoot().pickNode(pickRay, pickResultChooser);
        return pickResultChooser.toPickResult();
    }
}

