/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene;

import com.sun.javafx.logging.PulseLogger;
import com.sun.javafx.perf.PerformanceTracker;
import com.sun.javafx.scene.CssFlags;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.sg.prism.NGCamera;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.tk.TKPulseListener;
import com.sun.javafx.tk.Toolkit;
import com.sun.prism.impl.PrismSettings;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.Scene$DirtyBits;
import javafx.scene.SubScene;

class Scene$ScenePulseListener
implements TKPulseListener {
    private boolean firstPulse = true;
    final /* synthetic */ Scene this$0;

    Scene$ScenePulseListener(Scene scene) {
        this.this$0 = scene;
    }

    private void synchronizeSceneNodes() {
        Toolkit.getToolkit().checkFxUserThread();
        Scene.inSynchronizer = true;
        if (this.this$0.dirtyNodes == null) {
            Scene$ScenePulseListener scene$ScenePulseListener = this;
            scene$ScenePulseListener.syncAll(scene$ScenePulseListener.this$0.getRoot());
            this.this$0.dirtyNodes = new Node[30];
        } else {
            for (int i2 = 0; i2 < this.this$0.dirtyNodesSize; ++i2) {
                Node node = this.this$0.dirtyNodes[i2];
                this.this$0.dirtyNodes[i2] = null;
                if (node.getScene() != this.this$0) continue;
                node.syncPeer();
            }
            this.this$0.dirtyNodesSize = 0;
        }
        Scene.inSynchronizer = false;
    }

    private int syncAll(Node node) {
        node.syncPeer();
        int n2 = 1;
        if (node instanceof Parent) {
            Parent parent = (Parent)node;
            int n3 = parent.getChildren().size();
            for (int i2 = 0; i2 < n3; ++i2) {
                Node node2 = (Node)parent.getChildren().get(i2);
                if (node2 == null) continue;
                n2 += this.syncAll(node2);
            }
        } else if (node instanceof SubScene) {
            SubScene subScene = (SubScene)node;
            n2 = 1 + this.syncAll(subScene.getRoot());
        }
        if (node.getClip() != null) {
            n2 += this.syncAll(node.getClip());
        }
        return n2;
    }

    private void synchronizeSceneProperties() {
        Object object;
        Scene.inSynchronizer = true;
        if (this.this$0.isDirty(Scene$DirtyBits.ROOT_DIRTY)) {
            this.this$0.peer.setRoot((NGNode)this.this$0.getRoot().getPeer());
        }
        if (this.this$0.isDirty(Scene$DirtyBits.FILL_DIRTY)) {
            object = Toolkit.getToolkit();
            this.this$0.peer.setFillPaint(this.this$0.getFill() == null ? null : ((Toolkit)object).getPaint(this.this$0.getFill()));
        }
        object = this.this$0.getEffectiveCamera();
        if (this.this$0.isDirty(Scene$DirtyBits.CAMERA_DIRTY)) {
            NodeHelper.updatePeer((Node)object);
            this.this$0.peer.setCamera((NGCamera)((Node)object).getPeer());
        }
        if (this.this$0.isDirty(Scene$DirtyBits.CURSOR_DIRTY)) {
            this.this$0.mouseHandler.updateCursor(this.this$0.getCursor());
            this.this$0.mouseHandler.updateCursorFrame();
        }
        this.this$0.clearDirty();
        Scene.inSynchronizer = false;
    }

    private void focusCleanup() {
        if (this.this$0.isFocusDirty()) {
            Node node = this.this$0.getFocusOwner();
            if (node == null) {
                this.this$0.focusInitial();
            } else if (node.getScene() != this.this$0) {
                this.this$0.requestFocus(null, false);
                this.this$0.focusInitial();
            } else if (!node.isCanReceiveFocus()) {
                this.this$0.requestFocus(null, false);
                this.this$0.focusIneligible(node);
            }
            this.this$0.setFocusDirty(false);
        }
    }

    @Override
    public void pulse() {
        boolean bl2;
        if (this.this$0.tracker != null) {
            this.this$0.tracker.pulse();
        }
        if (this.firstPulse) {
            PerformanceTracker.logEvent("Scene - first repaint");
        }
        this.focusCleanup();
        this.this$0.disposeAccessibles();
        if (this.this$0.preLayoutPulseListeners != null) {
            for (Runnable runnable : this.this$0.preLayoutPulseListeners) {
                runnable.run();
            }
        }
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newPhase("CSS Pass");
        }
        this.this$0.doCSSPass();
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newPhase("Layout Pass");
        }
        this.this$0.doLayoutPass();
        if (this.this$0.postLayoutPulseListeners != null) {
            for (Runnable runnable : this.this$0.postLayoutPulseListeners) {
                runnable.run();
            }
        }
        if (bl2 = this.this$0.dirtyNodes == null || this.this$0.dirtyNodesSize != 0 || !this.this$0.isDirtyEmpty()) {
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newPhase("Update bounds");
            }
            this.this$0.getRoot().updateBounds();
            if (this.this$0.peer != null) {
                try {
                    if (PulseLogger.PULSE_LOGGING_ENABLED) {
                        PulseLogger.newPhase("Waiting for previous rendering");
                    }
                    this.this$0.peer.waitForRenderingToComplete();
                    this.this$0.peer.waitForSynchronization();
                    if (PulseLogger.PULSE_LOGGING_ENABLED) {
                        PulseLogger.newPhase("Copy state to render graph");
                    }
                    this.this$0.syncLights();
                    this.synchronizeSceneProperties();
                    this.synchronizeSceneNodes();
                    this.this$0.mouseHandler.pulse();
                    this.this$0.peer.markDirty();
                }
                finally {
                    this.this$0.peer.releaseSynchronization(true);
                }
            } else {
                if (PulseLogger.PULSE_LOGGING_ENABLED) {
                    PulseLogger.newPhase("Synchronize with null peer");
                }
                this.synchronizeSceneNodes();
                this.this$0.mouseHandler.pulse();
            }
            if (this.this$0.getRoot().cssFlag != CssFlags.CLEAN) {
                NodeHelper.markDirty(this.this$0.getRoot(), DirtyBits.NODE_CSS);
            }
        }
        this.this$0.mouseHandler.updateCursorFrame();
        if (this.firstPulse) {
            if (PerformanceTracker.isLoggingEnabled()) {
                PerformanceTracker.logEvent("Scene - first repaint - layout complete");
                if (PrismSettings.perfLogFirstPaintFlush) {
                    PerformanceTracker.outputLog();
                }
                if (PrismSettings.perfLogFirstPaintExit) {
                    System.exit(0);
                }
            }
            this.firstPulse = false;
        }
        if (this.this$0.testPulseListener != null) {
            this.this$0.testPulseListener.run();
        }
    }
}

