/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene;

import java.util.List;
import javafx.event.EventTarget;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.PickResult;

class Scene$TargetWrapper {
    private Scene scene;
    private Node node;
    private PickResult result;

    private Scene$TargetWrapper() {
    }

    public void fillHierarchy(List<EventTarget> list) {
        list.clear();
        Node node = this.node;
        while (node != null) {
            list.add(node);
            Parent parent = node.getParent();
            node = parent != null ? parent : node.getSubScene();
        }
        if (this.scene != null) {
            list.add(this.scene);
        }
    }

    public EventTarget getEventTarget() {
        if (this.node != null) {
            return this.node;
        }
        return this.scene;
    }

    public Cursor getCursor() {
        Cursor cursor = null;
        if (this.node != null) {
            cursor = this.node.getCursor();
            Parent parent = this.node.getParent();
            while (cursor == null && parent != null) {
                cursor = parent.getCursor();
                Parent parent2 = parent.getParent();
                parent = parent2 != null ? parent2 : parent.getSubScene();
            }
        }
        return cursor;
    }

    public void clear() {
        this.set(null, null);
        this.result = null;
    }

    public void setNodeResult(PickResult object) {
        if (object != null) {
            this.result = object;
            Object object2 = object = ((PickResult)object).getIntersectedNode();
            this.set((Node)object2, ((Node)object2).getScene());
        }
    }

    public void setSceneResult(PickResult pickResult, Scene scene) {
        if (pickResult != null) {
            this.result = pickResult;
            this.set(null, scene);
        }
    }

    public PickResult getResult() {
        return this.result;
    }

    public void copy(Scene$TargetWrapper scene$TargetWrapper) {
        this.node = scene$TargetWrapper.node;
        this.scene = scene$TargetWrapper.scene;
        this.result = scene$TargetWrapper.result;
    }

    private void set(Node node, Scene scene) {
        this.node = node;
        this.scene = scene;
    }
}

