/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene;

import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.SpotLightHelper;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGSpotLight;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.geometry.Point3D;
import javafx.scene.PointLight;
import javafx.scene.SpotLight$1;
import javafx.scene.SpotLight$2;
import javafx.scene.paint.Color;

public class SpotLight
extends PointLight {
    private ObjectProperty<Point3D> direction;
    private static final Point3D DEFAULT_DIRECTION;
    private DoubleProperty innerAngle;
    private static final double DEFAULT_INNER_ANGLE;
    private DoubleProperty outerAngle;
    private static final double DEFAULT_OUTER_ANGLE;
    private DoubleProperty falloff;
    private static final double DEFAULT_FALLOFF;

    public SpotLight() {
        SpotLightHelper.initHelper(this);
    }

    public SpotLight(Color color) {
        super(color);
        SpotLightHelper.initHelper(this);
    }

    public final void setDirection(Point3D point3D) {
        this.directionProperty().set(point3D);
    }

    public final Point3D getDirection() {
        if (this.direction == null) {
            return DEFAULT_DIRECTION;
        }
        return (Point3D)this.direction.get();
    }

    public final ObjectProperty<Point3D> directionProperty() {
        if (this.direction == null) {
            SpotLight spotLight = this;
            this.direction = new SpotLight$2(spotLight, spotLight, "direction", DEFAULT_DIRECTION);
        }
        return this.direction;
    }

    public final void setInnerAngle(double d2) {
        this.innerAngleProperty().set(d2);
    }

    public final double getInnerAngle() {
        if (this.innerAngle == null) {
            return DEFAULT_INNER_ANGLE;
        }
        return this.innerAngle.get();
    }

    public final DoubleProperty innerAngleProperty() {
        if (this.innerAngle == null) {
            this.innerAngle = this.getLightDoubleProperty("innerAngle", DEFAULT_INNER_ANGLE);
        }
        return this.innerAngle;
    }

    public final void setOuterAngle(double d2) {
        this.outerAngleProperty().set(d2);
    }

    public final double getOuterAngle() {
        if (this.outerAngle == null) {
            return DEFAULT_OUTER_ANGLE;
        }
        return this.outerAngle.get();
    }

    public final DoubleProperty outerAngleProperty() {
        if (this.outerAngle == null) {
            this.outerAngle = this.getLightDoubleProperty("outerAngle", DEFAULT_OUTER_ANGLE);
        }
        return this.outerAngle;
    }

    public final void setFalloff(double d2) {
        this.falloffProperty().set(d2);
    }

    public final double getFalloff() {
        if (this.falloff == null) {
            return DEFAULT_FALLOFF;
        }
        return this.falloff.get();
    }

    public final DoubleProperty falloffProperty() {
        if (this.falloff == null) {
            this.falloff = this.getLightDoubleProperty("falloff", DEFAULT_FALLOFF);
        }
        return this.falloff;
    }

    private NGNode doCreatePeer() {
        return new NGSpotLight();
    }

    private void doUpdatePeer() {
        if (this.isDirty(DirtyBits.NODE_LIGHT)) {
            NGSpotLight nGSpotLight = (NGSpotLight)this.getPeer();
            nGSpotLight.setDirection(this.getDirection());
            nGSpotLight.setInnerAngle((float)this.getInnerAngle());
            nGSpotLight.setOuterAngle((float)this.getOuterAngle());
            nGSpotLight.setFalloff((float)this.getFalloff());
        }
    }

    static {
        SpotLightHelper.setSpotLightAccessor(new SpotLight$1());
        DEFAULT_DIRECTION = NGSpotLight.getDefaultDirection();
        DEFAULT_INNER_ANGLE = NGSpotLight.getDefaultInnerAngle();
        DEFAULT_OUTER_ANGLE = NGSpotLight.getDefaultOuterAngle();
        DEFAULT_FALLOFF = NGSpotLight.getDefaultFalloff();
    }
}

