/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.canvas;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.canvas.CanvasHelper;
import com.sun.javafx.sg.prism.GrowableDataBuffer;
import com.sun.javafx.sg.prism.NGCanvas;
import com.sun.javafx.sg.prism.NGNode;
import javafx.beans.property.DoubleProperty;
import javafx.geometry.NodeOrientation;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas$1;
import javafx.scene.canvas.Canvas$2;
import javafx.scene.canvas.Canvas$3;
import javafx.scene.canvas.GraphicsContext;

public class Canvas
extends Node {
    static final int DEFAULT_VAL_BUF_SIZE = 1024;
    static final int DEFAULT_OBJ_BUF_SIZE = 32;
    private static final int SIZE_HISTORY = 5;
    private GrowableDataBuffer current;
    private boolean rendererBehind;
    private int[] recentvalsizes;
    private int[] recentobjsizes;
    private int lastsizeindex;
    private GraphicsContext theContext;
    private DoubleProperty width;
    private DoubleProperty height;

    public Canvas() {
        this(0.0, 0.0);
    }

    public Canvas(double d2, double d3) {
        CanvasHelper.initHelper(this);
        this.recentvalsizes = new int[5];
        this.recentobjsizes = new int[5];
        this.setNodeOrientation(NodeOrientation.LEFT_TO_RIGHT);
        this.setWidth(d2);
        this.setHeight(d3);
    }

    private static int max(int[] nArray, int n2) {
        for (int n3 : nArray) {
            if (n2 >= n3) continue;
            n2 = n3;
        }
        return n2;
    }

    GrowableDataBuffer getBuffer() {
        NodeHelper.markDirty(this, DirtyBits.NODE_CONTENTS);
        NodeHelper.markDirty(this, DirtyBits.NODE_FORCE_SYNC);
        if (this.current == null) {
            int n2 = Canvas.max(this.recentvalsizes, 1024);
            int n3 = Canvas.max(this.recentobjsizes, 32);
            this.current = GrowableDataBuffer.getBuffer(n2, n3);
            this.theContext.updateDimensions();
        }
        return this.current;
    }

    boolean isRendererFallingBehind() {
        return this.rendererBehind;
    }

    public GraphicsContext getGraphicsContext2D() {
        if (this.theContext == null) {
            this.theContext = new GraphicsContext(this);
        }
        return this.theContext;
    }

    public final void setWidth(double d2) {
        this.widthProperty().set(d2);
    }

    public final double getWidth() {
        if (this.width == null) {
            return 0.0;
        }
        return this.width.get();
    }

    public final DoubleProperty widthProperty() {
        if (this.width == null) {
            this.width = new Canvas$2(this);
        }
        return this.width;
    }

    public final void setHeight(double d2) {
        this.heightProperty().set(d2);
    }

    public final double getHeight() {
        if (this.height == null) {
            return 0.0;
        }
        return this.height.get();
    }

    public final DoubleProperty heightProperty() {
        if (this.height == null) {
            this.height = new Canvas$3(this);
        }
        return this.height;
    }

    private NGNode doCreatePeer() {
        return new NGCanvas();
    }

    private void doUpdatePeer() {
        NGCanvas nGCanvas;
        if (NodeHelper.isDirty(this, DirtyBits.NODE_GEOMETRY)) {
            nGCanvas = (NGCanvas)NodeHelper.getPeer(this);
            nGCanvas.updateBounds((float)this.getWidth(), (float)this.getHeight());
        }
        if (NodeHelper.isDirty(this, DirtyBits.NODE_CONTENTS)) {
            nGCanvas = (NGCanvas)NodeHelper.getPeer(this);
            if (this.current != null && !this.current.isEmpty()) {
                if (--this.lastsizeindex < 0) {
                    this.lastsizeindex = 4;
                }
                this.recentvalsizes[this.lastsizeindex] = this.current.writeValuePosition();
                this.recentobjsizes[this.lastsizeindex] = this.current.writeObjectPosition();
                this.rendererBehind = nGCanvas.updateRendering(this.current);
                this.current = null;
            }
        }
    }

    private boolean doComputeContains(double d2, double d3) {
        double d4 = this.getWidth();
        double d5 = this.getHeight();
        return d4 > 0.0 && d5 > 0.0 && d2 >= 0.0 && d3 >= 0.0 && d2 < d4 && d3 < d5;
    }

    private BaseBounds doComputeGeomBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        BaseBounds baseBounds2 = baseBounds = new RectBounds(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
        baseBounds = baseTransform.transform(baseBounds2, baseBounds2);
        return baseBounds;
    }

    static {
        CanvasHelper.setCanvasAccessor(new Canvas$1());
    }
}

