/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.canvas;

import com.sun.javafx.geom.Arc2D;
import com.sun.javafx.geom.IllegalPathStateException;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;
import com.sun.javafx.scene.text.FontHelper;
import com.sun.javafx.sg.prism.GrowableDataBuffer;
import com.sun.javafx.tk.Toolkit;
import com.sun.scenario.effect.EffectHelper;
import java.util.Arrays;
import java.util.LinkedList;
import javafx.geometry.NodeOrientation;
import javafx.geometry.VPos;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext$1;
import javafx.scene.canvas.GraphicsContext$State;
import javafx.scene.effect.BlendMode;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.PixelWriter;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.text.Font;
import javafx.scene.text.FontSmoothingType;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Transform;

public final class GraphicsContext {
    Canvas theCanvas;
    Path2D path;
    boolean pathDirty;
    GraphicsContext$State curState;
    LinkedList<GraphicsContext$State> stateStack;
    LinkedList<Path2D> clipStack;
    private float[] coords = new float[6];
    private static final byte[] pgtype = new byte[]{41, 42, 43, 44, 45};
    private static final int[] numsegs = new int[]{2, 2, 4, 6, 0};
    private float[] polybuf = new float[512];
    private boolean txdirty;
    private PixelWriter writer;

    GraphicsContext(Canvas canvas) {
        this.theCanvas = canvas;
        this.path = new Path2D();
        this.pathDirty = true;
        this.curState = new GraphicsContext$State();
        this.stateStack = new LinkedList();
        this.clipStack = new LinkedList();
    }

    private GrowableDataBuffer getBuffer() {
        return this.theCanvas.getBuffer();
    }

    private void markPathDirty() {
        this.pathDirty = true;
    }

    private void writePath(byte by2) {
        this.updateTransform();
        GrowableDataBuffer growableDataBuffer = this.getBuffer();
        if (this.pathDirty) {
            growableDataBuffer.putByte((byte)40);
            PathIterator pathIterator = ((Shape)this.path).getPathIterator(null);
            while (!pathIterator.isDone()) {
                int n2 = pathIterator.currentSegment(this.coords);
                growableDataBuffer.putByte(pgtype[n2]);
                for (int i2 = 0; i2 < numsegs[n2]; ++i2) {
                    growableDataBuffer.putFloat(this.coords[i2]);
                }
                pathIterator.next();
            }
            growableDataBuffer.putByte((byte)46);
            this.pathDirty = false;
        }
        growableDataBuffer.putByte(by2);
    }

    private void writePaint(Paint paint, byte by2) {
        GrowableDataBuffer growableDataBuffer = this.getBuffer();
        growableDataBuffer.putByte(by2);
        growableDataBuffer.putObject(Toolkit.getPaintAccessor().getPlatformPaint(paint));
    }

    private void writeArcType(ArcType arcType) {
        byte by2;
        switch (arcType) {
            case OPEN: {
                by2 = 0;
                break;
            }
            case CHORD: {
                by2 = 1;
                break;
            }
            case ROUND: {
                by2 = 2;
                break;
            }
            default: {
                return;
            }
        }
        this.writeParam(by2, (byte)15);
    }

    private void writeRectParams(GrowableDataBuffer growableDataBuffer, double d2, double d3, double d4, double d5, byte by2) {
        growableDataBuffer.putByte(by2);
        growableDataBuffer.putFloat((float)d2);
        growableDataBuffer.putFloat((float)d3);
        growableDataBuffer.putFloat((float)d4);
        growableDataBuffer.putFloat((float)d5);
    }

    private void writeOp4(double d2, double d3, double d4, double d5, byte by2) {
        this.updateTransform();
        GraphicsContext graphicsContext = this;
        graphicsContext.writeRectParams(graphicsContext.getBuffer(), d2, d3, d4, d5, by2);
    }

    private void writeOp6(double d2, double d3, double d4, double d5, double d6, double d7, byte by2) {
        this.updateTransform();
        GrowableDataBuffer growableDataBuffer = this.getBuffer();
        growableDataBuffer.putByte(by2);
        growableDataBuffer.putFloat((float)d2);
        growableDataBuffer.putFloat((float)d3);
        growableDataBuffer.putFloat((float)d4);
        growableDataBuffer.putFloat((float)d5);
        growableDataBuffer.putFloat((float)d6);
        growableDataBuffer.putFloat((float)d7);
    }

    private void flushPolyBuf(GrowableDataBuffer growableDataBuffer, float[] fArray, int n2, byte by2) {
        ((BaseTransform)this.curState.transform).transform(fArray, 0, fArray, 0, n2 / 2);
        for (int i2 = 0; i2 < n2; i2 += 2) {
            growableDataBuffer.putByte(by2);
            growableDataBuffer.putFloat(fArray[i2]);
            growableDataBuffer.putFloat(fArray[i2 + 1]);
            by2 = (byte)42;
        }
    }

    private void writePoly(double[] dArray, double[] dArray2, int n2, boolean bl2, byte by2) {
        if (dArray == null || dArray2 == null) {
            return;
        }
        GrowableDataBuffer growableDataBuffer = this.getBuffer();
        growableDataBuffer.putByte((byte)40);
        int n3 = 0;
        int n4 = 41;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (n3 >= this.polybuf.length) {
                this.flushPolyBuf(growableDataBuffer, this.polybuf, n3, (byte)n4);
                n3 = 0;
                n4 = 42;
            }
            this.polybuf[n3++] = (float)dArray[i2];
            this.polybuf[n3++] = (float)dArray2[i2];
        }
        this.flushPolyBuf(growableDataBuffer, this.polybuf, n3, (byte)n4);
        if (bl2) {
            growableDataBuffer.putByte((byte)45);
        }
        growableDataBuffer.putByte((byte)46);
        this.updateTransform();
        growableDataBuffer.putByte(by2);
        this.markPathDirty();
    }

    private void writeImage(Image object, double d2, double d3, double d4, double d5) {
        if (object == null || ((Image)object).getProgress() < 1.0) {
            return;
        }
        object = Toolkit.getImageAccessor().getPlatformImage((Image)object);
        if (object == null) {
            return;
        }
        this.updateTransform();
        GrowableDataBuffer growableDataBuffer = this.getBuffer();
        this.writeRectParams(growableDataBuffer, d2, d3, d4, d5, (byte)50);
        growableDataBuffer.putObject(object);
    }

    private void writeImage(Image object, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        if (object == null || ((Image)object).getProgress() < 1.0) {
            return;
        }
        object = Toolkit.getImageAccessor().getPlatformImage((Image)object);
        if (object == null) {
            return;
        }
        this.updateTransform();
        GrowableDataBuffer growableDataBuffer = this.getBuffer();
        this.writeRectParams(growableDataBuffer, d2, d3, d4, d5, (byte)51);
        growableDataBuffer.putFloat((float)d6);
        growableDataBuffer.putFloat((float)d7);
        growableDataBuffer.putFloat((float)d8);
        growableDataBuffer.putFloat((float)d9);
        growableDataBuffer.putObject(object);
    }

    private void writeText(String string, double d2, double d3, double d4, byte by2) {
        if (string == null) {
            return;
        }
        this.updateTransform();
        GrowableDataBuffer growableDataBuffer = this.getBuffer();
        growableDataBuffer.putByte(by2);
        growableDataBuffer.putFloat((float)d2);
        growableDataBuffer.putFloat((float)d3);
        growableDataBuffer.putFloat((float)d4);
        growableDataBuffer.putBoolean(this.theCanvas.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT);
        growableDataBuffer.putObject(string);
    }

    final void writeParam(double d2, byte by2) {
        GrowableDataBuffer growableDataBuffer = this.getBuffer();
        growableDataBuffer.putByte(by2);
        growableDataBuffer.putFloat((float)d2);
    }

    private void writeParam(byte by2, byte by3) {
        GrowableDataBuffer growableDataBuffer = this.getBuffer();
        growableDataBuffer.putByte(by3);
        growableDataBuffer.putByte(by2);
    }

    private void updateTransform() {
        if (this.txdirty) {
            this.txdirty = false;
            GrowableDataBuffer growableDataBuffer = this.getBuffer();
            growableDataBuffer.putByte((byte)11);
            growableDataBuffer.putDouble(((BaseTransform)this.curState.transform).getMxx());
            growableDataBuffer.putDouble(((BaseTransform)this.curState.transform).getMxy());
            growableDataBuffer.putDouble(((BaseTransform)this.curState.transform).getMxt());
            growableDataBuffer.putDouble(((BaseTransform)this.curState.transform).getMyx());
            growableDataBuffer.putDouble(((BaseTransform)this.curState.transform).getMyy());
            growableDataBuffer.putDouble(((BaseTransform)this.curState.transform).getMyt());
        }
    }

    final void updateDimensions() {
        GrowableDataBuffer growableDataBuffer = this.getBuffer();
        growableDataBuffer.putByte((byte)71);
        growableDataBuffer.putFloat((float)this.theCanvas.getWidth());
        growableDataBuffer.putFloat((float)this.theCanvas.getHeight());
    }

    private void reset() {
        GrowableDataBuffer growableDataBuffer = this.getBuffer();
        if (growableDataBuffer.writeValuePosition() > 1024 || this.theCanvas.isRendererFallingBehind()) {
            growableDataBuffer.reset();
            growableDataBuffer.putByte((byte)70);
            this.updateDimensions();
            this.txdirty = true;
            this.pathDirty = true;
            GraphicsContext$State graphicsContext$State = this.curState;
            int n2 = this.curState.numClipPaths;
            this.curState = new GraphicsContext$State();
            for (int i2 = 0; i2 < n2; ++i2) {
                Path2D path2D = this.clipStack.get(i2);
                growableDataBuffer.putByte((byte)13);
                growableDataBuffer.putObject(path2D);
            }
            this.curState.numClipPaths = n2;
            graphicsContext$State.restore(this);
        }
    }

    private void resetIfCovers(Paint paint, double d2, double d3, double d4, double d5) {
        Affine2D affine2D = this.curState.transform;
        if (((BaseTransform)affine2D).isTranslateOrIdentity()) {
            d3 += ((BaseTransform)affine2D).getMyt();
            if ((d2 += ((BaseTransform)affine2D).getMxt()) > 0.0 || d3 > 0.0 || d2 + d4 < this.theCanvas.getWidth() || d3 + d5 < this.theCanvas.getHeight()) {
                return;
            }
        } else {
            return;
        }
        if (paint != null) {
            if (this.curState.blendop != BlendMode.SRC_OVER) {
                return;
            }
            if (!paint.isOpaque() || this.curState.globalAlpha < 1.0) {
                return;
            }
        }
        if (this.curState.numClipPaths > 0) {
            return;
        }
        if (this.curState.effect != null) {
            return;
        }
        this.reset();
    }

    public final Canvas getCanvas() {
        return this.theCanvas;
    }

    public final void save() {
        this.stateStack.push(this.curState.copy());
    }

    public final void restore() {
        if (!this.stateStack.isEmpty()) {
            GraphicsContext$State graphicsContext$State = this.stateStack.pop();
            graphicsContext$State.restore(this);
            this.txdirty = true;
        }
    }

    public final void translate(double d2, double d3) {
        this.curState.transform.translate(d2, d3);
        this.txdirty = true;
    }

    public final void scale(double d2, double d3) {
        this.curState.transform.scale(d2, d3);
        this.txdirty = true;
    }

    public final void rotate(double d2) {
        this.curState.transform.rotate(Math.toRadians(d2));
        this.txdirty = true;
    }

    public final void transform(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.curState.transform.concatenate(d2, d4, d6, d3, d5, d7);
        this.txdirty = true;
    }

    public final void transform(Affine affine) {
        if (affine == null) {
            return;
        }
        this.curState.transform.concatenate(((Transform)affine).getMxx(), ((Transform)affine).getMxy(), ((Transform)affine).getTx(), ((Transform)affine).getMyx(), ((Transform)affine).getMyy(), ((Transform)affine).getTy());
        this.txdirty = true;
    }

    public final void setTransform(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.curState.transform.setTransform(d2, d3, d4, d5, d6, d7);
        this.txdirty = true;
    }

    public final void setTransform(Affine affine) {
        this.curState.transform.setTransform(((Transform)affine).getMxx(), ((Transform)affine).getMyx(), ((Transform)affine).getMxy(), ((Transform)affine).getMyy(), ((Transform)affine).getTx(), ((Transform)affine).getTy());
        this.txdirty = true;
    }

    public final Affine getTransform(Affine affine) {
        if (affine == null) {
            affine = new Affine();
        }
        affine.setMxx(((BaseTransform)this.curState.transform).getMxx());
        affine.setMxy(((BaseTransform)this.curState.transform).getMxy());
        affine.setMxz(0.0);
        affine.setTx(((BaseTransform)this.curState.transform).getMxt());
        affine.setMyx(((BaseTransform)this.curState.transform).getMyx());
        affine.setMyy(((BaseTransform)this.curState.transform).getMyy());
        affine.setMyz(0.0);
        affine.setTy(((BaseTransform)this.curState.transform).getMyt());
        affine.setMzx(0.0);
        affine.setMzy(0.0);
        affine.setMzz(1.0);
        affine.setTz(0.0);
        return affine;
    }

    public final Affine getTransform() {
        return this.getTransform(null);
    }

    public final void setGlobalAlpha(double d2) {
        if (this.curState.globalAlpha != d2) {
            this.curState.globalAlpha = d2;
            d2 = d2 > 1.0 ? 1.0 : (d2 < 0.0 ? 0.0 : d2);
            this.writeParam(d2, (byte)0);
        }
    }

    public final double getGlobalAlpha() {
        return this.curState.globalAlpha;
    }

    public final void setGlobalBlendMode(BlendMode blendMode) {
        if (blendMode != null && blendMode != this.curState.blendop) {
            GrowableDataBuffer growableDataBuffer = this.getBuffer();
            this.curState.blendop = blendMode;
            growableDataBuffer.putByte((byte)1);
            growableDataBuffer.putObject((Object)EffectHelper.getToolkitBlendMode(blendMode));
        }
    }

    public final BlendMode getGlobalBlendMode() {
        return this.curState.blendop;
    }

    public final void setFill(Paint paint) {
        if (paint != null && this.curState.fill != paint) {
            this.curState.fill = paint;
            this.writePaint(paint, (byte)2);
        }
    }

    public final Paint getFill() {
        return this.curState.fill;
    }

    public final void setStroke(Paint paint) {
        if (paint != null && this.curState.stroke != paint) {
            this.curState.stroke = paint;
            this.writePaint(paint, (byte)3);
        }
    }

    public final Paint getStroke() {
        return this.curState.stroke;
    }

    public final void setLineWidth(double d2) {
        if (d2 > 0.0 && d2 < Double.POSITIVE_INFINITY && this.curState.linewidth != d2) {
            this.curState.linewidth = d2;
            this.writeParam(d2, (byte)4);
        }
    }

    public final double getLineWidth() {
        return this.curState.linewidth;
    }

    public final void setLineCap(StrokeLineCap strokeLineCap) {
        if (strokeLineCap != null && this.curState.linecap != strokeLineCap) {
            byte by2;
            switch (strokeLineCap) {
                case BUTT: {
                    by2 = 0;
                    break;
                }
                case ROUND: {
                    by2 = 1;
                    break;
                }
                case SQUARE: {
                    by2 = 2;
                    break;
                }
                default: {
                    return;
                }
            }
            this.curState.linecap = strokeLineCap;
            this.writeParam(by2, (byte)5);
        }
    }

    public final StrokeLineCap getLineCap() {
        return this.curState.linecap;
    }

    public final void setLineJoin(StrokeLineJoin strokeLineJoin) {
        if (strokeLineJoin != null && this.curState.linejoin != strokeLineJoin) {
            byte by2;
            switch (strokeLineJoin) {
                case MITER: {
                    by2 = 0;
                    break;
                }
                case BEVEL: {
                    by2 = 2;
                    break;
                }
                case ROUND: {
                    by2 = 1;
                    break;
                }
                default: {
                    return;
                }
            }
            this.curState.linejoin = strokeLineJoin;
            this.writeParam(by2, (byte)6);
        }
    }

    public final StrokeLineJoin getLineJoin() {
        return this.curState.linejoin;
    }

    public final void setMiterLimit(double d2) {
        if (d2 > 0.0 && d2 < Double.POSITIVE_INFINITY && this.curState.miterlimit != d2) {
            this.curState.miterlimit = d2;
            this.writeParam(d2, (byte)7);
        }
    }

    public final double getMiterLimit() {
        return this.curState.miterlimit;
    }

    public final void setLineDashes(double ... dArray) {
        if (dArray == null || dArray.length == 0) {
            if (this.curState.dashes == null) {
                return;
            }
            this.curState.dashes = null;
        } else {
            int n2;
            boolean bl2 = true;
            for (n2 = 0; n2 < dArray.length; ++n2) {
                double d2;
                double d3 = dArray[n2];
                if (d2 >= 0.0 && d3 < Double.POSITIVE_INFINITY) {
                    if (!(d3 > 0.0)) continue;
                    bl2 = false;
                    continue;
                }
                return;
            }
            if (bl2) {
                if (this.curState.dashes == null) {
                    return;
                }
                this.curState.dashes = null;
            } else {
                n2 = dArray.length;
                if ((n2 & 1) == 0) {
                    this.curState.dashes = Arrays.copyOf(dArray, n2);
                } else {
                    this.curState.dashes = Arrays.copyOf(dArray, n2 << 1);
                    int n3 = n2;
                    System.arraycopy(dArray, 0, this.curState.dashes, n3, n3);
                }
            }
        }
        GrowableDataBuffer growableDataBuffer = this.getBuffer();
        growableDataBuffer.putByte((byte)17);
        growableDataBuffer.putObject(this.curState.dashes);
    }

    public final double[] getLineDashes() {
        if (this.curState.dashes == null) {
            return null;
        }
        return Arrays.copyOf(this.curState.dashes, this.curState.dashes.length);
    }

    public final void setLineDashOffset(double d2) {
        if (d2 > Double.NEGATIVE_INFINITY && d2 < Double.POSITIVE_INFINITY) {
            this.curState.dashOffset = d2;
            this.writeParam(d2, (byte)18);
        }
    }

    public final double getLineDashOffset() {
        return this.curState.dashOffset;
    }

    public final void setFont(Font font) {
        if (font != null && this.curState.font != font) {
            this.curState.font = font;
            GrowableDataBuffer growableDataBuffer = this.getBuffer();
            growableDataBuffer.putByte((byte)8);
            growableDataBuffer.putObject(FontHelper.getNativeFont(font));
        }
    }

    public final Font getFont() {
        return this.curState.font;
    }

    public final void setFontSmoothingType(FontSmoothingType fontSmoothingType) {
        if (fontSmoothingType != null && fontSmoothingType != this.curState.fontsmoothing) {
            this.curState.fontsmoothing = fontSmoothingType;
            this.writeParam((byte)fontSmoothingType.ordinal(), (byte)19);
        }
    }

    public final FontSmoothingType getFontSmoothingType() {
        return this.curState.fontsmoothing;
    }

    public final void setTextAlign(TextAlignment textAlignment) {
        if (textAlignment != null && this.curState.textalign != textAlignment) {
            byte by2;
            switch (textAlignment) {
                case LEFT: {
                    by2 = 0;
                    break;
                }
                case CENTER: {
                    by2 = 1;
                    break;
                }
                case RIGHT: {
                    by2 = 2;
                    break;
                }
                case JUSTIFY: {
                    by2 = 3;
                    break;
                }
                default: {
                    return;
                }
            }
            this.curState.textalign = textAlignment;
            this.writeParam(by2, (byte)9);
        }
    }

    public final TextAlignment getTextAlign() {
        return this.curState.textalign;
    }

    public final void setTextBaseline(VPos vPos) {
        if (vPos != null && this.curState.textbaseline != vPos) {
            byte by2;
            switch (vPos) {
                case TOP: {
                    by2 = 0;
                    break;
                }
                case CENTER: {
                    by2 = 1;
                    break;
                }
                case BASELINE: {
                    by2 = 2;
                    break;
                }
                case BOTTOM: {
                    by2 = 3;
                    break;
                }
                default: {
                    return;
                }
            }
            this.curState.textbaseline = vPos;
            this.writeParam(by2, (byte)10);
        }
    }

    public final VPos getTextBaseline() {
        return this.curState.textbaseline;
    }

    public final void fillText(String string, double d2, double d3) {
        this.writeText(string, d2, d3, 0.0, (byte)35);
    }

    public final void strokeText(String string, double d2, double d3) {
        this.writeText(string, d2, d3, 0.0, (byte)36);
    }

    public final void fillText(String string, double d2, double d3, double d4) {
        if (d4 <= 0.0) {
            return;
        }
        this.writeText(string, d2, d3, d4, (byte)35);
    }

    public final void strokeText(String string, double d2, double d3, double d4) {
        if (d4 <= 0.0) {
            return;
        }
        this.writeText(string, d2, d3, d4, (byte)36);
    }

    public final void setFillRule(FillRule fillRule) {
        if (fillRule != null && this.curState.fillRule != fillRule) {
            byte by2 = fillRule == FillRule.EVEN_ODD ? (byte)1 : 0;
            this.curState.fillRule = fillRule;
            this.writeParam(by2, (byte)16);
        }
    }

    public final FillRule getFillRule() {
        return this.curState.fillRule;
    }

    public final void setImageSmoothing(boolean bl2) {
        if (this.curState.imageSmoothing != bl2) {
            this.curState.imageSmoothing = bl2;
            GrowableDataBuffer growableDataBuffer = this.getBuffer();
            growableDataBuffer.putByte((byte)20);
            growableDataBuffer.putBoolean(this.curState.imageSmoothing);
        }
    }

    public final boolean isImageSmoothing() {
        return this.curState.imageSmoothing;
    }

    public final void beginPath() {
        this.path.reset();
        this.markPathDirty();
    }

    public final void moveTo(double d2, double d3) {
        this.coords[0] = (float)d2;
        this.coords[1] = (float)d3;
        ((BaseTransform)this.curState.transform).transform(this.coords, 0, this.coords, 0, 1);
        this.path.moveTo(this.coords[0], this.coords[1]);
        this.markPathDirty();
    }

    public final void lineTo(double d2, double d3) {
        this.coords[0] = (float)d2;
        this.coords[1] = (float)d3;
        ((BaseTransform)this.curState.transform).transform(this.coords, 0, this.coords, 0, 1);
        if (this.path.getNumCommands() == 0) {
            this.path.moveTo(this.coords[0], this.coords[1]);
        }
        this.path.lineTo(this.coords[0], this.coords[1]);
        this.markPathDirty();
    }

    public final void quadraticCurveTo(double d2, double d3, double d4, double d5) {
        this.coords[0] = (float)d2;
        this.coords[1] = (float)d3;
        this.coords[2] = (float)d4;
        this.coords[3] = (float)d5;
        ((BaseTransform)this.curState.transform).transform(this.coords, 0, this.coords, 0, 2);
        if (this.path.getNumCommands() == 0) {
            this.path.moveTo(this.coords[0], this.coords[1]);
        }
        this.path.quadTo(this.coords[0], this.coords[1], this.coords[2], this.coords[3]);
        this.markPathDirty();
    }

    public final void bezierCurveTo(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.coords[0] = (float)d2;
        this.coords[1] = (float)d3;
        this.coords[2] = (float)d4;
        this.coords[3] = (float)d5;
        this.coords[4] = (float)d6;
        this.coords[5] = (float)d7;
        ((BaseTransform)this.curState.transform).transform(this.coords, 0, this.coords, 0, 3);
        if (this.path.getNumCommands() == 0) {
            this.path.moveTo(this.coords[0], this.coords[1]);
        }
        this.path.curveTo(this.coords[0], this.coords[1], this.coords[2], this.coords[3], this.coords[4], this.coords[5]);
        this.markPathDirty();
    }

    public final void arcTo(double d2, double d3, double d4, double d5, double d6) {
        if (this.path.getNumCommands() == 0) {
            this.moveTo(d2, d3);
            this.lineTo(d2, d3);
            return;
        }
        if (!this.tryArcTo((float)d2, (float)d3, (float)d4, (float)d5, (float)d6)) {
            this.lineTo(d2, d3);
        }
    }

    private static double lenSq(double d2, double d3, double d4, double d5) {
        double d6 = d4 -= d2;
        double d7 = d5 -= d3;
        return d6 * d6 + d7 * d7;
    }

    private boolean tryArcTo(float f2, float f3, float f4, float f5, float f6) {
        boolean bl2;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        float f7;
        float f8;
        block17: {
            block16: {
                if (((BaseTransform)this.curState.transform).isTranslateOrIdentity()) {
                    f8 = (float)((double)this.path.getCurrentX() - ((BaseTransform)this.curState.transform).getMxt());
                    f7 = (float)((double)this.path.getCurrentY() - ((BaseTransform)this.curState.transform).getMyt());
                } else {
                    this.coords[0] = this.path.getCurrentX();
                    this.coords[1] = this.path.getCurrentY();
                    try {
                        ((BaseTransform)this.curState.transform).inverseTransform(this.coords, 0, this.coords, 0, 1);
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        return false;
                    }
                    f8 = this.coords[0];
                    f7 = this.coords[1];
                }
                double d12 = GraphicsContext.lenSq(f8, f7, f2, f3);
                double d13 = GraphicsContext.lenSq(f2, f3, f4, f5);
                double d14 = GraphicsContext.lenSq(f8, f7, f4, f5);
                double d15 = Math.sqrt(d12);
                double d16 = Math.sqrt(d13);
                double d17 = d12 + d13 - d14;
                double d18 = d15 * 2.0 * d16;
                if (d18 == 0.0 || f6 <= 0.0f) {
                    return false;
                }
                d11 = d17 / d18;
                double d19 = d11 + 1.0;
                if (d19 == 0.0) {
                    return false;
                }
                double d20 = (1.0 - d11) / d19;
                double d21 = (double)f6 / Math.sqrt(d20);
                d10 = (double)f2 + d21 / d15 * (double)(f8 - f2);
                d8 = (d10 + (d9 = (double)f2 + d21 / d16 * (double)(f4 - f2))) / 2.0;
                d4 = GraphicsContext.lenSq(d8, d7 = ((d6 = (double)f3 + d21 / d15 * (double)(f7 - f3)) + (d5 = (double)f3 + d21 / d16 * (double)(f5 - f3))) / 2.0, f2, f3);
                if (d4 == 0.0) {
                    return false;
                }
                double d22 = GraphicsContext.lenSq(d8, d7, d10, d6) / d4;
                double d23 = d8;
                d3 = d23 + (d23 - (double)f2) * d22;
                double d24 = d7;
                d2 = d24 + (d24 - (double)f3) * d22;
                double d25 = d3;
                if (d25 != d25) break block16;
                double d26 = d2;
                if (d26 == d26) break block17;
            }
            return false;
        }
        if (d10 != (double)f8 || d6 != (double)f7) {
            this.lineTo(d10, d6);
        }
        double d27 = Math.sqrt((1.0 - d11) / 2.0);
        boolean bl3 = bl2 = (d6 - d2) * (d9 - d3) > (d5 - d2) * (d10 - d3);
        if (d11 <= 0.0) {
            double d28 = Math.sqrt((d11 + 1.0) / 2.0);
            double d29 = d28 * 1.3333333333333333 / (d27 + 1.0);
            if (bl2) {
                d29 = -d29;
            }
            double d30 = d10 - d29 * (d6 - d2);
            double d31 = d6 + d29 * (d10 - d3);
            double d32 = d9 + d29 * (d5 - d2);
            double d33 = d5 - d29 * (d9 - d3);
            this.bezierCurveTo(d30, d31, d32, d33, d9, d5);
        } else {
            double d34 = Math.sqrt((1.0 - d27) / 2.0);
            double d35 = Math.sqrt((d27 + 1.0) / 2.0);
            double d36 = d34 * 1.3333333333333333 / (d35 + 1.0);
            if (bl2) {
                d36 = -d36;
            }
            double d37 = (double)f6 / Math.sqrt(d4);
            double d38 = d3 + ((double)f2 - d8) * d37;
            double d39 = d2 + ((double)f3 - d7) * d37;
            double d40 = d10 - d36 * (d6 - d2);
            double d41 = d6 + d36 * (d10 - d3);
            double d42 = d38 + d36 * (d39 - d2);
            double d43 = d39 - d36 * (d38 - d3);
            this.bezierCurveTo(d40, d41, d42, d43, d38, d39);
            d40 = d38 - d36 * (d39 - d2);
            d41 = d39 + d36 * (d38 - d3);
            d42 = d9 + d36 * (d5 - d2);
            d43 = d5 - d36 * (d9 - d3);
            this.bezierCurveTo(d40, d41, d42, d43, d9, d5);
        }
        return true;
    }

    public final void arc(double d2, double d3, double d4, double d5, double d6, double d7) {
        Arc2D arc2D = new Arc2D((float)(d2 - d4), (float)(d3 - d5), (float)(d4 * 2.0), (float)(d5 * 2.0), (float)d6, (float)d7, 0);
        this.path.append(((Shape)arc2D).getPathIterator(this.curState.transform), true);
        this.markPathDirty();
    }

    public final void rect(double d2, double d3, double d4, double d5) {
        this.coords[0] = (float)d2;
        this.coords[1] = (float)d3;
        this.coords[2] = (float)d4;
        this.coords[3] = 0.0f;
        this.coords[4] = 0.0f;
        this.coords[5] = (float)d5;
        ((BaseTransform)this.curState.transform).deltaTransform(this.coords, 0, this.coords, 0, 3);
        float f2 = this.coords[0] + (float)((BaseTransform)this.curState.transform).getMxt();
        float f3 = this.coords[1] + (float)((BaseTransform)this.curState.transform).getMyt();
        float f4 = this.coords[2];
        float f5 = this.coords[3];
        float f6 = this.coords[4];
        float f7 = this.coords[5];
        this.path.moveTo(f2, f3);
        this.path.lineTo(f2 + f4, f3 + f5);
        this.path.lineTo(f2 + f4 + f6, f3 + f5 + f7);
        this.path.lineTo(f2 + f6, f3 + f7);
        this.path.closePath();
        this.markPathDirty();
    }

    public final void appendSVGPath(String string) {
        if (string == null) {
            return;
        }
        boolean bl2 = true;
        boolean bl3 = true;
        block9: for (int i2 = 0; i2 < string.length(); ++i2) {
            switch (string.charAt(i2)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block9;
                }
                case 'M': {
                    bl3 = false;
                    bl2 = false;
                    break block9;
                }
                case 'm': {
                    if (this.path.getNumCommands() == 0) {
                        bl2 = false;
                    }
                    bl3 = false;
                }
            }
        }
        Path2D path2D = new Path2D();
        if (bl2 && this.path.getNumCommands() > 0) {
            float f2;
            float f3;
            if (((BaseTransform)this.curState.transform).isTranslateOrIdentity()) {
                f3 = (float)((double)this.path.getCurrentX() - ((BaseTransform)this.curState.transform).getMxt());
                f2 = (float)((double)this.path.getCurrentY() - ((BaseTransform)this.curState.transform).getMyt());
            } else {
                this.coords[0] = this.path.getCurrentX();
                this.coords[1] = this.path.getCurrentY();
                try {
                    ((BaseTransform)this.curState.transform).inverseTransform(this.coords, 0, this.coords, 0, 1);
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {}
                f3 = this.coords[0];
                f2 = this.coords[1];
            }
            path2D.moveTo(f3, f2);
        } else {
            bl3 = false;
        }
        try {
            path2D.appendSVGPath(string);
            PathIterator pathIterator = ((Shape)path2D).getPathIterator(this.curState.transform);
            if (bl3) {
                pathIterator.next();
            }
            this.path.append(pathIterator, false);
            return;
        }
        catch (IllegalPathStateException | IllegalArgumentException runtimeException) {
            return;
        }
    }

    public final void closePath() {
        if (this.path.getNumCommands() > 0) {
            this.path.closePath();
            this.markPathDirty();
        }
    }

    public final void fill() {
        this.writePath((byte)47);
    }

    public final void stroke() {
        this.writePath((byte)48);
    }

    public final void clip() {
        Path2D path2D = new Path2D(this.path);
        this.clipStack.addLast(path2D);
        ++this.curState.numClipPaths;
        GrowableDataBuffer growableDataBuffer = this.getBuffer();
        growableDataBuffer.putByte((byte)13);
        growableDataBuffer.putObject(path2D);
    }

    public final boolean isPointInPath(double d2, double d3) {
        return ((Shape)this.path).contains((float)d2, (float)d3);
    }

    public final void clearRect(double d2, double d3, double d4, double d5) {
        if (d4 != 0.0 && d5 != 0.0) {
            this.resetIfCovers(null, d2, d3, d4, d5);
            this.writeOp4(d2, d3, d4, d5, (byte)27);
        }
    }

    public final void fillRect(double d2, double d3, double d4, double d5) {
        if (d4 != 0.0 && d5 != 0.0) {
            GraphicsContext graphicsContext = this;
            graphicsContext.resetIfCovers(graphicsContext.curState.fill, d2, d3, d4, d5);
            this.writeOp4(d2, d3, d4, d5, (byte)25);
        }
    }

    public final void strokeRect(double d2, double d3, double d4, double d5) {
        if (d4 != 0.0 || d5 != 0.0) {
            this.writeOp4(d2, d3, d4, d5, (byte)26);
        }
    }

    public final void fillOval(double d2, double d3, double d4, double d5) {
        if (d4 != 0.0 && d5 != 0.0) {
            this.writeOp4(d2, d3, d4, d5, (byte)29);
        }
    }

    public final void strokeOval(double d2, double d3, double d4, double d5) {
        if (d4 != 0.0 || d5 != 0.0) {
            this.writeOp4(d2, d3, d4, d5, (byte)30);
        }
    }

    public final void fillArc(double d2, double d3, double d4, double d5, double d6, double d7, ArcType arcType) {
        if (d4 != 0.0 && d5 != 0.0 && arcType != null) {
            this.writeArcType(arcType);
            this.writeOp6(d2, d3, d4, d5, d6, d7, (byte)33);
        }
    }

    public final void strokeArc(double d2, double d3, double d4, double d5, double d6, double d7, ArcType arcType) {
        if (d4 != 0.0 && d5 != 0.0 && arcType != null) {
            this.writeArcType(arcType);
            this.writeOp6(d2, d3, d4, d5, d6, d7, (byte)34);
        }
    }

    public final void fillRoundRect(double d2, double d3, double d4, double d5, double d6, double d7) {
        if (d4 != 0.0 && d5 != 0.0) {
            this.writeOp6(d2, d3, d4, d5, d6, d7, (byte)31);
        }
    }

    public final void strokeRoundRect(double d2, double d3, double d4, double d5, double d6, double d7) {
        if (d4 != 0.0 && d5 != 0.0) {
            this.writeOp6(d2, d3, d4, d5, d6, d7, (byte)32);
        }
    }

    public final void strokeLine(double d2, double d3, double d4, double d5) {
        this.writeOp4(d2, d3, d4, d5, (byte)28);
    }

    public final void fillPolygon(double[] dArray, double[] dArray2, int n2) {
        if (n2 >= 3) {
            this.writePoly(dArray, dArray2, n2, true, (byte)47);
        }
    }

    public final void strokePolygon(double[] dArray, double[] dArray2, int n2) {
        if (n2 >= 2) {
            this.writePoly(dArray, dArray2, n2, true, (byte)48);
        }
    }

    public final void strokePolyline(double[] dArray, double[] dArray2, int n2) {
        if (n2 >= 2) {
            this.writePoly(dArray, dArray2, n2, false, (byte)48);
        }
    }

    public final void drawImage(Image image, double d2, double d3) {
        if (image == null) {
            return;
        }
        double d4 = image.getWidth();
        double d5 = image.getHeight();
        this.writeImage(image, d2, d3, d4, d5);
    }

    public final void drawImage(Image image, double d2, double d3, double d4, double d5) {
        this.writeImage(image, d2, d3, d4, d5);
    }

    public final void drawImage(Image image, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        this.writeImage(image, d6, d7, d8, d9, d2, d3, d4, d5);
    }

    public final PixelWriter getPixelWriter() {
        if (this.writer == null) {
            this.writer = new GraphicsContext$1(this);
        }
        return this.writer;
    }

    public final void setEffect(Effect effect) {
        GrowableDataBuffer growableDataBuffer = this.getBuffer();
        growableDataBuffer.putByte((byte)12);
        if (effect == null) {
            this.curState.effect = null;
            growableDataBuffer.putObject(null);
            return;
        }
        this.curState.effect = EffectHelper.copy(effect);
        EffectHelper.sync(this.curState.effect);
        growableDataBuffer.putObject(EffectHelper.getPeer(this.curState.effect));
    }

    public final Effect getEffect(Effect effect) {
        if (this.curState.effect == null) {
            return null;
        }
        return EffectHelper.copy(this.curState.effect);
    }

    public final void applyEffect(Effect effect) {
        if (effect == null) {
            return;
        }
        GrowableDataBuffer growableDataBuffer = this.getBuffer();
        growableDataBuffer.putByte((byte)60);
        effect = EffectHelper.copy(effect);
        EffectHelper.sync(effect);
        growableDataBuffer.putObject(EffectHelper.getPeer(effect));
    }
}

