/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import com.sun.javafx.charts.Legend$LegendItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.NamedArg;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener$Change;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.scene.AccessibleRole;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.chart.AreaChart$1;
import javafx.scene.chart.AreaChart$StyleableProperties;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart$SortingPolicy;
import javafx.scene.chart.XYChart;
import javafx.scene.chart.XYChart$Data;
import javafx.scene.chart.XYChart$Series;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineJoin;
import javafx.util.Duration;

public class AreaChart<X, Y>
extends XYChart<X, Y> {
    private Map<XYChart$Series<X, Y>, DoubleProperty> seriesYMultiplierMap = new HashMap<XYChart$Series<X, Y>, DoubleProperty>();
    private Timeline timeline;
    private BooleanProperty createSymbols = new AreaChart$1(this, true);

    public final boolean getCreateSymbols() {
        return this.createSymbols.getValue();
    }

    public final void setCreateSymbols(boolean bl2) {
        this.createSymbols.setValue(bl2);
    }

    public final BooleanProperty createSymbolsProperty() {
        return this.createSymbols;
    }

    public AreaChart(@NamedArg(value="xAxis") Axis<X> axis, @NamedArg(value="yAxis") Axis<Y> axis2) {
        this(axis, axis2, FXCollections.observableArrayList());
    }

    public AreaChart(@NamedArg(value="xAxis") Axis<X> axis, @NamedArg(value="yAxis") Axis<Y> axis2, @NamedArg(value="data") ObservableList<XYChart$Series<X, Y>> observableList) {
        super(axis, axis2);
        this.setData(observableList);
    }

    private static double doubleValue(Number number) {
        return AreaChart.doubleValue(number, 0.0);
    }

    private static double doubleValue(Number number, double d2) {
        if (number == null) {
            return d2;
        }
        return number.doubleValue();
    }

    @Override
    protected void updateAxisRange() {
        Axis axis = this.getXAxis();
        Axis axis2 = this.getYAxis();
        ArrayList arrayList = null;
        ArrayList arrayList2 = null;
        if (axis.isAutoRanging()) {
            arrayList = new ArrayList();
        }
        if (axis2.isAutoRanging()) {
            arrayList2 = new ArrayList();
        }
        if (arrayList != null || arrayList2 != null) {
            for (XYChart$Series xYChart$Series : this.getData()) {
                for (XYChart$Data xYChart$Data : xYChart$Series.getData()) {
                    if (arrayList != null) {
                        arrayList.add(xYChart$Data.getXValue());
                    }
                    if (arrayList2 == null) continue;
                    arrayList2.add(xYChart$Data.getYValue());
                }
            }
            if (arrayList != null && (arrayList.size() != 1 || this.getXAxis().toNumericValue(arrayList.get(0)) != 0.0)) {
                axis.invalidateRange(arrayList);
            }
            if (arrayList2 != null && (arrayList2.size() != 1 || this.getYAxis().toNumericValue(arrayList2.get(0)) != 0.0)) {
                axis2.invalidateRange(arrayList2);
            }
        }
    }

    @Override
    protected void dataItemAdded(XYChart$Series<X, Y> object, int n2, XYChart$Data<X, Y> xYChart$Data) {
        Node node = this.createSymbol((XYChart$Series<X, Y>)object, this.getData().indexOf(object), xYChart$Data, n2);
        if (this.shouldAnimate()) {
            Object object2;
            boolean bl2 = false;
            if (n2 > 0 && n2 < ((XYChart$Series)object).getData().size() - 1) {
                bl2 = true;
                object2 = (XYChart$Data)((XYChart$Series)object).getData().get(n2 - 1);
                object = (XYChart$Data)((XYChart$Series)object).getData().get(n2 + 1);
                double d2 = this.getXAxis().toNumericValue(((XYChart$Data)object2).getXValue());
                double d3 = this.getYAxis().toNumericValue(((XYChart$Data)object2).getYValue());
                double d4 = this.getXAxis().toNumericValue(((XYChart$Data)object).getXValue());
                double d5 = this.getYAxis().toNumericValue(((XYChart$Data)object).getYValue());
                double d6 = this.getXAxis().toNumericValue(xYChart$Data.getXValue());
                this.getYAxis().toNumericValue(xYChart$Data.getYValue());
                double d7 = (d5 - d3) / (d4 - d2) * d6 + (d4 * d3 - d5 * d2) / (d4 - d2);
                xYChart$Data.setCurrentY(this.getYAxis().toRealValue(d7));
                xYChart$Data.setCurrentX(this.getXAxis().toRealValue(d6));
            } else if (n2 == 0 && ((XYChart$Series)object).getData().size() > 1) {
                bl2 = true;
                xYChart$Data.setCurrentX(((XYChart$Data)((XYChart$Series)object).getData().get(1)).getXValue());
                xYChart$Data.setCurrentY(((XYChart$Data)((XYChart$Series)object).getData().get(1)).getYValue());
            } else if (n2 == ((XYChart$Series)object).getData().size() - 1 && ((XYChart$Series)object).getData().size() > 1) {
                bl2 = true;
                int n3 = ((XYChart$Series)object).getData().size() - 2;
                xYChart$Data.setCurrentX(((XYChart$Data)((XYChart$Series)object).getData().get(n3)).getXValue());
                xYChart$Data.setCurrentY(((XYChart$Data)((XYChart$Series)object).getData().get(n3)).getYValue());
            }
            if (node != null) {
                node.setOpacity(0.0);
                this.getPlotChildren().add(node);
                object2 = new FadeTransition(Duration.millis(500.0), node);
                ((FadeTransition)object2).setToValue(1.0);
                ((Animation)object2).play();
            }
            if (bl2) {
                this.animate(new KeyFrame(Duration.ZERO, actionEvent -> {
                    if (node != null && !this.getPlotChildren().contains(node)) {
                        this.getPlotChildren().add(node);
                    }
                }, new KeyValue(xYChart$Data.currentYProperty(), xYChart$Data.getCurrentY()), new KeyValue(xYChart$Data.currentXProperty(), xYChart$Data.getCurrentX())), new KeyFrame(Duration.millis(800.0), new KeyValue(xYChart$Data.currentYProperty(), xYChart$Data.getYValue(), Interpolator.EASE_BOTH), new KeyValue(xYChart$Data.currentXProperty(), xYChart$Data.getXValue(), Interpolator.EASE_BOTH)));
            }
            return;
        }
        if (node != null) {
            this.getPlotChildren().add(node);
        }
    }

    @Override
    protected void dataItemRemoved(XYChart$Data<X, Y> xYChart$Data, XYChart$Series<X, Y> xYChart$Series) {
        Node node = xYChart$Data.getNode();
        if (node != null) {
            node.focusTraversableProperty().unbind();
        }
        int n2 = xYChart$Series.getItemIndex(xYChart$Data);
        if (this.shouldAnimate()) {
            boolean bl2 = false;
            int n3 = xYChart$Series.getDataSize();
            int n4 = xYChart$Series.getData().size();
            if (n2 > 0 && n2 < n3 - 1) {
                bl2 = true;
                XYChart$Data<X, Y> xYChart$Data2 = xYChart$Series.getItem(n2 - 1);
                XYChart$Data<X, Y> xYChart$Data3 = xYChart$Series.getItem(n2 + 1);
                double d2 = this.getXAxis().toNumericValue(xYChart$Data2.getXValue());
                double d3 = this.getYAxis().toNumericValue(xYChart$Data2.getYValue());
                double d4 = this.getXAxis().toNumericValue(xYChart$Data3.getXValue());
                double d5 = this.getYAxis().toNumericValue(xYChart$Data3.getYValue());
                double d6 = this.getXAxis().toNumericValue(xYChart$Data.getXValue());
                double d7 = this.getYAxis().toNumericValue(xYChart$Data.getYValue());
                double d8 = (d5 - d3) / (d4 - d2) * d6 + (d4 * d3 - d5 * d2) / (d4 - d2);
                xYChart$Data.setCurrentX(this.getXAxis().toRealValue(d6));
                xYChart$Data.setCurrentY(this.getYAxis().toRealValue(d7));
                xYChart$Data.setXValue(this.getXAxis().toRealValue(d6));
                xYChart$Data.setYValue(this.getYAxis().toRealValue(d8));
            } else if (n2 == 0 && n4 > 1) {
                bl2 = true;
                xYChart$Data.setXValue(((XYChart$Data)xYChart$Series.getData().get(0)).getXValue());
                xYChart$Data.setYValue(((XYChart$Data)xYChart$Series.getData().get(0)).getYValue());
            } else if (n2 == n3 - 1 && n4 > 1) {
                bl2 = true;
                n3 = n4 - 1;
                xYChart$Data.setXValue(((XYChart$Data)xYChart$Series.getData().get(n3)).getXValue());
                xYChart$Data.setYValue(((XYChart$Data)xYChart$Series.getData().get(n3)).getYValue());
            } else if (node != null) {
                node.setOpacity(0.0);
                FadeTransition fadeTransition = new FadeTransition(Duration.millis(500.0), node);
                fadeTransition.setToValue(0.0);
                fadeTransition.setOnFinished(actionEvent -> {
                    this.getPlotChildren().remove(node);
                    this.removeDataItemFromDisplay(xYChart$Series, xYChart$Data);
                });
                fadeTransition.play();
            } else {
                xYChart$Data.setSeries(null);
                this.removeDataItemFromDisplay(xYChart$Series, xYChart$Data);
            }
            if (bl2) {
                this.animate(new KeyFrame(Duration.ZERO, new KeyValue(xYChart$Data.currentYProperty(), xYChart$Data.getCurrentY()), new KeyValue(xYChart$Data.currentXProperty(), xYChart$Data.getCurrentX())), new KeyFrame(Duration.millis(800.0), actionEvent -> {
                    xYChart$Data.setSeries(null);
                    this.getPlotChildren().remove(node);
                    this.removeDataItemFromDisplay(xYChart$Series, xYChart$Data);
                }, new KeyValue(xYChart$Data.currentYProperty(), xYChart$Data.getYValue(), Interpolator.EASE_BOTH), new KeyValue(xYChart$Data.currentXProperty(), xYChart$Data.getXValue(), Interpolator.EASE_BOTH)));
            }
            return;
        }
        xYChart$Data.setSeries(null);
        this.getPlotChildren().remove(node);
        this.removeDataItemFromDisplay(xYChart$Series, xYChart$Data);
    }

    @Override
    protected void dataItemChanged(XYChart$Data<X, Y> xYChart$Data) {
    }

    @Override
    protected void seriesChanged(ListChangeListener$Change<? extends XYChart$Series> listChangeListener$Change) {
        for (int i2 = 0; i2 < this.getDataSize(); ++i2) {
            XYChart$Series xYChart$Series = (XYChart$Series)this.getData().get(i2);
            Path path = (Path)((Group)xYChart$Series.getNode()).getChildren().get(1);
            Object object = (Path)((Group)xYChart$Series.getNode()).getChildren().get(0);
            path.getStyleClass().setAll((String[])new String[]{"chart-series-area-line", "series" + i2, xYChart$Series.defaultColorStyleClass});
            ((Node)object).getStyleClass().setAll((String[])new String[]{"chart-series-area-fill", "series" + i2, xYChart$Series.defaultColorStyleClass});
            for (int i3 = 0; i3 < xYChart$Series.getData().size(); ++i3) {
                object = (XYChart$Data)xYChart$Series.getData().get(i3);
                if ((object = ((XYChart$Data)object).getNode()) == null) continue;
                ((Node)object).getStyleClass().setAll((String[])new String[]{"chart-area-symbol", "series" + i2, "data" + i3, xYChart$Series.defaultColorStyleClass});
            }
        }
    }

    @Override
    protected void seriesAdded(XYChart$Series<X, Y> xYChart$Series, int n2) {
        Node node = new Path();
        Object object = new Path();
        ((Shape)node).setStrokeLineJoin(StrokeLineJoin.BEVEL);
        node = new Group(new Node[]{object, node});
        xYChart$Series.setNode(node);
        object = new SimpleDoubleProperty(this, "seriesYMultiplier");
        this.seriesYMultiplierMap.put(xYChart$Series, (DoubleProperty)object);
        if (this.shouldAnimate()) {
            ((DoubleProperty)object).setValue(0.0);
        } else {
            ((DoubleProperty)object).setValue(1.0);
        }
        this.getPlotChildren().add(node);
        ArrayList<KeyFrame> arrayList = new ArrayList<KeyFrame>();
        if (this.shouldAnimate()) {
            arrayList.add(new KeyFrame(Duration.ZERO, new KeyValue(node.opacityProperty(), 0), new KeyValue(object, 0)));
            arrayList.add(new KeyFrame(Duration.millis(200.0), new KeyValue(node.opacityProperty(), 1)));
            arrayList.add(new KeyFrame(Duration.millis(500.0), new KeyValue(object, 1)));
        }
        for (int i2 = 0; i2 < xYChart$Series.getData().size(); ++i2) {
            object = (XYChart$Data)xYChart$Series.getData().get(i2);
            if ((object = this.createSymbol(xYChart$Series, n2, (XYChart$Data<X, Y>)object, i2)) == null) continue;
            if (this.shouldAnimate()) {
                ((Node)object).setOpacity(0.0);
                this.getPlotChildren().add((Node)object);
                arrayList.add(new KeyFrame(Duration.ZERO, new KeyValue(((Node)object).opacityProperty(), 0)));
                arrayList.add(new KeyFrame(Duration.millis(200.0), new KeyValue(((Node)object).opacityProperty(), 1)));
                continue;
            }
            this.getPlotChildren().add((Node)object);
        }
        if (this.shouldAnimate()) {
            ArrayList<KeyFrame> arrayList2 = arrayList;
            this.animate(arrayList2.toArray(new KeyFrame[arrayList2.size()]));
        }
    }

    @Override
    protected void seriesRemoved(XYChart$Series<X, Y> xYChart$Series) {
        this.seriesYMultiplierMap.remove(xYChart$Series);
        if (this.shouldAnimate()) {
            this.timeline = new Timeline(this.createSeriesRemoveTimeLine(xYChart$Series, 400L));
            this.timeline.play();
            return;
        }
        this.getPlotChildren().remove(xYChart$Series.getNode());
        for (XYChart$Data xYChart$Data : xYChart$Series.getData()) {
            this.getPlotChildren().remove(xYChart$Data.getNode());
        }
        this.removeSeriesFromDisplay(xYChart$Series);
    }

    @Override
    protected void layoutPlotChildren() {
        ArrayList<LineTo> arrayList = new ArrayList<LineTo>(this.getDataSize());
        for (int i2 = 0; i2 < this.getDataSize(); ++i2) {
            XYChart$Series xYChart$Series = (XYChart$Series)this.getData().get(i2);
            DoubleProperty doubleProperty = this.seriesYMultiplierMap.get(xYChart$Series);
            Object object = ((Group)xYChart$Series.getNode()).getChildren();
            Path path = (Path)object.get(0);
            object = (Path)object.get(1);
            AreaChart.makePaths(this, xYChart$Series, arrayList, path, (Path)object, doubleProperty.get(), LineChart$SortingPolicy.X_AXIS);
        }
    }

    static <X, Y> void makePaths(XYChart<X, Y> object, XYChart$Series<X, Y> object2, List<LineTo> list, Path path, Path path2, double d2, LineChart$SortingPolicy lineChart$SortingPolicy) {
        double d3;
        Axis<X> axis = ((XYChart)object).getXAxis();
        Axis<Y> axis2 = ((XYChart)object).getYAxis();
        double d4 = path2.getStrokeWidth() / 2.0;
        boolean bl2 = lineChart$SortingPolicy == LineChart$SortingPolicy.X_AXIS;
        boolean bl3 = lineChart$SortingPolicy == LineChart$SortingPolicy.Y_AXIS;
        double d5 = bl2 ? -d4 : Double.NEGATIVE_INFINITY;
        double d6 = bl2 ? axis.getWidth() + d4 : Double.POSITIVE_INFINITY;
        double d7 = bl3 ? -d4 : Double.NEGATIVE_INFINITY;
        double d8 = bl3 ? axis2.getHeight() + d4 : Double.POSITIVE_INFINITY;
        LineTo lineTo3 = null;
        LineTo lineTo4 = null;
        list.clear();
        object = ((XYChart)object).getDisplayedDataIterator(object2);
        while (object.hasNext()) {
            object2 = (XYChart$Data)object.next();
            d3 = axis.getDisplayPosition(((XYChart$Data)object2).getCurrentX());
            Axis<Y> axis3 = axis2;
            double d9 = axis3.getDisplayPosition(axis3.toRealValue(axis2.toNumericValue(((XYChart$Data)object2).getCurrentY()) * d2));
            boolean bl4 = Double.isNaN(d3) || Double.isNaN(d9);
            Node node = ((XYChart$Data)object2).getNode();
            if (node != null) {
                double d10 = node.prefWidth(-1.0);
                double d11 = node.prefHeight(-1.0);
                if (bl4) {
                    node.resizeRelocate(-d10 * 2.0, -d11 * 2.0, d10, d11);
                } else {
                    node.resizeRelocate(d3 - d10 / 2.0, d9 - d11 / 2.0, d10, d11);
                }
            }
            if (bl4) continue;
            if (d3 < d5 || d9 < d7) {
                if (lineTo3 == null) {
                    lineTo3 = new LineTo(d3, d9);
                    continue;
                }
                if (!(bl2 && lineTo3.getX() <= d3) && (!bl3 || !(lineTo3.getY() <= d9))) continue;
                lineTo3.setX(d3);
                lineTo3.setY(d9);
                continue;
            }
            if (d3 <= d6 && d9 <= d8) {
                list.add(new LineTo(d3, d9));
                continue;
            }
            if (lineTo4 == null) {
                lineTo4 = new LineTo(d3, d9);
                continue;
            }
            if (!(bl2 && d3 < lineTo4.getX()) && (!bl3 || !(d9 < lineTo4.getY()))) continue;
            lineTo4.setX(d3);
            lineTo4.setY(d9);
        }
        if (!list.isEmpty() || lineTo3 != null || lineTo4 != null) {
            if (bl2) {
                Collections.sort(list, (lineTo, lineTo2) -> Double.compare(lineTo.getX(), lineTo2.getX()));
            } else if (bl3) {
                Collections.sort(list, (lineTo, lineTo2) -> Double.compare(lineTo.getY(), lineTo2.getY()));
            }
            if (lineTo3 != null) {
                list.add(0, lineTo3);
            }
            if (lineTo4 != null) {
                list.add(lineTo4);
            }
            object = list.get(0);
            List<LineTo> list2 = list;
            object2 = list2.get(list2.size() - 1);
            d3 = ((LineTo)object).getY();
            ObservableList<PathElement> observableList = path2.getElements();
            observableList.clear();
            observableList.add(new MoveTo(((LineTo)object).getX(), d3));
            observableList.addAll((Collection<PathElement>)list);
            if (path != null) {
                ObservableList<PathElement> observableList2 = path.getElements();
                observableList2.clear();
                Axis<Y> axis4 = axis2;
                double d12 = axis4.getDisplayPosition(axis4.toRealValue(0.0));
                observableList2.add(new MoveTo(((LineTo)object).getX(), d12));
                observableList2.addAll((Collection<PathElement>)list);
                observableList2.add(new LineTo(((LineTo)object2).getX(), d12));
                observableList2.add(new ClosePath());
            }
        }
    }

    private Node createSymbol(XYChart$Series<X, Y> xYChart$Series, int n2, XYChart$Data<X, Y> xYChart$Data, int n3) {
        Node node = xYChart$Data.getNode();
        if (node == null && this.getCreateSymbols()) {
            node = new StackPane();
            node.setAccessibleRole(AccessibleRole.TEXT);
            node.setAccessibleRoleDescription("Point");
            node.focusTraversableProperty().bind(Platform.accessibilityActiveProperty());
            xYChart$Data.setNode(node);
        }
        if (node != null) {
            node.getStyleClass().setAll((String[])new String[]{"chart-area-symbol", "series" + n2, "data" + n3, xYChart$Series.defaultColorStyleClass});
        }
        return node;
    }

    @Override
    Legend$LegendItem createLegendItemForSeries(XYChart$Series<X, Y> xYChart$Series, int n2) {
        Legend$LegendItem legend$LegendItem = new Legend$LegendItem(xYChart$Series.getName());
        legend$LegendItem.getSymbol().getStyleClass().addAll((String[])new String[]{"chart-area-symbol", "series" + n2, "area-legend-symbol", xYChart$Series.defaultColorStyleClass});
        return legend$LegendItem;
    }

    @Override
    void seriesBeingRemovedIsAdded(XYChart$Series<X, Y> xYChart$Series) {
        if (this.timeline != null) {
            this.timeline.setOnFinished(null);
            ((Animation)this.timeline).stop();
            this.timeline = null;
            this.getPlotChildren().remove(xYChart$Series.getNode());
            for (XYChart$Data xYChart$Data : xYChart$Series.getData()) {
                this.getPlotChildren().remove(xYChart$Data.getNode());
            }
            this.removeSeriesFromDisplay(xYChart$Series);
        }
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return AreaChart$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return AreaChart.getClassCssMetaData();
    }
}

