/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import com.sun.javafx.charts.ChartLayoutAnimator;
import java.util.ArrayList;
import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.geometry.Dimension2D;
import javafx.geometry.Side;
import javafx.scene.chart.Axis;
import javafx.scene.chart.CategoryAxis$1;
import javafx.scene.chart.CategoryAxis$2;
import javafx.scene.chart.CategoryAxis$3;
import javafx.scene.chart.CategoryAxis$4;
import javafx.scene.chart.CategoryAxis$StyleableProperties;
import javafx.util.Duration;

public final class CategoryAxis
extends Axis<String> {
    private List<String> allDataCategories = new ArrayList<String>();
    private boolean changeIsLocal = false;
    private final DoubleProperty firstCategoryPos = new SimpleDoubleProperty(this, "firstCategoryPos", 0.0);
    private Object currentAnimationID;
    private final ChartLayoutAnimator animator = new ChartLayoutAnimator(this);
    private ListChangeListener<String> itemsListener = listChangeListener$Change -> {
        while (listChangeListener$Change.next()) {
            if (!listChangeListener$Change.getAddedSubList().isEmpty()) {
                for (String string : listChangeListener$Change.getAddedSubList()) {
                    this.checkAndRemoveDuplicates(string);
                }
            }
            if (!this.isAutoRanging()) {
                this.allDataCategories.clear();
                this.allDataCategories.addAll(this.getCategories());
                this.rangeValid = false;
            }
            this.requestAxisLayout();
        }
    };
    private DoubleProperty startMargin = new CategoryAxis$1(this, 5.0);
    private DoubleProperty endMargin = new CategoryAxis$2(this, 5.0);
    private BooleanProperty gapStartAndEnd = new CategoryAxis$3(this, true);
    private ObjectProperty<ObservableList<String>> categories = new CategoryAxis$4(this);
    private final ReadOnlyDoubleWrapper categorySpacing = new ReadOnlyDoubleWrapper(this, "categorySpacing", 1.0);

    public final double getStartMargin() {
        return this.startMargin.getValue();
    }

    public final void setStartMargin(double d2) {
        this.startMargin.setValue(d2);
    }

    public final DoubleProperty startMarginProperty() {
        return this.startMargin;
    }

    public final double getEndMargin() {
        return this.endMargin.getValue();
    }

    public final void setEndMargin(double d2) {
        this.endMargin.setValue(d2);
    }

    public final DoubleProperty endMarginProperty() {
        return this.endMargin;
    }

    public final boolean isGapStartAndEnd() {
        return this.gapStartAndEnd.getValue();
    }

    public final void setGapStartAndEnd(boolean bl2) {
        this.gapStartAndEnd.setValue(bl2);
    }

    public final BooleanProperty gapStartAndEndProperty() {
        return this.gapStartAndEnd;
    }

    public final void setCategories(ObservableList<String> observableList) {
        this.categories.set(observableList);
        if (!this.changeIsLocal) {
            this.setAutoRanging(false);
            this.allDataCategories.clear();
            this.allDataCategories.addAll(this.getCategories());
        }
        this.requestAxisLayout();
    }

    private void checkAndRemoveDuplicates(String string) {
        if (this.getDuplicate() != null) {
            this.getCategories().remove(string);
            throw new IllegalArgumentException("Duplicate category ; " + string + " already present");
        }
    }

    private String getDuplicate() {
        if (this.getCategories() != null) {
            for (int i2 = 0; i2 < this.getCategories().size(); ++i2) {
                for (int i3 = 0; i3 < this.getCategories().size(); ++i3) {
                    if (!((String)this.getCategories().get(i2)).equals(this.getCategories().get(i3)) || i2 == i3) continue;
                    return (String)this.getCategories().get(i2);
                }
            }
        }
        return null;
    }

    public final ObservableList<String> getCategories() {
        return (ObservableList)this.categories.get();
    }

    public final double getCategorySpacing() {
        return this.categorySpacing.get();
    }

    public final ReadOnlyDoubleProperty categorySpacingProperty() {
        return this.categorySpacing.getReadOnlyProperty();
    }

    public CategoryAxis() {
        this.changeIsLocal = true;
        this.setCategories(FXCollections.observableArrayList());
        this.changeIsLocal = false;
    }

    public CategoryAxis(ObservableList<String> observableList) {
        this.setCategories(observableList);
    }

    private double calculateNewSpacing(double d2, List<String> list) {
        this.getEffectiveSide();
        double d3 = 1.0;
        if (list != null) {
            double d4 = this.isGapStartAndEnd() ? list.size() : list.size() - 1;
            double d5 = d3 = d4 == 0.0 ? 1.0 : (d2 - this.getStartMargin() - this.getEndMargin()) / d4;
        }
        if (!this.isAutoRanging()) {
            this.categorySpacing.set(d3);
        }
        return d3;
    }

    private double calculateNewFirstPos(double d2, double d3) {
        Side side = this.getEffectiveSide();
        double d4 = this.isGapStartAndEnd() ? d3 / 2.0 : 0.0;
        double d5 = side.isHorizontal() ? 0.0 + this.getStartMargin() + d4 : d2 - this.getStartMargin() - d4;
        if (!this.isAutoRanging()) {
            this.firstCategoryPos.set(d5);
        }
        return d5;
    }

    @Override
    protected final Object getRange() {
        return new Object[]{this.getCategories(), this.categorySpacing.get(), this.firstCategoryPos.get(), this.getEffectiveTickLabelRotation()};
    }

    @Override
    protected final void setRange(Object objectArray, boolean bl2) {
        objectArray = objectArray;
        List list = (List)objectArray[0];
        double d2 = (Double)objectArray[1];
        double d3 = (Double)objectArray[2];
        this.setEffectiveTickLabelRotation((Double)objectArray[3]);
        this.changeIsLocal = true;
        this.setCategories(FXCollections.observableArrayList(list));
        this.changeIsLocal = false;
        if (bl2) {
            this.animator.stop(this.currentAnimationID);
            this.currentAnimationID = this.animator.animate(new KeyFrame(Duration.ZERO, new KeyValue(this.firstCategoryPos, this.firstCategoryPos.get()), new KeyValue(this.categorySpacing, this.categorySpacing.get())), new KeyFrame(Duration.millis(1000.0), new KeyValue(this.firstCategoryPos, d3), new KeyValue(this.categorySpacing, d2)));
            return;
        }
        this.categorySpacing.set(d2);
        this.firstCategoryPos.set(d3);
    }

    @Override
    protected final Object autoRange(double d2) {
        Side side = this.getEffectiveSide();
        double d3 = this.calculateNewSpacing(d2, this.allDataCategories);
        double d4 = this.calculateNewFirstPos(d2, d3);
        double d5 = this.getTickLabelRotation();
        if (d2 >= 0.0) {
            double d6;
            double d7 = this.calculateRequiredSize(side.isVertical(), d5);
            if (d6 > d2) {
                if (side.isHorizontal() && d5 != 90.0) {
                    d5 = 90.0;
                }
                if (side.isVertical() && d5 != 0.0) {
                    d5 = 0.0;
                }
            }
        }
        return new Object[]{this.allDataCategories, d3, d4, d5};
    }

    private double calculateRequiredSize(boolean bl2, double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        boolean bl3 = true;
        for (String string : this.allDataCategories) {
            double d5;
            Dimension2D object = this.measureTickMarkSize(string, d2);
            double d6 = d5 = bl2 || d2 != 0.0 ? object.getHeight() : object.getWidth();
            if (bl3) {
                bl3 = false;
                d4 = d5 / 2.0;
                continue;
            }
            d3 = Math.max(d3, d4 + 6.0 + d5 / 2.0);
        }
        return this.getStartMargin() + d3 * (double)this.allDataCategories.size() + this.getEndMargin();
    }

    @Override
    protected final List<String> calculateTickValues(double d2, Object object) {
        Object[] objectArray = (Object[])object;
        return (List)objectArray[0];
    }

    @Override
    protected final String getTickMarkLabel(String string) {
        return string;
    }

    @Override
    protected final Dimension2D measureTickMarkSize(String string, Object objectArray) {
        objectArray = objectArray;
        double d2 = (Double)objectArray[3];
        return this.measureTickMarkSize(string, d2);
    }

    @Override
    public final void invalidateRange(List<String> list) {
        super.invalidateRange(list);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.allDataCategories);
        for (String string : this.allDataCategories) {
            if (list.contains(string)) continue;
            arrayList.remove(string);
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            int n2 = arrayList.size();
            if (arrayList.contains(list.get(i2))) continue;
            arrayList.add(i2 > n2 ? n2 : i2, list.get(i2));
        }
        this.allDataCategories.clear();
        this.allDataCategories.addAll(arrayList);
    }

    final List<String> getAllDataCategories() {
        return this.allDataCategories;
    }

    @Override
    public final double getDisplayPosition(String string) {
        ObservableList<String> observableList = this.getCategories();
        if (!observableList.contains(string)) {
            return Double.NaN;
        }
        if (this.getEffectiveSide().isHorizontal()) {
            return this.firstCategoryPos.get() + (double)observableList.indexOf(string) * this.categorySpacing.get();
        }
        return this.firstCategoryPos.get() + -((double)observableList.indexOf(string) * this.categorySpacing.get());
    }

    @Override
    public final String getValueForDisplay(double d2) {
        if (this.getEffectiveSide().isHorizontal()) {
            if (d2 < 0.0 || d2 > this.getWidth()) {
                return null;
            }
            double d3 = (d2 - this.firstCategoryPos.get()) / this.categorySpacing.get();
            return this.toRealValue(d3);
        }
        if (d2 < 0.0 || d2 > this.getHeight()) {
            return null;
        }
        double d4 = (d2 - this.firstCategoryPos.get()) / -this.categorySpacing.get();
        return this.toRealValue(d4);
    }

    @Override
    public final boolean isValueOnAxis(String string) {
        return this.getCategories().indexOf(string) != -1;
    }

    @Override
    public final double toNumericValue(String string) {
        return this.getCategories().indexOf(string);
    }

    @Override
    public final String toRealValue(double d2) {
        int n2 = (int)Math.round(d2);
        ObservableList<String> observableList = this.getCategories();
        if (n2 >= 0 && n2 < observableList.size()) {
            return (String)this.getCategories().get(n2);
        }
        return null;
    }

    @Override
    public final double getZeroPosition() {
        return Double.NaN;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return CategoryAxis$StyleableProperties.STYLEABLES;
    }

    @Override
    public final List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return CategoryAxis.getClassCssMetaData();
    }
}

