/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import java.text.DecimalFormat;
import java.text.ParseException;
import javafx.beans.value.ChangeListener;
import javafx.scene.chart.NumberAxis;
import javafx.util.StringConverter;

public class NumberAxis$DefaultFormatter
extends StringConverter<Number> {
    private DecimalFormat formatter;
    private String prefix = null;
    private String suffix = null;

    public NumberAxis$DefaultFormatter(NumberAxis numberAxis) {
        this.formatter = numberAxis.isAutoRanging() ? new DecimalFormat((String)numberAxis.currentFormatterProperty.get()) : new DecimalFormat();
        ChangeListener<Object> changeListener = (observableValue, object, object2) -> {
            this.formatter = numberAxis.isAutoRanging() ? new DecimalFormat((String)numberAxis.currentFormatterProperty.get()) : new DecimalFormat();
        };
        numberAxis.currentFormatterProperty.addListener(changeListener);
        numberAxis.autoRangingProperty().addListener(changeListener);
    }

    public NumberAxis$DefaultFormatter(NumberAxis numberAxis, String string, String string2) {
        this(numberAxis);
        this.prefix = string;
        this.suffix = string2;
    }

    @Override
    public String toString(Number number) {
        return this.toString(number, this.formatter);
    }

    private String toString(Number number, String string) {
        if (string == null || string.isEmpty()) {
            return this.toString(number, this.formatter);
        }
        return this.toString(number, new DecimalFormat(string));
    }

    private String toString(Number number, DecimalFormat decimalFormat) {
        if (this.prefix != null && this.suffix != null) {
            return this.prefix + decimalFormat.format(number) + this.suffix;
        }
        if (this.prefix != null) {
            return this.prefix + decimalFormat.format(number);
        }
        if (this.suffix != null) {
            return decimalFormat.format(number) + this.suffix;
        }
        return decimalFormat.format(number);
    }

    @Override
    public Number fromString(String string) {
        try {
            int n2 = this.prefix == null ? 0 : this.prefix.length();
            int n3 = this.suffix == null ? 0 : this.suffix.length();
            return this.formatter.parse(string.substring(n2, string.length() - n3));
        }
        catch (ParseException parseException) {
            return null;
        }
    }
}

