/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import com.sun.javafx.charts.Legend;
import com.sun.javafx.charts.Legend$LegendItem;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.Animation$Status;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.chart.Chart;
import javafx.scene.chart.PieChart$1;
import javafx.scene.chart.PieChart$2;
import javafx.scene.chart.PieChart$3;
import javafx.scene.chart.PieChart$4;
import javafx.scene.chart.PieChart$5;
import javafx.scene.chart.PieChart$6;
import javafx.scene.chart.PieChart$7;
import javafx.scene.chart.PieChart$Data;
import javafx.scene.chart.PieChart$LabelLayoutInfo;
import javafx.scene.chart.PieChart$StyleableProperties;
import javafx.scene.layout.Region;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcTo;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.text.Text;
import javafx.scene.transform.Scale;
import javafx.util.Duration;

public class PieChart
extends Chart {
    private static final int MIN_PIE_RADIUS = 25;
    private static final double LABEL_TICK_GAP = 6.0;
    private static final double LABEL_BALL_RADIUS = 2.0;
    private BitSet colorBits = new BitSet(8);
    private double pieRadius;
    private PieChart$Data begin = null;
    private final Path labelLinePath = new PieChart$1(this);
    private List<PieChart$LabelLayoutInfo> labelLayoutInfos = null;
    private Legend legend = new Legend();
    private PieChart$Data dataItemBeingRemoved = null;
    private Timeline dataRemoveTimeline = null;
    private final ListChangeListener<PieChart$Data> dataChangeListener = listChangeListener$Change -> {
        while (listChangeListener$Change.next()) {
            PieChart$Data pieChart$Data4;
            int n2;
            PieChart$Data pieChart$Data2;
            if (listChangeListener$Change.wasPermutated()) {
                PieChart$Data pieChart$Data3 = this.begin;
                for (int i2 = 0; i2 < this.getData().size(); ++i2) {
                    pieChart$Data2 = (PieChart$Data)this.getData().get(i2);
                    this.updateDataItemStyleClass(pieChart$Data2, i2);
                    if (i2 == 0) {
                        pieChart$Data3 = this.begin = pieChart$Data2;
                        this.begin.next = null;
                        continue;
                    }
                    pieChart$Data3.next = pieChart$Data2;
                    pieChart$Data2.next = null;
                    pieChart$Data3 = pieChart$Data2;
                }
                this.updateLegend();
                this.requestChartLayout();
                return;
            }
            for (n2 = listChangeListener$Change.getFrom(); n2 < listChangeListener$Change.getTo(); ++n2) {
                pieChart$Data4 = (PieChart$Data)this.getData().get(n2);
                pieChart$Data4.setChart(this);
                if (this.begin == null) {
                    this.begin = pieChart$Data4;
                    this.begin.next = null;
                    continue;
                }
                if (n2 == 0) {
                    pieChart$Data4.next = this.begin;
                    this.begin = pieChart$Data4;
                    continue;
                }
                pieChart$Data2 = this.begin;
                for (int i3 = 0; i3 < n2 - 1; ++i3) {
                    pieChart$Data2 = pieChart$Data2.next;
                }
                pieChart$Data4.next = pieChart$Data2.next;
                pieChart$Data2.next = pieChart$Data4;
            }
            for (PieChart$Data pieChart$Data4 : listChangeListener$Change.getRemoved()) {
                this.dataItemRemoved(pieChart$Data4);
            }
            for (n2 = listChangeListener$Change.getFrom(); n2 < listChangeListener$Change.getTo(); ++n2) {
                pieChart$Data4 = (PieChart$Data)this.getData().get(n2);
                ((PieChart$Data)this.getData().get(n2)).defaultColorIndex = this.colorBits.nextClearBit(0);
                this.colorBits.set(pieChart$Data4.defaultColorIndex);
                this.dataItemAdded(pieChart$Data4, n2);
            }
            if (!listChangeListener$Change.wasRemoved() && !listChangeListener$Change.wasAdded()) continue;
            for (n2 = 0; n2 < this.getData().size(); ++n2) {
                pieChart$Data4 = (PieChart$Data)this.getData().get(n2);
                this.updateDataItemStyleClass(pieChart$Data4, n2);
            }
            this.updateLegend();
        }
        this.requestChartLayout();
    };
    private ObjectProperty<ObservableList<PieChart$Data>> data = new PieChart$2(this);
    private DoubleProperty startAngle = new PieChart$3(this, 0.0);
    private BooleanProperty clockwise = new PieChart$4(this, true);
    private DoubleProperty labelLineLength = new PieChart$5(this, 20.0);
    private BooleanProperty labelsVisible = new PieChart$6(this, true);

    public final ObservableList<PieChart$Data> getData() {
        return (ObservableList)this.data.getValue();
    }

    public final void setData(ObservableList<PieChart$Data> observableList) {
        this.data.setValue(observableList);
    }

    public final ObjectProperty<ObservableList<PieChart$Data>> dataProperty() {
        return this.data;
    }

    public final double getStartAngle() {
        return this.startAngle.getValue();
    }

    public final void setStartAngle(double d2) {
        this.startAngle.setValue(d2);
    }

    public final DoubleProperty startAngleProperty() {
        return this.startAngle;
    }

    public final void setClockwise(boolean bl2) {
        this.clockwise.setValue(bl2);
    }

    public final boolean isClockwise() {
        return this.clockwise.getValue();
    }

    public final BooleanProperty clockwiseProperty() {
        return this.clockwise;
    }

    public final double getLabelLineLength() {
        return this.labelLineLength.getValue();
    }

    public final void setLabelLineLength(double d2) {
        this.labelLineLength.setValue(d2);
    }

    public final DoubleProperty labelLineLengthProperty() {
        return this.labelLineLength;
    }

    public final void setLabelsVisible(boolean bl2) {
        this.labelsVisible.setValue(bl2);
    }

    public final boolean getLabelsVisible() {
        return this.labelsVisible.getValue();
    }

    public final BooleanProperty labelsVisibleProperty() {
        return this.labelsVisible;
    }

    public PieChart() {
        this(FXCollections.observableArrayList());
    }

    public PieChart(ObservableList<PieChart$Data> observableList) {
        this.getChartChildren().add(this.labelLinePath);
        this.labelLinePath.getStyleClass().add("chart-pie-label-line");
        PieChart pieChart = this;
        pieChart.setLegend(pieChart.legend);
        this.setData(observableList);
        this.useChartContentMirroring = false;
    }

    private void dataNameChanged(PieChart$Data pieChart$Data) {
        pieChart$Data.textNode.setText(pieChart$Data.getName());
        this.requestChartLayout();
        this.updateLegend();
    }

    private void dataPieValueChanged(PieChart$Data pieChart$Data) {
        if (this.shouldAnimate()) {
            this.animate(new KeyFrame(Duration.ZERO, new KeyValue(pieChart$Data.currentPieValueProperty(), pieChart$Data.getCurrentPieValue())), new KeyFrame(Duration.millis(500.0), new KeyValue(pieChart$Data.currentPieValueProperty(), pieChart$Data.getPieValue(), Interpolator.EASE_BOTH)));
            return;
        }
        PieChart$Data pieChart$Data2 = pieChart$Data;
        pieChart$Data2.setCurrentPieValue(pieChart$Data2.getPieValue());
        this.requestChartLayout();
    }

    private Node createArcRegion(PieChart$Data pieChart$Data) {
        Node node = pieChart$Data.getNode();
        if (node == null) {
            node = new Region();
            node.setNodeOrientation(NodeOrientation.LEFT_TO_RIGHT);
            node.setPickOnBounds(false);
            pieChart$Data.setNode(node);
        }
        return node;
    }

    private Text createPieLabel(PieChart$Data pieChart$Data) {
        Text text = pieChart$Data.textNode;
        text.setText(pieChart$Data.getName());
        return text;
    }

    private void updateDataItemStyleClass(PieChart$Data pieChart$Data, int n2) {
        Node node = pieChart$Data.getNode();
        if (node != null) {
            node.getStyleClass().setAll((String[])new String[]{"chart-pie", "data" + n2, "default-color" + pieChart$Data.defaultColorIndex % 8});
            if (pieChart$Data.getPieValue() < 0.0) {
                node.getStyleClass().add("negative");
            }
        }
    }

    private void dataItemAdded(PieChart$Data pieChart$Data, int n2) {
        Node node = this.createArcRegion(pieChart$Data);
        Text text = this.createPieLabel(pieChart$Data);
        pieChart$Data.getChart().getChartChildren().add(node);
        if (this.shouldAnimate()) {
            if (this.dataRemoveTimeline != null && this.dataRemoveTimeline.getStatus().equals((Object)Animation$Status.RUNNING) && this.dataItemBeingRemoved == pieChart$Data) {
                ((Animation)this.dataRemoveTimeline).stop();
                this.dataRemoveTimeline = null;
                this.getChartChildren().remove(pieChart$Data.textNode);
                this.getChartChildren().remove(node);
                this.removeDataItemRef(pieChart$Data);
            }
            this.animate(new KeyFrame(Duration.ZERO, new KeyValue(pieChart$Data.currentPieValueProperty(), pieChart$Data.getCurrentPieValue()), new KeyValue(pieChart$Data.radiusMultiplierProperty(), pieChart$Data.getRadiusMultiplier())), new KeyFrame(Duration.millis(500.0), actionEvent -> {
                ((Node)text).setOpacity(0.0);
                if (pieChart$Data.getChart() == null) {
                    pieChart$Data.setChart(this);
                }
                pieChart$Data.getChart().getChartChildren().add(text);
                text = new FadeTransition(Duration.millis(150.0), text);
                ((FadeTransition)((Object)text)).setToValue(1.0);
                ((Animation)((Object)text)).play();
            }, new KeyValue(pieChart$Data.currentPieValueProperty(), pieChart$Data.getPieValue(), Interpolator.EASE_BOTH), new KeyValue(pieChart$Data.radiusMultiplierProperty(), 1, Interpolator.EASE_BOTH)));
        } else {
            this.getChartChildren().add(text);
            pieChart$Data.setRadiusMultiplier(1.0);
            PieChart$Data pieChart$Data2 = pieChart$Data;
            pieChart$Data2.setCurrentPieValue(pieChart$Data2.getPieValue());
        }
        for (int i2 = 0; i2 < this.getChartChildren().size(); ++i2) {
            node = (Node)this.getChartChildren().get(i2);
            if (!(node instanceof Text)) continue;
            node.toFront();
        }
    }

    private void removeDataItemRef(PieChart$Data pieChart$Data) {
        if (this.begin == pieChart$Data) {
            this.begin = pieChart$Data.next;
            return;
        }
        PieChart$Data pieChart$Data2 = this.begin;
        while (pieChart$Data2 != null && pieChart$Data2.next != pieChart$Data) {
            pieChart$Data2 = pieChart$Data2.next;
        }
        if (pieChart$Data2 != null) {
            pieChart$Data2.next = pieChart$Data.next;
        }
    }

    private Timeline createDataRemoveTimeline(PieChart$Data pieChart$Data) {
        Node node = pieChart$Data.getNode();
        Timeline timeline = new Timeline();
        timeline.getKeyFrames().addAll((KeyFrame[])new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue(pieChart$Data.currentPieValueProperty(), pieChart$Data.getCurrentPieValue()), new KeyValue(pieChart$Data.radiusMultiplierProperty(), pieChart$Data.getRadiusMultiplier())), new KeyFrame(Duration.millis(500.0), actionEvent -> {
            this.colorBits.clear(pieChart$Data.defaultColorIndex);
            this.getChartChildren().remove(node);
            node = new FadeTransition(Duration.millis(150.0), pieChart$Data.textNode);
            ((FadeTransition)((Object)node)).setFromValue(1.0);
            ((FadeTransition)((Object)node)).setToValue(0.0);
            ((Animation)((Object)node)).setOnFinished(new PieChart$7(this, pieChart$Data));
            ((Animation)((Object)node)).play();
        }, new KeyValue(pieChart$Data.currentPieValueProperty(), 0, Interpolator.EASE_BOTH), new KeyValue(pieChart$Data.radiusMultiplierProperty(), 0))});
        return timeline;
    }

    private void dataItemRemoved(PieChart$Data pieChart$Data) {
        Node node = pieChart$Data.getNode();
        if (this.shouldAnimate()) {
            this.dataRemoveTimeline = this.createDataRemoveTimeline(pieChart$Data);
            this.dataItemBeingRemoved = pieChart$Data;
            PieChart pieChart = this;
            pieChart.animate(pieChart.dataRemoveTimeline);
            return;
        }
        this.colorBits.clear(pieChart$Data.defaultColorIndex);
        this.getChartChildren().remove(pieChart$Data.textNode);
        this.getChartChildren().remove(node);
        pieChart$Data.setChart(null);
        this.removeDataItemRef(pieChart$Data);
    }

    @Override
    protected void layoutChartChildren(double d2, double d3, double d4, double d5) {
        double d6;
        double d7;
        Object object;
        int n2;
        double d8;
        double d9;
        double d10 = 0.0;
        PieChart$Data pieChart$Data = this.begin;
        while (pieChart$Data != null) {
            d10 += Math.abs(pieChart$Data.getCurrentPieValue());
            pieChart$Data = pieChart$Data.next;
        }
        double d11 = d10 != 0.0 ? 360.0 / d10 : 0.0;
        double[] dArray = null;
        double[] dArray2 = null;
        double[] dArray3 = null;
        double d12 = 1.0;
        ArrayList<PieChart$LabelLayoutInfo> arrayList = null;
        boolean bl2 = this.getLabelsVisible();
        if (bl2) {
            d9 = 0.0;
            d8 = 0.0;
            dArray = new double[this.getDataSize()];
            dArray2 = new double[this.getDataSize()];
            dArray3 = new double[this.getDataSize()];
            arrayList = new ArrayList<PieChart$LabelLayoutInfo>();
            n2 = 0;
            double d13 = this.getStartAngle();
            object = this.begin;
            while (object != null) {
                ((PieChart$Data)object).textNode.getTransforms().clear();
                double d14 = this.isClockwise() ? -d11 * Math.abs(((PieChart$Data)object).getCurrentPieValue()) : d11 * Math.abs(((PieChart$Data)object).getCurrentPieValue());
                dArray3[n2] = PieChart.normalizeAngle(d13 + d14 / 2.0);
                d7 = PieChart.calcX(dArray3[n2], this.getLabelLineLength(), 0.0);
                double d15 = PieChart.calcY(dArray3[n2], this.getLabelLineLength(), 0.0);
                dArray[n2] = d7;
                dArray2[n2] = d15;
                d9 = Math.max(d9, 2.0 * (((PieChart$Data)object).textNode.getLayoutBounds().getWidth() + 6.0 + Math.abs(d7)));
                d8 = d15 > 0.0 ? Math.max(d8, 2.0 * Math.abs(d15 + ((PieChart$Data)object).textNode.getLayoutBounds().getMaxY())) : Math.max(d8, 2.0 * Math.abs(d15 + ((PieChart$Data)object).textNode.getLayoutBounds().getMinY()));
                d13 += d14;
                ++n2;
                object = ((PieChart$Data)object).next;
            }
            this.pieRadius = Math.min(d4 - d9, d5 - d8) / 2.0;
            if (this.pieRadius < 25.0) {
                double d16 = d4 - 25.0 - 25.0;
                d6 = d5 - 25.0 - 25.0;
                d12 = Math.min(d16 / d9, d6 / d8);
                if (this.begin == null && d12 < 0.7 || this.begin.textNode.getFont().getSize() * d12 < 9.0) {
                    bl2 = false;
                    d12 = 1.0;
                } else {
                    this.pieRadius = 25.0;
                    for (int i2 = 0; i2 < dArray.length; ++i2) {
                        dArray[i2] = dArray[i2] * d12;
                        dArray2[i2] = dArray2[i2] * d12;
                    }
                }
            }
        }
        if (!bl2) {
            this.pieRadius = Math.min(d4, d5) / 2.0;
            this.labelLinePath.getElements().clear();
        }
        if (this.getChartChildren().size() > 0) {
            d9 = d4 / 2.0 + d3;
            d8 = d5 / 2.0 + d2;
            n2 = 0;
            PieChart$Data pieChart$Data2 = this.begin;
            while (pieChart$Data2 != null) {
                pieChart$Data2.textNode.setVisible(bl2);
                if (bl2) {
                    double d17 = this.isClockwise() ? -d11 * Math.abs(pieChart$Data2.getCurrentPieValue()) : d11 * Math.abs(pieChart$Data2.getCurrentPieValue());
                    boolean bl3 = !(dArray3[n2] > -90.0) || !(dArray3[n2] < 90.0);
                    d6 = PieChart.calcX(dArray3[n2], this.pieRadius, d9);
                    double d18 = PieChart.calcY(dArray3[n2], this.pieRadius, d8);
                    double d19 = bl3 ? dArray[n2] + d6 - pieChart$Data2.textNode.getLayoutBounds().getMaxX() - 6.0 : dArray[n2] + d6 - pieChart$Data2.textNode.getLayoutBounds().getMinX() + 6.0;
                    double d20 = dArray2[n2] + d18 - pieChart$Data2.textNode.getLayoutBounds().getMinY() / 2.0 - 2.0;
                    double d21 = d6 + dArray[n2];
                    double d22 = d18 + dArray2[n2];
                    PieChart$LabelLayoutInfo pieChart$LabelLayoutInfo = new PieChart$LabelLayoutInfo(d6, d18, d21, d22, d19, d20, pieChart$Data2.textNode, Math.abs(d17));
                    arrayList.add(pieChart$LabelLayoutInfo);
                    if (d12 < 1.0) {
                        double d23 = d12;
                        pieChart$Data2.textNode.getTransforms().add(new Scale(d23, d23, bl3 ? pieChart$Data2.textNode.getLayoutBounds().getWidth() : 0.0, 0.0));
                    }
                }
                ++n2;
                pieChart$Data2 = pieChart$Data2.next;
            }
            double d24 = this.getStartAngle();
            object = this.begin;
            while (object != null) {
                Node node = ((PieChart$Data)object).getNode();
                Arc arc = null;
                if (node != null && node instanceof Region) {
                    Region region = (Region)node;
                    if (region.getShape() == null) {
                        arc = new Arc();
                        region.setShape(arc);
                    } else {
                        arc = (Arc)region.getShape();
                    }
                    region.setScaleShape(false);
                    region.setCenterShape(false);
                    region.setCacheShape(false);
                }
                d7 = this.isClockwise() ? -d11 * Math.abs(((PieChart$Data)object).getCurrentPieValue()) : d11 * Math.abs(((PieChart$Data)object).getCurrentPieValue());
                arc.setStartAngle(d24);
                arc.setLength(d7);
                arc.setType(ArcType.ROUND);
                arc.setRadiusX(this.pieRadius * ((PieChart$Data)object).getRadiusMultiplier());
                arc.setRadiusY(this.pieRadius * ((PieChart$Data)object).getRadiusMultiplier());
                node.setLayoutX(d9);
                node.setLayoutY(d8);
                d24 += d7;
                object = ((PieChart$Data)object).next;
            }
            if (arrayList != null) {
                this.resolveCollision(arrayList);
                if (!arrayList.equals(this.labelLayoutInfos)) {
                    this.labelLinePath.getElements().clear();
                    for (PieChart$LabelLayoutInfo pieChart$LabelLayoutInfo : arrayList) {
                        if (!pieChart$LabelLayoutInfo.text.isVisible()) continue;
                        this.drawLabelLinePath(pieChart$LabelLayoutInfo);
                    }
                    this.labelLayoutInfos = arrayList;
                }
            }
        }
    }

    private void resolveCollision(List<PieChart$LabelLayoutInfo> list) {
        int n2 = this.begin != null ? (int)this.begin.textNode.getLayoutBounds().getHeight() : 0;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            for (int i3 = i2 + 1; i3 < list.size(); ++i3) {
                PieChart$LabelLayoutInfo pieChart$LabelLayoutInfo = list.get(i2);
                PieChart$LabelLayoutInfo pieChart$LabelLayoutInfo2 = list.get(i3);
                if (!pieChart$LabelLayoutInfo.text.isVisible() || !pieChart$LabelLayoutInfo2.text.isVisible() || !(this.fuzzyGT(pieChart$LabelLayoutInfo2.textY, pieChart$LabelLayoutInfo.textY) ? this.fuzzyLT(pieChart$LabelLayoutInfo2.textY - (double)n2 - pieChart$LabelLayoutInfo.textY, 2.0) : this.fuzzyLT(pieChart$LabelLayoutInfo.textY - (double)n2 - pieChart$LabelLayoutInfo2.textY, 2.0)) || !(this.fuzzyGT(pieChart$LabelLayoutInfo.textX, pieChart$LabelLayoutInfo2.textX) ? this.fuzzyLT(pieChart$LabelLayoutInfo.textX - pieChart$LabelLayoutInfo2.textX, pieChart$LabelLayoutInfo2.text.prefWidth(-1.0)) : this.fuzzyLT(pieChart$LabelLayoutInfo2.textX - pieChart$LabelLayoutInfo.textX, pieChart$LabelLayoutInfo.text.prefWidth(-1.0)))) continue;
                if (this.fuzzyLT(pieChart$LabelLayoutInfo.size, pieChart$LabelLayoutInfo2.size)) {
                    pieChart$LabelLayoutInfo.text.setVisible(false);
                    continue;
                }
                pieChart$LabelLayoutInfo2.text.setVisible(false);
            }
        }
    }

    private int fuzzyCompare(double d2, double d3) {
        if (Math.abs(d2 - d3) < 1.0E-5) {
            return 0;
        }
        if (d2 < d3) {
            return -1;
        }
        return 1;
    }

    private boolean fuzzyGT(double d2, double d3) {
        return this.fuzzyCompare(d2, d3) == 1;
    }

    private boolean fuzzyLT(double d2, double d3) {
        return this.fuzzyCompare(d2, d3) == -1;
    }

    private void drawLabelLinePath(PieChart$LabelLayoutInfo pieChart$LabelLayoutInfo) {
        pieChart$LabelLayoutInfo.text.setLayoutX(pieChart$LabelLayoutInfo.textX);
        pieChart$LabelLayoutInfo.text.setLayoutY(pieChart$LabelLayoutInfo.textY);
        this.labelLinePath.getElements().add(new MoveTo(pieChart$LabelLayoutInfo.startX, pieChart$LabelLayoutInfo.startY));
        this.labelLinePath.getElements().add(new LineTo(pieChart$LabelLayoutInfo.endX, pieChart$LabelLayoutInfo.endY));
        this.labelLinePath.getElements().add(new MoveTo(pieChart$LabelLayoutInfo.endX - 2.0, pieChart$LabelLayoutInfo.endY));
        this.labelLinePath.getElements().add(new ArcTo(2.0, 2.0, 90.0, pieChart$LabelLayoutInfo.endX, pieChart$LabelLayoutInfo.endY - 2.0, false, true));
        this.labelLinePath.getElements().add(new ArcTo(2.0, 2.0, 90.0, pieChart$LabelLayoutInfo.endX + 2.0, pieChart$LabelLayoutInfo.endY, false, true));
        this.labelLinePath.getElements().add(new ArcTo(2.0, 2.0, 90.0, pieChart$LabelLayoutInfo.endX, pieChart$LabelLayoutInfo.endY + 2.0, false, true));
        this.labelLinePath.getElements().add(new ArcTo(2.0, 2.0, 90.0, pieChart$LabelLayoutInfo.endX - 2.0, pieChart$LabelLayoutInfo.endY, false, true));
        this.labelLinePath.getElements().add(new ClosePath());
    }

    private void updateLegend() {
        Node node = this.getLegend();
        if (node != null && node != this.legend) {
            return;
        }
        this.legend.setVertical(this.getLegendSide().equals((Object)Side.LEFT) || this.getLegendSide().equals((Object)Side.RIGHT));
        ArrayList<Legend$LegendItem> arrayList = new ArrayList<Legend$LegendItem>();
        if (this.getData() != null) {
            for (PieChart$Data pieChart$Data : this.getData()) {
                Legend$LegendItem legend$LegendItem = new Legend$LegendItem(pieChart$Data.getName());
                legend$LegendItem.getSymbol().getStyleClass().addAll((Collection<String>)pieChart$Data.getNode().getStyleClass());
                legend$LegendItem.getSymbol().getStyleClass().add("pie-legend-symbol");
                arrayList.add(legend$LegendItem);
            }
        }
        this.legend.getItems().setAll((Collection<Legend$LegendItem>)arrayList);
        if (arrayList.size() > 0) {
            if (node == null) {
                PieChart pieChart = this;
                pieChart.setLegend(pieChart.legend);
                return;
            }
        } else {
            this.setLegend(null);
        }
    }

    private int getDataSize() {
        int n2 = 0;
        PieChart$Data pieChart$Data = this.begin;
        while (pieChart$Data != null) {
            ++n2;
            pieChart$Data = pieChart$Data.next;
        }
        return n2;
    }

    private static double calcX(double d2, double d3, double d4) {
        return d4 + d3 * Math.cos(Math.toRadians(-d2));
    }

    private static double calcY(double d2, double d3, double d4) {
        return d4 + d3 * Math.sin(Math.toRadians(-d2));
    }

    private static double normalizeAngle(double d2) {
        double d3;
        double d4 = d2 % 360.0;
        if (d3 <= -180.0) {
            d4 += 360.0;
        }
        if (d4 > 180.0) {
            d4 -= 360.0;
        }
        return d4;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return PieChart$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return PieChart.getClassCssMetaData();
    }
}

