/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import com.sun.javafx.charts.Legend$LegendItem;
import java.util.Collection;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.ParallelTransition;
import javafx.application.Platform;
import javafx.beans.NamedArg;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.XYChart;
import javafx.scene.chart.XYChart$Data;
import javafx.scene.chart.XYChart$Series;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;

public class ScatterChart<X, Y>
extends XYChart<X, Y> {
    private ParallelTransition parallelTransition;

    public ScatterChart(@NamedArg(value="xAxis") Axis<X> axis, @NamedArg(value="yAxis") Axis<Y> axis2) {
        this(axis, axis2, FXCollections.observableArrayList());
    }

    public ScatterChart(@NamedArg(value="xAxis") Axis<X> axis, @NamedArg(value="yAxis") Axis<Y> axis2, @NamedArg(value="data") ObservableList<XYChart$Series<X, Y>> observableList) {
        super(axis, axis2);
        this.setData(observableList);
    }

    @Override
    protected void dataItemAdded(XYChart$Series<X, Y> object, int n2, XYChart$Data<X, Y> xYChart$Data) {
        Node node = xYChart$Data.getNode();
        if (node == null) {
            node = new StackPane();
            node.setAccessibleRole(AccessibleRole.TEXT);
            node.setAccessibleRoleDescription("Point");
            node.focusTraversableProperty().bind(Platform.accessibilityActiveProperty());
            xYChart$Data.setNode(node);
        }
        node.getStyleClass().setAll((String[])new String[]{"chart-symbol", "series" + this.getData().indexOf(object), "data" + n2, ((XYChart$Series)object).defaultColorStyleClass});
        if (this.shouldAnimate()) {
            node.setOpacity(0.0);
            this.getPlotChildren().add(node);
            object = new FadeTransition(Duration.millis(500.0), node);
            ((FadeTransition)object).setToValue(1.0);
            ((Animation)object).play();
            return;
        }
        this.getPlotChildren().add(node);
    }

    @Override
    protected void dataItemRemoved(XYChart$Data<X, Y> xYChart$Data, XYChart$Series<X, Y> xYChart$Series) {
        Node node = xYChart$Data.getNode();
        if (node != null) {
            node.focusTraversableProperty().unbind();
        }
        if (this.shouldAnimate()) {
            FadeTransition fadeTransition = new FadeTransition(Duration.millis(500.0), node);
            fadeTransition.setToValue(0.0);
            fadeTransition.setOnFinished(actionEvent -> {
                this.getPlotChildren().remove(node);
                this.removeDataItemFromDisplay(xYChart$Series, xYChart$Data);
                node.setOpacity(1.0);
            });
            fadeTransition.play();
            return;
        }
        this.getPlotChildren().remove(node);
        this.removeDataItemFromDisplay(xYChart$Series, xYChart$Data);
    }

    @Override
    protected void dataItemChanged(XYChart$Data<X, Y> xYChart$Data) {
    }

    @Override
    protected void seriesAdded(XYChart$Series<X, Y> xYChart$Series, int n2) {
        for (n2 = 0; n2 < xYChart$Series.getData().size(); ++n2) {
            this.dataItemAdded(xYChart$Series, n2, (XYChart$Data)xYChart$Series.getData().get(n2));
        }
    }

    @Override
    protected void seriesRemoved(XYChart$Series<X, Y> object) {
        if (this.shouldAnimate()) {
            this.parallelTransition = new ParallelTransition();
            this.parallelTransition.setOnFinished(arg_0 -> this.lambda$seriesRemoved$1((XYChart$Series)object, arg_0));
            for (XYChart$Data object3 : ((XYChart$Series)object).getData()) {
                Node object2 = object3.getNode();
                object = new FadeTransition(Duration.millis(500.0), object2);
                ((FadeTransition)object).setToValue(0.0);
                ((Animation)object).setOnFinished(actionEvent -> {
                    this.getPlotChildren().remove(object2);
                    object2.setOpacity(1.0);
                });
                this.parallelTransition.getChildren().add((Animation)object);
            }
            this.parallelTransition.play();
            return;
        }
        for (XYChart$Data xYChart$Data : ((XYChart$Series)object).getData()) {
            Node node = xYChart$Data.getNode();
            this.getPlotChildren().remove(node);
        }
        this.removeSeriesFromDisplay(object);
    }

    @Override
    protected void layoutPlotChildren() {
        for (int i2 = 0; i2 < this.getDataSize(); ++i2) {
            Object object = (XYChart$Series)this.getData().get(i2);
            object = this.getDisplayedDataIterator(object);
            while (object.hasNext()) {
                Object object2 = (XYChart$Data)object.next();
                double d2 = this.getXAxis().getDisplayPosition(((XYChart$Data)object2).getCurrentX());
                double d3 = this.getYAxis().getDisplayPosition(((XYChart$Data)object2).getCurrentY());
                if (Double.isNaN(d2) || Double.isNaN(d3) || (object2 = ((XYChart$Data)object2).getNode()) == null) continue;
                double d4 = ((Node)object2).prefWidth(-1.0);
                double d5 = ((Node)object2).prefHeight(-1.0);
                ((Node)object2).resizeRelocate(d2 - d4 / 2.0, d3 - d5 / 2.0, d4, d5);
            }
        }
    }

    @Override
    Legend$LegendItem createLegendItemForSeries(XYChart$Series<X, Y> xYChart$Series, int n2) {
        Legend$LegendItem legend$LegendItem = new Legend$LegendItem(xYChart$Series.getName());
        if ((xYChart$Series = xYChart$Series.getData().isEmpty() ? null : ((XYChart$Data)xYChart$Series.getData().get(0)).getNode()) != null) {
            legend$LegendItem.getSymbol().getStyleClass().addAll((Collection<String>)((Node)((Object)xYChart$Series)).getStyleClass());
        }
        return legend$LegendItem;
    }

    @Override
    void seriesBeingRemovedIsAdded(XYChart$Series<X, Y> xYChart$Series) {
        if (this.parallelTransition != null) {
            this.parallelTransition.setOnFinished(null);
            this.parallelTransition.stop();
            this.parallelTransition = null;
            this.getPlotChildren().remove(xYChart$Series.getNode());
            for (XYChart$Data xYChart$Data : xYChart$Series.getData()) {
                this.getPlotChildren().remove(xYChart$Data.getNode());
            }
            this.removeSeriesFromDisplay(xYChart$Series);
        }
    }
}

