/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import com.sun.javafx.charts.Legend$LegendItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.NamedArg;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener$Change;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.scene.AccessibleRole;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.StackedAreaChart$1;
import javafx.scene.chart.StackedAreaChart$DataPointInfo;
import javafx.scene.chart.StackedAreaChart$PartOf;
import javafx.scene.chart.StackedAreaChart$StyleableProperties;
import javafx.scene.chart.ValueAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.chart.XYChart$Data;
import javafx.scene.chart.XYChart$Series;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineJoin;
import javafx.util.Duration;

public class StackedAreaChart<X, Y>
extends XYChart<X, Y> {
    private Map<XYChart$Series<X, Y>, DoubleProperty> seriesYMultiplierMap = new HashMap<XYChart$Series<X, Y>, DoubleProperty>();
    private Timeline timeline;
    private BooleanProperty createSymbols = new StackedAreaChart$1(this, true);

    public final boolean getCreateSymbols() {
        return this.createSymbols.getValue();
    }

    public final void setCreateSymbols(boolean bl2) {
        this.createSymbols.setValue(bl2);
    }

    public final BooleanProperty createSymbolsProperty() {
        return this.createSymbols;
    }

    public StackedAreaChart(@NamedArg(value="xAxis") Axis<X> axis, @NamedArg(value="yAxis") Axis<Y> axis2) {
        this(axis, axis2, FXCollections.observableArrayList());
    }

    public StackedAreaChart(@NamedArg(value="xAxis") Axis<X> axis, @NamedArg(value="yAxis") Axis<Y> axis2, @NamedArg(value="data") ObservableList<XYChart$Series<X, Y>> observableList) {
        super(axis, axis2);
        if (!(axis2 instanceof ValueAxis)) {
            throw new IllegalArgumentException("Axis type incorrect, yAxis must be of ValueAxis type.");
        }
        this.setData(observableList);
    }

    private static double doubleValue(Number number) {
        return StackedAreaChart.doubleValue(number, 0.0);
    }

    private static double doubleValue(Number number, double d2) {
        if (number == null) {
            return d2;
        }
        return number.doubleValue();
    }

    @Override
    protected void dataItemAdded(XYChart$Series<X, Y> object, int n2, XYChart$Data<X, Y> xYChart$Data) {
        Node node = this.createSymbol((XYChart$Series<X, Y>)object, this.getData().indexOf(object), xYChart$Data, n2);
        if (this.shouldAnimate()) {
            boolean bl2 = false;
            if (n2 > 0 && n2 < ((XYChart$Series)object).getData().size() - 1) {
                bl2 = true;
                XYChart$Data xYChart$Data2 = (XYChart$Data)((XYChart$Series)object).getData().get(n2 - 1);
                object = (XYChart$Data)((XYChart$Series)object).getData().get(n2 + 1);
                double d2 = this.getXAxis().toNumericValue(xYChart$Data2.getXValue());
                double d3 = this.getYAxis().toNumericValue(xYChart$Data2.getYValue());
                double d4 = this.getXAxis().toNumericValue(((XYChart$Data)object).getXValue());
                double d5 = this.getYAxis().toNumericValue(((XYChart$Data)object).getYValue());
                double d6 = this.getXAxis().toNumericValue(xYChart$Data.getXValue());
                this.getYAxis().toNumericValue(xYChart$Data.getYValue());
                double d7 = (d5 - d3) / (d4 - d2) * d6 + (d4 * d3 - d5 * d2) / (d4 - d2);
                xYChart$Data.setCurrentY(this.getYAxis().toRealValue(d7));
                xYChart$Data.setCurrentX(this.getXAxis().toRealValue(d6));
            } else if (n2 == 0 && ((XYChart$Series)object).getData().size() > 1) {
                bl2 = true;
                xYChart$Data.setCurrentX(((XYChart$Data)((XYChart$Series)object).getData().get(1)).getXValue());
                xYChart$Data.setCurrentY(((XYChart$Data)((XYChart$Series)object).getData().get(1)).getYValue());
            } else if (n2 == ((XYChart$Series)object).getData().size() - 1 && ((XYChart$Series)object).getData().size() > 1) {
                bl2 = true;
                int n3 = ((XYChart$Series)object).getData().size() - 2;
                xYChart$Data.setCurrentX(((XYChart$Data)((XYChart$Series)object).getData().get(n3)).getXValue());
                xYChart$Data.setCurrentY(((XYChart$Data)((XYChart$Series)object).getData().get(n3)).getYValue());
            } else if (node != null) {
                node.setOpacity(0.0);
                this.getPlotChildren().add(node);
                FadeTransition fadeTransition = new FadeTransition(Duration.millis(500.0), node);
                fadeTransition.setToValue(1.0);
                fadeTransition.play();
            }
            if (bl2) {
                this.animate(new KeyFrame(Duration.ZERO, actionEvent -> {
                    if (node != null && !this.getPlotChildren().contains(node)) {
                        this.getPlotChildren().add(node);
                    }
                }, new KeyValue(xYChart$Data.currentYProperty(), xYChart$Data.getCurrentY()), new KeyValue(xYChart$Data.currentXProperty(), xYChart$Data.getCurrentX())), new KeyFrame(Duration.millis(800.0), new KeyValue(xYChart$Data.currentYProperty(), xYChart$Data.getYValue(), Interpolator.EASE_BOTH), new KeyValue(xYChart$Data.currentXProperty(), xYChart$Data.getXValue(), Interpolator.EASE_BOTH)));
            }
            return;
        }
        if (node != null) {
            this.getPlotChildren().add(node);
        }
    }

    @Override
    protected void dataItemRemoved(XYChart$Data<X, Y> xYChart$Data, XYChart$Series<X, Y> xYChart$Series) {
        Node node = xYChart$Data.getNode();
        if (node != null) {
            node.focusTraversableProperty().unbind();
        }
        int n2 = xYChart$Series.getItemIndex(xYChart$Data);
        if (this.shouldAnimate()) {
            boolean bl2 = false;
            int n3 = xYChart$Series.getDataSize();
            int n4 = xYChart$Series.getData().size();
            if (n2 > 0 && n2 < n3 - 1) {
                bl2 = true;
                XYChart$Data<X, Y> xYChart$Data2 = xYChart$Series.getItem(n2 - 1);
                XYChart$Data<X, Y> xYChart$Data3 = xYChart$Series.getItem(n2 + 1);
                double d2 = this.getXAxis().toNumericValue(xYChart$Data2.getXValue());
                double d3 = this.getYAxis().toNumericValue(xYChart$Data2.getYValue());
                double d4 = this.getXAxis().toNumericValue(xYChart$Data3.getXValue());
                double d5 = this.getYAxis().toNumericValue(xYChart$Data3.getYValue());
                double d6 = this.getXAxis().toNumericValue(xYChart$Data.getXValue());
                double d7 = this.getYAxis().toNumericValue(xYChart$Data.getYValue());
                double d8 = (d5 - d3) / (d4 - d2) * d6 + (d4 * d3 - d5 * d2) / (d4 - d2);
                xYChart$Data.setCurrentX(this.getXAxis().toRealValue(d6));
                xYChart$Data.setCurrentY(this.getYAxis().toRealValue(d7));
                xYChart$Data.setXValue(this.getXAxis().toRealValue(d6));
                xYChart$Data.setYValue(this.getYAxis().toRealValue(d8));
            } else if (n2 == 0 && n4 > 1) {
                bl2 = true;
                xYChart$Data.setXValue(((XYChart$Data)xYChart$Series.getData().get(0)).getXValue());
                xYChart$Data.setYValue(((XYChart$Data)xYChart$Series.getData().get(0)).getYValue());
            } else if (n2 == n3 - 1 && n4 > 1) {
                bl2 = true;
                n3 = n4 - 1;
                xYChart$Data.setXValue(((XYChart$Data)xYChart$Series.getData().get(n3)).getXValue());
                xYChart$Data.setYValue(((XYChart$Data)xYChart$Series.getData().get(n3)).getYValue());
            } else if (node != null) {
                node.setOpacity(0.0);
                FadeTransition fadeTransition = new FadeTransition(Duration.millis(500.0), node);
                fadeTransition.setToValue(0.0);
                fadeTransition.setOnFinished(actionEvent -> {
                    this.getPlotChildren().remove(node);
                    this.removeDataItemFromDisplay(xYChart$Series, xYChart$Data);
                    node.setOpacity(1.0);
                });
                fadeTransition.play();
            } else {
                xYChart$Data.setSeries(null);
                this.removeDataItemFromDisplay(xYChart$Series, xYChart$Data);
            }
            if (bl2) {
                this.animate(new KeyFrame(Duration.ZERO, new KeyValue(xYChart$Data.currentYProperty(), xYChart$Data.getCurrentY()), new KeyValue(xYChart$Data.currentXProperty(), xYChart$Data.getCurrentX())), new KeyFrame(Duration.millis(800.0), actionEvent -> {
                    this.getPlotChildren().remove(node);
                    this.removeDataItemFromDisplay(xYChart$Series, xYChart$Data);
                }, new KeyValue(xYChart$Data.currentYProperty(), xYChart$Data.getYValue(), Interpolator.EASE_BOTH), new KeyValue(xYChart$Data.currentXProperty(), xYChart$Data.getXValue(), Interpolator.EASE_BOTH)));
            }
            return;
        }
        this.getPlotChildren().remove(node);
        this.removeDataItemFromDisplay(xYChart$Series, xYChart$Data);
    }

    @Override
    protected void dataItemChanged(XYChart$Data<X, Y> xYChart$Data) {
    }

    @Override
    protected void seriesChanged(ListChangeListener$Change<? extends XYChart$Series> listChangeListener$Change) {
        for (int i2 = 0; i2 < this.getDataSize(); ++i2) {
            XYChart$Series xYChart$Series = (XYChart$Series)this.getData().get(i2);
            Path path = (Path)((Group)xYChart$Series.getNode()).getChildren().get(1);
            Object object = (Path)((Group)xYChart$Series.getNode()).getChildren().get(0);
            path.getStyleClass().setAll((String[])new String[]{"chart-series-area-line", "series" + i2, xYChart$Series.defaultColorStyleClass});
            ((Node)object).getStyleClass().setAll((String[])new String[]{"chart-series-area-fill", "series" + i2, xYChart$Series.defaultColorStyleClass});
            for (int i3 = 0; i3 < xYChart$Series.getData().size(); ++i3) {
                object = (XYChart$Data)xYChart$Series.getData().get(i3);
                if ((object = ((XYChart$Data)object).getNode()) == null) continue;
                ((Node)object).getStyleClass().setAll((String[])new String[]{"chart-area-symbol", "series" + i2, "data" + i3, xYChart$Series.defaultColorStyleClass});
            }
        }
    }

    @Override
    protected void seriesAdded(XYChart$Series<X, Y> xYChart$Series, int n2) {
        Node node = new Path();
        Object object = new Path();
        ((Shape)node).setStrokeLineJoin(StrokeLineJoin.BEVEL);
        ((Shape)object).setStrokeLineJoin(StrokeLineJoin.BEVEL);
        node = new Group(new Node[]{object, node});
        xYChart$Series.setNode(node);
        object = new SimpleDoubleProperty(this, "seriesYMultiplier");
        this.seriesYMultiplierMap.put(xYChart$Series, (DoubleProperty)object);
        if (this.shouldAnimate()) {
            ((DoubleProperty)object).setValue(0.0);
        } else {
            ((DoubleProperty)object).setValue(1.0);
        }
        this.getPlotChildren().add(node);
        ArrayList<KeyFrame> arrayList = new ArrayList<KeyFrame>();
        if (this.shouldAnimate()) {
            arrayList.add(new KeyFrame(Duration.ZERO, new KeyValue(node.opacityProperty(), 0), new KeyValue(object, 0)));
            arrayList.add(new KeyFrame(Duration.millis(200.0), new KeyValue(node.opacityProperty(), 1)));
            arrayList.add(new KeyFrame(Duration.millis(500.0), new KeyValue(object, 1)));
        }
        for (int i2 = 0; i2 < xYChart$Series.getData().size(); ++i2) {
            object = (XYChart$Data)xYChart$Series.getData().get(i2);
            if ((object = this.createSymbol(xYChart$Series, n2, (XYChart$Data<X, Y>)object, i2)) == null) continue;
            if (this.shouldAnimate()) {
                ((Node)object).setOpacity(0.0);
            }
            this.getPlotChildren().add((Node)object);
            if (!this.shouldAnimate()) continue;
            arrayList.add(new KeyFrame(Duration.ZERO, new KeyValue(((Node)object).opacityProperty(), 0)));
            arrayList.add(new KeyFrame(Duration.millis(200.0), new KeyValue(((Node)object).opacityProperty(), 1)));
        }
        if (this.shouldAnimate()) {
            ArrayList<KeyFrame> arrayList2 = arrayList;
            this.animate(arrayList2.toArray(new KeyFrame[arrayList2.size()]));
        }
    }

    @Override
    protected void seriesRemoved(XYChart$Series<X, Y> xYChart$Series) {
        this.seriesYMultiplierMap.remove(xYChart$Series);
        if (this.shouldAnimate()) {
            this.timeline = new Timeline(this.createSeriesRemoveTimeLine(xYChart$Series, 400L));
            this.timeline.play();
            return;
        }
        this.getPlotChildren().remove(xYChart$Series.getNode());
        for (XYChart$Data xYChart$Data : xYChart$Series.getData()) {
            this.getPlotChildren().remove(xYChart$Data.getNode());
        }
        this.removeSeriesFromDisplay(xYChart$Series);
    }

    @Override
    protected void updateAxisRange() {
        Axis axis = this.getXAxis();
        Axis axis2 = this.getYAxis();
        if (axis.isAutoRanging()) {
            ArrayList arrayList = new ArrayList();
            for (XYChart$Series object : this.getData()) {
                for (XYChart$Data xYChart$Data : object.getData()) {
                    arrayList.add(xYChart$Data.getXValue());
                }
            }
            axis.invalidateRange(arrayList);
        }
        if (axis2.isAutoRanging()) {
            double d2 = Double.MAX_VALUE;
            Iterator iterator = this.getDisplayedSeriesIterator();
            boolean bl2 = true;
            TreeMap<Double, Double> treeMap = new TreeMap<Double, Double>();
            TreeMap<Double, Double> treeMap2 = new TreeMap<Double, Double>();
            TreeMap<Double, Double> treeMap3 = new TreeMap<Double, Double>();
            while (iterator.hasNext()) {
                treeMap3.clear();
                Iterator iterator2 = iterator.next();
                for (XYChart$Data xYChart$Data : ((XYChart$Series)((Object)iterator2)).getData()) {
                    if (xYChart$Data == null) continue;
                    double d3 = axis.toNumericValue(xYChart$Data.getXValue());
                    double d4 = axis2.toNumericValue(xYChart$Data.getYValue());
                    treeMap3.put(d3, d4);
                    if (bl2) {
                        treeMap.put(d3, d4);
                        d2 = Math.min(d2, d4);
                        continue;
                    }
                    if (treeMap2.containsKey(d3)) {
                        treeMap.put(d3, (Double)treeMap2.get(d3) + d4);
                        continue;
                    }
                    Map.Entry entry = treeMap2.higherEntry(d3);
                    Map.Entry entry2 = treeMap2.lowerEntry(d3);
                    if (entry != null && entry2 != null) {
                        treeMap.put(d3, (d3 - entry2.getKey()) / (entry.getKey() - entry2.getKey()) * ((Double)entry2.getValue() + (Double)entry.getValue()) + d4);
                        continue;
                    }
                    if (entry != null) {
                        treeMap.put(d3, (Double)entry.getValue() + d4);
                        continue;
                    }
                    if (entry2 != null) {
                        treeMap.put(d3, (Double)entry2.getValue() + d4);
                        continue;
                    }
                    treeMap.put(d3, d4);
                }
                for (Map.Entry entry : treeMap2.entrySet()) {
                    if (treeMap.keySet().contains(entry.getKey())) continue;
                    Double d5 = (Double)entry.getKey();
                    Double d6 = (Double)entry.getValue();
                    Map.Entry entry3 = treeMap3.higherEntry(d5);
                    Map.Entry entry4 = treeMap3.lowerEntry(d5);
                    if (entry3 != null && entry4 != null) {
                        Double d7 = d5;
                        treeMap.put(d7, (d7 - entry4.getKey()) / (entry3.getKey() - entry4.getKey()) * ((Double)entry4.getValue() + (Double)entry3.getValue()) + d6);
                        continue;
                    }
                    if (entry3 != null) {
                        treeMap.put(d5, (Double)entry3.getValue() + d6);
                        continue;
                    }
                    if (entry4 != null) {
                        treeMap.put(d5, (Double)entry4.getValue() + d6);
                        continue;
                    }
                    treeMap.put(d5, d6);
                }
                treeMap2.clear();
                treeMap2.putAll(treeMap);
                treeMap.clear();
                bl2 = d2 == Double.MAX_VALUE;
            }
            if (d2 != Double.MAX_VALUE) {
                axis2.invalidateRange(Arrays.asList(axis2.toRealValue(d2), axis2.toRealValue((Double)Collections.max(treeMap2.values()))));
            }
        }
    }

    @Override
    protected void layoutPlotChildren() {
        ArrayList<StackedAreaChart$DataPointInfo<X, Y>> arrayList = new ArrayList<StackedAreaChart$DataPointInfo<X, Y>>();
        ArrayList<StackedAreaChart$DataPointInfo<X, Y>> arrayList2 = new ArrayList<StackedAreaChart$DataPointInfo<X, Y>>();
        for (int i2 = 0; i2 < this.getDataSize(); ++i2) {
            XYChart$Data xYChart$Data;
            Object object;
            XYChart$Series xYChart$Series = (XYChart$Series)this.getData().get(i2);
            arrayList2.clear();
            for (StackedAreaChart$DataPointInfo stackedAreaChart$DataPointInfo : arrayList) {
                ((StackedAreaChart$DataPointInfo)object3.next()).partOf = StackedAreaChart$PartOf.PREVIOUS;
                arrayList2.add(stackedAreaChart$DataPointInfo);
            }
            arrayList.clear();
            Object object3 = this.getDisplayedDataIterator(xYChart$Series);
            while (object3.hasNext()) {
                XYChart$Data xYChart$Data2;
                XYChart$Data xYChart$Data3 = xYChart$Data2 = (XYChart$Data)object3.next();
                object = new StackedAreaChart$DataPointInfo(xYChart$Data3, xYChart$Data3.getXValue(), xYChart$Data2.getYValue(), StackedAreaChart$PartOf.CURRENT);
                arrayList2.add((StackedAreaChart$DataPointInfo<X, Y>)object);
            }
            object3 = this.seriesYMultiplierMap.get(xYChart$Series);
            Path object22 = (Path)((Group)xYChart$Series.getNode()).getChildren().get(1);
            object = (Path)((Group)xYChart$Series.getNode()).getChildren().get(0);
            object22.getElements().clear();
            ((Path)object).getElements().clear();
            int n2 = 0;
            this.sortAggregateList(arrayList2);
            Axis axis = this.getYAxis();
            Axis axis2 = this.getXAxis();
            boolean bl2 = false;
            boolean bl3 = false;
            int n3 = this.findNextCurrent(arrayList2, -1);
            ArrayList<StackedAreaChart$DataPointInfo<X, Y>> arrayList3 = arrayList2;
            int n4 = this.findPreviousCurrent(arrayList3, arrayList3.size());
            double d2 = axis.getZeroPosition();
            if (Double.isNaN(d2)) {
                ValueAxis valueAxis;
                Iterator iterator = (ValueAxis)axis;
                if (valueAxis.getLowerBound() > 0.0) {
                    Iterator iterator2 = iterator;
                    d2 = ((ValueAxis)((Object)iterator2)).getDisplayPosition(((ValueAxis)((Object)iterator2)).getLowerBound());
                } else {
                    Iterator iterator3 = iterator;
                    d2 = ((ValueAxis)((Object)iterator3)).getDisplayPosition(((ValueAxis)((Object)iterator3)).getUpperBound());
                }
            }
            for (StackedAreaChart$DataPointInfo<X, Y> stackedAreaChart$DataPointInfo : arrayList2) {
                if (n2 == n4) {
                    bl3 = true;
                }
                if (n2 == n3) {
                    bl2 = true;
                }
                xYChart$Data = stackedAreaChart$DataPointInfo.dataItem;
                if (stackedAreaChart$DataPointInfo.partOf.equals((Object)StackedAreaChart$PartOf.CURRENT)) {
                    var20_24 = this.findPreviousPrevious(arrayList2, n2);
                    var21_26 = this.findNextPrevious(arrayList2, n2);
                    if (var20_24 == -1 || var21_26 == -1 && !arrayList2.get((int)var20_24).x.equals(stackedAreaChart$DataPointInfo.x)) {
                        if (bl2) {
                            XYChart$Data xYChart$Data4;
                            XYChart$Data xYChart$Data5 = xYChart$Data4 = new XYChart$Data(stackedAreaChart$DataPointInfo.x, 0);
                            this.addDropDown(arrayList, xYChart$Data5, xYChart$Data5.getXValue(), xYChart$Data4.getYValue(), axis2.getDisplayPosition(xYChart$Data4.getCurrentX()), d2);
                        }
                        var24_30 = axis2.getDisplayPosition(xYChart$Data.getCurrentX());
                        Axis axis3 = axis;
                        var26_32 = axis3.getDisplayPosition(axis3.toRealValue(axis.toNumericValue(xYChart$Data.getCurrentY()) * ((DoubleExpression)object3).getValue()));
                        XYChart$Data xYChart$Data6 = xYChart$Data;
                        this.addPoint(arrayList, xYChart$Data6, xYChart$Data6.getXValue(), xYChart$Data.getYValue(), var24_30, var26_32, StackedAreaChart$PartOf.CURRENT, false, !bl2);
                        if (n2 == n4) {
                            XYChart$Data xYChart$Data7;
                            XYChart$Data xYChart$Data8 = xYChart$Data7 = new XYChart$Data(stackedAreaChart$DataPointInfo.x, 0);
                            this.addDropDown(arrayList, xYChart$Data8, xYChart$Data8.getXValue(), xYChart$Data7.getYValue(), axis2.getDisplayPosition(xYChart$Data7.getCurrentX()), d2);
                        }
                    } else {
                        var22_27 = arrayList2.get(var20_24);
                        if (var22_27.x.equals(stackedAreaChart$DataPointInfo.x)) {
                            if (var22_27.dropDown) {
                                var20_24 = this.findPreviousPrevious(arrayList2, var20_24);
                                var22_27 = arrayList2.get(var20_24);
                            }
                            if (var22_27.x.equals(stackedAreaChart$DataPointInfo.x)) {
                                var24_30 = axis2.getDisplayPosition(xYChart$Data.getCurrentX());
                                var26_32 = axis.toNumericValue(xYChart$Data.getCurrentY()) + axis.toNumericValue(var22_27.y);
                                Axis axis4 = axis;
                                double d3 = axis4.getDisplayPosition(axis4.toRealValue(var26_32 * ((DoubleExpression)object3).getValue()));
                                this.addPoint(arrayList, xYChart$Data, stackedAreaChart$DataPointInfo.x, axis.toRealValue(var26_32), var24_30, d3, StackedAreaChart$PartOf.CURRENT, false, !bl2);
                            }
                            if (bl3) {
                                this.addDropDown(arrayList, xYChart$Data, var22_27.x, var22_27.y, var22_27.displayX, var22_27.displayY);
                            }
                        } else {
                            var23_29 = var21_26 == -1 ? null : arrayList2.get(var21_26);
                            var22_27 = var20_24 == -1 ? null : arrayList2.get(var20_24);
                            var24_30 = axis.toNumericValue(xYChart$Data.getCurrentY());
                            if (var22_27 != null && var23_29 != null) {
                                var26_32 = axis2.getDisplayPosition(xYChart$Data.getCurrentX());
                                double d4 = this.interpolate(var22_27.displayX, var22_27.displayY, var23_29.displayX, var23_29.displayY, var26_32);
                                var30_37 = this.interpolate(axis2.toNumericValue(var22_27.x), axis.toNumericValue(var22_27.y), axis2.toNumericValue(var23_29.x), axis.toNumericValue(var23_29.y), axis2.toNumericValue(stackedAreaChart$DataPointInfo.x));
                                if (bl2) {
                                    XYChart$Data xYChart$Data9 = new XYChart$Data(stackedAreaChart$DataPointInfo.x, var30_37);
                                    this.addDropDown(arrayList, xYChart$Data9, stackedAreaChart$DataPointInfo.x, axis.toRealValue(var30_37), var26_32, d4);
                                }
                                Axis axis5 = axis;
                                double d5 = axis5.getDisplayPosition(axis5.toRealValue((var24_30 + var30_37) * ((DoubleExpression)object3).getValue()));
                                this.addPoint(arrayList, xYChart$Data, stackedAreaChart$DataPointInfo.x, axis.toRealValue(var24_30 + var30_37), var26_32, d5, StackedAreaChart$PartOf.CURRENT, false, !bl2);
                                if (n2 == n4) {
                                    xYChart$Data = new XYChart$Data(stackedAreaChart$DataPointInfo.x, var30_37);
                                    this.addDropDown(arrayList, xYChart$Data, stackedAreaChart$DataPointInfo.x, axis.toRealValue(var30_37), var26_32, d4);
                                }
                            }
                        }
                    }
                } else {
                    var20_24 = this.findPreviousCurrent(arrayList2, n2);
                    var21_26 = this.findNextCurrent(arrayList2, n2);
                    if (stackedAreaChart$DataPointInfo.dropDown) {
                        if (axis2.toNumericValue(stackedAreaChart$DataPointInfo.x) <= axis2.toNumericValue(arrayList2.get((int)n3).x) || axis2.toNumericValue(stackedAreaChart$DataPointInfo.x) > axis2.toNumericValue(arrayList2.get((int)n4).x)) {
                            this.addDropDown(arrayList, xYChart$Data, stackedAreaChart$DataPointInfo.x, stackedAreaChart$DataPointInfo.y, stackedAreaChart$DataPointInfo.displayX, stackedAreaChart$DataPointInfo.displayY);
                        }
                    } else if (var20_24 == -1 || var21_26 == -1) {
                        this.addPoint(arrayList, xYChart$Data, stackedAreaChart$DataPointInfo.x, stackedAreaChart$DataPointInfo.y, stackedAreaChart$DataPointInfo.displayX, stackedAreaChart$DataPointInfo.displayY, StackedAreaChart$PartOf.CURRENT, true, false);
                    } else {
                        var23_29 = arrayList2.get(var21_26);
                        if (!var23_29.x.equals(stackedAreaChart$DataPointInfo.x)) {
                            var22_27 = arrayList2.get(var20_24);
                            var24_30 = axis2.getDisplayPosition(xYChart$Data.getCurrentX());
                            var26_32 = this.interpolate(axis2.toNumericValue(var22_27.x), axis.toNumericValue(var22_27.y), axis2.toNumericValue(var23_29.x), axis.toNumericValue(var23_29.y), axis2.toNumericValue(stackedAreaChart$DataPointInfo.x));
                            double d6 = axis.toNumericValue(stackedAreaChart$DataPointInfo.y) + var26_32;
                            Axis axis6 = axis;
                            var30_37 = axis6.getDisplayPosition(axis6.toRealValue(d6 * ((DoubleExpression)object3).getValue()));
                            this.addPoint(arrayList, new XYChart$Data(stackedAreaChart$DataPointInfo.x, var26_32), stackedAreaChart$DataPointInfo.x, axis.toRealValue(d6), var24_30, var30_37, StackedAreaChart$PartOf.CURRENT, true, true);
                        }
                    }
                }
                ++n2;
                if (bl2) {
                    bl2 = false;
                }
                if (!bl3) continue;
                bl3 = false;
            }
            if (!arrayList.isEmpty()) {
                object22.getElements().add(new MoveTo(((StackedAreaChart$DataPointInfo)arrayList.get((int)0)).displayX, ((StackedAreaChart$DataPointInfo)arrayList.get((int)0)).displayY));
                ((Path)object).getElements().add(new MoveTo(((StackedAreaChart$DataPointInfo)arrayList.get((int)0)).displayX, ((StackedAreaChart$DataPointInfo)arrayList.get((int)0)).displayY));
            }
            for (StackedAreaChart$DataPointInfo<X, Y> stackedAreaChart$DataPointInfo : arrayList) {
                if (stackedAreaChart$DataPointInfo.lineTo) {
                    object22.getElements().add(new LineTo(stackedAreaChart$DataPointInfo.displayX, stackedAreaChart$DataPointInfo.displayY));
                } else {
                    object22.getElements().add(new MoveTo(stackedAreaChart$DataPointInfo.displayX, stackedAreaChart$DataPointInfo.displayY));
                }
                ((Path)object).getElements().add(new LineTo(stackedAreaChart$DataPointInfo.displayX, stackedAreaChart$DataPointInfo.displayY));
                if (stackedAreaChart$DataPointInfo.skipSymbol || (xYChart$Data = stackedAreaChart$DataPointInfo.dataItem.getNode()) == null) continue;
                double d7 = ((Node)((Object)xYChart$Data)).prefWidth(-1.0);
                double d8 = ((Node)((Object)xYChart$Data)).prefHeight(-1.0);
                ((Node)((Object)xYChart$Data)).resizeRelocate(stackedAreaChart$DataPointInfo.displayX - d7 / 2.0, stackedAreaChart$DataPointInfo.displayY - d8 / 2.0, d7, d8);
            }
            for (int i3 = arrayList2.size() - 1; i3 > 0; --i3) {
                StackedAreaChart$DataPointInfo<X, Y> stackedAreaChart$DataPointInfo;
                stackedAreaChart$DataPointInfo = arrayList2.get(i3);
                if (!StackedAreaChart$PartOf.PREVIOUS.equals((Object)stackedAreaChart$DataPointInfo.partOf)) continue;
                ((Path)object).getElements().add(new LineTo(stackedAreaChart$DataPointInfo.displayX, stackedAreaChart$DataPointInfo.displayY));
            }
            if (((Path)object).getElements().isEmpty()) continue;
            ((Path)object).getElements().add(new ClosePath());
        }
    }

    private void addDropDown(ArrayList<StackedAreaChart$DataPointInfo<X, Y>> arrayList, XYChart$Data<X, Y> xYChart$Data, X x2, Y y2, double d2, double d3) {
        StackedAreaChart$DataPointInfo<X, Y> stackedAreaChart$DataPointInfo = new StackedAreaChart$DataPointInfo<X, Y>(true);
        stackedAreaChart$DataPointInfo.setValues(xYChart$Data, x2, y2, d2, d3, StackedAreaChart$PartOf.CURRENT, true, false);
        arrayList.add(stackedAreaChart$DataPointInfo);
    }

    private void addPoint(ArrayList<StackedAreaChart$DataPointInfo<X, Y>> arrayList, XYChart$Data<X, Y> xYChart$Data, X x2, Y y2, double d2, double d3, StackedAreaChart$PartOf stackedAreaChart$PartOf, boolean bl2, boolean bl3) {
        StackedAreaChart$DataPointInfo<X, Y> stackedAreaChart$DataPointInfo = new StackedAreaChart$DataPointInfo<X, Y>();
        stackedAreaChart$DataPointInfo.setValues(xYChart$Data, x2, y2, d2, d3, stackedAreaChart$PartOf, bl2, bl3);
        arrayList.add(stackedAreaChart$DataPointInfo);
    }

    @Override
    void seriesBeingRemovedIsAdded(XYChart$Series<X, Y> xYChart$Series) {
        if (this.timeline != null) {
            this.timeline.setOnFinished(null);
            ((Animation)this.timeline).stop();
            this.timeline = null;
            this.getPlotChildren().remove(xYChart$Series.getNode());
            for (XYChart$Data xYChart$Data : xYChart$Series.getData()) {
                this.getPlotChildren().remove(xYChart$Data.getNode());
            }
            this.removeSeriesFromDisplay(xYChart$Series);
        }
    }

    private int findNextCurrent(ArrayList<StackedAreaChart$DataPointInfo<X, Y>> arrayList, int n2) {
        ++n2;
        while (n2 < arrayList.size()) {
            if (arrayList.get((int)n2).partOf.equals((Object)StackedAreaChart$PartOf.CURRENT)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private int findPreviousCurrent(ArrayList<StackedAreaChart$DataPointInfo<X, Y>> arrayList, int n2) {
        --n2;
        while (n2 >= 0) {
            if (arrayList.get((int)n2).partOf.equals((Object)StackedAreaChart$PartOf.CURRENT)) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    private int findPreviousPrevious(ArrayList<StackedAreaChart$DataPointInfo<X, Y>> arrayList, int n2) {
        --n2;
        while (n2 >= 0) {
            if (arrayList.get((int)n2).partOf.equals((Object)StackedAreaChart$PartOf.PREVIOUS)) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    private int findNextPrevious(ArrayList<StackedAreaChart$DataPointInfo<X, Y>> arrayList, int n2) {
        ++n2;
        while (n2 < arrayList.size()) {
            if (arrayList.get((int)n2).partOf.equals((Object)StackedAreaChart$PartOf.PREVIOUS)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private void sortAggregateList(ArrayList<StackedAreaChart$DataPointInfo<X, Y>> arrayList) {
        Collections.sort(arrayList, (object, object2) -> {
            double d2;
            object = ((StackedAreaChart$DataPointInfo)object).dataItem;
            object2 = ((StackedAreaChart$DataPointInfo)object2).dataItem;
            double d3 = this.getXAxis().toNumericValue(((XYChart$Data)object).getXValue());
            if (d3 < (d2 = this.getXAxis().toNumericValue(((XYChart$Data)object2).getXValue()))) {
                return -1;
            }
            if (d3 == d2) {
                return 0;
            }
            return 1;
        });
    }

    private double interpolate(double d2, double d3, double d4, double d5, double d6) {
        return (d5 - d3) / (d4 - d2) * (d6 - d2) + d3;
    }

    private Node createSymbol(XYChart$Series<X, Y> xYChart$Series, int n2, XYChart$Data<X, Y> xYChart$Data, int n3) {
        Node node = xYChart$Data.getNode();
        if (node == null && this.getCreateSymbols()) {
            node = new StackPane();
            node.setAccessibleRole(AccessibleRole.TEXT);
            node.setAccessibleRoleDescription("Point");
            node.focusTraversableProperty().bind(Platform.accessibilityActiveProperty());
            xYChart$Data.setNode(node);
        }
        if (node != null) {
            node.getStyleClass().setAll((String[])new String[]{"chart-area-symbol", "series" + n2, "data" + n3, xYChart$Series.defaultColorStyleClass});
        }
        return node;
    }

    @Override
    Legend$LegendItem createLegendItemForSeries(XYChart$Series<X, Y> xYChart$Series, int n2) {
        Legend$LegendItem legend$LegendItem = new Legend$LegendItem(xYChart$Series.getName());
        legend$LegendItem.getSymbol().getStyleClass().addAll((String[])new String[]{"chart-area-symbol", "series" + n2, "area-legend-symbol", xYChart$Series.defaultColorStyleClass});
        return legend$LegendItem;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StackedAreaChart$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return StackedAreaChart.getClassCssMetaData();
    }
}

