/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import java.lang.ref.WeakReference;
import javafx.beans.InvalidationListener;
import javafx.beans.NamedArg;
import javafx.beans.property.ObjectProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.Alert$1;
import javafx.scene.control.Alert$AlertType;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;

public class Alert
extends Dialog<ButtonType> {
    private WeakReference<DialogPane> dialogPaneRef;
    private boolean installingDefaults = false;
    private boolean hasCustomButtons = false;
    private boolean hasCustomTitle = false;
    private boolean hasCustomHeaderText = false;
    private final InvalidationListener headerTextListener = observable -> {
        if (!this.installingDefaults) {
            this.hasCustomHeaderText = true;
        }
    };
    private final InvalidationListener titleListener = observable -> {
        if (!this.installingDefaults) {
            this.hasCustomTitle = true;
        }
    };
    private final ListChangeListener<ButtonType> buttonsListener = listChangeListener$Change -> {
        if (!this.installingDefaults) {
            this.hasCustomButtons = true;
        }
    };
    private final ObjectProperty<Alert$AlertType> alertType = new Alert$1(this, null);

    public Alert(@NamedArg(value="alertType") Alert$AlertType alert$AlertType) {
        this(alert$AlertType, "", new ButtonType[0]);
    }

    public Alert(@NamedArg(value="alertType") Alert$AlertType alert$AlertType, @NamedArg(value="contentText") String buttonTypeArray, ButtonType ... buttonTypeArray2) {
        DialogPane dialogPane = this.getDialogPane();
        dialogPane.setContentText((String)buttonTypeArray);
        this.getDialogPane().getStyleClass().add("alert");
        this.dialogPaneRef = new WeakReference<DialogPane>(dialogPane);
        boolean bl2 = this.hasCustomButtons = buttonTypeArray2 != null && buttonTypeArray2.length > 0;
        if (this.hasCustomButtons) {
            buttonTypeArray = buttonTypeArray2;
            int n2 = buttonTypeArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                ButtonType buttonType = buttonTypeArray[i2];
                dialogPane.getButtonTypes().addAll((ButtonType[])new ButtonType[]{buttonType});
            }
        }
        this.setAlertType(alert$AlertType);
        this.dialogPaneProperty().addListener(observable -> this.updateListeners());
        this.titleProperty().addListener(this.titleListener);
        this.updateListeners();
    }

    public final Alert$AlertType getAlertType() {
        return (Alert$AlertType)((Object)this.alertType.get());
    }

    public final void setAlertType(Alert$AlertType alert$AlertType) {
        this.alertType.setValue(alert$AlertType);
    }

    public final ObjectProperty<Alert$AlertType> alertTypeProperty() {
        return this.alertType;
    }

    public final ObservableList<ButtonType> getButtonTypes() {
        return this.getDialogPane().getButtonTypes();
    }

    private void updateListeners() {
        DialogPane dialogPane = (DialogPane)this.dialogPaneRef.get();
        if (dialogPane != null) {
            dialogPane.headerTextProperty().removeListener(this.headerTextListener);
            dialogPane.getButtonTypes().removeListener(this.buttonsListener);
        }
        if ((dialogPane = this.getDialogPane()) != null) {
            dialogPane.headerTextProperty().addListener(this.headerTextListener);
            dialogPane.getButtonTypes().addListener(this.buttonsListener);
        }
        this.dialogPaneRef = new WeakReference<DialogPane>(dialogPane);
    }
}

