/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.PseudoClass;
import javafx.css.StyleableProperty;
import javafx.scene.control.Cell$1;
import javafx.scene.control.Cell$2;
import javafx.scene.control.Cell$3;
import javafx.scene.control.Labeled;

public class Cell<T>
extends Labeled {
    private ObjectProperty<T> item = new SimpleObjectProperty(this, "item");
    private ReadOnlyBooleanWrapper empty = new Cell$2(this, true);
    private ReadOnlyBooleanWrapper selected = new Cell$3(this);
    private ReadOnlyBooleanWrapper editing;
    private BooleanProperty editable;
    private boolean itemDirty = false;
    private static final String DEFAULT_STYLE_CLASS = "cell";
    private static final PseudoClass PSEUDO_CLASS_SELECTED = PseudoClass.getPseudoClass("selected");
    private static final PseudoClass PSEUDO_CLASS_FOCUSED = PseudoClass.getPseudoClass("focused");
    private static final PseudoClass PSEUDO_CLASS_EMPTY = PseudoClass.getPseudoClass("empty");
    private static final PseudoClass PSEUDO_CLASS_FILLED = PseudoClass.getPseudoClass("filled");

    public Cell() {
        this.setText(null);
        ((StyleableProperty)((Object)this.focusTraversableProperty())).applyStyle(null, Boolean.FALSE);
        this.getStyleClass().addAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        super.focusedProperty().addListener(new Cell$1(this));
        this.pseudoClassStateChanged(PSEUDO_CLASS_EMPTY, true);
    }

    public final ObjectProperty<T> itemProperty() {
        return this.item;
    }

    public final void setItem(T t2) {
        this.item.set(t2);
    }

    public final T getItem() {
        return this.item.get();
    }

    public final ReadOnlyBooleanProperty emptyProperty() {
        return this.empty.getReadOnlyProperty();
    }

    private void setEmpty(boolean bl2) {
        this.empty.set(bl2);
    }

    public final boolean isEmpty() {
        return this.empty.get();
    }

    public final ReadOnlyBooleanProperty selectedProperty() {
        return this.selected.getReadOnlyProperty();
    }

    void setSelected(boolean bl2) {
        this.selected.set(bl2);
    }

    public final boolean isSelected() {
        return this.selected.get();
    }

    private void setEditing(boolean bl2) {
        this.editingPropertyImpl().set(bl2);
    }

    public final boolean isEditing() {
        if (this.editing == null) {
            return false;
        }
        return this.editing.get();
    }

    public final ReadOnlyBooleanProperty editingProperty() {
        return this.editingPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyBooleanWrapper editingPropertyImpl() {
        if (this.editing == null) {
            this.editing = new ReadOnlyBooleanWrapper(this, "editing");
        }
        return this.editing;
    }

    public final void setEditable(boolean bl2) {
        this.editableProperty().set(bl2);
    }

    public final boolean isEditable() {
        if (this.editable == null) {
            return true;
        }
        return this.editable.get();
    }

    public final BooleanProperty editableProperty() {
        if (this.editable == null) {
            this.editable = new SimpleBooleanProperty(this, "editable", true);
        }
        return this.editable;
    }

    public void startEdit() {
        if (this.isEditable() && !this.isEditing() && !this.isEmpty()) {
            this.setEditing(true);
        }
    }

    public void cancelEdit() {
        if (this.isEditing()) {
            this.setEditing(false);
        }
    }

    public void commitEdit(T t2) {
        if (this.isEditing()) {
            this.setEditing(false);
        }
    }

    @Override
    protected void layoutChildren() {
        if (this.itemDirty) {
            Cell cell = this;
            cell.updateItem(cell.getItem(), this.isEmpty());
            this.itemDirty = false;
        }
        super.layoutChildren();
    }

    protected void updateItem(T t2, boolean bl2) {
        this.setItem(t2);
        this.setEmpty(bl2);
        if (bl2 && this.isSelected()) {
            this.updateSelected(false);
        }
    }

    public void updateSelected(boolean bl2) {
        if (bl2 && this.isEmpty()) {
            return;
        }
        boolean bl3 = this.isSelected();
        this.setSelected(bl2);
        if (bl3 != bl2) {
            this.markCellDirty();
        }
    }

    protected boolean isItemChanged(T t2, T t3) {
        if (t2 != null) {
            return !t2.equals(t3);
        }
        return t3 != null;
    }

    private final void markCellDirty() {
        this.itemDirty = true;
        this.requestLayout();
    }

    @Override
    protected Boolean getInitialFocusTraversable() {
        return Boolean.FALSE;
    }
}

