/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.geometry.Pos;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckBox$1;
import javafx.scene.control.CheckBox$2;
import javafx.scene.control.Skin;
import javafx.scene.control.skin.CheckBoxSkin;

public class CheckBox
extends ButtonBase {
    private BooleanProperty indeterminate;
    private BooleanProperty selected;
    private BooleanProperty allowIndeterminate;
    private static final String DEFAULT_STYLE_CLASS = "check-box";
    private static final PseudoClass PSEUDO_CLASS_DETERMINATE = PseudoClass.getPseudoClass("determinate");
    private static final PseudoClass PSEUDO_CLASS_INDETERMINATE = PseudoClass.getPseudoClass("indeterminate");
    private static final PseudoClass PSEUDO_CLASS_SELECTED = PseudoClass.getPseudoClass("selected");

    public CheckBox() {
        this.initialize();
    }

    public CheckBox(String string) {
        this.setText(string);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setAccessibleRole(AccessibleRole.CHECK_BOX);
        this.setAlignment(Pos.CENTER_LEFT);
        this.setMnemonicParsing(true);
        this.pseudoClassStateChanged(PSEUDO_CLASS_DETERMINATE, true);
    }

    public final void setIndeterminate(boolean bl2) {
        this.indeterminateProperty().set(bl2);
    }

    public final boolean isIndeterminate() {
        if (this.indeterminate == null) {
            return false;
        }
        return this.indeterminate.get();
    }

    public final BooleanProperty indeterminateProperty() {
        if (this.indeterminate == null) {
            this.indeterminate = new CheckBox$1(this, false);
        }
        return this.indeterminate;
    }

    public final void setSelected(boolean bl2) {
        this.selectedProperty().set(bl2);
    }

    public final boolean isSelected() {
        if (this.selected == null) {
            return false;
        }
        return this.selected.get();
    }

    public final BooleanProperty selectedProperty() {
        if (this.selected == null) {
            this.selected = new CheckBox$2(this);
        }
        return this.selected;
    }

    public final void setAllowIndeterminate(boolean bl2) {
        this.allowIndeterminateProperty().set(bl2);
    }

    public final boolean isAllowIndeterminate() {
        if (this.allowIndeterminate == null) {
            return false;
        }
        return this.allowIndeterminate.get();
    }

    public final BooleanProperty allowIndeterminateProperty() {
        if (this.allowIndeterminate == null) {
            this.allowIndeterminate = new SimpleBooleanProperty(this, "allowIndeterminate");
        }
        return this.allowIndeterminate;
    }

    @Override
    public void fire() {
        block0: {
            block3: {
                boolean bl2;
                CheckBox checkBox;
                block5: {
                    block1: {
                        block4: {
                            block2: {
                                if (this.isDisabled()) break block0;
                                if (!this.isAllowIndeterminate()) break block1;
                                if (this.isSelected() || this.isIndeterminate()) break block2;
                                this.setIndeterminate(true);
                                break block3;
                            }
                            if (!this.isSelected() || this.isIndeterminate()) break block4;
                            this.setSelected(false);
                            break block3;
                        }
                        if (!this.isIndeterminate()) break block3;
                        checkBox = this;
                        bl2 = true;
                        break block5;
                    }
                    CheckBox checkBox2 = this;
                    checkBox = checkBox2;
                    bl2 = !checkBox2.isSelected();
                }
                checkBox.setSelected(bl2);
                this.setIndeterminate(false);
            }
            this.fireEvent(new ActionEvent());
        }
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new CheckBoxSkin(this);
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objectArray) {
        switch (accessibleAttribute) {
            case SELECTED: {
                return this.isSelected();
            }
            case INDETERMINATE: {
                return this.isIndeterminate();
            }
        }
        return super.queryAccessibleAttribute(accessibleAttribute, objectArray);
    }
}

