/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.event.Event;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.CheckBoxTreeItem$1;
import javafx.scene.control.CheckBoxTreeItem$2;
import javafx.scene.control.CheckBoxTreeItem$TreeModificationEvent;
import javafx.scene.control.TreeItem;

public class CheckBoxTreeItem<T>
extends TreeItem<T> {
    private static final EventType<? extends Event> CHECK_BOX_SELECTION_CHANGED_EVENT = new EventType<Event>(CheckBoxTreeItem$TreeModificationEvent.ANY, "checkBoxSelectionChangedEvent");
    private final ChangeListener<Boolean> stateChangeListener = (observableValue, bl2, bl3) -> this.updateState();
    private final BooleanProperty selected;
    private final BooleanProperty indeterminate;
    private final BooleanProperty independent;
    private static boolean updateLock = false;

    public static <T> EventType<CheckBoxTreeItem$TreeModificationEvent<T>> checkBoxSelectionChangedEvent() {
        return CHECK_BOX_SELECTION_CHANGED_EVENT;
    }

    public CheckBoxTreeItem() {
        this(null);
    }

    public CheckBoxTreeItem(T t2) {
        this(t2, null, false);
    }

    public CheckBoxTreeItem(T t2, Node node) {
        this(t2, node, false);
    }

    public CheckBoxTreeItem(T t2, Node node, boolean bl2) {
        this(t2, node, bl2, false);
    }

    public CheckBoxTreeItem(T t2, Node node, boolean bl4, boolean bl5) {
        super(t2, node);
        CheckBoxTreeItem checkBoxTreeItem = this;
        this.selected = new CheckBoxTreeItem$1(checkBoxTreeItem, checkBoxTreeItem, "selected", false);
        CheckBoxTreeItem checkBoxTreeItem2 = this;
        this.indeterminate = new CheckBoxTreeItem$2(checkBoxTreeItem2, checkBoxTreeItem2, "indeterminate", false);
        this.independent = new SimpleBooleanProperty(this, "independent", false);
        this.setSelected(bl4);
        this.setIndependent(bl5);
        this.selectedProperty().addListener(this.stateChangeListener);
        this.indeterminateProperty().addListener(this.stateChangeListener);
    }

    public final void setSelected(boolean bl2) {
        this.selectedProperty().setValue(bl2);
    }

    public final boolean isSelected() {
        return this.selected.getValue();
    }

    public final BooleanProperty selectedProperty() {
        return this.selected;
    }

    public final void setIndeterminate(boolean bl2) {
        this.indeterminateProperty().setValue(bl2);
    }

    public final boolean isIndeterminate() {
        return this.indeterminate.getValue();
    }

    public final BooleanProperty indeterminateProperty() {
        return this.indeterminate;
    }

    public final BooleanProperty independentProperty() {
        return this.independent;
    }

    public final void setIndependent(boolean bl2) {
        this.independentProperty().setValue(bl2);
    }

    public final boolean isIndependent() {
        return this.independent.getValue();
    }

    private void updateState() {
        if (this.isIndependent()) {
            return;
        }
        boolean bl2 = !updateLock;
        updateLock = true;
        this.updateUpwards();
        if (bl2) {
            updateLock = false;
        }
        if (updateLock) {
            return;
        }
        this.updateDownwards();
    }

    private void updateUpwards() {
        if (!(this.getParent() instanceof CheckBoxTreeItem)) {
            return;
        }
        CheckBoxTreeItem checkBoxTreeItem = (CheckBoxTreeItem)this.getParent();
        int n2 = 0;
        int n3 = 0;
        for (TreeItem treeItem : checkBoxTreeItem.getChildren()) {
            if (!(treeItem instanceof CheckBoxTreeItem)) continue;
            CheckBoxTreeItem checkBoxTreeItem2 = (CheckBoxTreeItem)treeItem;
            n2 += checkBoxTreeItem2.isSelected() && !checkBoxTreeItem2.isIndeterminate() ? 1 : 0;
            n3 += checkBoxTreeItem2.isIndeterminate() ? 1 : 0;
        }
        if (n2 == checkBoxTreeItem.getChildren().size()) {
            checkBoxTreeItem.setSelected(true);
            checkBoxTreeItem.setIndeterminate(false);
            return;
        }
        if (n2 == 0 && n3 == 0) {
            checkBoxTreeItem.setSelected(false);
            checkBoxTreeItem.setIndeterminate(false);
            return;
        }
        checkBoxTreeItem.setIndeterminate(true);
    }

    private void updateDownwards() {
        if (!this.isLeaf()) {
            for (TreeItem treeItem : this.getChildren()) {
                if (!(treeItem instanceof CheckBoxTreeItem)) continue;
                CheckBoxTreeItem checkBoxTreeItem = (CheckBoxTreeItem)treeItem;
                checkBoxTreeItem.setSelected(this.isSelected());
            }
        }
    }

    private void fireEvent(CheckBoxTreeItem<T> object, boolean bl2) {
        object = new CheckBoxTreeItem$TreeModificationEvent<T>((EventType<Event>)CHECK_BOX_SELECTION_CHANGED_EVENT, object, bl2);
        Event.fireEvent(this, (Event)object);
    }
}

