/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.Separator;
import javafx.scene.control.SingleSelectionModel;

class ChoiceBox$ChoiceBoxSelectionModel<T>
extends SingleSelectionModel<T> {
    private final ChoiceBox<T> choiceBox;
    private ChangeListener<ObservableList<T>> itemsObserver;
    private ListChangeListener<T> itemsContentObserver;
    private WeakListChangeListener<T> weakItemsContentObserver;

    public ChoiceBox$ChoiceBoxSelectionModel(ChoiceBox<T> choiceBox) {
        if (choiceBox == null) {
            throw new NullPointerException("ChoiceBox can not be null");
        }
        this.choiceBox = choiceBox;
        this.itemsContentObserver = listChangeListener$Change -> {
            int n2;
            if (this.choiceBox.getItems() == null || this.choiceBox.getItems().isEmpty()) {
                this.setSelectedIndex(-1);
                return;
            }
            if (this.getSelectedIndex() == -1 && this.getSelectedItem() != null && (n2 = this.choiceBox.getItems().indexOf(this.getSelectedItem())) != -1) {
                this.setSelectedIndex(n2);
            }
        };
        this.weakItemsContentObserver = new WeakListChangeListener<T>(this.itemsContentObserver);
        if (this.choiceBox.getItems() != null) {
            this.choiceBox.getItems().addListener(this.weakItemsContentObserver);
        }
        this.itemsObserver = (observableValue, observableList, observableList2) -> {
            int n2;
            if (observableList != null) {
                observableList.removeListener(this.weakItemsContentObserver);
            }
            if (observableList2 != null) {
                observableList2.addListener(this.weakItemsContentObserver);
            }
            this.setSelectedIndex(-1);
            if (this.getSelectedItem() != null && (n2 = this.choiceBox.getItems().indexOf(this.getSelectedItem())) != -1) {
                this.setSelectedIndex(n2);
            }
        };
        this.choiceBox.itemsProperty().addListener(new WeakChangeListener<ObservableList<T>>(this.itemsObserver));
    }

    @Override
    protected T getModelItem(int n2) {
        ObservableList<T> observableList = this.choiceBox.getItems();
        if (observableList == null) {
            return null;
        }
        if (n2 < 0 || n2 >= observableList.size()) {
            return null;
        }
        return (T)observableList.get(n2);
    }

    @Override
    protected int getItemCount() {
        ObservableList<T> observableList = this.choiceBox.getItems();
        if (observableList == null) {
            return 0;
        }
        return observableList.size();
    }

    @Override
    public void select(int n2) {
        super.select(n2);
        if (this.choiceBox.isShowing()) {
            this.choiceBox.hide();
        }
    }

    @Override
    public void select(T t2) {
        super.select(t2);
        if (t2 != null && !this.choiceBox.getItems().contains(t2)) {
            this.setSelectedIndex(-1);
        }
    }

    @Override
    public void selectPrevious() {
        for (int i2 = this.getSelectedIndex() - 1; i2 >= 0; --i2) {
            T t2 = this.getModelItem(i2);
            if (t2 instanceof Separator) {
                continue;
            }
            ((SelectionModel)this).select(i2);
            return;
        }
    }

    @Override
    public void selectNext() {
        for (int i2 = this.getSelectedIndex() + 1; i2 < this.getItemCount(); ++i2) {
            T t2 = this.getModelItem(i2);
            if (t2 instanceof Separator) {
                continue;
            }
            ((SelectionModel)this).select(i2);
            return;
        }
    }
}

