/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.control.ComboBoxBase$1;
import javafx.scene.control.ComboBoxBase$2;
import javafx.scene.control.ComboBoxBase$3;
import javafx.scene.control.ComboBoxBase$4;
import javafx.scene.control.ComboBoxBase$5;
import javafx.scene.control.ComboBoxBase$6;
import javafx.scene.control.ComboBoxBase$7;
import javafx.scene.control.ComboBoxBase$8;
import javafx.scene.control.ComboBoxBase$9;
import javafx.scene.control.Control;

public abstract class ComboBoxBase<T>
extends Control {
    public static final EventType<Event> ON_SHOWING = new EventType<Event>(Event.ANY, "COMBO_BOX_BASE_ON_SHOWING");
    public static final EventType<Event> ON_SHOWN = new EventType<Event>(Event.ANY, "COMBO_BOX_BASE_ON_SHOWN");
    public static final EventType<Event> ON_HIDING = new EventType<Event>(Event.ANY, "COMBO_BOX_BASE_ON_HIDING");
    public static final EventType<Event> ON_HIDDEN = new EventType<Event>(Event.ANY, "COMBO_BOX_BASE_ON_HIDDEN");
    private ObjectProperty<T> value = new SimpleObjectProperty(this, "value");
    private BooleanProperty editable;
    private ReadOnlyBooleanWrapper showing;
    private StringProperty promptText;
    private BooleanProperty armed;
    private ObjectProperty<EventHandler<ActionEvent>> onAction;
    private ObjectProperty<EventHandler<Event>> onShowing;
    private ObjectProperty<EventHandler<Event>> onShown;
    private ObjectProperty<EventHandler<Event>> onHiding;
    private ObjectProperty<EventHandler<Event>> onHidden;
    private static final String DEFAULT_STYLE_CLASS = "combo-box-base";
    private static final PseudoClass PSEUDO_CLASS_EDITABLE = PseudoClass.getPseudoClass("editable");
    private static final PseudoClass PSEUDO_CLASS_SHOWING = PseudoClass.getPseudoClass("showing");
    private static final PseudoClass PSEUDO_CLASS_ARMED = PseudoClass.getPseudoClass("armed");

    public ComboBoxBase() {
        ComboBoxBase comboBoxBase = this;
        this.editable = new ComboBoxBase$1(comboBoxBase, comboBoxBase, "editable", false);
        ComboBoxBase comboBoxBase2 = this;
        this.promptText = new ComboBoxBase$3(comboBoxBase2, comboBoxBase2, "promptText", null);
        ComboBoxBase comboBoxBase3 = this;
        this.armed = new ComboBoxBase$4(comboBoxBase3, comboBoxBase3, "armed", false);
        this.onAction = new ComboBoxBase$5(this);
        this.onShowing = new ComboBoxBase$6(this);
        this.onShown = new ComboBoxBase$7(this);
        this.onHiding = new ComboBoxBase$8(this);
        this.onHidden = new ComboBoxBase$9(this);
        this.getStyleClass().add(DEFAULT_STYLE_CLASS);
        this.getProperties().addListener(mapChangeListener$Change -> {
            if (mapChangeListener$Change.wasAdded() && mapChangeListener$Change.getKey() == "FOCUSED") {
                this.setFocused((Boolean)mapChangeListener$Change.getValueAdded());
                this.getProperties().remove("FOCUSED");
            }
        });
    }

    public ObjectProperty<T> valueProperty() {
        return this.value;
    }

    public final void setValue(T t2) {
        this.valueProperty().set(t2);
    }

    public final T getValue() {
        return this.valueProperty().get();
    }

    public BooleanProperty editableProperty() {
        return this.editable;
    }

    public final void setEditable(boolean bl2) {
        this.editableProperty().set(bl2);
    }

    public final boolean isEditable() {
        return this.editableProperty().get();
    }

    public ReadOnlyBooleanProperty showingProperty() {
        return this.showingPropertyImpl().getReadOnlyProperty();
    }

    public final boolean isShowing() {
        return this.showingPropertyImpl().get();
    }

    private void setShowing(boolean bl2) {
        Event.fireEvent(this, bl2 ? new Event(ON_SHOWING) : new Event(ON_HIDING));
        this.showingPropertyImpl().set(bl2);
        Event.fireEvent(this, bl2 ? new Event(ON_SHOWN) : new Event(ON_HIDDEN));
    }

    private ReadOnlyBooleanWrapper showingPropertyImpl() {
        if (this.showing == null) {
            this.showing = new ComboBoxBase$2(this, false);
        }
        return this.showing;
    }

    public final StringProperty promptTextProperty() {
        return this.promptText;
    }

    public final String getPromptText() {
        return (String)this.promptText.get();
    }

    public final void setPromptText(String string) {
        this.promptText.set(string);
    }

    public BooleanProperty armedProperty() {
        return this.armed;
    }

    private final void setArmed(boolean bl2) {
        this.armedProperty().set(bl2);
    }

    public final boolean isArmed() {
        return this.armedProperty().get();
    }

    public final ObjectProperty<EventHandler<ActionEvent>> onActionProperty() {
        return this.onAction;
    }

    public final void setOnAction(EventHandler<ActionEvent> eventHandler) {
        this.onActionProperty().set(eventHandler);
    }

    public final EventHandler<ActionEvent> getOnAction() {
        return (EventHandler)this.onActionProperty().get();
    }

    public final ObjectProperty<EventHandler<Event>> onShowingProperty() {
        return this.onShowing;
    }

    public final void setOnShowing(EventHandler<Event> eventHandler) {
        this.onShowingProperty().set(eventHandler);
    }

    public final EventHandler<Event> getOnShowing() {
        return (EventHandler)this.onShowingProperty().get();
    }

    public final ObjectProperty<EventHandler<Event>> onShownProperty() {
        return this.onShown;
    }

    public final void setOnShown(EventHandler<Event> eventHandler) {
        this.onShownProperty().set(eventHandler);
    }

    public final EventHandler<Event> getOnShown() {
        return (EventHandler)this.onShownProperty().get();
    }

    public final ObjectProperty<EventHandler<Event>> onHidingProperty() {
        return this.onHiding;
    }

    public final void setOnHiding(EventHandler<Event> eventHandler) {
        this.onHidingProperty().set(eventHandler);
    }

    public final EventHandler<Event> getOnHiding() {
        return (EventHandler)this.onHidingProperty().get();
    }

    public final ObjectProperty<EventHandler<Event>> onHiddenProperty() {
        return this.onHidden;
    }

    public final void setOnHidden(EventHandler<Event> eventHandler) {
        this.onHiddenProperty().set(eventHandler);
    }

    public final EventHandler<Event> getOnHidden() {
        return (EventHandler)this.onHiddenProperty().get();
    }

    public void show() {
        if (!this.isDisabled()) {
            this.setShowing(true);
        }
    }

    public void hide() {
        if (this.isShowing()) {
            this.setShowing(false);
        }
    }

    public void arm() {
        if (!this.armedProperty().isBound()) {
            this.setArmed(true);
        }
    }

    public void disarm() {
        if (!this.armedProperty().isBound()) {
            this.setArmed(false);
        }
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objectArray) {
        switch (accessibleAttribute) {
            case EXPANDED: {
                return this.isShowing();
            }
            case EDITABLE: {
                return this.isEditable();
            }
        }
        return super.queryAccessibleAttribute(accessibleAttribute, objectArray);
    }

    @Override
    public void executeAccessibleAction(AccessibleAction accessibleAction, Object ... objectArray) {
        switch (accessibleAction) {
            case EXPAND: {
                this.show();
                return;
            }
            case COLLAPSE: {
                this.hide();
                return;
            }
        }
        super.executeAccessibleAction(accessibleAction, new Object[0]);
    }

    static /* synthetic */ void access$000(ComboBoxBase comboBoxBase, EventType eventType, EventHandler eventHandler) {
        comboBoxBase.setEventHandler(eventType, eventHandler);
    }

    static /* synthetic */ void access$100(ComboBoxBase comboBoxBase, EventType eventType, EventHandler eventHandler) {
        comboBoxBase.setEventHandler(eventType, eventHandler);
    }

    static /* synthetic */ void access$200(ComboBoxBase comboBoxBase, EventType eventType, EventHandler eventHandler) {
        comboBoxBase.setEventHandler(eventType, eventHandler);
    }

    static /* synthetic */ void access$300(ComboBoxBase comboBoxBase, EventType eventType, EventHandler eventHandler) {
        comboBoxBase.setEventHandler(eventType, eventHandler);
    }

    static /* synthetic */ void access$400(ComboBoxBase comboBoxBase, EventType eventType, EventHandler eventHandler) {
        comboBoxBase.setEventHandler(eventType, eventHandler);
    }
}

