/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.scene.control.ReadOnlyUnbackedObservableList;
import com.sun.javafx.scene.control.skin.Utils;
import java.util.Comparator;
import java.util.List;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import javafx.collections.ListChangeListener$Change;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Control;
import javafx.scene.control.ControlUtils$1;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.MultipleSelectionModelBase;
import javafx.scene.control.ScrollToEvent;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TablePositionBase;
import javafx.scene.control.TreeItem;

class ControlUtils {
    private ControlUtils() {
    }

    public static void scrollToIndex(Control control, int n2) {
        Utils.executeOnceWhenPropertyIsNonNull(control.skinProperty(), skin -> {
            Control control2 = control;
            Event.fireEvent(control, new ScrollToEvent<Integer>(control2, control2, ScrollToEvent.scrollToTopIndex(), n2));
        });
    }

    public static void scrollToColumn(Control control, TableColumnBase<?, ?> tableColumnBase) {
        Utils.executeOnceWhenPropertyIsNonNull(control.skinProperty(), skin -> {
            Control control2 = control;
            control.fireEvent(new ScrollToEvent<TableColumnBase>(control2, control2, ScrollToEvent.scrollToColumn(), tableColumnBase));
        });
    }

    static void requestFocusOnControlOnlyIfCurrentFocusOwnerIsChild(Control control) {
        EventTarget eventTarget = control.getScene();
        eventTarget = eventTarget == null ? null : ((Scene)eventTarget).getFocusOwner();
        if (eventTarget == null) {
            control.requestFocus();
            return;
        }
        if (!control.equals(eventTarget)) {
            for (eventTarget = ((Node)eventTarget).getParent(); eventTarget != null; eventTarget = ((Node)eventTarget).getParent()) {
                if (!control.equals(eventTarget)) continue;
                control.requestFocus();
                return;
            }
        }
    }

    static <T> ListChangeListener$Change<T> buildClearAndSelectChange(ObservableList<T> observableList, List<T> list, T t2, Comparator<T> comparator) {
        return new ControlUtils$1(observableList, list, t2, comparator);
    }

    public static <S> void updateSelectedIndices(MultipleSelectionModelBase<S> multipleSelectionModelBase, boolean bl2, ListChangeListener$Change<? extends TablePositionBase<?>> listChangeListener$Change, IntPredicate intPredicate) {
        ((ReadOnlyUnbackedObservableList)multipleSelectionModelBase.selectedIndices)._beginChange();
        while (listChangeListener$Change.next()) {
            int n2;
            multipleSelectionModelBase.startAtomic();
            List list = listChangeListener$Change.getRemoved().stream().mapToInt(TablePositionBase::getRow).distinct().filter(intPredicate).boxed().peek(multipleSelectionModelBase.selectedIndices::clear).collect(Collectors.toList());
            int n3 = (int)listChangeListener$Change.getAddedSubList().stream().mapToInt(TablePositionBase::getRow).distinct().peek(multipleSelectionModelBase.selectedIndices::set).count();
            multipleSelectionModelBase.stopAtomic();
            int n4 = listChangeListener$Change.getFrom();
            if (bl2 && n4 > 0 && n4 < listChangeListener$Change.getList().size()) {
                n2 = ((TablePositionBase)listChangeListener$Change.getList().get(n4)).getRow();
                n4 = ((ReadOnlyUnbackedObservableList)multipleSelectionModelBase.selectedIndices).indexOf(n2);
            }
            n2 = n4 + n3;
            if (listChangeListener$Change.wasReplaced()) {
                ((ReadOnlyUnbackedObservableList)multipleSelectionModelBase.selectedIndices)._nextReplace(n4, n2, list);
                continue;
            }
            if (listChangeListener$Change.wasRemoved()) {
                ((ReadOnlyUnbackedObservableList)multipleSelectionModelBase.selectedIndices)._nextRemove(n4, list);
                continue;
            }
            if (!listChangeListener$Change.wasAdded()) continue;
            ((ReadOnlyUnbackedObservableList)multipleSelectionModelBase.selectedIndices)._nextAdd(n4, n2);
        }
        listChangeListener$Change.reset();
        multipleSelectionModelBase.selectedIndices.reset();
        if (multipleSelectionModelBase.isAtomic()) {
            return;
        }
        if (((MultipleSelectionModel)multipleSelectionModelBase).getSelectedItems().isEmpty() && multipleSelectionModelBase.getSelectedItem() != null) {
            multipleSelectionModelBase.setSelectedItem(null);
        }
        ((ReadOnlyUnbackedObservableList)multipleSelectionModelBase.selectedIndices)._endChange();
    }

    public static <S> int getIndexOfChildWithDescendant(TreeItem<S> treeItem, TreeItem<S> treeItem2) {
        if (treeItem2 == null || treeItem == null) {
            return -1;
        }
        TreeItem<S> treeItem3 = treeItem2;
        treeItem2 = treeItem2.getParent();
        while (treeItem2 != null) {
            if (treeItem2 == treeItem) {
                return treeItem.getChildren().indexOf(treeItem3);
            }
            treeItem3 = treeItem2;
            treeItem2 = treeItem3.getParent();
        }
        return -1;
    }

    public static <S> boolean isTreeItemIncludingAncestorsExpanded(TreeItem<S> treeItem) {
        if (treeItem == null || !treeItem.isExpanded()) {
            return false;
        }
        for (treeItem = treeItem.getParent(); treeItem != null; treeItem = treeItem.getParent()) {
            if (treeItem.isExpanded()) continue;
            return false;
        }
        return true;
    }
}

