/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.event.EventHandlerManager;
import com.sun.javafx.tk.Toolkit;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar$ButtonData;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog$1;
import javafx.scene.control.Dialog$2;
import javafx.scene.control.Dialog$3;
import javafx.scene.control.Dialog$4;
import javafx.scene.control.Dialog$5;
import javafx.scene.control.Dialog$6;
import javafx.scene.control.Dialog$7;
import javafx.scene.control.DialogEvent;
import javafx.scene.control.DialogPane;
import javafx.scene.control.FXDialog;
import javafx.scene.control.HeavyweightDialog;
import javafx.stage.Modality;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Callback;

public class Dialog<R>
implements EventTarget {
    final FXDialog dialog = new HeavyweightDialog(this);
    private boolean isClosing;
    private ObjectProperty<DialogPane> dialogPane;
    private final ObjectProperty<R> resultProperty;
    private final ObjectProperty<Callback<ButtonType, R>> resultConverterProperty;
    private final EventHandlerManager eventHandlerManager;
    private ObjectProperty<EventHandler<DialogEvent>> onShowing;
    private ObjectProperty<EventHandler<DialogEvent>> onShown;
    private ObjectProperty<EventHandler<DialogEvent>> onHiding;
    private ObjectProperty<EventHandler<DialogEvent>> onHidden;
    private ObjectProperty<EventHandler<DialogEvent>> onCloseRequest;
    private static final PseudoClass HEADER_PSEUDO_CLASS = PseudoClass.getPseudoClass("header");
    private static final PseudoClass NO_HEADER_PSEUDO_CLASS = PseudoClass.getPseudoClass("no-header");

    public Dialog() {
        Dialog dialog = this;
        this.dialogPane = new Dialog$1(dialog, dialog, "dialogPane", new DialogPane());
        this.resultProperty = new Dialog$2(this);
        this.resultConverterProperty = new SimpleObjectProperty<Callback<ButtonType, R>>(this, "resultConverter");
        this.eventHandlerManager = new EventHandlerManager(this);
        this.setDialogPane(new DialogPane());
        this.initModality(Modality.APPLICATION_MODAL);
    }

    public final void show() {
        Toolkit.getToolkit().checkFxUserThread();
        Event.fireEvent(this, new DialogEvent(this, DialogEvent.DIALOG_SHOWING));
        if (Double.isNaN(this.getWidth()) && Double.isNaN(this.getHeight())) {
            this.dialog.sizeToScene();
        }
        this.dialog.show();
        Event.fireEvent(this, new DialogEvent(this, DialogEvent.DIALOG_SHOWN));
    }

    public final Optional<R> showAndWait() {
        Toolkit.getToolkit().checkFxUserThread();
        if (!Toolkit.getToolkit().canStartNestedEventLoop()) {
            throw new IllegalStateException("showAndWait is not allowed during animation or layout processing");
        }
        Event.fireEvent(this, new DialogEvent(this, DialogEvent.DIALOG_SHOWING));
        if (Double.isNaN(this.getWidth()) && Double.isNaN(this.getHeight())) {
            this.dialog.sizeToScene();
        }
        Event.fireEvent(this, new DialogEvent(this, DialogEvent.DIALOG_SHOWN));
        this.dialog.showAndWait();
        return Optional.ofNullable(this.getResult());
    }

    public final void close() {
        if (this.isClosing) {
            return;
        }
        this.isClosing = true;
        Object object = this.getResult();
        if (object == null && !this.dialog.requestPermissionToClose(this)) {
            this.isClosing = false;
            return;
        }
        if (object == null) {
            object = null;
            for (ButtonType buttonType : this.getDialogPane().getButtonTypes()) {
                ButtonBar$ButtonData buttonBar$ButtonData = buttonType.getButtonData();
                if (buttonBar$ButtonData == null) continue;
                if (buttonBar$ButtonData == ButtonBar$ButtonData.CANCEL_CLOSE) {
                    object = buttonType;
                    break;
                }
                if (!buttonBar$ButtonData.isCancelButton()) continue;
                object = buttonType;
            }
            this.setResultAndClose((ButtonType)object, false);
        }
        Event.fireEvent(this, new DialogEvent(this, DialogEvent.DIALOG_HIDING));
        object = new DialogEvent(this, DialogEvent.DIALOG_CLOSE_REQUEST);
        Event.fireEvent(this, object);
        if (((Event)object).isConsumed()) {
            this.isClosing = false;
            return;
        }
        this.dialog.close();
        Event.fireEvent(this, new DialogEvent(this, DialogEvent.DIALOG_HIDDEN));
        this.isClosing = false;
    }

    public final void hide() {
        this.close();
    }

    public final void initModality(Modality modality) {
        this.dialog.initModality(modality);
    }

    public final Modality getModality() {
        return this.dialog.getModality();
    }

    public final void initStyle(StageStyle stageStyle) {
        this.dialog.initStyle(stageStyle);
    }

    public final void initOwner(Window window) {
        this.dialog.initOwner(window);
    }

    public final Window getOwner() {
        return this.dialog.getOwner();
    }

    public final ObjectProperty<DialogPane> dialogPaneProperty() {
        return this.dialogPane;
    }

    public final DialogPane getDialogPane() {
        return (DialogPane)this.dialogPane.get();
    }

    public final void setDialogPane(DialogPane dialogPane) {
        this.dialogPane.set(dialogPane);
    }

    public final StringProperty contentTextProperty() {
        return this.getDialogPane().contentTextProperty();
    }

    public final String getContentText() {
        return this.getDialogPane().getContentText();
    }

    public final void setContentText(String string) {
        this.getDialogPane().setContentText(string);
    }

    public final StringProperty headerTextProperty() {
        return this.getDialogPane().headerTextProperty();
    }

    public final String getHeaderText() {
        return this.getDialogPane().getHeaderText();
    }

    public final void setHeaderText(String string) {
        this.getDialogPane().setHeaderText(string);
    }

    public final ObjectProperty<Node> graphicProperty() {
        return this.getDialogPane().graphicProperty();
    }

    public final Node getGraphic() {
        return this.getDialogPane().getGraphic();
    }

    public final void setGraphic(Node node) {
        this.getDialogPane().setGraphic(node);
    }

    public final ObjectProperty<R> resultProperty() {
        return this.resultProperty;
    }

    public final R getResult() {
        return (R)this.resultProperty().get();
    }

    public final void setResult(R r2) {
        this.resultProperty().set(r2);
    }

    public final ObjectProperty<Callback<ButtonType, R>> resultConverterProperty() {
        return this.resultConverterProperty;
    }

    public final Callback<ButtonType, R> getResultConverter() {
        return (Callback)this.resultConverterProperty().get();
    }

    public final void setResultConverter(Callback<ButtonType, R> callback) {
        this.resultConverterProperty().set(callback);
    }

    public final ReadOnlyBooleanProperty showingProperty() {
        return this.dialog.showingProperty();
    }

    public final boolean isShowing() {
        return this.showingProperty().get();
    }

    public final BooleanProperty resizableProperty() {
        return this.dialog.resizableProperty();
    }

    public final boolean isResizable() {
        return this.resizableProperty().get();
    }

    public final void setResizable(boolean bl2) {
        this.resizableProperty().set(bl2);
    }

    public final ReadOnlyDoubleProperty widthProperty() {
        return this.dialog.widthProperty();
    }

    public final double getWidth() {
        return this.widthProperty().get();
    }

    public final void setWidth(double d2) {
        this.dialog.setWidth(d2);
    }

    public final ReadOnlyDoubleProperty heightProperty() {
        return this.dialog.heightProperty();
    }

    public final double getHeight() {
        return this.heightProperty().get();
    }

    public final void setHeight(double d2) {
        this.dialog.setHeight(d2);
    }

    public final StringProperty titleProperty() {
        return this.dialog.titleProperty();
    }

    public final String getTitle() {
        return (String)this.dialog.titleProperty().get();
    }

    public final void setTitle(String string) {
        this.dialog.titleProperty().set(string);
    }

    public final double getX() {
        return this.dialog.getX();
    }

    public final void setX(double d2) {
        this.dialog.setX(d2);
    }

    public final ReadOnlyDoubleProperty xProperty() {
        return this.dialog.xProperty();
    }

    public final double getY() {
        return this.dialog.getY();
    }

    public final void setY(double d2) {
        this.dialog.setY(d2);
    }

    public final ReadOnlyDoubleProperty yProperty() {
        return this.dialog.yProperty();
    }

    @Override
    public EventDispatchChain buildEventDispatchChain(EventDispatchChain eventDispatchChain) {
        return eventDispatchChain.prepend(this.eventHandlerManager);
    }

    @Override
    public final <E extends Event> void addEventHandler(EventType<E> eventType, EventHandler<? super E> eventHandler) {
        this.eventHandlerManager.addEventHandler(eventType, eventHandler);
    }

    @Override
    public final <E extends Event> void removeEventHandler(EventType<E> eventType, EventHandler<? super E> eventHandler) {
        this.eventHandlerManager.removeEventHandler(eventType, eventHandler);
    }

    @Override
    public final <E extends Event> void addEventFilter(EventType<E> eventType, EventHandler<? super E> eventHandler) {
        this.eventHandlerManager.addEventFilter(eventType, eventHandler);
    }

    @Override
    public final <E extends Event> void removeEventFilter(EventType<E> eventType, EventHandler<? super E> eventHandler) {
        this.eventHandlerManager.removeEventFilter(eventType, eventHandler);
    }

    public final void setOnShowing(EventHandler<DialogEvent> eventHandler) {
        this.onShowingProperty().set(eventHandler);
    }

    public final EventHandler<DialogEvent> getOnShowing() {
        if (this.onShowing == null) {
            return null;
        }
        return (EventHandler)this.onShowing.get();
    }

    public final ObjectProperty<EventHandler<DialogEvent>> onShowingProperty() {
        if (this.onShowing == null) {
            Dialog dialog = this;
            this.onShowing = new Dialog$3(dialog, dialog, "onShowing");
        }
        return this.onShowing;
    }

    public final void setOnShown(EventHandler<DialogEvent> eventHandler) {
        this.onShownProperty().set(eventHandler);
    }

    public final EventHandler<DialogEvent> getOnShown() {
        if (this.onShown == null) {
            return null;
        }
        return (EventHandler)this.onShown.get();
    }

    public final ObjectProperty<EventHandler<DialogEvent>> onShownProperty() {
        if (this.onShown == null) {
            Dialog dialog = this;
            this.onShown = new Dialog$4(dialog, dialog, "onShown");
        }
        return this.onShown;
    }

    public final void setOnHiding(EventHandler<DialogEvent> eventHandler) {
        this.onHidingProperty().set(eventHandler);
    }

    public final EventHandler<DialogEvent> getOnHiding() {
        if (this.onHiding == null) {
            return null;
        }
        return (EventHandler)this.onHiding.get();
    }

    public final ObjectProperty<EventHandler<DialogEvent>> onHidingProperty() {
        if (this.onHiding == null) {
            Dialog dialog = this;
            this.onHiding = new Dialog$5(dialog, dialog, "onHiding");
        }
        return this.onHiding;
    }

    public final void setOnHidden(EventHandler<DialogEvent> eventHandler) {
        this.onHiddenProperty().set(eventHandler);
    }

    public final EventHandler<DialogEvent> getOnHidden() {
        if (this.onHidden == null) {
            return null;
        }
        return (EventHandler)this.onHidden.get();
    }

    public final ObjectProperty<EventHandler<DialogEvent>> onHiddenProperty() {
        if (this.onHidden == null) {
            Dialog dialog = this;
            this.onHidden = new Dialog$6(dialog, dialog, "onHidden");
        }
        return this.onHidden;
    }

    public final void setOnCloseRequest(EventHandler<DialogEvent> eventHandler) {
        this.onCloseRequestProperty().set(eventHandler);
    }

    public final EventHandler<DialogEvent> getOnCloseRequest() {
        if (this.onCloseRequest != null) {
            return (EventHandler)this.onCloseRequest.get();
        }
        return null;
    }

    public final ObjectProperty<EventHandler<DialogEvent>> onCloseRequestProperty() {
        if (this.onCloseRequest == null) {
            Dialog dialog = this;
            this.onCloseRequest = new Dialog$7(dialog, dialog, "onCloseRequest");
        }
        return this.onCloseRequest;
    }

    void setResultAndClose(ButtonType buttonType, boolean bl2) {
        Callback<ButtonType, R> callback = this.getResultConverter();
        R r2 = this.getResult();
        if (callback != null) {
            buttonType = callback.call(buttonType);
        }
        this.setResult(buttonType);
        if (bl2 && r2 == buttonType) {
            this.close();
        }
    }

    private void updatePseudoClassState() {
        DialogPane dialogPane = this.getDialogPane();
        if (dialogPane != null) {
            boolean bl2 = this.getDialogPane().hasHeader();
            dialogPane.pseudoClassStateChanged(HEADER_PSEUDO_CLASS, bl2);
            dialogPane.pseudoClassStateChanged(NO_HEADER_PSEUDO_CLASS, !bl2);
        }
    }
}

