/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.scene.control.skin.Utils;
import com.sun.javafx.scene.control.skin.resources.ControlResources;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.beans.DefaultProperty;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableStringProperty;
import javafx.event.ActionEvent;
import javafx.geometry.Pos;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonBar$ButtonData;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane$1;
import javafx.scene.control.DialogPane$2;
import javafx.scene.control.DialogPane$3;
import javafx.scene.control.DialogPane$4;
import javafx.scene.control.DialogPane$5;
import javafx.scene.control.DialogPane$6;
import javafx.scene.control.DialogPane$7;
import javafx.scene.control.DialogPane$8;
import javafx.scene.control.DialogPane$StyleableProperties;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;

@DefaultProperty(value="buttonTypes")
public class DialogPane
extends Pane {
    private final GridPane headerTextPanel;
    private final Label contentLabel;
    private final StackPane graphicContainer;
    private final Node buttonBar;
    private final ObservableList<ButtonType> buttons = FXCollections.observableArrayList();
    private final Map<ButtonType, Node> buttonNodes = new WeakHashMap<ButtonType, Node>();
    private Node detailsButton;
    private Dialog<?> dialog;
    private final ObjectProperty<Node> graphicProperty = new DialogPane$1(this);
    private StyleableStringProperty imageUrl = null;
    private final ObjectProperty<Node> header = new DialogPane$3(this, null);
    private final StringProperty headerText;
    private final ObjectProperty<Node> content;
    private final StringProperty contentText;
    private final ObjectProperty<Node> expandableContentProperty;
    private final BooleanProperty expandedProperty;
    private double oldHeight;

    static Label createContentLabel(String object) {
        object = new Label((String)object);
        ((Region)object).setMaxWidth(Double.MAX_VALUE);
        ((Region)object).setMaxHeight(Double.MAX_VALUE);
        ((Node)object).getStyleClass().add("content");
        ((Labeled)object).setWrapText(true);
        ((Region)object).setPrefWidth(360.0);
        return object;
    }

    public DialogPane() {
        DialogPane dialogPane = this;
        this.headerText = new DialogPane$4(dialogPane, dialogPane, "headerText");
        this.content = new DialogPane$5(this, null);
        DialogPane dialogPane2 = this;
        this.contentText = new DialogPane$6(dialogPane2, dialogPane2, "contentText");
        this.expandableContentProperty = new DialogPane$7(this, null);
        DialogPane dialogPane3 = this;
        this.expandedProperty = new DialogPane$8(dialogPane3, dialogPane3, "expanded", false);
        this.oldHeight = -1.0;
        this.getStyleClass().add("dialog-pane");
        this.setAccessibleRole(AccessibleRole.DIALOG);
        this.headerTextPanel = new GridPane();
        this.getChildren().add(this.headerTextPanel);
        this.graphicContainer = new StackPane();
        this.contentLabel = DialogPane.createContentLabel("");
        this.getChildren().add(this.contentLabel);
        this.buttons.addListener(listChangeListener$Change -> {
            while (listChangeListener$Change.next()) {
                if (listChangeListener$Change.wasRemoved()) {
                    for (ButtonType buttonType : listChangeListener$Change.getRemoved()) {
                        this.buttonNodes.remove(buttonType);
                    }
                }
                if (!listChangeListener$Change.wasAdded()) continue;
                for (ButtonType buttonType : listChangeListener$Change.getAddedSubList()) {
                    if (this.buttonNodes.containsKey(buttonType)) continue;
                    this.buttonNodes.put(buttonType, this.createButton(buttonType));
                }
            }
        });
        this.buttonBar = this.createButtonBar();
        if (this.buttonBar != null) {
            this.getChildren().add(this.buttonBar);
        }
    }

    public final ObjectProperty<Node> graphicProperty() {
        return this.graphicProperty;
    }

    public final Node getGraphic() {
        return (Node)this.graphicProperty.get();
    }

    public final void setGraphic(Node node) {
        this.graphicProperty.set(node);
    }

    private StyleableStringProperty imageUrlProperty() {
        if (this.imageUrl == null) {
            this.imageUrl = new DialogPane$2(this);
        }
        return this.imageUrl;
    }

    public final Node getHeader() {
        return (Node)this.header.get();
    }

    public final void setHeader(Node node) {
        this.header.setValue(node);
    }

    public final ObjectProperty<Node> headerProperty() {
        return this.header;
    }

    public final void setHeaderText(String string) {
        this.headerText.set(string);
    }

    public final String getHeaderText() {
        return (String)this.headerText.get();
    }

    public final StringProperty headerTextProperty() {
        return this.headerText;
    }

    public final Node getContent() {
        return (Node)this.content.get();
    }

    public final void setContent(Node node) {
        this.content.setValue(node);
    }

    public final ObjectProperty<Node> contentProperty() {
        return this.content;
    }

    public final void setContentText(String string) {
        this.contentText.set(string);
    }

    public final String getContentText() {
        return (String)this.contentText.get();
    }

    public final StringProperty contentTextProperty() {
        return this.contentText;
    }

    public final ObjectProperty<Node> expandableContentProperty() {
        return this.expandableContentProperty;
    }

    public final Node getExpandableContent() {
        return (Node)this.expandableContentProperty.get();
    }

    public final void setExpandableContent(Node node) {
        this.expandableContentProperty.set(node);
    }

    public final BooleanProperty expandedProperty() {
        return this.expandedProperty;
    }

    public final boolean isExpanded() {
        return this.expandedProperty().get();
    }

    public final void setExpanded(boolean bl2) {
        this.expandedProperty().set(bl2);
    }

    public final ObservableList<ButtonType> getButtonTypes() {
        return this.buttons;
    }

    public final Node lookupButton(ButtonType buttonType) {
        return this.buttonNodes.get(buttonType);
    }

    protected Node createButtonBar() {
        ButtonBar buttonBar = new ButtonBar();
        buttonBar.setMaxWidth(Double.MAX_VALUE);
        this.updateButtons(buttonBar);
        this.getButtonTypes().addListener(listChangeListener$Change -> this.updateButtons(buttonBar));
        this.expandableContentProperty().addListener(observable -> this.updateButtons(buttonBar));
        return buttonBar;
    }

    protected Node createButton(ButtonType buttonType) {
        Button button = new Button(buttonType.getText());
        ButtonBar$ButtonData buttonBar$ButtonData = buttonType.getButtonData();
        ButtonBar.setButtonData(button, buttonBar$ButtonData);
        button.setDefaultButton(buttonBar$ButtonData.isDefaultButton());
        button.setCancelButton(buttonBar$ButtonData.isCancelButton());
        button.addEventHandler(ActionEvent.ACTION, (? super T actionEvent) -> {
            if (actionEvent.isConsumed()) {
                return;
            }
            if (this.dialog != null) {
                this.dialog.setResultAndClose(buttonType, true);
            }
        });
        return button;
    }

    protected Node createDetailsButton() {
        Hyperlink hyperlink = new Hyperlink();
        Object object = ControlResources.getString("Dialog.detail.button.more");
        String string = ControlResources.getString("Dialog.detail.button.less");
        object = arg_0 -> this.lambda$createDetailsButton$4(hyperlink, string, (String)object, arg_0);
        object.invalidated(null);
        this.expandedProperty().addListener((InvalidationListener)object);
        hyperlink.setOnAction(actionEvent -> {
            DialogPane dialogPane = this;
            dialogPane.setExpanded(!dialogPane.isExpanded());
        });
        return hyperlink;
    }

    @Override
    protected void layoutChildren() {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        boolean bl2 = this.hasHeader();
        double d7 = Math.max(((Node)this).minWidth(-1.0), this.getWidth());
        double d8 = ((Node)this).minHeight(d7);
        double d9 = ((Node)this).prefHeight(d7);
        double d10 = ((Node)this).maxHeight(d7);
        double d11 = this.getHeight();
        double d12 = d6 = this.dialog == null ? 0.0 : this.dialog.dialog.getSceneHeight();
        if (d9 > d11 && d9 > d8 && (d9 <= d6 || d6 == 0.0)) {
            d5 = Utils.boundedSize(d9, d8, d10);
        } else {
            boolean bl3 = d11 > this.oldHeight;
            if (bl3) {
                double d13 = d11 < d9 ? Math.min(d9, d11) : Math.max(d9, d6);
                d5 = Utils.boundedSize(d13, d8, d10);
            } else {
                d5 = Utils.boundedSize(Math.min(d11, d6), d8, d10);
            }
        }
        ((Node)this).resize(d7, d5);
        this.oldHeight = d5 -= this.snappedTopInset() + this.snappedBottomInset();
        double d14 = this.snappedLeftInset();
        double d15 = this.snappedTopInset();
        double d16 = this.snappedRightInset();
        Node node = this.getActualHeader();
        Node node2 = this.getActualContent();
        Node node3 = this.getActualGraphic();
        Node node4 = this.getExpandableContent();
        double d17 = bl2 || node3 == null ? 0.0 : node3.prefWidth(-1.0);
        double d18 = bl2 ? node.prefHeight(d7) : 0.0;
        double d19 = this.buttonBar == null ? 0.0 : this.buttonBar.prefHeight(d7);
        double d20 = bl2 || node3 == null ? 0.0 : node3.prefHeight(-1.0);
        double d21 = d7 - d17 - d14 - d16;
        if (this.isExpanded()) {
            d4 = this.isExpanded() ? node2.prefHeight(d21) : 0.0;
            d3 = bl2 ? d4 : Math.max(d20, d4);
            d2 = d5 - (d18 + d3 + d19);
        } else {
            d2 = this.isExpanded() ? node4.prefHeight(d7) : 0.0;
            d4 = d5 - (d18 + d2 + d19);
            d3 = bl2 ? d4 : Math.max(d20, d4);
        }
        double d22 = d14;
        double d23 = d15;
        if (!bl2) {
            if (node3 != null) {
                node3.resizeRelocate(d22, d23, d17, d20);
                d22 += d17;
            }
        } else {
            node.resizeRelocate(d22, d23, d7 - (d14 + d16), d18);
            d23 += d18;
        }
        node2.resizeRelocate(d22, d23, d21, d4);
        d23 += bl2 ? d4 : d3;
        if (node4 != null) {
            node4.resizeRelocate(d14, d23, d7 - d16, d2);
            d23 += d2;
        }
        if (this.buttonBar != null) {
            this.buttonBar.resizeRelocate(d14, d23, d7 - (d14 + d16), d19);
        }
    }

    @Override
    protected double computeMinWidth(double d2) {
        double d3 = this.hasHeader() ? this.getActualHeader().minWidth(d2) + 10.0 : 0.0;
        double d4 = this.getActualContent().minWidth(d2);
        double d5 = this.buttonBar == null ? 0.0 : this.buttonBar.minWidth(d2);
        double d6 = this.getActualGraphic().minWidth(d2);
        double d7 = 0.0;
        Node node = this.getExpandableContent();
        if (this.isExpanded() && node != null) {
            d7 = node.minWidth(d2);
        }
        double d8 = this.snappedLeftInset() + (this.hasHeader() ? 0.0 : d6) + Math.max(Math.max(d3, d7), Math.max(d4, d5)) + this.snappedRightInset();
        return this.snapSizeX(d8);
    }

    @Override
    protected double computeMinHeight(double d2) {
        boolean bl2 = this.hasHeader();
        double d3 = bl2 ? this.getActualHeader().minHeight(d2) : 0.0;
        double d4 = this.buttonBar == null ? 0.0 : this.buttonBar.minHeight(d2);
        Node node = this.getActualGraphic();
        double d5 = bl2 ? 0.0 : node.minWidth(-1.0);
        double d6 = bl2 ? 0.0 : node.minHeight(d2);
        node = this.getActualContent();
        double d7 = d2 == -1.0 ? -1.0 : (bl2 ? d2 : d2 - d5);
        double d8 = node.minHeight(d7);
        double d9 = 0.0;
        Node node2 = this.getExpandableContent();
        if (this.isExpanded() && node2 != null) {
            d9 = node2.minHeight(d2);
        }
        double d10 = this.snappedTopInset() + d3 + Math.max(d6, d8) + d9 + d4 + this.snappedBottomInset();
        return this.snapSizeY(d10);
    }

    @Override
    protected double computePrefWidth(double d2) {
        double d3 = this.hasHeader() ? this.getActualHeader().prefWidth(d2) + 10.0 : 0.0;
        double d4 = this.getActualContent().prefWidth(d2);
        double d5 = this.buttonBar == null ? 0.0 : this.buttonBar.prefWidth(d2);
        double d6 = this.getActualGraphic().prefWidth(d2);
        double d7 = 0.0;
        Node node = this.getExpandableContent();
        if (this.isExpanded() && node != null) {
            d7 = node.prefWidth(d2);
        }
        double d8 = this.snappedLeftInset() + (this.hasHeader() ? 0.0 : d6) + Math.max(Math.max(d3, d7), Math.max(d4, d5)) + this.snappedRightInset();
        return this.snapSizeX(d8);
    }

    @Override
    protected double computePrefHeight(double d2) {
        boolean bl2 = this.hasHeader();
        double d3 = bl2 ? this.getActualHeader().prefHeight(d2) : 0.0;
        double d4 = this.buttonBar == null ? 0.0 : this.buttonBar.prefHeight(d2);
        Node node = this.getActualGraphic();
        double d5 = bl2 ? 0.0 : node.prefWidth(-1.0);
        double d6 = bl2 ? 0.0 : node.prefHeight(d2);
        node = this.getActualContent();
        double d7 = d2 == -1.0 ? -1.0 : (bl2 ? d2 : d2 - d5);
        double d8 = node.prefHeight(d7);
        double d9 = 0.0;
        Node node2 = this.getExpandableContent();
        if (this.isExpanded() && node2 != null) {
            d9 = node2.prefHeight(d2);
        }
        double d10 = this.snappedTopInset() + d3 + Math.max(d6, d8) + d9 + d4 + this.snappedBottomInset();
        return this.snapSizeY(d10);
    }

    private void updateButtons(ButtonBar buttonBar) {
        buttonBar.getButtons().clear();
        if (this.hasExpandableContent()) {
            if (this.detailsButton == null) {
                this.detailsButton = this.createDetailsButton();
            }
            ButtonBar.setButtonData(this.detailsButton, ButtonBar$ButtonData.HELP_2);
            buttonBar.getButtons().add(this.detailsButton);
            ButtonBar.setButtonUniformSize(this.detailsButton, false);
        }
        boolean bl2 = false;
        for (ButtonType buttonType : this.getButtonTypes()) {
            Node node = this.buttonNodes.get(buttonType);
            if (node instanceof Button) {
                ButtonBar$ButtonData buttonBar$ButtonData = buttonType.getButtonData();
                ((Button)node).setDefaultButton(!bl2 && buttonBar$ButtonData != null && buttonBar$ButtonData.isDefaultButton());
                ((Button)node).setCancelButton(buttonBar$ButtonData != null && buttonBar$ButtonData.isCancelButton());
                bl2 |= buttonBar$ButtonData != null && buttonBar$ButtonData.isDefaultButton();
            }
            buttonBar.getButtons().add(node);
        }
    }

    private Node getActualContent() {
        Node node = this.getContent();
        if (node == null) {
            return this.contentLabel;
        }
        return node;
    }

    private Node getActualHeader() {
        Node node = this.getHeader();
        if (node == null) {
            return this.headerTextPanel;
        }
        return node;
    }

    private Node getActualGraphic() {
        return this.headerTextPanel;
    }

    private void updateHeaderArea() {
        Object object = this.getHeader();
        if (object != null) {
            if (!this.getChildren().contains(object)) {
                this.getChildren().add((Node)object);
            }
            this.headerTextPanel.setVisible(false);
            this.headerTextPanel.setManaged(false);
            return;
        }
        object = this.getHeaderText();
        this.headerTextPanel.getChildren().clear();
        this.headerTextPanel.getStyleClass().clear();
        this.headerTextPanel.setMaxWidth(Double.MAX_VALUE);
        if (object != null && !((String)object).isEmpty()) {
            this.headerTextPanel.getStyleClass().add("header-panel");
        }
        object = new Label((String)object);
        ((Labeled)object).setWrapText(true);
        ((Labeled)object).setAlignment(Pos.CENTER_LEFT);
        ((Region)object).setMaxWidth(Double.MAX_VALUE);
        ((Region)object).setMaxHeight(Double.MAX_VALUE);
        this.headerTextPanel.add((Node)object, 0, 0);
        this.graphicContainer.getChildren().clear();
        this.graphicContainer.getStyleClass().clear();
        object = this.getGraphic();
        if (object != null) {
            this.graphicContainer.getChildren().add((Node)object);
            this.graphicContainer.getStyleClass().add("graphic-container");
        }
        this.headerTextPanel.add(this.graphicContainer, 1, 0);
        object = new ColumnConstraints();
        ((ColumnConstraints)object).setFillWidth(true);
        ((ColumnConstraints)object).setHgrow(Priority.ALWAYS);
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setFillWidth(false);
        columnConstraints.setHgrow(Priority.NEVER);
        this.headerTextPanel.getColumnConstraints().setAll((ColumnConstraints[])new ColumnConstraints[]{object, columnConstraints});
        this.headerTextPanel.setVisible(true);
        this.headerTextPanel.setManaged(true);
    }

    private void updateContentArea() {
        Object object = this.getContent();
        if (object != null) {
            if (!this.getChildren().contains(object)) {
                this.getChildren().add((Node)object);
            }
            if (!((Node)object).getStyleClass().contains("content")) {
                ((Node)object).getStyleClass().add("content");
            }
            this.contentLabel.setVisible(false);
            this.contentLabel.setManaged(false);
            return;
        }
        object = this.getContentText();
        boolean bl2 = object != null && !((String)object).isEmpty();
        this.contentLabel.setText((String)(bl2 ? object : ""));
        this.contentLabel.setVisible(bl2);
        this.contentLabel.setManaged(bl2);
    }

    boolean hasHeader() {
        return this.getHeader() != null || this.isTextHeader();
    }

    private boolean isTextHeader() {
        String string = this.getHeaderText();
        return string != null && !string.isEmpty();
    }

    boolean hasExpandableContent() {
        return this.getExpandableContent() != null;
    }

    void setDialog(Dialog<?> dialog) {
        this.dialog = dialog;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return DialogPane$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return DialogPane.getClassCssMetaData();
    }

    private /* synthetic */ void lambda$createDetailsButton$4(Hyperlink hyperlink, String string, String string2, Observable observable) {
        boolean bl2 = this.isExpanded();
        hyperlink.setText(bl2 ? string : string2);
        hyperlink.getStyleClass().setAll((String[])new String[]{"details-button", bl2 ? "less" : "more"});
    }
}

