/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.WeakListChangeListener;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.control.Cell;
import javafx.scene.control.ControlUtils;
import javafx.scene.control.FocusModel;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.ListCell$1;
import javafx.scene.control.ListCell$2;
import javafx.scene.control.ListCell$3;
import javafx.scene.control.ListCell$4;
import javafx.scene.control.ListCell$5;
import javafx.scene.control.ListView;
import javafx.scene.control.ListView$EditEvent;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.Skin;
import javafx.scene.control.skin.ListCellSkin;

public class ListCell<T>
extends IndexedCell<T> {
    private final InvalidationListener editingListener = observable -> this.updateEditing();
    private boolean updateEditingIndex = true;
    private final ListChangeListener<Integer> selectedListener = listChangeListener$Change -> this.updateSelection();
    private final ChangeListener<MultipleSelectionModel<T>> selectionModelPropertyListener = new ListCell$1(this);
    private final ListChangeListener<T> itemsListener = listChangeListener$Change -> {
        int n2 = 0;
        while (listChangeListener$Change.next()) {
            n2 = this.getIndex();
            ListView<T> listView = this.getListView();
            listView = listView == null ? null : listView.getItems();
            int n3 = listView == null ? 0 : listView.size();
            boolean bl2 = n2 >= listChangeListener$Change.getFrom();
            n2 = n2 < listChangeListener$Change.getTo() || n2 == n3 ? 1 : 0;
            n2 = bl2 && n2 != 0 ? 1 : 0;
            n2 = n2 != 0 || bl2 && !listChangeListener$Change.wasReplaced() && (listChangeListener$Change.wasRemoved() || listChangeListener$Change.wasAdded()) ? 1 : 0;
        }
        if (n2 != 0) {
            this.updateItem(-1);
        }
    };
    private final InvalidationListener itemsPropertyListener = new ListCell$2(this);
    private final InvalidationListener focusedListener = observable -> this.updateFocus();
    private final ChangeListener<FocusModel<T>> focusModelPropertyListener = new ListCell$3(this);
    private final WeakInvalidationListener weakEditingListener = new WeakInvalidationListener(this.editingListener);
    private final WeakListChangeListener<Integer> weakSelectedListener = new WeakListChangeListener<Integer>(this.selectedListener);
    private final WeakChangeListener<MultipleSelectionModel<T>> weakSelectionModelPropertyListener = new WeakChangeListener<MultipleSelectionModel<MultipleSelectionModel<T>>>(this.selectionModelPropertyListener);
    private final WeakListChangeListener<T> weakItemsListener = new WeakListChangeListener<T>(this.itemsListener);
    private final WeakInvalidationListener weakItemsPropertyListener = new WeakInvalidationListener(this.itemsPropertyListener);
    private final WeakInvalidationListener weakFocusedListener = new WeakInvalidationListener(this.focusedListener);
    private final WeakChangeListener<FocusModel<T>> weakFocusModelPropertyListener = new WeakChangeListener<FocusModel<FocusModel<T>>>(this.focusModelPropertyListener);
    private ReadOnlyObjectWrapper<ListView<T>> listView;
    private int indexAtStartEdit;
    private boolean firstRun;
    private static final String DEFAULT_STYLE_CLASS = "list-cell";

    public ListCell() {
        ListCell listCell = this;
        this.listView = new ListCell$4(listCell, listCell, "listView");
        this.firstRun = true;
        this.getStyleClass().addAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setAccessibleRole(AccessibleRole.LIST_ITEM);
    }

    private void setListView(ListView<T> listView) {
        this.listView.set(listView);
    }

    public final ListView<T> getListView() {
        return (ListView)this.listView.get();
    }

    public final ReadOnlyObjectProperty<ListView<T>> listViewProperty() {
        return this.listView.getReadOnlyProperty();
    }

    @Override
    void indexChanged(int n2, int n3) {
        super.indexChanged(n2, n3);
        if (!this.isEditing() || n3 != n2) {
            this.updateItem(n2);
            this.updateSelection();
            this.updateFocus();
            this.updateEditing();
        }
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new ListCellSkin(this);
    }

    @Override
    public void startEdit() {
        if (this.isEditing()) {
            return;
        }
        ListView<T> listView = this.getListView();
        if (!this.isEditable() || listView != null && !listView.isEditable()) {
            return;
        }
        super.startEdit();
        if (!this.isEditing()) {
            return;
        }
        this.indexAtStartEdit = this.getIndex();
        if (listView != null) {
            listView.fireEvent(new ListView$EditEvent<Object>(listView, ListView.editStartEvent(), null, this.indexAtStartEdit));
            listView.edit(this.indexAtStartEdit);
            listView.requestFocus();
        }
    }

    @Override
    public void commitEdit(T t2) {
        if (!this.isEditing()) {
            return;
        }
        super.commitEdit(t2);
        ListView<T> listView = this.getListView();
        if (listView != null) {
            listView.fireEvent(new ListView$EditEvent<T>(listView, ListView.editCommitEvent(), t2, listView.getEditingIndex()));
        }
        this.updateItem(t2, false);
        if (listView != null) {
            listView.edit(-1);
            ControlUtils.requestFocusOnControlOnlyIfCurrentFocusOwnerIsChild(listView);
        }
    }

    @Override
    public void cancelEdit() {
        if (!this.isEditing()) {
            return;
        }
        super.cancelEdit();
        ListView<T> listView = this.getListView();
        if (listView != null) {
            if (this.updateEditingIndex) {
                listView.edit(-1);
            }
            ControlUtils.requestFocusOnControlOnlyIfCurrentFocusOwnerIsChild(listView);
            listView.fireEvent(new ListView$EditEvent<Object>(listView, ListView.editCancelEvent(), null, this.indexAtStartEdit));
        }
    }

    private void updateItem(int n2) {
        ListView<T> listView = this.getListView();
        listView = listView == null ? null : listView.getItems();
        int n3 = this.getIndex();
        int n4 = listView == null ? -1 : listView.size();
        n4 = listView != null && n3 >= 0 && n3 < n4 ? 1 : 0;
        Object t2 = this.getItem();
        boolean bl2 = this.isEmpty();
        if (n4 != 0) {
            listView = listView.get(n3);
            if (n2 != n3 || this.isItemChanged(t2, listView)) {
                this.updateItem(listView, false);
                return;
            }
        } else if (!bl2 || this.firstRun) {
            this.updateItem(null, true);
            this.firstRun = false;
        }
    }

    public final void updateListView(ListView<T> listView) {
        this.setListView(listView);
    }

    private void updateSelection() {
        if (this.isEmpty()) {
            return;
        }
        int bl2 = this.getIndex();
        Object object = this.getListView();
        if (bl2 == -1 || object == null) {
            return;
        }
        if ((object = ((ListView)object).getSelectionModel()) == null) {
            this.updateSelected(false);
            return;
        }
        boolean bl3 = ((SelectionModel)object).isSelected(bl2);
        if (this.isSelected() == bl3) {
            return;
        }
        this.updateSelected(bl3);
    }

    private void updateFocus() {
        int n2 = this.getIndex();
        Object object = this.getListView();
        if (n2 == -1 || object == null) {
            return;
        }
        if ((object = ((ListView)object).getFocusModel()) == null) {
            this.setFocused(false);
            return;
        }
        this.setFocused(((FocusModel)object).isFocused(n2));
    }

    private void updateEditing() {
        int n2 = this.getIndex();
        ListView<T> listView = this.getListView();
        int n3 = listView == null ? -1 : listView.getEditingIndex();
        boolean bl2 = this.isEditing();
        n2 = listView != null && n2 != -1 && n2 == n3 ? 1 : 0;
        if (n2 != 0 && !bl2) {
            ((Cell)this).startEdit();
            return;
        }
        if (n2 == 0 && bl2) {
            try {
                this.updateEditingIndex = false;
                ((Cell)this).cancelEdit();
                return;
            }
            finally {
                this.updateEditingIndex = true;
            }
        }
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objectArray) {
        switch (accessibleAttribute) {
            case INDEX: {
                return this.getIndex();
            }
            case SELECTED: {
                return this.isSelected();
            }
        }
        return super.queryAccessibleAttribute(accessibleAttribute, objectArray);
    }

    @Override
    public void executeAccessibleAction(AccessibleAction object, Object ... objectArray) {
        switch (ListCell$5.$SwitchMap$javafx$scene$AccessibleAction[((Enum)object).ordinal()]) {
            case 1: {
                object = this.getListView();
                if (object == null) break;
                if ((object = ((ListView)object).getFocusModel()) != null) {
                    ((FocusModel)object).focus(this.getIndex());
                }
                return;
            }
            default: {
                super.executeAccessibleAction((AccessibleAction)((Object)object), objectArray);
            }
        }
    }
}

