/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.scene.control.behavior.ListCellBehavior;
import java.util.ArrayList;
import java.util.HashMap;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ListChangeListener$Change;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.scene.AccessibleAttribute;
import javafx.scene.control.ListView;
import javafx.scene.control.ListView$ListViewBitSetSelectionModel$1;
import javafx.scene.control.ListView$ListViewBitSetSelectionModel$2;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.MultipleSelectionModelBase;
import javafx.scene.control.SelectionModel;
import javafx.util.Pair;

class ListView$ListViewBitSetSelectionModel<T>
extends MultipleSelectionModelBase<T> {
    private final ListChangeListener<T> itemsContentObserver = new ListView$ListViewBitSetSelectionModel$2(this);
    private final InvalidationListener itemsObserver;
    private WeakListChangeListener<T> weakItemsContentObserver = new WeakListChangeListener<T>(this.itemsContentObserver);
    private final ListView<T> listView;
    private int itemCount = 0;
    private int previousModelSize = 0;

    public ListView$ListViewBitSetSelectionModel(ListView<T> listView) {
        if (listView == null) {
            throw new IllegalArgumentException("ListView can not be null");
        }
        this.listView = listView;
        this.itemsObserver = new ListView$ListViewBitSetSelectionModel$1(this, listView);
        this.listView.itemsProperty().addListener(new WeakInvalidationListener(this.itemsObserver));
        if (listView.getItems() != null) {
            this.listView.getItems().addListener(this.weakItemsContentObserver);
        }
        this.updateItemCount();
        this.updateDefaultSelection();
    }

    private void updateSelection(ListChangeListener$Change<? extends T> listChangeListener$Change) {
        listChangeListener$Change.reset();
        ArrayList<Pair<Integer, Integer>> arrayList = new ArrayList<Pair<Integer, Integer>>();
        while (listChangeListener$Change.next()) {
            int n2;
            if (listChangeListener$Change.wasReplaced()) {
                if (listChangeListener$Change.getList().isEmpty()) {
                    ((SelectionModel)this).clearSelection();
                    continue;
                }
                int n3 = this.getSelectedIndex();
                if (this.previousModelSize != listChangeListener$Change.getRemovedSize() && n3 < this.getItemCount() && n3 >= 0) {
                    this.startAtomic();
                    ((SelectionModel)this).clearSelection(n3);
                    this.stopAtomic();
                    ((SelectionModel)this).select(n3);
                    continue;
                }
                ((SelectionModel)this).clearSelection();
                continue;
            }
            if (listChangeListener$Change.wasAdded() || listChangeListener$Change.wasRemoved()) {
                int n4 = listChangeListener$Change.wasAdded() ? listChangeListener$Change.getAddedSize() : -listChangeListener$Change.getRemovedSize();
                arrayList.add(new Pair<Integer, Integer>(listChangeListener$Change.getFrom(), n4));
                continue;
            }
            if (!listChangeListener$Change.wasPermutated()) continue;
            int n5 = listChangeListener$Change.getTo() - listChangeListener$Change.getFrom();
            HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>(n5);
            for (int i2 = listChangeListener$Change.getFrom(); i2 < listChangeListener$Change.getTo(); ++i2) {
                hashMap.put(i2, listChangeListener$Change.getPermutation(i2));
            }
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>(((MultipleSelectionModel)this).getSelectedIndices());
            ((SelectionModel)this).clearSelection();
            ArrayList<Integer> arrayList3 = new ArrayList<Integer>(((MultipleSelectionModel)this).getSelectedIndices().size());
            for (int i3 = 0; i3 < arrayList2.size(); ++i3) {
                n2 = (Integer)arrayList2.get(i3);
                if (!hashMap.containsKey(n2)) continue;
                Integer n6 = (Integer)hashMap.get(n2);
                arrayList3.add(n6);
            }
            if (arrayList3.isEmpty()) continue;
            if (arrayList3.size() == 1) {
                ((SelectionModel)this).select((Integer)arrayList3.get(0));
                continue;
            }
            int[] nArray = new int[arrayList3.size() - 1];
            for (n2 = 0; n2 < arrayList3.size() - 1; ++n2) {
                nArray[n2] = (Integer)arrayList3.get(n2 + 1);
            }
            ((MultipleSelectionModel)this).selectIndices((Integer)arrayList3.get(0), nArray);
        }
        if (!arrayList.isEmpty()) {
            this.shiftSelection(arrayList, null);
        }
        this.previousModelSize = this.getItemCount();
    }

    @Override
    public void selectAll() {
        int n2 = ListCellBehavior.getAnchor(this.listView, -1);
        super.selectAll();
        ListCellBehavior.setAnchor(this.listView, n2, false);
    }

    @Override
    public void clearAndSelect(int n2) {
        ListCellBehavior.setAnchor(this.listView, n2, false);
        super.clearAndSelect(n2);
    }

    @Override
    protected void focus(int n2) {
        if (this.listView.getFocusModel() == null) {
            return;
        }
        this.listView.getFocusModel().focus(n2);
        this.listView.notifyAccessibleAttributeChanged(AccessibleAttribute.FOCUS_ITEM);
    }

    @Override
    protected int getFocusedIndex() {
        if (this.listView.getFocusModel() == null) {
            return -1;
        }
        return this.listView.getFocusModel().getFocusedIndex();
    }

    @Override
    protected int getItemCount() {
        return this.itemCount;
    }

    @Override
    protected T getModelItem(int n2) {
        ObservableList<T> observableList = this.listView.getItems();
        if (observableList == null) {
            return null;
        }
        if (n2 < 0 || n2 >= this.itemCount) {
            return null;
        }
        return (T)observableList.get(n2);
    }

    private void updateItemCount() {
        int n2;
        if (this.listView == null) {
            v0 = this;
            n2 = -1;
        } else {
            ObservableList<T> observableList = this.listView.getItems();
            v0 = this;
            n2 = observableList == null ? -1 : observableList.size();
        }
        v0.itemCount = n2;
    }

    private void updateItemsObserver(ObservableList<T> observableList, ObservableList<T> observableList2) {
        if (observableList != null) {
            observableList.removeListener(this.weakItemsContentObserver);
        }
        if (observableList2 != null) {
            observableList2.addListener(this.weakItemsContentObserver);
        }
        this.updateItemCount();
        this.updateDefaultSelection();
    }

    private void updateDefaultSelection() {
        int n2 = -1;
        int n3 = -1;
        if (this.listView.getItems() != null) {
            Object t2 = this.getSelectedItem();
            if (t2 != null) {
                n3 = n2 = this.listView.getItems().indexOf(t2);
            }
            if (this.listView.selectFirstRowByDefault && n3 == -1) {
                this.listView.getItems().size();
            }
        }
        ((SelectionModel)this).clearSelection();
        ((SelectionModel)this).select(n2);
    }
}

