/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import javafx.beans.DefaultProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.Menu$1;
import javafx.scene.control.Menu$2;
import javafx.scene.control.Menu$3;
import javafx.scene.control.Menu$4;
import javafx.scene.control.Menu$5;
import javafx.scene.control.Menu$6;
import javafx.scene.control.MenuItem;

@DefaultProperty(value="items")
public class Menu
extends MenuItem {
    public static final EventType<Event> ON_SHOWING = new EventType<Event>(Event.ANY, "MENU_ON_SHOWING");
    public static final EventType<Event> ON_SHOWN = new EventType<Event>(Event.ANY, "MENU_ON_SHOWN");
    public static final EventType<Event> ON_HIDING = new EventType<Event>(Event.ANY, "MENU_ON_HIDING");
    public static final EventType<Event> ON_HIDDEN = new EventType<Event>(Event.ANY, "MENU_ON_HIDDEN");
    private ReadOnlyBooleanWrapper showing;
    private ObjectProperty<EventHandler<Event>> onShowing = new Menu$2(this);
    private ObjectProperty<EventHandler<Event>> onShown = new Menu$3(this);
    private ObjectProperty<EventHandler<Event>> onHiding = new Menu$4(this);
    private ObjectProperty<EventHandler<Event>> onHidden = new Menu$5(this);
    private final ObservableList<MenuItem> items = new Menu$6(this);
    private static final String DEFAULT_STYLE_CLASS = "menu";
    private static final String STYLE_CLASS_SHOWING = "showing";

    public Menu() {
        this("");
    }

    public Menu(String string) {
        this(string, null);
    }

    public Menu(String string, Node node) {
        this(string, node, null);
    }

    public Menu(String string, Node node, MenuItem ... menuItemArray) {
        super(string, node);
        this.getStyleClass().add(DEFAULT_STYLE_CLASS);
        if (menuItemArray != null) {
            this.getItems().addAll((MenuItem[])menuItemArray);
        }
        this.parentPopupProperty().addListener(observable -> {
            for (int i2 = 0; i2 < this.getItems().size(); ++i2) {
                MenuItem menuItem = (MenuItem)this.getItems().get(i2);
                menuItem.setParentPopup(this.getParentPopup());
            }
        });
    }

    private void setShowing(boolean bl2) {
        if (this.getItems().size() == 0 || bl2 && this.isShowing()) {
            return;
        }
        if (bl2) {
            if (this.getOnMenuValidation() != null) {
                Event.fireEvent(this, new Event(MENU_VALIDATION_EVENT));
                for (MenuItem menuItem : this.getItems()) {
                    if (menuItem instanceof Menu || menuItem.getOnMenuValidation() == null) continue;
                    Event.fireEvent(menuItem, new Event(MenuItem.MENU_VALIDATION_EVENT));
                }
            }
            Event.fireEvent(this, new Event(ON_SHOWING));
        } else {
            Event.fireEvent(this, new Event(ON_HIDING));
        }
        this.showingPropertyImpl().set(bl2);
        Event.fireEvent(this, bl2 ? new Event(ON_SHOWN) : new Event(ON_HIDDEN));
    }

    public final boolean isShowing() {
        if (this.showing == null) {
            return false;
        }
        return this.showing.get();
    }

    public final ReadOnlyBooleanProperty showingProperty() {
        return this.showingPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyBooleanWrapper showingPropertyImpl() {
        if (this.showing == null) {
            this.showing = new Menu$1(this);
        }
        return this.showing;
    }

    public final ObjectProperty<EventHandler<Event>> onShowingProperty() {
        return this.onShowing;
    }

    public final void setOnShowing(EventHandler<Event> eventHandler) {
        this.onShowingProperty().set(eventHandler);
    }

    public final EventHandler<Event> getOnShowing() {
        return (EventHandler)this.onShowingProperty().get();
    }

    public final ObjectProperty<EventHandler<Event>> onShownProperty() {
        return this.onShown;
    }

    public final void setOnShown(EventHandler<Event> eventHandler) {
        this.onShownProperty().set(eventHandler);
    }

    public final EventHandler<Event> getOnShown() {
        return (EventHandler)this.onShownProperty().get();
    }

    public final ObjectProperty<EventHandler<Event>> onHidingProperty() {
        return this.onHiding;
    }

    public final void setOnHiding(EventHandler<Event> eventHandler) {
        this.onHidingProperty().set(eventHandler);
    }

    public final EventHandler<Event> getOnHiding() {
        return (EventHandler)this.onHidingProperty().get();
    }

    public final ObjectProperty<EventHandler<Event>> onHiddenProperty() {
        return this.onHidden;
    }

    public final void setOnHidden(EventHandler<Event> eventHandler) {
        this.onHiddenProperty().set(eventHandler);
    }

    public final EventHandler<Event> getOnHidden() {
        return (EventHandler)this.onHiddenProperty().get();
    }

    public final ObservableList<MenuItem> getItems() {
        return this.items;
    }

    public void show() {
        if (this.isDisable()) {
            return;
        }
        this.setShowing(true);
    }

    public void hide() {
        if (!this.isShowing()) {
            return;
        }
        for (MenuItem menuItem : this.getItems()) {
            if (!(menuItem instanceof Menu)) continue;
            menuItem = (Menu)menuItem;
            ((Menu)menuItem).hide();
        }
        this.setShowing(false);
    }

    @Override
    public EventDispatchChain buildEventDispatchChain(EventDispatchChain eventDispatchChain) {
        return eventDispatchChain.prepend(this.eventHandlerManager);
    }
}

