/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.collections.NonIterableChange$GenericAddRemoveChange;
import com.sun.javafx.scene.control.MultipleAdditionAndRemovedChange;
import com.sun.javafx.scene.control.ReadOnlyUnbackedObservableList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.collections.ListChangeListener$Change;
import javafx.collections.ObservableList;
import javafx.collections.ObservableListBase;
import javafx.scene.control.ControlUtils;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.MultipleSelectionModelBase$1;
import javafx.scene.control.MultipleSelectionModelBase$SelectedIndicesList;
import javafx.scene.control.MultipleSelectionModelBase$ShiftParams;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SelectionModel;
import javafx.util.Callback;
import javafx.util.Pair;

abstract class MultipleSelectionModelBase<T>
extends MultipleSelectionModel<T> {
    final MultipleSelectionModelBase$SelectedIndicesList selectedIndices;
    private final ObservableListBase<T> selectedItems;
    ListChangeListener$Change selectedItemChange;

    public MultipleSelectionModelBase() {
        this.selectedIndexProperty().addListener(observable -> {
            MultipleSelectionModelBase multipleSelectionModelBase = this;
            multipleSelectionModelBase.setSelectedItem(multipleSelectionModelBase.getModelItem(this.getSelectedIndex()));
        });
        this.selectedIndices = new MultipleSelectionModelBase$SelectedIndicesList(this);
        MultipleSelectionModelBase multipleSelectionModelBase = this;
        this.selectedItems = new MultipleSelectionModelBase$1(multipleSelectionModelBase, multipleSelectionModelBase.selectedIndices, () -> this.getItemCount());
    }

    @Override
    public ObservableList<Integer> getSelectedIndices() {
        return this.selectedIndices;
    }

    @Override
    public ObservableList<T> getSelectedItems() {
        return this.selectedItems;
    }

    protected abstract int getItemCount();

    protected abstract T getModelItem(int var1);

    protected abstract void focus(int var1);

    protected abstract int getFocusedIndex();

    void shiftSelection(int n2, int n3, Callback<MultipleSelectionModelBase$ShiftParams, Void> callback) {
        this.shiftSelection(Arrays.asList(new Pair<Integer, Integer>(n2, n3)), callback);
    }

    void shiftSelection(List<Pair<Integer, Integer>> object, Callback<MultipleSelectionModelBase$ShiftParams, Void> callback) {
        int n3 = ((ReadOnlyUnbackedObservableList)this.selectedIndices).size();
        if (n3 == 0) {
            return;
        }
        n3 = this.selectedIndices.bitsetSize();
        int[] nArray = new int[n3];
        Arrays.fill(nArray, -1);
        Collections.sort(object, (pair, pair2) -> Integer.compare((Integer)pair2.getKey(), (Integer)pair.getKey()));
        List<Pair<Integer, Integer>> list = object;
        int n4 = list.get(list.size() - 1).getKey();
        BitSet bitSet = (BitSet)this.selectedIndices.bitset.clone();
        this.startAtomic();
        Object object2 = object.iterator();
        while (object2.hasNext()) {
            Pair<Integer, Integer> pair3 = object2.next();
            this.doShift(pair3, callback, nArray);
        }
        this.stopAtomic();
        int[] nArray2 = Arrays.stream(nArray).filter(n2 -> n2 >= 0).toArray();
        object2 = nArray2;
        boolean bl2 = nArray2.length > 0;
        int n5 = this.getSelectedIndex();
        if (n5 >= n4 && n5 >= 0) {
            int n6 = object.stream().filter(pair -> (Integer)pair.getKey() <= n5).mapToInt(pair -> (Integer)pair.getValue()).sum();
            n5 = Math.max(0, n5 + n6);
            this.setSelectedIndex(n5);
            if (bl2) {
                this.selectedIndices.set(n5, true);
            } else {
                ((SelectionModel)this).select(n5);
            }
        }
        if (bl2) {
            object = (BitSet)bitSet.clone();
            ((BitSet)object).andNot(this.selectedIndices.bitset);
            BitSet bitSet2 = (BitSet)this.selectedIndices.bitset.clone();
            bitSet2.andNot(bitSet);
            this.selectedIndices.reset();
            this.selectedIndices.callObservers(new MultipleAdditionAndRemovedChange<Integer>(bitSet2.stream().boxed().collect(Collectors.toList()), ((BitSet)object).stream().boxed().collect(Collectors.toList()), this.selectedIndices));
        }
    }

    private void doShift(Pair<Integer, Integer> pair, Callback<MultipleSelectionModelBase$ShiftParams, Void> callback, int[] nArray) {
        int n3 = pair.getKey();
        int n4 = pair.getValue();
        if (n3 < 0) {
            return;
        }
        if (n4 == 0) {
            return;
        }
        int n5 = (int)Arrays.stream(nArray).filter(n2 -> n2 >= 0).count();
        int n6 = this.selectedIndices.bitsetSize() - n5;
        if (n4 > 0) {
            for (int i2 = n6 - 1; i2 >= n3 && i2 >= 0; --i2) {
                boolean bl2 = this.selectedIndices.isSelected(i2);
                if (callback == null) {
                    this.selectedIndices.clear(i2);
                    this.selectedIndices.set(i2 + n4, bl2);
                } else {
                    int n7 = i2;
                    callback.call(new MultipleSelectionModelBase$ShiftParams(n7, n7 + n4, bl2));
                }
                if (!bl2) continue;
                nArray[n5++] = i2 + 1;
            }
            this.selectedIndices.clear(n3);
            return;
        }
        if (n4 < 0) {
            for (int i3 = n3; i3 < n6; ++i3) {
                if (i3 + n4 < 0 || i3 + 1 + n4 < n3) continue;
                boolean bl3 = this.selectedIndices.isSelected(i3 + 1);
                if (callback == null) {
                    this.selectedIndices.clear(i3 + 1);
                    this.selectedIndices.set(i3 + 1 + n4, bl3);
                } else {
                    callback.call(new MultipleSelectionModelBase$ShiftParams(i3 + 1, i3 + 1 + n4, bl3));
                }
                if (!bl3) continue;
                nArray[n5++] = i3;
            }
        }
    }

    void startAtomic() {
        this.selectedIndices.startAtomic();
    }

    void stopAtomic() {
        this.selectedIndices.stopAtomic();
    }

    boolean isAtomic() {
        return this.selectedIndices.isAtomic();
    }

    @Override
    public void clearAndSelect(int n2) {
        ListChangeListener$Change<Integer> listChangeListener$Change;
        if (n2 < 0 || n2 >= this.getItemCount()) {
            ((SelectionModel)this).clearSelection();
            return;
        }
        boolean bl2 = ((SelectionModel)this).isSelected(n2);
        if (bl2 && ((MultipleSelectionModel)this).getSelectedIndices().size() == 1 && this.getSelectedItem() == this.getModelItem(n2)) {
            return;
        }
        Object object = new BitSet();
        ((BitSet)object).or(this.selectedIndices.bitset);
        ((BitSet)object).clear(n2);
        object = new MultipleSelectionModelBase$SelectedIndicesList(this, (BitSet)object);
        this.startAtomic();
        ((SelectionModel)this).clearSelection();
        ((SelectionModel)this).select(n2);
        this.stopAtomic();
        if (bl2) {
            listChangeListener$Change = ControlUtils.buildClearAndSelectChange(this.selectedIndices, object, n2, Comparator.naturalOrder());
        } else {
            int n3 = n2 = Math.max(0, ((ReadOnlyUnbackedObservableList)this.selectedIndices).indexOf(n2));
            listChangeListener$Change = new NonIterableChange$GenericAddRemoveChange<Integer>(n3, n3 + 1, (List<Integer>)object, this.selectedIndices);
        }
        this.selectedIndices.callObservers(listChangeListener$Change);
    }

    @Override
    public void select(int n2) {
        if (n2 == -1) {
            ((SelectionModel)this).clearSelection();
            return;
        }
        if (n2 < 0 || n2 >= this.getItemCount()) {
            return;
        }
        boolean bl2 = n2 == this.getSelectedIndex();
        Object t2 = this.getSelectedItem();
        T t3 = this.getModelItem(n2);
        boolean bl3 = t3 != null && t3.equals(t2);
        bl2 = bl2 && !bl3;
        this.focus(n2);
        if (!this.selectedIndices.isSelected(n2)) {
            if (this.getSelectionMode() == SelectionMode.SINGLE) {
                this.startAtomic();
                this.quietClearSelection();
                this.stopAtomic();
            }
            this.selectedIndices.set(n2);
        }
        this.setSelectedIndex(n2);
        if (bl2) {
            this.setSelectedItem(t3);
        }
    }

    @Override
    public void select(T t2) {
        if (t2 == null && this.getSelectionMode() == SelectionMode.SINGLE) {
            ((SelectionModel)this).clearSelection();
            return;
        }
        int n2 = this.getItemCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            T t3 = this.getModelItem(i2);
            if (t3 == null || !t3.equals(t2)) continue;
            if (((SelectionModel)this).isSelected(i2)) {
                return;
            }
            if (this.getSelectionMode() == SelectionMode.SINGLE) {
                this.quietClearSelection();
            }
            ((SelectionModel)this).select(i2);
            return;
        }
        this.setSelectedIndex(-1);
        this.setSelectedItem(t2);
    }

    @Override
    public void selectIndices(int n4, int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            ((SelectionModel)this).select(n4);
            return;
        }
        int n5 = this.getItemCount();
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.quietClearSelection();
            for (int i2 = nArray.length - 1; i2 >= 0; --i2) {
                int n6 = nArray[i2];
                if (n6 < 0 || n6 >= n5) continue;
                this.selectedIndices.set(n6);
                ((SelectionModel)this).select(n6);
                break;
            }
            if (this.selectedIndices.isEmpty() && n4 > 0 && n4 < n5) {
                this.selectedIndices.set(n4);
                ((SelectionModel)this).select(n4);
                return;
            }
        } else {
            this.selectedIndices.set(n4, nArray);
            IntStream.concat(IntStream.of(n4), IntStream.of(nArray)).filter(n3 -> n3 >= 0 && n3 < n5).reduce((n2, n3) -> n3).ifPresent(n2 -> {
                this.setSelectedIndex(n2);
                this.focus(n2);
                MultipleSelectionModelBase multipleSelectionModelBase = this;
                multipleSelectionModelBase.setSelectedItem(multipleSelectionModelBase.getModelItem(n2));
            });
        }
    }

    @Override
    public void selectAll() {
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            return;
        }
        if (this.getItemCount() <= 0) {
            return;
        }
        int n2 = this.getItemCount();
        int n3 = this.getFocusedIndex();
        ((SelectionModel)this).clearSelection();
        this.selectedIndices.set(0, n2, true);
        if (n3 == -1) {
            this.setSelectedIndex(n2 - 1);
            this.focus(n2 - 1);
            return;
        }
        this.setSelectedIndex(n3);
        this.focus(n3);
    }

    @Override
    public void selectFirst() {
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.quietClearSelection();
        }
        if (this.getItemCount() > 0) {
            ((SelectionModel)this).select(0);
        }
    }

    @Override
    public void selectLast() {
        int n2;
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.quietClearSelection();
        }
        if ((n2 = this.getItemCount()) > 0 && this.getSelectedIndex() < n2 - 1) {
            ((SelectionModel)this).select(n2 - 1);
        }
    }

    @Override
    public void clearSelection(int n2) {
        if (n2 < 0) {
            return;
        }
        boolean bl2 = this.selectedIndices.isEmpty();
        this.selectedIndices.clear(n2);
        if (!bl2 && this.selectedIndices.isEmpty()) {
            ((SelectionModel)this).clearSelection();
        }
    }

    @Override
    public void clearSelection() {
        this.quietClearSelection();
        if (!this.isAtomic()) {
            this.setSelectedIndex(-1);
            this.focus(-1);
        }
    }

    private void quietClearSelection() {
        ((ReadOnlyUnbackedObservableList)this.selectedIndices).clear();
    }

    @Override
    public boolean isSelected(int n2) {
        if (n2 >= 0 && n2 < this.selectedIndices.bitsetSize()) {
            return this.selectedIndices.isSelected(n2);
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.selectedIndices.isEmpty();
    }

    @Override
    public void selectPrevious() {
        int n2 = this.getFocusedIndex();
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.quietClearSelection();
        }
        if (n2 == -1) {
            MultipleSelectionModelBase multipleSelectionModelBase = this;
            ((SelectionModel)multipleSelectionModelBase).select(multipleSelectionModelBase.getItemCount() - 1);
            return;
        }
        if (n2 > 0) {
            ((SelectionModel)this).select(n2 - 1);
        }
    }

    @Override
    public void selectNext() {
        int n2 = this.getFocusedIndex();
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.quietClearSelection();
        }
        if (n2 == -1) {
            ((SelectionModel)this).select(0);
            return;
        }
        if (n2 != this.getItemCount() - 1) {
            ((SelectionModel)this).select(n2 + 1);
        }
    }
}

