/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Pagination$1;
import javafx.scene.control.Pagination$2;
import javafx.scene.control.Pagination$3;
import javafx.scene.control.Pagination$StyleableProperties;
import javafx.scene.control.Skin;
import javafx.scene.control.skin.PaginationSkin;
import javafx.util.Callback;

@DefaultProperty(value="pages")
public class Pagination
extends Control {
    private static final int DEFAULT_MAX_PAGE_INDICATOR_COUNT = 10;
    public static final String STYLE_CLASS_BULLET = "bullet";
    public static final int INDETERMINATE = Integer.MAX_VALUE;
    private int oldMaxPageIndicatorCount = 10;
    private IntegerProperty maxPageIndicatorCount;
    private int oldPageCount = Integer.MAX_VALUE;
    private IntegerProperty pageCount;
    private final IntegerProperty currentPageIndex;
    private ObjectProperty<Callback<Integer, Node>> pageFactory;
    private static final String DEFAULT_STYLE_CLASS = "pagination";

    public Pagination(int n2, int n3) {
        Pagination pagination = this;
        this.pageCount = new Pagination$2(pagination, pagination, "pageCount", Integer.MAX_VALUE);
        Pagination pagination2 = this;
        this.currentPageIndex = new Pagination$3(pagination2, pagination2, "currentPageIndex", 0);
        this.pageFactory = new SimpleObjectProperty<Callback<Integer, Node>>(this, "pageFactory");
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setAccessibleRole(AccessibleRole.PAGINATION);
        this.setPageCount(n2);
        this.setCurrentPageIndex(n3);
    }

    public Pagination(int n2) {
        this(n2, 0);
    }

    public Pagination() {
        this(Integer.MAX_VALUE, 0);
    }

    public final void setMaxPageIndicatorCount(int n2) {
        this.maxPageIndicatorCountProperty().set(n2);
    }

    public final int getMaxPageIndicatorCount() {
        if (this.maxPageIndicatorCount == null) {
            return 10;
        }
        return this.maxPageIndicatorCount.get();
    }

    public final IntegerProperty maxPageIndicatorCountProperty() {
        if (this.maxPageIndicatorCount == null) {
            this.maxPageIndicatorCount = new Pagination$1(this, 10);
        }
        return this.maxPageIndicatorCount;
    }

    public final void setPageCount(int n2) {
        this.pageCount.set(n2);
    }

    public final int getPageCount() {
        return this.pageCount.get();
    }

    public final IntegerProperty pageCountProperty() {
        return this.pageCount;
    }

    public final void setCurrentPageIndex(int n2) {
        this.currentPageIndex.set(n2);
    }

    public final int getCurrentPageIndex() {
        return this.currentPageIndex.get();
    }

    public final IntegerProperty currentPageIndexProperty() {
        return this.currentPageIndex;
    }

    public final void setPageFactory(Callback<Integer, Node> callback) {
        this.pageFactory.set(callback);
    }

    public final Callback<Integer, Node> getPageFactory() {
        return (Callback)this.pageFactory.get();
    }

    public final ObjectProperty<Callback<Integer, Node>> pageFactoryProperty() {
        return this.pageFactory;
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new PaginationSkin(this);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return Pagination$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return Pagination.getClassCssMetaData();
    }
}

