/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.util.Utils;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.geometry.Orientation;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollBar$1;
import javafx.scene.control.ScrollBar$2;
import javafx.scene.control.ScrollBar$3;
import javafx.scene.control.ScrollBar$4;
import javafx.scene.control.ScrollBar$StyleableProperties;
import javafx.scene.control.Skin;
import javafx.scene.control.skin.ScrollBarSkin;

public class ScrollBar
extends Control {
    private DoubleProperty min;
    private DoubleProperty max;
    private DoubleProperty value;
    private ObjectProperty<Orientation> orientation;
    private DoubleProperty unitIncrement;
    private DoubleProperty blockIncrement;
    private DoubleProperty visibleAmount;
    private static final String DEFAULT_STYLE_CLASS = "scroll-bar";
    private static final PseudoClass VERTICAL_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("vertical");
    private static final PseudoClass HORIZONTAL_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("horizontal");

    public ScrollBar() {
        this.setWidth(20.0);
        this.setHeight(100.0);
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setAccessibleRole(AccessibleRole.SCROLL_BAR);
        ((StyleableProperty)((Object)this.focusTraversableProperty())).applyStyle(null, Boolean.FALSE);
        this.pseudoClassStateChanged(HORIZONTAL_PSEUDOCLASS_STATE, true);
    }

    public final void setMin(double d2) {
        this.minProperty().set(d2);
    }

    public final double getMin() {
        if (this.min == null) {
            return 0.0;
        }
        return this.min.get();
    }

    public final DoubleProperty minProperty() {
        if (this.min == null) {
            this.min = new SimpleDoubleProperty(this, "min");
        }
        return this.min;
    }

    public final void setMax(double d2) {
        this.maxProperty().set(d2);
    }

    public final double getMax() {
        if (this.max == null) {
            return 100.0;
        }
        return this.max.get();
    }

    public final DoubleProperty maxProperty() {
        if (this.max == null) {
            this.max = new SimpleDoubleProperty(this, "max", 100.0);
        }
        return this.max;
    }

    public final void setValue(double d2) {
        this.valueProperty().set(d2);
    }

    public final double getValue() {
        if (this.value == null) {
            return 0.0;
        }
        return this.value.get();
    }

    public final DoubleProperty valueProperty() {
        if (this.value == null) {
            this.value = new SimpleDoubleProperty(this, "value");
        }
        return this.value;
    }

    public final void setOrientation(Orientation orientation) {
        this.orientationProperty().set(orientation);
    }

    public final Orientation getOrientation() {
        if (this.orientation == null) {
            return Orientation.HORIZONTAL;
        }
        return (Orientation)((Object)this.orientation.get());
    }

    public final ObjectProperty<Orientation> orientationProperty() {
        if (this.orientation == null) {
            this.orientation = new ScrollBar$1(this, Orientation.HORIZONTAL);
        }
        return this.orientation;
    }

    public final void setUnitIncrement(double d2) {
        this.unitIncrementProperty().set(d2);
    }

    public final double getUnitIncrement() {
        if (this.unitIncrement == null) {
            return 1.0;
        }
        return this.unitIncrement.get();
    }

    public final DoubleProperty unitIncrementProperty() {
        if (this.unitIncrement == null) {
            this.unitIncrement = new ScrollBar$2(this, 1.0);
        }
        return this.unitIncrement;
    }

    public final void setBlockIncrement(double d2) {
        this.blockIncrementProperty().set(d2);
    }

    public final double getBlockIncrement() {
        if (this.blockIncrement == null) {
            return 10.0;
        }
        return this.blockIncrement.get();
    }

    public final DoubleProperty blockIncrementProperty() {
        if (this.blockIncrement == null) {
            this.blockIncrement = new ScrollBar$3(this, 10.0);
        }
        return this.blockIncrement;
    }

    public final void setVisibleAmount(double d2) {
        this.visibleAmountProperty().set(d2);
    }

    public final double getVisibleAmount() {
        if (this.visibleAmount == null) {
            return 15.0;
        }
        return this.visibleAmount.get();
    }

    public final DoubleProperty visibleAmountProperty() {
        if (this.visibleAmount == null) {
            this.visibleAmount = new SimpleDoubleProperty(this, "visibleAmount");
        }
        return this.visibleAmount;
    }

    public void adjustValue(double d2) {
        double d3 = (this.getMax() - this.getMin()) * Utils.clamp(0.0, d2, 1.0) + this.getMin();
        if (Double.compare(d3, this.getValue()) != 0) {
            double d4 = d3 > this.getValue() ? this.getValue() + this.getBlockIncrement() : this.getValue() - this.getBlockIncrement();
            ScrollBar scrollBar = this;
            scrollBar.setValue(Utils.clamp(scrollBar.getMin(), d4, this.getMax()));
        }
    }

    public void increment() {
        ScrollBar scrollBar = this;
        scrollBar.setValue(Utils.clamp(scrollBar.getMin(), this.getValue() + this.getUnitIncrement(), this.getMax()));
    }

    public void decrement() {
        ScrollBar scrollBar = this;
        scrollBar.setValue(Utils.clamp(scrollBar.getMin(), this.getValue() - this.getUnitIncrement(), this.getMax()));
    }

    private void blockIncrement() {
        ScrollBar scrollBar = this;
        scrollBar.adjustValue(scrollBar.getValue() + this.getBlockIncrement());
    }

    private void blockDecrement() {
        ScrollBar scrollBar = this;
        scrollBar.adjustValue(scrollBar.getValue() - this.getBlockIncrement());
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new ScrollBarSkin(this);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return ScrollBar$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return ScrollBar.getClassCssMetaData();
    }

    @Override
    protected Boolean getInitialFocusTraversable() {
        return Boolean.FALSE;
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objectArray) {
        switch (accessibleAttribute) {
            case VALUE: {
                return this.getValue();
            }
            case MAX_VALUE: {
                return this.getMax();
            }
            case MIN_VALUE: {
                return this.getMin();
            }
            case ORIENTATION: {
                return this.getOrientation();
            }
        }
        return super.queryAccessibleAttribute(accessibleAttribute, objectArray);
    }

    @Override
    public void executeAccessibleAction(AccessibleAction object, Object ... objectArray) {
        switch (ScrollBar$4.$SwitchMap$javafx$scene$AccessibleAction[((Enum)object).ordinal()]) {
            case 1: {
                this.increment();
                return;
            }
            case 2: {
                this.decrement();
                return;
            }
            case 3: {
                this.blockIncrement();
                return;
            }
            case 4: {
                this.blockDecrement();
                return;
            }
            case 5: {
                object = (Double)objectArray[0];
                if (object == null) break;
                this.setValue((Double)object);
                return;
            }
            default: {
                super.executeAccessibleAction((AccessibleAction)((Object)object), objectArray);
            }
        }
    }
}

