/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.util.Utils;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.geometry.Orientation;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.Slider$1;
import javafx.scene.control.Slider$10;
import javafx.scene.control.Slider$11;
import javafx.scene.control.Slider$2;
import javafx.scene.control.Slider$3;
import javafx.scene.control.Slider$4;
import javafx.scene.control.Slider$5;
import javafx.scene.control.Slider$6;
import javafx.scene.control.Slider$7;
import javafx.scene.control.Slider$8;
import javafx.scene.control.Slider$9;
import javafx.scene.control.Slider$StyleableProperties;
import javafx.scene.control.skin.SliderSkin;
import javafx.util.StringConverter;

public class Slider
extends Control {
    private DoubleProperty max;
    private DoubleProperty min;
    private DoubleProperty value;
    private BooleanProperty valueChanging;
    private ObjectProperty<Orientation> orientation;
    private BooleanProperty showTickLabels;
    private BooleanProperty showTickMarks;
    private DoubleProperty majorTickUnit;
    private IntegerProperty minorTickCount;
    private BooleanProperty snapToTicks;
    private ObjectProperty<StringConverter<Double>> labelFormatter;
    private DoubleProperty blockIncrement;
    private static final String DEFAULT_STYLE_CLASS = "slider";
    private static final PseudoClass VERTICAL_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("vertical");
    private static final PseudoClass HORIZONTAL_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("horizontal");

    public Slider() {
        this.initialize();
    }

    public Slider(double d2, double d3, double d4) {
        this.setMax(d3);
        this.setMin(d2);
        this.setValue(d4);
        this.adjustValues();
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setAccessibleRole(AccessibleRole.SLIDER);
        this.pseudoClassStateChanged(HORIZONTAL_PSEUDOCLASS_STATE, true);
    }

    public final void setMax(double d2) {
        this.maxProperty().set(d2);
    }

    public final double getMax() {
        if (this.max == null) {
            return 100.0;
        }
        return this.max.get();
    }

    public final DoubleProperty maxProperty() {
        if (this.max == null) {
            this.max = new Slider$1(this, 100.0);
        }
        return this.max;
    }

    public final void setMin(double d2) {
        this.minProperty().set(d2);
    }

    public final double getMin() {
        if (this.min == null) {
            return 0.0;
        }
        return this.min.get();
    }

    public final DoubleProperty minProperty() {
        if (this.min == null) {
            this.min = new Slider$2(this, 0.0);
        }
        return this.min;
    }

    public final void setValue(double d2) {
        if (!this.valueProperty().isBound()) {
            this.valueProperty().set(d2);
        }
    }

    public final double getValue() {
        if (this.value == null) {
            return 0.0;
        }
        return this.value.get();
    }

    public final DoubleProperty valueProperty() {
        if (this.value == null) {
            this.value = new Slider$3(this, 0.0);
        }
        return this.value;
    }

    public final void setValueChanging(boolean bl2) {
        this.valueChangingProperty().set(bl2);
    }

    public final boolean isValueChanging() {
        if (this.valueChanging == null) {
            return false;
        }
        return this.valueChanging.get();
    }

    public final BooleanProperty valueChangingProperty() {
        if (this.valueChanging == null) {
            this.valueChanging = new SimpleBooleanProperty(this, "valueChanging", false);
        }
        return this.valueChanging;
    }

    public final void setOrientation(Orientation orientation) {
        this.orientationProperty().set(orientation);
    }

    public final Orientation getOrientation() {
        if (this.orientation == null) {
            return Orientation.HORIZONTAL;
        }
        return (Orientation)((Object)this.orientation.get());
    }

    public final ObjectProperty<Orientation> orientationProperty() {
        if (this.orientation == null) {
            this.orientation = new Slider$4(this, Orientation.HORIZONTAL);
        }
        return this.orientation;
    }

    public final void setShowTickLabels(boolean bl2) {
        this.showTickLabelsProperty().set(bl2);
    }

    public final boolean isShowTickLabels() {
        if (this.showTickLabels == null) {
            return false;
        }
        return this.showTickLabels.get();
    }

    public final BooleanProperty showTickLabelsProperty() {
        if (this.showTickLabels == null) {
            this.showTickLabels = new Slider$5(this, false);
        }
        return this.showTickLabels;
    }

    public final void setShowTickMarks(boolean bl2) {
        this.showTickMarksProperty().set(bl2);
    }

    public final boolean isShowTickMarks() {
        if (this.showTickMarks == null) {
            return false;
        }
        return this.showTickMarks.get();
    }

    public final BooleanProperty showTickMarksProperty() {
        if (this.showTickMarks == null) {
            this.showTickMarks = new Slider$6(this, false);
        }
        return this.showTickMarks;
    }

    public final void setMajorTickUnit(double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("MajorTickUnit cannot be less than or equal to 0.");
        }
        this.majorTickUnitProperty().set(d2);
    }

    public final double getMajorTickUnit() {
        if (this.majorTickUnit == null) {
            return 25.0;
        }
        return this.majorTickUnit.get();
    }

    public final DoubleProperty majorTickUnitProperty() {
        if (this.majorTickUnit == null) {
            this.majorTickUnit = new Slider$7(this, 25.0);
        }
        return this.majorTickUnit;
    }

    public final void setMinorTickCount(int n2) {
        this.minorTickCountProperty().set(n2);
    }

    public final int getMinorTickCount() {
        if (this.minorTickCount == null) {
            return 3;
        }
        return this.minorTickCount.get();
    }

    public final IntegerProperty minorTickCountProperty() {
        if (this.minorTickCount == null) {
            this.minorTickCount = new Slider$8(this, 3);
        }
        return this.minorTickCount;
    }

    public final void setSnapToTicks(boolean bl2) {
        this.snapToTicksProperty().set(bl2);
    }

    public final boolean isSnapToTicks() {
        if (this.snapToTicks == null) {
            return false;
        }
        return this.snapToTicks.get();
    }

    public final BooleanProperty snapToTicksProperty() {
        if (this.snapToTicks == null) {
            this.snapToTicks = new Slider$9(this, false);
        }
        return this.snapToTicks;
    }

    public final void setLabelFormatter(StringConverter<Double> stringConverter) {
        this.labelFormatterProperty().set(stringConverter);
    }

    public final StringConverter<Double> getLabelFormatter() {
        if (this.labelFormatter == null) {
            return null;
        }
        return (StringConverter)this.labelFormatter.get();
    }

    public final ObjectProperty<StringConverter<Double>> labelFormatterProperty() {
        if (this.labelFormatter == null) {
            this.labelFormatter = new SimpleObjectProperty<StringConverter<Double>>(this, "labelFormatter");
        }
        return this.labelFormatter;
    }

    public final void setBlockIncrement(double d2) {
        this.blockIncrementProperty().set(d2);
    }

    public final double getBlockIncrement() {
        if (this.blockIncrement == null) {
            return 10.0;
        }
        return this.blockIncrement.get();
    }

    public final DoubleProperty blockIncrementProperty() {
        if (this.blockIncrement == null) {
            this.blockIncrement = new Slider$10(this, 10.0);
        }
        return this.blockIncrement;
    }

    public void adjustValue(double d2) {
        double d3;
        double d4 = this.getMin();
        double d5 = this.getMax();
        if (d3 <= d4) {
            return;
        }
        d2 = d2 < d4 ? d4 : d2;
        d2 = d2 > d5 ? d5 : d2;
        Slider slider = this;
        slider.setValue(slider.snapValueToTicks(d2));
    }

    public void increment() {
        Slider slider = this;
        slider.adjustValue(slider.getValue() + this.getBlockIncrement());
    }

    public void decrement() {
        Slider slider = this;
        slider.adjustValue(slider.getValue() - this.getBlockIncrement());
    }

    private void adjustValues() {
        if (this.getValue() < this.getMin() || this.getValue() > this.getMax()) {
            Slider slider = this;
            slider.setValue(Utils.clamp(slider.getMin(), this.getValue(), this.getMax()));
        }
    }

    private double snapValueToTicks(double d2) {
        double d3 = d2;
        if (this.isSnapToTicks()) {
            double d4 = this.getMinorTickCount() != 0 ? this.getMajorTickUnit() / (double)(Math.max(this.getMinorTickCount(), 0) + 1) : this.getMajorTickUnit();
            int n2 = (int)((d3 - this.getMin()) / d4);
            double d5 = (double)n2 * d4 + this.getMin();
            double d6 = (double)(n2 + 1) * d4 + this.getMin();
            d3 = Utils.nearest(d5, d3, d6);
        }
        return Utils.clamp(this.getMin(), d3, this.getMax());
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new SliderSkin(this);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return Slider$StyleableProperties.STYLEABLES;
    }

    @Override
    protected List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return Slider.getClassCssMetaData();
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objectArray) {
        switch (accessibleAttribute) {
            case VALUE: {
                return this.getValue();
            }
            case MAX_VALUE: {
                return this.getMax();
            }
            case MIN_VALUE: {
                return this.getMin();
            }
            case ORIENTATION: {
                return this.getOrientation();
            }
        }
        return super.queryAccessibleAttribute(accessibleAttribute, objectArray);
    }

    @Override
    public void executeAccessibleAction(AccessibleAction object, Object ... objectArray) {
        switch (Slider$11.$SwitchMap$javafx$scene$AccessibleAction[((Enum)object).ordinal()]) {
            case 1: {
                this.increment();
                return;
            }
            case 2: {
                this.decrement();
                return;
            }
            case 3: {
                object = (Double)objectArray[0];
                if (object == null) break;
                this.setValue((Double)object);
                return;
            }
            default: {
                super.executeAccessibleAction((AccessibleAction)((Object)object), objectArray);
            }
        }
    }
}

