/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import javafx.beans.NamedArg;
import javafx.beans.property.ObjectProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.SpinnerValueFactory$ListSpinnerValueFactory$1;
import javafx.scene.control.SpinnerValueFactory$ListSpinnerValueFactory$2;

public class SpinnerValueFactory$ListSpinnerValueFactory<T>
extends SpinnerValueFactory<T> {
    private int currentIndex = 0;
    private final ListChangeListener<T> itemsContentObserver = listChangeListener$Change -> this.updateCurrentIndex();
    private WeakListChangeListener<T> weakItemsContentObserver = new WeakListChangeListener<T>(this.itemsContentObserver);
    private ObjectProperty<ObservableList<T>> items;

    public SpinnerValueFactory$ListSpinnerValueFactory(@NamedArg(value="items") ObservableList<T> observableList) {
        this.setItems(observableList);
        this.setConverter(new SpinnerValueFactory$ListSpinnerValueFactory$1(this));
        this.valueProperty().addListener((observableValue, object, object2) -> {
            int n2;
            if (object2 == null) {
                return;
            }
            if (observableList.contains(object2)) {
                n2 = observableList.indexOf(object2);
            } else {
                observableList.add(object2);
                n2 = observableList.indexOf(object2);
            }
            this.currentIndex = n2;
        });
        SpinnerValueFactory$ListSpinnerValueFactory spinnerValueFactory$ListSpinnerValueFactory = this;
        spinnerValueFactory$ListSpinnerValueFactory.setValue(spinnerValueFactory$ListSpinnerValueFactory._getValue(this.currentIndex));
    }

    public final void setItems(ObservableList<T> observableList) {
        this.itemsProperty().set(observableList);
    }

    public final ObservableList<T> getItems() {
        if (this.items == null) {
            return null;
        }
        return (ObservableList)this.items.get();
    }

    public final ObjectProperty<ObservableList<T>> itemsProperty() {
        if (this.items == null) {
            SpinnerValueFactory$ListSpinnerValueFactory spinnerValueFactory$ListSpinnerValueFactory = this;
            this.items = new SpinnerValueFactory$ListSpinnerValueFactory$2(spinnerValueFactory$ListSpinnerValueFactory, spinnerValueFactory$ListSpinnerValueFactory, "items");
        }
        return this.items;
    }

    @Override
    public void decrement(int n2) {
        int n3 = this.getItemsSize() - 1;
        this.currentIndex = (n2 = this.currentIndex - n2) >= 0 ? n2 : (this.isWrapAround() ? Spinner.wrapValue(n2, 0, n3 + 1) : 0);
        SpinnerValueFactory$ListSpinnerValueFactory spinnerValueFactory$ListSpinnerValueFactory = this;
        spinnerValueFactory$ListSpinnerValueFactory.setValue(spinnerValueFactory$ListSpinnerValueFactory._getValue(this.currentIndex));
    }

    @Override
    public void increment(int n2) {
        int n3 = this.getItemsSize() - 1;
        this.currentIndex = (n2 = this.currentIndex + n2) <= n3 ? n2 : (this.isWrapAround() ? Spinner.wrapValue(n2, 0, n3 + 1) : n3);
        SpinnerValueFactory$ListSpinnerValueFactory spinnerValueFactory$ListSpinnerValueFactory = this;
        spinnerValueFactory$ListSpinnerValueFactory.setValue(spinnerValueFactory$ListSpinnerValueFactory._getValue(this.currentIndex));
    }

    private int getItemsSize() {
        ObservableList<T> observableList = this.getItems();
        if (observableList == null) {
            return 0;
        }
        return observableList.size();
    }

    private void updateCurrentIndex() {
        int n2 = this.getItemsSize();
        if (this.currentIndex < 0 || this.currentIndex >= n2) {
            this.currentIndex = 0;
        }
        SpinnerValueFactory$ListSpinnerValueFactory spinnerValueFactory$ListSpinnerValueFactory = this;
        spinnerValueFactory$ListSpinnerValueFactory.setValue(spinnerValueFactory$ListSpinnerValueFactory._getValue(this.currentIndex));
    }

    private T _getValue(int n2) {
        ObservableList<T> observableList = this.getItems();
        if (observableList != null && n2 >= 0 && n2 < observableList.size()) {
            return (T)observableList.get(n2);
        }
        return null;
    }
}

