/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import javafx.beans.NamedArg;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.SpinnerValueFactory$LocalDateSpinnerValueFactory$1;
import javafx.scene.control.SpinnerValueFactory$LocalDateSpinnerValueFactory$2;
import javafx.scene.control.SpinnerValueFactory$LocalDateSpinnerValueFactory$3;

class SpinnerValueFactory$LocalDateSpinnerValueFactory
extends SpinnerValueFactory<LocalDate> {
    private ObjectProperty<LocalDate> min;
    private ObjectProperty<LocalDate> max;
    private ObjectProperty<TemporalUnit> temporalUnit;
    private LongProperty amountToStepBy;

    public SpinnerValueFactory$LocalDateSpinnerValueFactory() {
        this(LocalDate.now());
    }

    public SpinnerValueFactory$LocalDateSpinnerValueFactory(@NamedArg(value="initialValue") LocalDate localDate) {
        this(LocalDate.MIN, LocalDate.MAX, localDate);
    }

    public SpinnerValueFactory$LocalDateSpinnerValueFactory(@NamedArg(value="min") LocalDate localDate, @NamedArg(value="min") LocalDate localDate2, @NamedArg(value="initialValue") LocalDate localDate3) {
        this(localDate, localDate2, localDate3, 1L, ChronoUnit.DAYS);
    }

    public SpinnerValueFactory$LocalDateSpinnerValueFactory(@NamedArg(value="min") LocalDate localDate3, @NamedArg(value="min") LocalDate localDate4, @NamedArg(value="initialValue") LocalDate localDate5, @NamedArg(value="amountToStepBy") long l2, @NamedArg(value="temporalUnit") TemporalUnit temporalUnit) {
        SpinnerValueFactory$LocalDateSpinnerValueFactory spinnerValueFactory$LocalDateSpinnerValueFactory = this;
        this.min = new SpinnerValueFactory$LocalDateSpinnerValueFactory$2(spinnerValueFactory$LocalDateSpinnerValueFactory, spinnerValueFactory$LocalDateSpinnerValueFactory, "min");
        SpinnerValueFactory$LocalDateSpinnerValueFactory spinnerValueFactory$LocalDateSpinnerValueFactory2 = this;
        this.max = new SpinnerValueFactory$LocalDateSpinnerValueFactory$3(spinnerValueFactory$LocalDateSpinnerValueFactory2, spinnerValueFactory$LocalDateSpinnerValueFactory2, "max");
        this.temporalUnit = new SimpleObjectProperty<TemporalUnit>(this, "temporalUnit");
        this.amountToStepBy = new SimpleLongProperty(this, "amountToStepBy");
        this.setMin(localDate3);
        this.setMax(localDate4);
        this.setAmountToStepBy(l2);
        this.setTemporalUnit(temporalUnit);
        this.setConverter(new SpinnerValueFactory$LocalDateSpinnerValueFactory$1(this));
        this.valueProperty().addListener((observableValue, localDate, localDate2) -> {
            if (localDate2 == null) {
                return;
            }
            if (this.getMin() != null && localDate2.isBefore(this.getMin())) {
                SpinnerValueFactory$LocalDateSpinnerValueFactory spinnerValueFactory$LocalDateSpinnerValueFactory = this;
                spinnerValueFactory$LocalDateSpinnerValueFactory.setValue(spinnerValueFactory$LocalDateSpinnerValueFactory.getMin());
                return;
            }
            if (this.getMax() != null && localDate2.isAfter(this.getMax())) {
                SpinnerValueFactory$LocalDateSpinnerValueFactory spinnerValueFactory$LocalDateSpinnerValueFactory = this;
                spinnerValueFactory$LocalDateSpinnerValueFactory.setValue(spinnerValueFactory$LocalDateSpinnerValueFactory.getMax());
            }
        });
        this.setValue(localDate5 != null ? localDate5 : LocalDate.now());
    }

    public final void setMin(LocalDate localDate) {
        this.min.set(localDate);
    }

    public final LocalDate getMin() {
        return (LocalDate)this.min.get();
    }

    public final ObjectProperty<LocalDate> minProperty() {
        return this.min;
    }

    public final void setMax(LocalDate localDate) {
        this.max.set(localDate);
    }

    public final LocalDate getMax() {
        return (LocalDate)this.max.get();
    }

    public final ObjectProperty<LocalDate> maxProperty() {
        return this.max;
    }

    public final void setTemporalUnit(TemporalUnit temporalUnit) {
        this.temporalUnit.set(temporalUnit);
    }

    public final TemporalUnit getTemporalUnit() {
        return (TemporalUnit)this.temporalUnit.get();
    }

    public final ObjectProperty<TemporalUnit> temporalUnitProperty() {
        return this.temporalUnit;
    }

    public final void setAmountToStepBy(long l2) {
        this.amountToStepBy.set(l2);
    }

    public final long getAmountToStepBy() {
        return this.amountToStepBy.get();
    }

    public final LongProperty amountToStepByProperty() {
        return this.amountToStepBy;
    }

    @Override
    public void decrement(int n2) {
        LocalDate localDate = (LocalDate)this.getValue();
        LocalDate localDate2 = this.getMin();
        LocalDate localDate3 = localDate.minus(this.getAmountToStepBy() * (long)n2, this.getTemporalUnit());
        if (localDate2 != null && this.isWrapAround() && localDate3.isBefore(localDate2)) {
            localDate3 = this.getMax();
        }
        this.setValue(localDate3);
    }

    @Override
    public void increment(int n2) {
        LocalDate localDate = (LocalDate)this.getValue();
        LocalDate localDate2 = this.getMax();
        LocalDate localDate3 = localDate.plus(this.getAmountToStepBy() * (long)n2, this.getTemporalUnit());
        if (localDate2 != null && this.isWrapAround() && localDate3.isAfter(localDate2)) {
            localDate3 = this.getMin();
        }
        this.setValue(localDate3);
    }
}

