/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.scene.AccessibleAttribute;
import javafx.scene.control.FocusModel;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableFocusModel;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TablePositionBase;
import javafx.scene.control.TableView;
import javafx.scene.control.TableView$TableViewFocusModel$1;
import javafx.scene.control.TableView$TableViewFocusModel$2;

public class TableView$TableViewFocusModel<S>
extends TableFocusModel<S, TableColumn<S, ?>> {
    private final TableView<S> tableView;
    private final TablePosition<S, ?> EMPTY_CELL;
    private final InvalidationListener itemsObserver;
    private final ListChangeListener<S> itemsContentListener = listChangeListener$Change -> {
        int n2;
        listChangeListener$Change.next();
        if (listChangeListener$Change.wasReplaced() || listChangeListener$Change.getAddedSize() == this.getItemCount()) {
            this.updateDefaultFocus();
            return;
        }
        TablePosition tablePosition = this.getFocusedCell();
        int n3 = tablePosition.getRow();
        if (n3 == -1 || listChangeListener$Change.getFrom() > n3) {
            return;
        }
        listChangeListener$Change.reset();
        n3 = 0;
        boolean bl2 = false;
        int n4 = 0;
        int n5 = 0;
        while (listChangeListener$Change.next()) {
            n3 |= listChangeListener$Change.wasAdded();
            bl2 |= listChangeListener$Change.wasRemoved();
            n4 += listChangeListener$Change.getAddedSize();
            n5 += listChangeListener$Change.getRemovedSize();
        }
        if (n3 != 0 && !bl2) {
            if (n4 >= listChangeListener$Change.getList().size()) return;
            n2 = Math.min(this.getItemCount() - 1, this.getFocusedIndex() + n4);
        } else {
            if (n3 != 0 || !bl2) return;
            n2 = Math.max(0, this.getFocusedIndex() - n5);
            if (n2 < 0) {
                this.focus(0, (TableColumn<S, ?>)tablePosition.getTableColumn());
                return;
            }
        }
        this.focus(n2, (TableColumn<S, ?>)tablePosition.getTableColumn());
    };
    private WeakListChangeListener<S> weakItemsContentListener = new WeakListChangeListener<S>(this.itemsContentListener);
    private ReadOnlyObjectWrapper<TablePosition> focusedCell;

    public TableView$TableViewFocusModel(TableView<S> tableView) {
        if (tableView == null) {
            throw new NullPointerException("TableView can not be null");
        }
        this.tableView = tableView;
        this.EMPTY_CELL = new TablePosition(tableView, -1, null);
        this.itemsObserver = new TableView$TableViewFocusModel$1(this, tableView);
        this.tableView.itemsProperty().addListener(new WeakInvalidationListener(this.itemsObserver));
        if (tableView.getItems() != null) {
            this.tableView.getItems().addListener(this.weakItemsContentListener);
        }
        this.updateDefaultFocus();
        this.focusedCellProperty().addListener(observable -> tableView.notifyAccessibleAttributeChanged(AccessibleAttribute.FOCUS_ITEM));
    }

    private void updateItemsObserver(ObservableList<S> observableList, ObservableList<S> observableList2) {
        if (observableList != null) {
            observableList.removeListener(this.weakItemsContentListener);
        }
        if (observableList2 != null) {
            observableList2.addListener(this.weakItemsContentListener);
        }
        this.updateDefaultFocus();
    }

    @Override
    protected int getItemCount() {
        if (this.tableView.getItems() == null) {
            return -1;
        }
        return this.tableView.getItems().size();
    }

    @Override
    protected S getModelItem(int n2) {
        if (this.tableView.getItems() == null) {
            return null;
        }
        if (n2 < 0 || n2 >= this.getItemCount()) {
            return null;
        }
        return (S)this.tableView.getItems().get(n2);
    }

    public final ReadOnlyObjectProperty<TablePosition> focusedCellProperty() {
        return this.focusedCellPropertyImpl().getReadOnlyProperty();
    }

    private void setFocusedCell(TablePosition tablePosition) {
        this.focusedCellPropertyImpl().set(tablePosition);
    }

    public final TablePosition getFocusedCell() {
        if (this.focusedCell == null) {
            return this.EMPTY_CELL;
        }
        return (TablePosition)this.focusedCell.get();
    }

    private ReadOnlyObjectWrapper<TablePosition> focusedCellPropertyImpl() {
        if (this.focusedCell == null) {
            TableView$TableViewFocusModel tableView$TableViewFocusModel = this;
            this.focusedCell = new TableView$TableViewFocusModel$2(tableView$TableViewFocusModel, tableView$TableViewFocusModel.EMPTY_CELL);
        }
        return this.focusedCell;
    }

    @Override
    public void focus(int n2, TableColumn<S, ?> object) {
        if (n2 < 0 || n2 >= this.getItemCount()) {
            TableView$TableViewFocusModel tableView$TableViewFocusModel = this;
            tableView$TableViewFocusModel.setFocusedCell(tableView$TableViewFocusModel.EMPTY_CELL);
            return;
        }
        TablePosition tablePosition = this.getFocusedCell();
        object = new TablePosition(this.tableView, n2, object);
        this.setFocusedCell((TablePosition)object);
        if (((TablePositionBase)object).equals(tablePosition)) {
            this.setFocusedIndex(n2);
            TableView$TableViewFocusModel tableView$TableViewFocusModel = this;
            tableView$TableViewFocusModel.setFocusedItem(tableView$TableViewFocusModel.getModelItem(n2));
        }
    }

    public void focus(TablePosition tablePosition) {
        if (tablePosition == null) {
            return;
        }
        this.focus(tablePosition.getRow(), (TableColumn<S, ?>)tablePosition.getTableColumn());
    }

    @Override
    public boolean isFocused(int n2, TableColumn<S, ?> tableColumn) {
        boolean bl2;
        if (n2 < 0 || n2 >= this.getItemCount()) {
            return false;
        }
        TablePosition tablePosition = this.getFocusedCell();
        boolean bl3 = bl2 = tableColumn == null || tableColumn.equals(tablePosition.getTableColumn());
        return tablePosition.getRow() == n2 && bl2;
    }

    @Override
    public void focus(int n2) {
        if (n2 < 0 || n2 >= this.getItemCount()) {
            TableView$TableViewFocusModel tableView$TableViewFocusModel = this;
            tableView$TableViewFocusModel.setFocusedCell(tableView$TableViewFocusModel.EMPTY_CELL);
            return;
        }
        this.setFocusedCell(new TablePosition(this.tableView, n2, null));
    }

    @Override
    public void focusAboveCell() {
        TablePosition tablePosition = this.getFocusedCell();
        if (this.getFocusedIndex() == -1) {
            TableView$TableViewFocusModel tableView$TableViewFocusModel = this;
            tableView$TableViewFocusModel.focus(tableView$TableViewFocusModel.getItemCount() - 1, (TableColumn<S, ?>)tablePosition.getTableColumn());
            return;
        }
        if (this.getFocusedIndex() > 0) {
            TableView$TableViewFocusModel tableView$TableViewFocusModel = this;
            tableView$TableViewFocusModel.focus(tableView$TableViewFocusModel.getFocusedIndex() - 1, (TableColumn<S, ?>)tablePosition.getTableColumn());
        }
    }

    @Override
    public void focusBelowCell() {
        TablePosition tablePosition = this.getFocusedCell();
        if (this.getFocusedIndex() == -1) {
            this.focus(0, (TableColumn<S, ?>)tablePosition.getTableColumn());
            return;
        }
        if (this.getFocusedIndex() != this.getItemCount() - 1) {
            TableView$TableViewFocusModel tableView$TableViewFocusModel = this;
            tableView$TableViewFocusModel.focus(tableView$TableViewFocusModel.getFocusedIndex() + 1, (TableColumn<S, ?>)tablePosition.getTableColumn());
        }
    }

    @Override
    public void focusLeftCell() {
        TablePosition tablePosition = this.getFocusedCell();
        if (((TablePositionBase)tablePosition).getColumn() <= 0) {
            return;
        }
        this.focus(tablePosition.getRow(), this.getTableColumn((TableColumn<S, ?>)tablePosition.getTableColumn(), -1));
    }

    @Override
    public void focusRightCell() {
        TablePosition tablePosition = this.getFocusedCell();
        if (((TablePositionBase)tablePosition).getColumn() == this.getColumnCount() - 1) {
            return;
        }
        this.focus(tablePosition.getRow(), this.getTableColumn((TableColumn<S, ?>)tablePosition.getTableColumn(), 1));
    }

    @Override
    public void focusPrevious() {
        if (this.getFocusedIndex() == -1) {
            ((FocusModel)this).focus(0);
            return;
        }
        if (this.getFocusedIndex() > 0) {
            ((TableFocusModel)this).focusAboveCell();
        }
    }

    @Override
    public void focusNext() {
        if (this.getFocusedIndex() == -1) {
            ((FocusModel)this).focus(0);
            return;
        }
        if (this.getFocusedIndex() != this.getItemCount() - 1) {
            ((TableFocusModel)this).focusBelowCell();
        }
    }

    private void updateDefaultFocus() {
        Object object;
        int n2 = -1;
        if (this.tableView.getItems() != null) {
            object = this.getFocusedItem();
            if (object != null) {
                n2 = this.tableView.getItems().indexOf(object);
            }
            if (n2 == -1) {
                n2 = this.tableView.getItems().size() > 0 ? 0 : -1;
            }
        }
        object = (object = this.getFocusedCell()) != null && !this.EMPTY_CELL.equals(object) ? ((TablePosition)object).getTableColumn() : this.tableView.getVisibleLeafColumn(0);
        this.focus(n2, (TableColumn<S, ?>)object);
    }

    private int getColumnCount() {
        return this.tableView.getVisibleLeafColumns().size();
    }

    private TableColumn<S, ?> getTableColumn(TableColumn<S, ?> tableColumn, int n2) {
        int n3 = this.tableView.getVisibleLeafIndex(tableColumn);
        return this.tableView.getVisibleLeafColumn(n3 += n2);
    }
}

