/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.collections.NonIterableChange$GenericAddRemoveChange;
import com.sun.javafx.scene.control.ConstrainedColumnResize;
import com.sun.javafx.scene.control.ConstrainedColumnResize$ResizeMode;
import com.sun.javafx.scene.control.TableColumnComparatorBase$TableColumnComparator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import javafx.beans.DefaultProperty;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ControlUtils;
import javafx.scene.control.MultipleSelectionModelBase;
import javafx.scene.control.ScrollToEvent;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Skin;
import javafx.scene.control.SortEvent;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableUtil;
import javafx.scene.control.TableUtil$SortEventType;
import javafx.scene.control.TableView$1;
import javafx.scene.control.TableView$10;
import javafx.scene.control.TableView$11;
import javafx.scene.control.TableView$12;
import javafx.scene.control.TableView$2;
import javafx.scene.control.TableView$3;
import javafx.scene.control.TableView$4;
import javafx.scene.control.TableView$5;
import javafx.scene.control.TableView$6;
import javafx.scene.control.TableView$7;
import javafx.scene.control.TableView$8;
import javafx.scene.control.TableView$9;
import javafx.scene.control.TableView$ResizeFeatures;
import javafx.scene.control.TableView$StyleableProperties;
import javafx.scene.control.TableView$TableViewArrayListSelectionModel;
import javafx.scene.control.TableView$TableViewFocusModel;
import javafx.scene.control.TableView$TableViewSelectionModel;
import javafx.scene.control.skin.TableViewSkin;
import javafx.util.Callback;

@DefaultProperty(value="items")
public class TableView<S>
extends Control {
    static final String SET_CONTENT_WIDTH = "TableView.contentWidth";
    public static final Callback<TableView$ResizeFeatures, Boolean> UNCONSTRAINED_RESIZE_POLICY = new TableView$1();
    public static final Callback<TableView$ResizeFeatures, Boolean> CONSTRAINED_RESIZE_POLICY_ALL_COLUMNS = ConstrainedColumnResize.forTable(ConstrainedColumnResize$ResizeMode.AUTO_RESIZE_ALL_COLUMNS);
    public static final Callback<TableView$ResizeFeatures, Boolean> CONSTRAINED_RESIZE_POLICY_LAST_COLUMN = ConstrainedColumnResize.forTable(ConstrainedColumnResize$ResizeMode.AUTO_RESIZE_LAST_COLUMN);
    public static final Callback<TableView$ResizeFeatures, Boolean> CONSTRAINED_RESIZE_POLICY_NEXT_COLUMN = ConstrainedColumnResize.forTable(ConstrainedColumnResize$ResizeMode.AUTO_RESIZE_NEXT_COLUMN);
    public static final Callback<TableView$ResizeFeatures, Boolean> CONSTRAINED_RESIZE_POLICY_SUBSEQUENT_COLUMNS = ConstrainedColumnResize.forTable(ConstrainedColumnResize$ResizeMode.AUTO_RESIZE_SUBSEQUENT_COLUMNS);
    public static final Callback<TableView$ResizeFeatures, Boolean> CONSTRAINED_RESIZE_POLICY_FLEX_NEXT_COLUMN = ConstrainedColumnResize.forTable(ConstrainedColumnResize$ResizeMode.AUTO_RESIZE_FLEX_HEAD);
    public static final Callback<TableView$ResizeFeatures, Boolean> CONSTRAINED_RESIZE_POLICY_FLEX_LAST_COLUMN;
    @Deprecated(since="20")
    public static final Callback<TableView$ResizeFeatures, Boolean> CONSTRAINED_RESIZE_POLICY;
    public static final Callback<TableView, Boolean> DEFAULT_SORT_POLICY;
    private final ObservableList<TableColumn<S, ?>> columns = FXCollections.observableArrayList();
    private final ObservableList<TableColumn<S, ?>> visibleLeafColumns = FXCollections.observableArrayList();
    private final ObservableList<TableColumn<S, ?>> unmodifiableVisibleLeafColumns = FXCollections.unmodifiableObservableList(this.visibleLeafColumns);
    private ObservableList<TableColumn<S, ?>> sortOrder = FXCollections.observableArrayList();
    private double contentWidth;
    private boolean isInited = false;
    private final ListChangeListener<TableColumn<S, ?>> columnsObserver = new TableView$4(this);
    private final WeakHashMap<TableColumn<S, ?>, Integer> lastKnownColumnIndex = new WeakHashMap();
    private final InvalidationListener columnVisibleObserver = observable -> this.updateVisibleLeafColumns();
    private final InvalidationListener columnSortableObserver = object -> {
        object = ((Property)object).getBean();
        if (!this.getSortOrder().contains(object)) {
            return;
        }
        this.doSort(TableUtil$SortEventType.COLUMN_SORTABLE_CHANGE, object);
    };
    private final InvalidationListener columnSortTypeObserver = object -> {
        object = ((Property)object).getBean();
        if (!this.getSortOrder().contains(object)) {
            return;
        }
        this.doSort(TableUtil$SortEventType.COLUMN_SORT_TYPE_CHANGE, object);
    };
    private final InvalidationListener columnComparatorObserver = object -> {
        object = ((Property)object).getBean();
        if (!this.getSortOrder().contains(object)) {
            return;
        }
        this.doSort(TableUtil$SortEventType.COLUMN_COMPARATOR_CHANGE, object);
    };
    private final InvalidationListener cellSelectionModelInvalidationListener = observable -> {
        boolean bl2 = ((BooleanProperty)observable).get();
        this.pseudoClassStateChanged(PSEUDO_CLASS_CELL_SELECTION, bl2);
        this.pseudoClassStateChanged(PSEUDO_CLASS_ROW_SELECTION, !bl2);
    };
    private final WeakInvalidationListener weakColumnVisibleObserver = new WeakInvalidationListener(this.columnVisibleObserver);
    private final WeakInvalidationListener weakColumnSortableObserver = new WeakInvalidationListener(this.columnSortableObserver);
    private final WeakInvalidationListener weakColumnSortTypeObserver = new WeakInvalidationListener(this.columnSortTypeObserver);
    private final WeakInvalidationListener weakColumnComparatorObserver = new WeakInvalidationListener(this.columnComparatorObserver);
    private final WeakListChangeListener<TableColumn<S, ?>> weakColumnsObserver = new WeakListChangeListener(this.columnsObserver);
    private final WeakInvalidationListener weakCellSelectionModelInvalidationListener = new WeakInvalidationListener(this.cellSelectionModelInvalidationListener);
    private ObjectProperty<ObservableList<S>> items;
    private BooleanProperty tableMenuButtonVisible;
    private ObjectProperty<Callback<TableView$ResizeFeatures, Boolean>> columnResizePolicy;
    private ObjectProperty<Callback<TableView<S>, TableRow<S>>> rowFactory;
    private ObjectProperty<Node> placeholder;
    private ObjectProperty<TableView$TableViewSelectionModel<S>> selectionModel;
    private ObjectProperty<TableView$TableViewFocusModel<S>> focusModel;
    private BooleanProperty editable;
    private DoubleProperty fixedCellSize;
    private ReadOnlyObjectWrapper<TablePosition<S, ?>> editingCell;
    private ReadOnlyObjectWrapper<Comparator<S>> comparator;
    private ObjectProperty<Callback<TableView<S>, Boolean>> sortPolicy;
    private ObjectProperty<EventHandler<SortEvent<TableView<S>>>> onSort;
    private ObjectProperty<EventHandler<ScrollToEvent<Integer>>> onScrollTo;
    private ObjectProperty<EventHandler<ScrollToEvent<TableColumn<S, ?>>>> onScrollToColumn;
    private boolean sortLock;
    private TableUtil$SortEventType lastSortEventType;
    private Object[] lastSortEventSupportInfo;
    private static final String DEFAULT_STYLE_CLASS = "table-view";
    private static final PseudoClass PSEUDO_CLASS_CELL_SELECTION;
    private static final PseudoClass PSEUDO_CLASS_ROW_SELECTION;

    public TableView() {
        this(FXCollections.observableArrayList());
    }

    public TableView(ObservableList<S> observableList) {
        TableView tableView = this;
        this.items = new TableView$5(tableView, tableView, "items");
        TableView tableView2 = this;
        this.selectionModel = new TableView$7(tableView2, tableView2, "selectionModel");
        this.sortLock = false;
        this.lastSortEventType = null;
        this.lastSortEventSupportInfo = null;
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setAccessibleRole(AccessibleRole.TABLE_VIEW);
        this.setItems(observableList);
        this.setSelectionModel(new TableView$TableViewArrayListSelectionModel(this));
        this.setFocusModel(new TableView$TableViewFocusModel(this));
        this.getColumns().addListener(this.weakColumnsObserver);
        this.getSortOrder().addListener(listChangeListener$Change -> this.doSort(TableUtil$SortEventType.SORT_ORDER_CHANGE, listChangeListener$Change));
        this.getProperties().addListener(new TableView$3(this));
        TableView tableView3 = this;
        tableView3.pseudoClassStateChanged(PseudoClass.getPseudoClass(tableView3.getColumnResizePolicy().toString()), true);
        this.isInited = true;
    }

    public final ObjectProperty<ObservableList<S>> itemsProperty() {
        return this.items;
    }

    public final void setItems(ObservableList<S> observableList) {
        this.itemsProperty().set(observableList);
    }

    public final ObservableList<S> getItems() {
        return (ObservableList)this.items.get();
    }

    public final BooleanProperty tableMenuButtonVisibleProperty() {
        if (this.tableMenuButtonVisible == null) {
            this.tableMenuButtonVisible = new SimpleBooleanProperty(this, "tableMenuButtonVisible");
        }
        return this.tableMenuButtonVisible;
    }

    public final void setTableMenuButtonVisible(boolean bl2) {
        this.tableMenuButtonVisibleProperty().set(bl2);
    }

    public final boolean isTableMenuButtonVisible() {
        if (this.tableMenuButtonVisible == null) {
            return false;
        }
        return this.tableMenuButtonVisible.get();
    }

    public final void setColumnResizePolicy(Callback<TableView$ResizeFeatures, Boolean> callback) {
        this.columnResizePolicyProperty().set(callback);
    }

    public final Callback<TableView$ResizeFeatures, Boolean> getColumnResizePolicy() {
        if (this.columnResizePolicy == null) {
            return UNCONSTRAINED_RESIZE_POLICY;
        }
        return (Callback)this.columnResizePolicy.get();
    }

    public final ObjectProperty<Callback<TableView$ResizeFeatures, Boolean>> columnResizePolicyProperty() {
        if (this.columnResizePolicy == null) {
            TableView tableView = this;
            this.columnResizePolicy = new TableView$6(tableView, tableView, "columnResizePolicy", UNCONSTRAINED_RESIZE_POLICY);
        }
        return this.columnResizePolicy;
    }

    public final ObjectProperty<Callback<TableView<S>, TableRow<S>>> rowFactoryProperty() {
        if (this.rowFactory == null) {
            this.rowFactory = new SimpleObjectProperty<Callback<TableView<S>, TableRow<S>>>(this, "rowFactory");
        }
        return this.rowFactory;
    }

    public final void setRowFactory(Callback<TableView<S>, TableRow<S>> callback) {
        this.rowFactoryProperty().set(callback);
    }

    public final Callback<TableView<S>, TableRow<S>> getRowFactory() {
        if (this.rowFactory == null) {
            return null;
        }
        return (Callback)this.rowFactory.get();
    }

    public final ObjectProperty<Node> placeholderProperty() {
        if (this.placeholder == null) {
            this.placeholder = new SimpleObjectProperty<Node>(this, "placeholder");
        }
        return this.placeholder;
    }

    public final void setPlaceholder(Node node) {
        this.placeholderProperty().set(node);
    }

    public final Node getPlaceholder() {
        if (this.placeholder == null) {
            return null;
        }
        return (Node)this.placeholder.get();
    }

    public final ObjectProperty<TableView$TableViewSelectionModel<S>> selectionModelProperty() {
        return this.selectionModel;
    }

    public final void setSelectionModel(TableView$TableViewSelectionModel<S> tableView$TableViewSelectionModel) {
        this.selectionModelProperty().set(tableView$TableViewSelectionModel);
    }

    public final TableView$TableViewSelectionModel<S> getSelectionModel() {
        return (TableView$TableViewSelectionModel)this.selectionModel.get();
    }

    public final void setFocusModel(TableView$TableViewFocusModel<S> tableView$TableViewFocusModel) {
        this.focusModelProperty().set(tableView$TableViewFocusModel);
    }

    public final TableView$TableViewFocusModel<S> getFocusModel() {
        if (this.focusModel == null) {
            return null;
        }
        return (TableView$TableViewFocusModel)this.focusModel.get();
    }

    public final ObjectProperty<TableView$TableViewFocusModel<S>> focusModelProperty() {
        if (this.focusModel == null) {
            this.focusModel = new SimpleObjectProperty<TableView$TableViewFocusModel<S>>(this, "focusModel");
        }
        return this.focusModel;
    }

    public final void setEditable(boolean bl2) {
        this.editableProperty().set(bl2);
    }

    public final boolean isEditable() {
        if (this.editable == null) {
            return false;
        }
        return this.editable.get();
    }

    public final BooleanProperty editableProperty() {
        if (this.editable == null) {
            this.editable = new SimpleBooleanProperty(this, "editable", false);
        }
        return this.editable;
    }

    public final void setFixedCellSize(double d2) {
        this.fixedCellSizeProperty().set(d2);
    }

    public final double getFixedCellSize() {
        if (this.fixedCellSize == null) {
            return -1.0;
        }
        return this.fixedCellSize.get();
    }

    public final DoubleProperty fixedCellSizeProperty() {
        if (this.fixedCellSize == null) {
            this.fixedCellSize = new TableView$8(this, -1.0);
        }
        return this.fixedCellSize;
    }

    private void setEditingCell(TablePosition<S, ?> tablePosition) {
        this.editingCellPropertyImpl().set(tablePosition);
    }

    public final TablePosition<S, ?> getEditingCell() {
        if (this.editingCell == null) {
            return null;
        }
        return (TablePosition)this.editingCell.get();
    }

    public final ReadOnlyObjectProperty<TablePosition<S, ?>> editingCellProperty() {
        return this.editingCellPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<TablePosition<S, ?>> editingCellPropertyImpl() {
        if (this.editingCell == null) {
            this.editingCell = new ReadOnlyObjectWrapper(this, "editingCell");
        }
        return this.editingCell;
    }

    private void setComparator(Comparator<S> comparator) {
        this.comparatorPropertyImpl().set(comparator);
    }

    public final Comparator<S> getComparator() {
        if (this.comparator == null) {
            return null;
        }
        return (Comparator)this.comparator.get();
    }

    public final ReadOnlyObjectProperty<Comparator<S>> comparatorProperty() {
        return this.comparatorPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<Comparator<S>> comparatorPropertyImpl() {
        if (this.comparator == null) {
            this.comparator = new ReadOnlyObjectWrapper(this, "comparator");
        }
        return this.comparator;
    }

    public final void setSortPolicy(Callback<TableView<S>, Boolean> callback) {
        this.sortPolicyProperty().set(callback);
    }

    public final Callback<TableView<S>, Boolean> getSortPolicy() {
        if (this.sortPolicy == null) {
            return DEFAULT_SORT_POLICY;
        }
        return (Callback)this.sortPolicy.get();
    }

    public final ObjectProperty<Callback<TableView<S>, Boolean>> sortPolicyProperty() {
        if (this.sortPolicy == null) {
            TableView tableView = this;
            this.sortPolicy = new TableView$9(tableView, tableView, "sortPolicy", DEFAULT_SORT_POLICY);
        }
        return this.sortPolicy;
    }

    public void setOnSort(EventHandler<SortEvent<TableView<S>>> eventHandler) {
        this.onSortProperty().set(eventHandler);
    }

    public EventHandler<SortEvent<TableView<S>>> getOnSort() {
        if (this.onSort != null) {
            return (EventHandler)this.onSort.get();
        }
        return null;
    }

    public ObjectProperty<EventHandler<SortEvent<TableView<S>>>> onSortProperty() {
        if (this.onSort == null) {
            this.onSort = new TableView$10(this);
        }
        return this.onSort;
    }

    public final ObservableList<TableColumn<S, ?>> getColumns() {
        return this.columns;
    }

    public final ObservableList<TableColumn<S, ?>> getSortOrder() {
        return this.sortOrder;
    }

    public void scrollTo(int n2) {
        ControlUtils.scrollToIndex(this, n2);
    }

    public void scrollTo(S s2) {
        int n2;
        if (this.getItems() != null && (n2 = this.getItems().indexOf(s2)) >= 0) {
            ControlUtils.scrollToIndex(this, n2);
        }
    }

    public void setOnScrollTo(EventHandler<ScrollToEvent<Integer>> eventHandler) {
        this.onScrollToProperty().set(eventHandler);
    }

    public EventHandler<ScrollToEvent<Integer>> getOnScrollTo() {
        if (this.onScrollTo != null) {
            return (EventHandler)this.onScrollTo.get();
        }
        return null;
    }

    public ObjectProperty<EventHandler<ScrollToEvent<Integer>>> onScrollToProperty() {
        if (this.onScrollTo == null) {
            this.onScrollTo = new TableView$11(this);
        }
        return this.onScrollTo;
    }

    public void scrollToColumn(TableColumn<S, ?> tableColumn) {
        ControlUtils.scrollToColumn(this, tableColumn);
    }

    public void scrollToColumnIndex(int n2) {
        if (this.getColumns() != null) {
            TableView tableView = this;
            ControlUtils.scrollToColumn(tableView, (TableColumnBase)tableView.getColumns().get(n2));
        }
    }

    public void setOnScrollToColumn(EventHandler<ScrollToEvent<TableColumn<S, ?>>> eventHandler) {
        this.onScrollToColumnProperty().set(eventHandler);
    }

    public EventHandler<ScrollToEvent<TableColumn<S, ?>>> getOnScrollToColumn() {
        if (this.onScrollToColumn != null) {
            return (EventHandler)this.onScrollToColumn.get();
        }
        return null;
    }

    public ObjectProperty<EventHandler<ScrollToEvent<TableColumn<S, ?>>>> onScrollToColumnProperty() {
        if (this.onScrollToColumn == null) {
            this.onScrollToColumn = new TableView$12(this);
        }
        return this.onScrollToColumn;
    }

    public boolean resizeColumn(TableColumn<S, ?> tableColumn, double d2) {
        if (tableColumn == null || Double.compare(d2, 0.0) == 0) {
            return false;
        }
        boolean bl2 = this.getColumnResizePolicy().call(new TableView$ResizeFeatures<S>(this, tableColumn, d2));
        return bl2;
    }

    public void edit(int n2, TableColumn<S, ?> tableColumn) {
        if (!this.isEditable() || tableColumn != null && !tableColumn.isEditable()) {
            return;
        }
        if (n2 < 0 && tableColumn == null) {
            this.setEditingCell(null);
            return;
        }
        this.setEditingCell(new TablePosition(this, n2, tableColumn));
    }

    public ObservableList<TableColumn<S, ?>> getVisibleLeafColumns() {
        return this.unmodifiableVisibleLeafColumns;
    }

    public int getVisibleLeafIndex(TableColumn<S, ?> tableColumn) {
        return this.visibleLeafColumns.indexOf(tableColumn);
    }

    public TableColumn<S, ?> getVisibleLeafColumn(int n2) {
        if (n2 < 0 || n2 >= this.visibleLeafColumns.size()) {
            return null;
        }
        return (TableColumn)this.visibleLeafColumns.get(n2);
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new TableViewSkin(this);
    }

    public void sort() {
        Iterator iterator;
        ArrayList<TablePosition> arrayList;
        Object object = this.getSortOrder();
        Object object2 = this.getComparator();
        this.setComparator(object.isEmpty() ? null : new TableColumnComparatorBase$TableColumnComparator(object));
        TableView tableView = this;
        Object object3 = new SortEvent<TableView>(tableView, tableView);
        this.fireEvent((Event)object3);
        if (((Event)object3).isConsumed()) {
            return;
        }
        object3 = this.getSelectionModel();
        ArrayList<TablePosition> arrayList2 = arrayList = object3 == null ? null : new ArrayList<TablePosition>(((TableView$TableViewSelectionModel)object3).getSelectedCells());
        if (object3 != null) {
            ((MultipleSelectionModelBase)object3).startAtomic();
        }
        if ((iterator = this.getSortPolicy()) == null) {
            return;
        }
        iterator = iterator.call(this);
        if (object3 != null) {
            ((MultipleSelectionModelBase)object3).stopAtomic();
        }
        if (iterator == null || !((Boolean)((Object)iterator)).booleanValue()) {
            this.sortLock = true;
            TableUtil.handleSortFailure(object, this.lastSortEventType, this.lastSortEventSupportInfo);
            this.setComparator((Comparator<S>)object2);
            this.sortLock = false;
            return;
        }
        if (object3 instanceof TableView$TableViewArrayListSelectionModel) {
            object = (TableView$TableViewArrayListSelectionModel)object3;
            object2 = ((TableView$TableViewSelectionModel)object).getSelectedCells();
            object3 = new ArrayList<TablePosition>();
            if (arrayList != null) {
                for (TablePosition object4 : arrayList) {
                    if (object2.contains(object4)) continue;
                    object3.add(object4);
                }
            }
            if (!object3.isEmpty()) {
                int n2 = arrayList == null ? 0 : arrayList.size();
                NonIterableChange$GenericAddRemoveChange nonIterableChange$GenericAddRemoveChange = new NonIterableChange$GenericAddRemoveChange(0, n2, object3, object2);
                ((TableView$TableViewArrayListSelectionModel)object).fireCustomSelectedCellsListChangeEvent(nonIterableChange$GenericAddRemoveChange);
            }
        }
    }

    public void refresh() {
        this.getProperties().put("recreateKey", Boolean.TRUE);
    }

    private void doSort(TableUtil$SortEventType tableUtil$SortEventType, Object ... objectArray) {
        if (this.sortLock) {
            return;
        }
        this.lastSortEventType = tableUtil$SortEventType;
        this.lastSortEventSupportInfo = objectArray;
        this.sort();
        this.lastSortEventType = null;
        this.lastSortEventSupportInfo = null;
    }

    private void setContentWidth(double d2) {
        this.contentWidth = d2;
        if (this.isInited) {
            this.getColumnResizePolicy().call(new TableView$ResizeFeatures(this, null, 0.0));
        }
    }

    private void updateVisibleLeafColumns() {
        ArrayList arrayList = new ArrayList();
        TableView tableView = this;
        tableView.buildVisibleLeafColumns(tableView.getColumns(), arrayList);
        this.visibleLeafColumns.setAll(arrayList);
        this.getColumnResizePolicy().call(new TableView$ResizeFeatures(this, null, 0.0));
    }

    private void buildVisibleLeafColumns(List<TableColumn<S, ?>> object, List<TableColumn<S, ?>> list) {
        object = object.iterator();
        while (object.hasNext()) {
            TableColumn tableColumn = (TableColumn)object.next();
            if (tableColumn == null) continue;
            boolean bl2 = !((TableColumnBase)tableColumn).getColumns().isEmpty();
            if (bl2) {
                this.buildVisibleLeafColumns(((TableColumnBase)tableColumn).getColumns(), list);
                continue;
            }
            if (!tableColumn.isVisible()) continue;
            list.add(tableColumn);
        }
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return TableView$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return TableView.getClassCssMetaData();
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objectArray) {
        switch (accessibleAttribute) {
            case COLUMN_COUNT: {
                return this.getVisibleLeafColumns().size();
            }
            case ROW_COUNT: {
                return this.getItems().size();
            }
            case SELECTED_ITEMS: {
                Object object = (ObservableList)super.queryAccessibleAttribute(accessibleAttribute, objectArray);
                ArrayList arrayList = new ArrayList();
                if (object != null) {
                    object = object.iterator();
                    while (object.hasNext()) {
                        Object object2 = (TableRow)object.next();
                        if ((object2 = (ObservableList)((Node)object2).queryAccessibleAttribute(accessibleAttribute, objectArray)) == null) continue;
                        arrayList.addAll(object2);
                    }
                }
                return FXCollections.observableArrayList(arrayList);
            }
            case FOCUS_ITEM: {
                Node node = (Node)super.queryAccessibleAttribute(accessibleAttribute, objectArray);
                if (node == null) {
                    return null;
                }
                Node node2 = (Node)node.queryAccessibleAttribute(accessibleAttribute, objectArray);
                if (node2 != null) {
                    return node2;
                }
                return node;
            }
            case CELL_AT_ROW_COLUMN: {
                TableRow tableRow = (TableRow)super.queryAccessibleAttribute(accessibleAttribute, objectArray);
                if (tableRow != null) {
                    return ((Node)tableRow).queryAccessibleAttribute(accessibleAttribute, objectArray);
                }
                return null;
            }
            case MULTIPLE_SELECTION: {
                TableView$TableViewSelectionModel<S> tableView$TableViewSelectionModel = this.getSelectionModel();
                return tableView$TableViewSelectionModel != null && tableView$TableViewSelectionModel.getSelectionMode() == SelectionMode.MULTIPLE;
            }
        }
        return super.queryAccessibleAttribute(accessibleAttribute, objectArray);
    }

    static /* synthetic */ void access$000(TableView tableView, EventType eventType, EventHandler eventHandler) {
        tableView.setEventHandler(eventType, eventHandler);
    }

    static /* synthetic */ void access$100(TableView tableView, EventType eventType, EventHandler eventHandler) {
        tableView.setEventHandler(eventType, eventHandler);
    }

    static /* synthetic */ void access$200(TableView tableView, EventType eventType, EventHandler eventHandler) {
        tableView.setEventHandler(eventType, eventHandler);
    }

    static {
        CONSTRAINED_RESIZE_POLICY = CONSTRAINED_RESIZE_POLICY_FLEX_LAST_COLUMN = ConstrainedColumnResize.forTable(ConstrainedColumnResize$ResizeMode.AUTO_RESIZE_FLEX_TAIL);
        DEFAULT_SORT_POLICY = new TableView$2();
        PSEUDO_CLASS_CELL_SELECTION = PseudoClass.getPseudoClass("cell-selection");
        PSEUDO_CLASS_ROW_SELECTION = PseudoClass.getPseudoClass("row-selection");
    }
}

