/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import java.util.EventObject;
import javafx.animation.Animation;
import javafx.animation.Animation$Status;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.event.EventHandler;
import javafx.geometry.NodeOrientation;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.stage.Window;

class Tooltip$TooltipBehavior {
    private Timeline activationTimer = new Timeline();
    private Timeline hideTimer = new Timeline();
    private Timeline leftTimer = new Timeline();
    private Node hoveredNode;
    private Tooltip activatedTooltip;
    private Tooltip visibleTooltip;
    private double lastMouseX;
    private double lastMouseY;
    private boolean hideOnExit;
    private boolean cssForced = false;
    private EventHandler<MouseEvent> MOVE_HANDLER = mouseEvent -> {
        this.lastMouseX = mouseEvent.getScreenX();
        this.lastMouseY = mouseEvent.getScreenY();
        if (this.hideTimer.getStatus() == Animation$Status.RUNNING) {
            return;
        }
        this.hoveredNode = (Node)mouseEvent.getSource();
        Tooltip tooltip = (Tooltip)this.hoveredNode.getProperties().get(Tooltip.TOOLTIP_PROP_KEY);
        if (tooltip != null) {
            Tooltip$TooltipBehavior tooltip$TooltipBehavior = this;
            Window window = tooltip$TooltipBehavior.getWindow(tooltip$TooltipBehavior.hoveredNode);
            Tooltip$TooltipBehavior tooltip$TooltipBehavior2 = this;
            boolean bl2 = tooltip$TooltipBehavior2.isWindowHierarchyVisible(tooltip$TooltipBehavior2.hoveredNode);
            if (window != null && bl2) {
                if (this.leftTimer.getStatus() == Animation$Status.RUNNING) {
                    if (this.visibleTooltip != null) {
                        ((Window)this.visibleTooltip).hide();
                    }
                    this.visibleTooltip = tooltip;
                    tooltip.show(window, mouseEvent.getScreenX() + (double)Tooltip.TOOLTIP_XOFFSET, mouseEvent.getScreenY() + (double)Tooltip.TOOLTIP_YOFFSET);
                    ((Animation)this.leftTimer).stop();
                    if (tooltip.getShowDuration() != null) {
                        this.hideTimer.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{new KeyFrame(tooltip.getShowDuration(), new KeyValue[0])});
                    }
                    this.hideTimer.playFromStart();
                    return;
                }
                if (!this.cssForced) {
                    double d2 = tooltip.getOpacity();
                    tooltip.setOpacity(0.0);
                    tooltip.show(window);
                    ((Window)tooltip).hide();
                    tooltip.setOpacity(d2);
                    this.cssForced = true;
                }
                tooltip.setActivated(true);
                this.activatedTooltip = tooltip;
                ((Animation)this.activationTimer).stop();
                if (tooltip.getShowDelay() != null) {
                    this.activationTimer.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{new KeyFrame(tooltip.getShowDelay(), new KeyValue[0])});
                }
                this.activationTimer.playFromStart();
            }
        }
    };
    private EventHandler<MouseEvent> LEAVING_HANDLER = object -> {
        if (this.activationTimer.getStatus() == Animation$Status.RUNNING) {
            ((Animation)this.activationTimer).stop();
        } else if (this.hideTimer.getStatus() == Animation$Status.RUNNING) {
            if (!$assertionsDisabled && this.visibleTooltip == null) {
                throw new AssertionError();
            }
            ((Animation)this.hideTimer).stop();
            if (this.hideOnExit) {
                ((Window)this.visibleTooltip).hide();
            }
            object = (Node)((EventObject)object).getSource();
            if ((object = (Tooltip)((Node)((Object)object)).getProperties().get(Tooltip.TOOLTIP_PROP_KEY)) != null) {
                if (((Tooltip)((Object)object)).getHideDelay() != null) {
                    this.leftTimer.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{new KeyFrame(((Tooltip)((Object)object)).getHideDelay(), new KeyValue[0])});
                }
                this.leftTimer.playFromStart();
            }
        }
        this.hoveredNode = null;
        this.activatedTooltip = null;
        if (this.hideOnExit) {
            this.visibleTooltip = null;
        }
    };
    private EventHandler<MouseEvent> KILL_HANDLER = mouseEvent -> {
        ((Animation)this.activationTimer).stop();
        ((Animation)this.hideTimer).stop();
        ((Animation)this.leftTimer).stop();
        if (this.visibleTooltip != null) {
            ((Window)this.visibleTooltip).hide();
        }
        this.hoveredNode = null;
        this.activatedTooltip = null;
        this.visibleTooltip = null;
    };
    static final /* synthetic */ boolean $assertionsDisabled;

    Tooltip$TooltipBehavior(boolean bl2) {
        this.hideOnExit = bl2;
        this.activationTimer.setOnFinished(object -> {
            if (!$assertionsDisabled && this.activatedTooltip == null) {
                throw new AssertionError();
            }
            Tooltip$TooltipBehavior tooltip$TooltipBehavior = this;
            object = tooltip$TooltipBehavior.getWindow(tooltip$TooltipBehavior.hoveredNode);
            Tooltip$TooltipBehavior tooltip$TooltipBehavior2 = this;
            boolean bl2 = tooltip$TooltipBehavior2.isWindowHierarchyVisible(tooltip$TooltipBehavior2.hoveredNode);
            if (object != null && ((Window)((Object)object)).isShowing() && bl2) {
                double d2 = this.lastMouseX;
                double d3 = this.lastMouseY;
                NodeOrientation nodeOrientation = this.hoveredNode.getEffectiveNodeOrientation();
                this.activatedTooltip.getScene().setNodeOrientation(nodeOrientation);
                if (nodeOrientation == NodeOrientation.RIGHT_TO_LEFT) {
                    d2 -= this.activatedTooltip.getWidth();
                }
                this.activatedTooltip.show((Window)((Object)object), d2 + (double)Tooltip.TOOLTIP_XOFFSET, d3 + (double)Tooltip.TOOLTIP_YOFFSET);
                if (d3 + (double)Tooltip.TOOLTIP_YOFFSET > this.activatedTooltip.getAnchorY()) {
                    ((Window)this.activatedTooltip).hide();
                    this.activatedTooltip.show((Window)((Object)object), d2 + (double)Tooltip.TOOLTIP_XOFFSET, d3 -= this.activatedTooltip.getHeight());
                }
                this.visibleTooltip = this.activatedTooltip;
                this.hoveredNode = null;
                if (this.activatedTooltip.getShowDuration() != null) {
                    this.hideTimer.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{new KeyFrame(this.activatedTooltip.getShowDuration(), new KeyValue[0])});
                }
                this.hideTimer.playFromStart();
            }
            this.activatedTooltip.setActivated(false);
            this.activatedTooltip = null;
        });
        this.hideTimer.setOnFinished(actionEvent -> {
            if (!$assertionsDisabled && this.visibleTooltip == null) {
                throw new AssertionError();
            }
            ((Window)this.visibleTooltip).hide();
            this.visibleTooltip = null;
            this.hoveredNode = null;
        });
        this.leftTimer.setOnFinished(actionEvent -> {
            if (!bl2) {
                if (!$assertionsDisabled && this.visibleTooltip == null) {
                    throw new AssertionError();
                }
                ((Window)this.visibleTooltip).hide();
                this.visibleTooltip = null;
                this.hoveredNode = null;
            }
        });
    }

    private void install(Node node, Tooltip tooltip) {
        if (node == null) {
            return;
        }
        node.addEventHandler(MouseEvent.MOUSE_MOVED, this.MOVE_HANDLER);
        node.addEventHandler(MouseEvent.MOUSE_EXITED, this.LEAVING_HANDLER);
        node.addEventHandler(MouseEvent.MOUSE_PRESSED, this.KILL_HANDLER);
        node.getProperties().put(Tooltip.TOOLTIP_PROP_KEY, tooltip);
    }

    private void uninstall(Node node) {
        if (node == null) {
            return;
        }
        node.removeEventHandler(MouseEvent.MOUSE_MOVED, this.MOVE_HANDLER);
        node.removeEventHandler(MouseEvent.MOUSE_EXITED, this.LEAVING_HANDLER);
        node.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.KILL_HANDLER);
        Tooltip tooltip = (Tooltip)node.getProperties().get(Tooltip.TOOLTIP_PROP_KEY);
        if (tooltip != null) {
            node.getProperties().remove(Tooltip.TOOLTIP_PROP_KEY);
            if (tooltip.equals(this.visibleTooltip) || tooltip.equals(this.activatedTooltip)) {
                this.KILL_HANDLER.handle(null);
            }
        }
    }

    private Window getWindow(Node eventTarget) {
        if ((eventTarget = eventTarget == null ? null : ((Node)eventTarget).getScene()) == null) {
            return null;
        }
        return ((Scene)eventTarget).getWindow();
    }

    private boolean isWindowHierarchyVisible(Node node) {
        boolean bl2 = node != null;
        Node node2 = node = node == null ? null : node.getParent();
        while (node2 != null && bl2) {
            bl2 = node.isVisible();
            node2 = node.getParent();
        }
        return bl2;
    }

    static {
        $assertionsDisabled = !Tooltip.class.desiredAssertionStatus();
    }
}

