/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.beans.IDProperty;
import com.sun.javafx.stage.PopupWindowHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.StringProperty;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableStringProperty;
import javafx.css.converter.BooleanConverter;
import javafx.css.converter.DurationConverter;
import javafx.css.converter.EnumConverter;
import javafx.css.converter.SizeConverter;
import javafx.css.converter.StringConverter;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.OverrunStyle;
import javafx.scene.control.PopupControl;
import javafx.scene.control.Skin;
import javafx.scene.control.Tooltip$1;
import javafx.scene.control.Tooltip$10;
import javafx.scene.control.Tooltip$11;
import javafx.scene.control.Tooltip$12;
import javafx.scene.control.Tooltip$13;
import javafx.scene.control.Tooltip$14;
import javafx.scene.control.Tooltip$2;
import javafx.scene.control.Tooltip$3;
import javafx.scene.control.Tooltip$4;
import javafx.scene.control.Tooltip$5;
import javafx.scene.control.Tooltip$6;
import javafx.scene.control.Tooltip$7;
import javafx.scene.control.Tooltip$8;
import javafx.scene.control.Tooltip$9;
import javafx.scene.control.Tooltip$CSSBridge;
import javafx.scene.control.Tooltip$TooltipBehavior;
import javafx.scene.control.skin.TooltipSkin;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;
import javafx.util.Duration;

@IDProperty(value="id")
public class Tooltip
extends PopupControl {
    private static String TOOLTIP_PROP_KEY = "javafx.scene.control.Tooltip";
    private static int TOOLTIP_XOFFSET = 10;
    private static int TOOLTIP_YOFFSET = 7;
    private static Tooltip$TooltipBehavior BEHAVIOR = new Tooltip$TooltipBehavior(false);
    private final StringProperty text;
    private final ObjectProperty<TextAlignment> textAlignment;
    private final ObjectProperty<OverrunStyle> textOverrun;
    private final BooleanProperty wrapText;
    private final ObjectProperty<Font> font;
    private final ObjectProperty<Duration> showDelayProperty;
    private final ObjectProperty<Duration> showDurationProperty;
    private final ObjectProperty<Duration> hideDelayProperty;
    private final ObjectProperty<Node> graphic;
    private StyleableStringProperty imageUrl;
    private final ObjectProperty<ContentDisplay> contentDisplay;
    private final DoubleProperty graphicTextGap;
    private final ReadOnlyBooleanWrapper activated;
    private static final CssMetaData<Tooltip$CSSBridge, Font> FONT = new Tooltip$5("-fx-font", Font.getDefault());
    private static final CssMetaData<Tooltip$CSSBridge, TextAlignment> TEXT_ALIGNMENT = new Tooltip$6("-fx-text-alignment", new EnumConverter<TextAlignment>(TextAlignment.class), TextAlignment.LEFT);
    private static final CssMetaData<Tooltip$CSSBridge, OverrunStyle> TEXT_OVERRUN = new Tooltip$7("-fx-text-overrun", new EnumConverter<OverrunStyle>(OverrunStyle.class), OverrunStyle.ELLIPSIS);
    private static final CssMetaData<Tooltip$CSSBridge, Boolean> WRAP_TEXT = new Tooltip$8("-fx-wrap-text", BooleanConverter.getInstance(), Boolean.FALSE);
    private static final CssMetaData<Tooltip$CSSBridge, String> GRAPHIC = new Tooltip$9("-fx-graphic", StringConverter.getInstance());
    private static final CssMetaData<Tooltip$CSSBridge, ContentDisplay> CONTENT_DISPLAY = new Tooltip$10("-fx-content-display", new EnumConverter<ContentDisplay>(ContentDisplay.class), ContentDisplay.LEFT);
    private static final CssMetaData<Tooltip$CSSBridge, Number> GRAPHIC_TEXT_GAP = new Tooltip$11("-fx-graphic-text-gap", SizeConverter.getInstance(), 4.0);
    private static final CssMetaData<Tooltip$CSSBridge, Duration> SHOW_DELAY = new Tooltip$12("-fx-show-delay", DurationConverter.getInstance(), new Duration(1000.0));
    private static final CssMetaData<Tooltip$CSSBridge, Duration> SHOW_DURATION = new Tooltip$13("-fx-show-duration", DurationConverter.getInstance(), new Duration(5000.0));
    private static final CssMetaData<Tooltip$CSSBridge, Duration> HIDE_DELAY = new Tooltip$14("-fx-hide-delay", DurationConverter.getInstance(), new Duration(200.0));
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

    public static void install(Node node, Tooltip tooltip) {
        BEHAVIOR.install(node, tooltip);
    }

    public static void uninstall(Node node, Tooltip tooltip) {
        BEHAVIOR.uninstall(node);
    }

    public Tooltip() {
        this(null);
    }

    public Tooltip(String string) {
        Tooltip tooltip = this;
        this.text = new Tooltip$1(tooltip, tooltip, "text", "");
        this.textAlignment = new SimpleStyleableObjectProperty<TextAlignment>(TEXT_ALIGNMENT, this, "textAlignment", TextAlignment.LEFT);
        this.textOverrun = new SimpleStyleableObjectProperty<OverrunStyle>(TEXT_OVERRUN, this, "textOverrun", OverrunStyle.ELLIPSIS);
        this.wrapText = new SimpleStyleableBooleanProperty(WRAP_TEXT, this, "wrapText", false);
        this.font = new Tooltip$2(this, Font.getDefault());
        this.showDelayProperty = new SimpleStyleableObjectProperty<Duration>(SHOW_DELAY, this, "showDelay", new Duration(1000.0));
        this.showDurationProperty = new SimpleStyleableObjectProperty<Duration>(SHOW_DURATION, this, "showDuration", new Duration(5000.0));
        this.hideDelayProperty = new SimpleStyleableObjectProperty<Duration>(HIDE_DELAY, this, "hideDelay", new Duration(200.0));
        this.graphic = new Tooltip$3(this);
        this.imageUrl = null;
        this.contentDisplay = new SimpleStyleableObjectProperty<ContentDisplay>(CONTENT_DISPLAY, this, "contentDisplay", ContentDisplay.LEFT);
        this.graphicTextGap = new SimpleStyleableDoubleProperty(GRAPHIC_TEXT_GAP, this, "graphicTextGap", 4.0);
        this.activated = new ReadOnlyBooleanWrapper(this, "activated");
        if (string != null) {
            this.setText(string);
        }
        this.bridge = new Tooltip$CSSBridge(this);
        PopupWindowHelper.getContent(this).setAll((Node[])new Node[]{this.bridge});
        this.getStyleClass().setAll((String[])new String[]{"tooltip"});
    }

    public final StringProperty textProperty() {
        return this.text;
    }

    public final void setText(String string) {
        this.textProperty().setValue(string);
    }

    public final String getText() {
        if (this.text.getValue() == null) {
            return "";
        }
        return this.text.getValue();
    }

    public final ObjectProperty<TextAlignment> textAlignmentProperty() {
        return this.textAlignment;
    }

    public final void setTextAlignment(TextAlignment textAlignment) {
        this.textAlignmentProperty().setValue(textAlignment);
    }

    public final TextAlignment getTextAlignment() {
        return (TextAlignment)((Object)this.textAlignmentProperty().getValue());
    }

    public final ObjectProperty<OverrunStyle> textOverrunProperty() {
        return this.textOverrun;
    }

    public final void setTextOverrun(OverrunStyle overrunStyle) {
        this.textOverrunProperty().setValue(overrunStyle);
    }

    public final OverrunStyle getTextOverrun() {
        return (OverrunStyle)((Object)this.textOverrunProperty().getValue());
    }

    public final BooleanProperty wrapTextProperty() {
        return this.wrapText;
    }

    public final void setWrapText(boolean bl2) {
        this.wrapTextProperty().setValue(bl2);
    }

    public final boolean isWrapText() {
        return this.wrapTextProperty().getValue();
    }

    public final ObjectProperty<Font> fontProperty() {
        return this.font;
    }

    public final void setFont(Font font) {
        this.fontProperty().setValue(font);
    }

    public final Font getFont() {
        return (Font)this.fontProperty().getValue();
    }

    public final ObjectProperty<Duration> showDelayProperty() {
        return this.showDelayProperty;
    }

    public final void setShowDelay(Duration duration) {
        this.showDelayProperty.set(duration);
    }

    public final Duration getShowDelay() {
        return (Duration)this.showDelayProperty.get();
    }

    public final ObjectProperty<Duration> showDurationProperty() {
        return this.showDurationProperty;
    }

    public final void setShowDuration(Duration duration) {
        this.showDurationProperty.set(duration);
    }

    public final Duration getShowDuration() {
        return (Duration)this.showDurationProperty.get();
    }

    public final ObjectProperty<Duration> hideDelayProperty() {
        return this.hideDelayProperty;
    }

    public final void setHideDelay(Duration duration) {
        this.hideDelayProperty.set(duration);
    }

    public final Duration getHideDelay() {
        return (Duration)this.hideDelayProperty.get();
    }

    public final ObjectProperty<Node> graphicProperty() {
        return this.graphic;
    }

    public final void setGraphic(Node node) {
        this.graphicProperty().setValue(node);
    }

    public final Node getGraphic() {
        return (Node)this.graphicProperty().getValue();
    }

    private StyleableStringProperty imageUrlProperty() {
        if (this.imageUrl == null) {
            this.imageUrl = new Tooltip$4(this);
        }
        return this.imageUrl;
    }

    public final ObjectProperty<ContentDisplay> contentDisplayProperty() {
        return this.contentDisplay;
    }

    public final void setContentDisplay(ContentDisplay contentDisplay) {
        this.contentDisplayProperty().setValue(contentDisplay);
    }

    public final ContentDisplay getContentDisplay() {
        return (ContentDisplay)((Object)this.contentDisplayProperty().getValue());
    }

    public final DoubleProperty graphicTextGapProperty() {
        return this.graphicTextGap;
    }

    public final void setGraphicTextGap(double d2) {
        this.graphicTextGapProperty().setValue(d2);
    }

    public final double getGraphicTextGap() {
        return this.graphicTextGapProperty().getValue();
    }

    final void setActivated(boolean bl2) {
        this.activated.set(bl2);
    }

    public final boolean isActivated() {
        return this.activated.get();
    }

    public final ReadOnlyBooleanProperty activatedProperty() {
        return this.activated.getReadOnlyProperty();
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new TooltipSkin(this);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return Tooltip.getClassCssMetaData();
    }

    @Override
    public Styleable getStyleableParent() {
        if (Tooltip.BEHAVIOR.hoveredNode == null) {
            return super.getStyleableParent();
        }
        return Tooltip.BEHAVIOR.hoveredNode;
    }

    static {
        ArrayList arrayList = new ArrayList(PopupControl.getClassCssMetaData());
        arrayList.add(FONT);
        arrayList.add(TEXT_ALIGNMENT);
        arrayList.add(TEXT_OVERRUN);
        arrayList.add(WRAP_TEXT);
        arrayList.add(GRAPHIC);
        arrayList.add(CONTENT_DISPLAY);
        arrayList.add(GRAPHIC_TEXT_GAP);
        arrayList.add(SHOW_DELAY);
        arrayList.add(SHOW_DURATION);
        arrayList.add(HIDE_DELAY);
        STYLEABLES = Collections.unmodifiableList(arrayList);
    }
}

