/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import java.util.Collections;
import java.util.List;
import javafx.collections.ListChangeListener$Change;
import javafx.event.Event;
import javafx.event.EventType;
import javafx.scene.control.TreeItem;

public class TreeItem$TreeModificationEvent<T>
extends Event {
    private static final long serialVersionUID = 4741889985221719579L;
    public static final EventType<?> ANY = TreeItem.TREE_NOTIFICATION_EVENT;
    private final transient TreeItem<T> treeItem;
    private final T newValue;
    private final List<? extends TreeItem<T>> added;
    private final List<? extends TreeItem<T>> removed;
    private final ListChangeListener$Change<? extends TreeItem<T>> change;
    private final boolean wasExpanded;
    private final boolean wasCollapsed;
    private boolean wasPermutated;

    public TreeItem$TreeModificationEvent(EventType<? extends Event> eventType, TreeItem<T> treeItem) {
        this(eventType, treeItem, null);
    }

    public TreeItem$TreeModificationEvent(EventType<? extends Event> eventType, TreeItem<T> treeItem, T t2) {
        super(eventType);
        this.treeItem = treeItem;
        this.newValue = t2;
        this.added = null;
        this.removed = null;
        this.change = null;
        this.wasExpanded = false;
        this.wasCollapsed = false;
    }

    public TreeItem$TreeModificationEvent(EventType<? extends Event> eventType, TreeItem<T> treeItem, boolean bl2) {
        super(eventType);
        this.treeItem = treeItem;
        this.newValue = null;
        this.added = null;
        this.removed = null;
        this.change = null;
        this.wasExpanded = bl2;
        this.wasCollapsed = !bl2;
    }

    public TreeItem$TreeModificationEvent(EventType<? extends Event> eventType, TreeItem<T> treeItem, List<? extends TreeItem<T>> list, List<? extends TreeItem<T>> list2) {
        this(eventType, treeItem, list, list2, null);
    }

    private TreeItem$TreeModificationEvent(EventType<? extends Event> eventType, TreeItem<T> treeItem, List<? extends TreeItem<T>> list, List<? extends TreeItem<T>> list2, ListChangeListener$Change<? extends TreeItem<T>> listChangeListener$Change) {
        super(eventType);
        this.treeItem = treeItem;
        this.newValue = null;
        this.added = list;
        this.removed = list2;
        this.change = listChangeListener$Change;
        this.wasExpanded = false;
        this.wasCollapsed = false;
        this.wasPermutated = list != null && list2 != null && list.size() == list2.size() && list.containsAll(list2);
    }

    @Override
    public TreeItem<T> getSource() {
        return this.treeItem;
    }

    public TreeItem<T> getTreeItem() {
        return this.treeItem;
    }

    public T getNewValue() {
        return this.newValue;
    }

    public List<? extends TreeItem<T>> getAddedChildren() {
        if (this.added == null) {
            return Collections.emptyList();
        }
        return this.added;
    }

    public List<? extends TreeItem<T>> getRemovedChildren() {
        if (this.removed == null) {
            return Collections.emptyList();
        }
        return this.removed;
    }

    public int getRemovedSize() {
        return this.getRemovedChildren().size();
    }

    public int getAddedSize() {
        return this.getAddedChildren().size();
    }

    public boolean wasExpanded() {
        return this.wasExpanded;
    }

    public boolean wasCollapsed() {
        return this.wasCollapsed;
    }

    public boolean wasAdded() {
        return this.getAddedSize() > 0;
    }

    public boolean wasRemoved() {
        return this.getRemovedSize() > 0;
    }

    public boolean wasPermutated() {
        return this.wasPermutated;
    }

    int getFrom() {
        if (this.change == null) {
            return -1;
        }
        return this.change.getFrom();
    }

    int getTo() {
        if (this.change == null) {
            return -1;
        }
        return this.change.getTo();
    }

    ListChangeListener$Change<? extends TreeItem<T>> getChange() {
        return this.change;
    }
}

