/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.event.EventHandlerManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ListChangeListener$Change;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.TreeItem$1;
import javafx.scene.control.TreeItem$2;
import javafx.scene.control.TreeItem$3;
import javafx.scene.control.TreeItem$4;
import javafx.scene.control.TreeItem$TreeModificationEvent;
import javafx.scene.control.TreeSortMode;

public class TreeItem<T>
implements EventTarget {
    private static final EventType<?> TREE_NOTIFICATION_EVENT = new EventType<Event>(Event.ANY, "TreeNotificationEvent");
    private static final EventType<?> EXPANDED_ITEM_COUNT_CHANGE_EVENT = new EventType(TreeItem.treeNotificationEvent(), "ExpandedItemCountChangeEvent");
    private static final EventType<?> BRANCH_EXPANDED_EVENT = new EventType(TreeItem.expandedItemCountChangeEvent(), "BranchExpandedEvent");
    private static final EventType<?> BRANCH_COLLAPSED_EVENT = new EventType(TreeItem.expandedItemCountChangeEvent(), "BranchCollapsedEvent");
    private static final EventType<?> CHILDREN_MODIFICATION_EVENT = new EventType(TreeItem.expandedItemCountChangeEvent(), "ChildrenModificationEvent");
    private static final EventType<?> VALUE_CHANGED_EVENT = new EventType(TreeItem.treeNotificationEvent(), "ValueChangedEvent");
    private static final EventType<?> GRAPHIC_CHANGED_EVENT = new EventType(TreeItem.treeNotificationEvent(), "GraphicChangedEvent");
    private final EventHandler<TreeItem$TreeModificationEvent<Object>> itemListener = new TreeItem$1(this);
    private boolean ignoreSortUpdate = false;
    private boolean expandedDescendentCountDirty = true;
    ObservableList<TreeItem<T>> children;
    private final EventHandlerManager eventHandlerManager = new EventHandlerManager(this);
    private int expandedDescendentCount = 1;
    int previousExpandedDescendentCount = 1;
    Comparator<TreeItem<T>> lastComparator = null;
    TreeSortMode lastSortMode = null;
    private int parentLinkCount = 0;
    private ListChangeListener<TreeItem<T>> childrenListener = listChangeListener$Change -> {
        this.expandedDescendentCountDirty = true;
        this.updateChildren(listChangeListener$Change);
    };
    private ObjectProperty<T> value;
    private ObjectProperty<Node> graphic;
    private BooleanProperty expanded;
    private ReadOnlyBooleanWrapper leaf;
    private ReadOnlyObjectWrapper<TreeItem<T>> parent = new ReadOnlyObjectWrapper(this, "parent");

    public static <T> EventType<TreeItem$TreeModificationEvent<T>> treeNotificationEvent() {
        return TREE_NOTIFICATION_EVENT;
    }

    public static <T> EventType<TreeItem$TreeModificationEvent<T>> expandedItemCountChangeEvent() {
        return EXPANDED_ITEM_COUNT_CHANGE_EVENT;
    }

    public static <T> EventType<TreeItem$TreeModificationEvent<T>> branchExpandedEvent() {
        return BRANCH_EXPANDED_EVENT;
    }

    public static <T> EventType<TreeItem$TreeModificationEvent<T>> branchCollapsedEvent() {
        return BRANCH_COLLAPSED_EVENT;
    }

    public static <T> EventType<TreeItem$TreeModificationEvent<T>> childrenModificationEvent() {
        return CHILDREN_MODIFICATION_EVENT;
    }

    public static <T> EventType<TreeItem$TreeModificationEvent<T>> valueChangedEvent() {
        return VALUE_CHANGED_EVENT;
    }

    public static <T> EventType<TreeItem$TreeModificationEvent<T>> graphicChangedEvent() {
        return GRAPHIC_CHANGED_EVENT;
    }

    public TreeItem() {
        this(null);
    }

    public TreeItem(T t2) {
        this(t2, null);
    }

    public TreeItem(T t2, Node node) {
        this.setValue(t2);
        this.setGraphic(node);
        this.addEventHandler(TreeItem.expandedItemCountChangeEvent(), this.itemListener);
    }

    public final void setValue(T t2) {
        this.valueProperty().setValue(t2);
    }

    public final T getValue() {
        if (this.value == null) {
            return null;
        }
        return this.value.getValue();
    }

    public final ObjectProperty<T> valueProperty() {
        if (this.value == null) {
            this.value = new TreeItem$2(this);
        }
        return this.value;
    }

    public final void setGraphic(Node node) {
        this.graphicProperty().setValue(node);
    }

    public final Node getGraphic() {
        if (this.graphic == null) {
            return null;
        }
        return (Node)this.graphic.getValue();
    }

    public final ObjectProperty<Node> graphicProperty() {
        if (this.graphic == null) {
            this.graphic = new TreeItem$3(this);
        }
        return this.graphic;
    }

    public final void setExpanded(boolean bl2) {
        if (!bl2 && this.expanded == null) {
            return;
        }
        this.expandedProperty().setValue(bl2);
    }

    public final boolean isExpanded() {
        if (this.expanded == null) {
            return false;
        }
        return this.expanded.getValue();
    }

    public final BooleanProperty expandedProperty() {
        if (this.expanded == null) {
            this.expanded = new TreeItem$4(this);
        }
        return this.expanded;
    }

    private void setLeaf(boolean bl2) {
        if (bl2 && this.leaf == null) {
            return;
        }
        if (this.leaf == null) {
            this.leaf = new ReadOnlyBooleanWrapper(this, "leaf", true);
        }
        this.leaf.setValue(bl2);
    }

    public boolean isLeaf() {
        if (this.leaf == null) {
            return true;
        }
        return this.leaf.getValue();
    }

    public final ReadOnlyBooleanProperty leafProperty() {
        if (this.leaf == null) {
            this.leaf = new ReadOnlyBooleanWrapper(this, "leaf", true);
        }
        return this.leaf.getReadOnlyProperty();
    }

    private void setParent(TreeItem<T> treeItem) {
        this.parent.setValue(treeItem);
    }

    public final TreeItem<T> getParent() {
        if (this.parent == null) {
            return null;
        }
        return (TreeItem)this.parent.getValue();
    }

    public final ReadOnlyObjectProperty<TreeItem<T>> parentProperty() {
        return this.parent.getReadOnlyProperty();
    }

    public ObservableList<TreeItem<T>> getChildren() {
        if (this.children == null) {
            this.children = FXCollections.observableArrayList();
            this.children.addListener(this.childrenListener);
        }
        if (this.children.isEmpty()) {
            return this.children;
        }
        if (!this.ignoreSortUpdate) {
            this.checkSortState();
        }
        return this.children;
    }

    public TreeItem<T> previousSibling() {
        TreeItem treeItem = this;
        return treeItem.previousSibling(treeItem);
    }

    public TreeItem<T> previousSibling(TreeItem<T> treeItem) {
        if (this.getParent() == null || treeItem == null) {
            return null;
        }
        ObservableList<TreeItem<T>> observableList = this.getParent().getChildren();
        int n2 = observableList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!treeItem.equals(observableList.get(i2))) continue;
            int n3 = i2 - 1;
            if (n3 < 0) {
                return null;
            }
            return (TreeItem)observableList.get(n3);
        }
        return null;
    }

    public TreeItem<T> nextSibling() {
        TreeItem treeItem = this;
        return treeItem.nextSibling(treeItem);
    }

    public TreeItem<T> nextSibling(TreeItem<T> treeItem) {
        if (this.getParent() == null || treeItem == null) {
            return null;
        }
        ObservableList<TreeItem<T>> observableList = this.getParent().getChildren();
        int n2 = observableList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!treeItem.equals(observableList.get(i2))) continue;
            int n3 = i2 + 1;
            if (n3 >= n2) {
                return null;
            }
            return (TreeItem)observableList.get(n3);
        }
        return null;
    }

    public String toString() {
        return "TreeItem [ value: " + String.valueOf(this.getValue()) + " ]";
    }

    private void fireEvent(TreeItem$TreeModificationEvent<T> treeItem$TreeModificationEvent) {
        Event.fireEvent(this, treeItem$TreeModificationEvent);
    }

    @Override
    public EventDispatchChain buildEventDispatchChain(EventDispatchChain eventDispatchChain) {
        if (this.getParent() != null) {
            this.getParent().buildEventDispatchChain(eventDispatchChain);
        }
        return eventDispatchChain.append(this.eventHandlerManager);
    }

    @Override
    public <E extends Event> void addEventHandler(EventType<E> eventType, EventHandler<? super E> eventHandler) {
        this.eventHandlerManager.addEventHandler(eventType, eventHandler);
    }

    @Override
    public <E extends Event> void removeEventHandler(EventType<E> eventType, EventHandler<? super E> eventHandler) {
        this.eventHandlerManager.removeEventHandler(eventType, eventHandler);
    }

    @Override
    public <E extends Event> void addEventFilter(EventType<E> eventType, EventHandler<? super E> eventHandler) {
        this.eventHandlerManager.addEventFilter(eventType, eventHandler);
    }

    @Override
    public <E extends Event> void removeEventFilter(EventType<E> eventType, EventHandler<? super E> eventHandler) {
        this.eventHandlerManager.removeEventFilter(eventType, eventHandler);
    }

    void sort() {
        TreeItem treeItem = this;
        treeItem.sort(treeItem.children, this.lastComparator, this.lastSortMode);
    }

    private void sort(ObservableList<TreeItem<T>> object, Comparator<TreeItem<T>> comparator, TreeSortMode treeSortMode) {
        if (comparator == null) {
            return;
        }
        this.runSort((ObservableList<TreeItem<T>>)object, comparator, treeSortMode);
        if (this.getParent() == null) {
            object = new TreeItem$TreeModificationEvent(TreeItem.childrenModificationEvent(), this);
            new TreeItem$TreeModificationEvent(TreeItem.childrenModificationEvent(), this).wasPermutated = true;
            this.fireEvent((TreeItem$TreeModificationEvent<T>)object);
        }
    }

    private void checkSortState() {
        Comparator<TreeItem<T>> comparator = this.getRoot();
        TreeSortMode treeSortMode = ((TreeItem)((Object)comparator)).lastSortMode;
        comparator = ((TreeItem)((Object)comparator)).lastComparator;
        if (comparator != null && comparator != this.lastComparator) {
            this.lastComparator = comparator;
            TreeItem treeItem = this;
            treeItem.runSort(treeItem.children, comparator, treeSortMode);
        }
    }

    private void runSort(ObservableList<TreeItem<T>> observableList, Comparator<TreeItem<T>> comparator, TreeSortMode treeSortMode) {
        if (treeSortMode == TreeSortMode.ALL_DESCENDANTS) {
            this.doSort(observableList, comparator);
            return;
        }
        if (treeSortMode == TreeSortMode.ONLY_FIRST_LEVEL && this.getParent() == null) {
            this.doSort(observableList, comparator);
        }
    }

    private TreeItem<T> getRoot() {
        TreeItem<T> treeItem = this.getParent();
        if (treeItem == null) {
            return this;
        }
        TreeItem<T> treeItem2;
        while ((treeItem2 = treeItem.getParent()) != null) {
            treeItem = treeItem2;
        }
        return treeItem;
    }

    private void doSort(ObservableList<TreeItem<T>> observableList, Comparator<TreeItem<T>> comparator) {
        if (!this.isLeaf() && this.isExpanded()) {
            FXCollections.sort(observableList, comparator);
        }
    }

    int getExpandedDescendentCount(boolean bl2) {
        if (bl2 || this.expandedDescendentCountDirty) {
            this.updateExpandedDescendentCount(bl2);
            this.expandedDescendentCountDirty = false;
        }
        return this.expandedDescendentCount;
    }

    private void updateExpandedDescendentCount(boolean bl2) {
        this.previousExpandedDescendentCount = this.expandedDescendentCount;
        this.expandedDescendentCount = 1;
        this.ignoreSortUpdate = true;
        if (!this.isLeaf() && this.isExpanded()) {
            for (TreeItem treeItem : this.getChildren()) {
                if (treeItem == null) continue;
                this.expandedDescendentCount += treeItem.isExpanded() ? treeItem.getExpandedDescendentCount(bl2) : 1;
            }
        }
        this.ignoreSortUpdate = false;
    }

    private void updateChildren(ListChangeListener$Change<? extends TreeItem<T>> listChangeListener$Change) {
        TreeItem treeItem = this;
        treeItem.setLeaf(treeItem.children.isEmpty());
        ArrayList<? extends TreeItem<T>> arrayList = new ArrayList<TreeItem<T>>();
        ArrayList<? extends TreeItem<T>> arrayList2 = new ArrayList<TreeItem<T>>();
        while (listChangeListener$Change.next()) {
            arrayList.addAll(listChangeListener$Change.getAddedSubList());
            arrayList2.addAll(listChangeListener$Change.getRemoved());
        }
        TreeItem.updateChildrenParent(arrayList2, null);
        TreeItem.updateChildrenParent(arrayList, this);
        listChangeListener$Change.reset();
        this.fireEvent(new TreeItem$TreeModificationEvent(CHILDREN_MODIFICATION_EVENT, this, arrayList, arrayList2, listChangeListener$Change));
    }

    private static <T> void updateChildrenParent(List<? extends TreeItem<T>> object, TreeItem<T> treeItem) {
        if (object == null) {
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            boolean bl2;
            TreeItem treeItem2 = (TreeItem)object.next();
            if (treeItem2 == null) continue;
            TreeItem<T> treeItem3 = treeItem2.getParent();
            if (treeItem2.parentLinkCount == 0) {
                treeItem2.setParent(treeItem);
            }
            if (!(bl2 = treeItem3 != null && treeItem3.equals(treeItem))) continue;
            if (treeItem == null) {
                --treeItem2.parentLinkCount;
                continue;
            }
            ++treeItem2.parentLinkCount;
        }
    }
}

