/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import java.lang.ref.WeakReference;
import java.util.Collection;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.WeakListChangeListener;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.control.Cell;
import javafx.scene.control.ControlUtils;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.Skin;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableSelectionModel;
import javafx.scene.control.TreeTableCell$1;
import javafx.scene.control.TreeTableCell$2;
import javafx.scene.control.TreeTableCell$3;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableColumn$CellEditEvent;
import javafx.scene.control.TreeTablePosition;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;
import javafx.scene.control.TreeTableView$TreeTableViewFocusModel;
import javafx.scene.control.skin.TreeTableCellSkin;

public class TreeTableCell<S, T>
extends IndexedCell<T> {
    boolean lockItemOnEdit = false;
    private boolean itemDirty = false;
    private ListChangeListener<TreeTablePosition<S, ?>> selectedListener = listChangeListener$Change -> {
        while (listChangeListener$Change.next()) {
            if (!listChangeListener$Change.wasAdded() && !listChangeListener$Change.wasRemoved()) continue;
            this.updateSelection();
        }
    };
    private final InvalidationListener focusedListener = observable -> this.updateFocus();
    private final InvalidationListener tableRowUpdateObserver = observable -> {
        this.itemDirty = true;
        this.requestLayout();
    };
    private final InvalidationListener editingListener = observable -> this.updateEditing();
    private ListChangeListener<TreeTableColumn<S, ?>> visibleLeafColumnsListener = listChangeListener$Change -> this.updateColumnIndex();
    private ListChangeListener<String> columnStyleClassListener = listChangeListener$Change -> {
        while (listChangeListener$Change.next()) {
            if (listChangeListener$Change.wasRemoved()) {
                this.getStyleClass().removeAll(listChangeListener$Change.getRemoved());
            }
            if (!listChangeListener$Change.wasAdded()) continue;
            this.getStyleClass().addAll(listChangeListener$Change.getAddedSubList());
        }
    };
    private final InvalidationListener rootPropertyListener = observable -> this.updateItem(-1);
    private final InvalidationListener columnStyleListener = observable -> {
        if (this.getTableColumn() != null) {
            TreeTableCell treeTableCell = this;
            treeTableCell.possiblySetStyle(treeTableCell.getTableColumn().getStyle());
        }
    };
    private final InvalidationListener columnIdListener = observable -> {
        if (this.getTableColumn() != null) {
            TreeTableCell treeTableCell = this;
            treeTableCell.possiblySetId(treeTableCell.getTableColumn().getId());
        }
    };
    private final WeakListChangeListener<TreeTablePosition<S, ?>> weakSelectedListener = new WeakListChangeListener(this.selectedListener);
    private final WeakInvalidationListener weakFocusedListener = new WeakInvalidationListener(this.focusedListener);
    private final WeakInvalidationListener weaktableRowUpdateObserver = new WeakInvalidationListener(this.tableRowUpdateObserver);
    private final WeakInvalidationListener weakEditingListener = new WeakInvalidationListener(this.editingListener);
    private final WeakListChangeListener<TreeTableColumn<S, ?>> weakVisibleLeafColumnsListener = new WeakListChangeListener(this.visibleLeafColumnsListener);
    private final WeakListChangeListener<String> weakColumnStyleClassListener = new WeakListChangeListener<String>(this.columnStyleClassListener);
    private final WeakInvalidationListener weakColumnStyleListener = new WeakInvalidationListener(this.columnStyleListener);
    private final WeakInvalidationListener weakColumnIdListener = new WeakInvalidationListener(this.columnIdListener);
    private final WeakInvalidationListener weakRootPropertyListener = new WeakInvalidationListener(this.rootPropertyListener);
    private ReadOnlyObjectWrapper<TreeTableColumn<S, T>> tableColumn;
    private ReadOnlyObjectWrapper<TreeTableView<S>> treeTableView;
    private ReadOnlyObjectWrapper<TreeTableRow<S>> tableRow;
    private TreeTablePosition<S, T> editingCellAtStartEdit;
    private boolean isLastVisibleColumn;
    private int columnIndex;
    private boolean updateEditingIndex;
    private ObservableValue<T> currentObservableValue;
    private boolean isFirstRun;
    private WeakReference<S> oldRowItemRef;
    private static final String DEFAULT_STYLE_CLASS = "tree-table-cell";
    private static final PseudoClass PSEUDO_CLASS_LAST_VISIBLE = PseudoClass.getPseudoClass("last-visible");

    public TreeTableCell() {
        TreeTableCell treeTableCell = this;
        this.tableColumn = new TreeTableCell$1(treeTableCell, treeTableCell, "tableColumn");
        this.tableRow = new ReadOnlyObjectWrapper(this, "tableRow");
        this.editingCellAtStartEdit = null;
        this.isLastVisibleColumn = false;
        this.columnIndex = -1;
        this.updateEditingIndex = true;
        this.currentObservableValue = null;
        this.isFirstRun = true;
        this.getStyleClass().addAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setAccessibleRole(AccessibleRole.TREE_TABLE_CELL);
        this.updateColumnIndex();
    }

    public final ReadOnlyObjectProperty<TreeTableColumn<S, T>> tableColumnProperty() {
        return this.tableColumn.getReadOnlyProperty();
    }

    private void setTableColumn(TreeTableColumn<S, T> treeTableColumn) {
        this.tableColumn.set(treeTableColumn);
    }

    public final TreeTableColumn<S, T> getTableColumn() {
        return (TreeTableColumn)this.tableColumn.get();
    }

    private void setTreeTableView(TreeTableView<S> treeTableView) {
        this.treeTableViewPropertyImpl().set(treeTableView);
    }

    public final TreeTableView<S> getTreeTableView() {
        if (this.treeTableView == null) {
            return null;
        }
        return (TreeTableView)this.treeTableView.get();
    }

    public final ReadOnlyObjectProperty<TreeTableView<S>> treeTableViewProperty() {
        return this.treeTableViewPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<TreeTableView<S>> treeTableViewPropertyImpl() {
        if (this.treeTableView == null) {
            TreeTableCell treeTableCell = this;
            this.treeTableView = new TreeTableCell$2(treeTableCell, treeTableCell, "treeTableView");
        }
        return this.treeTableView;
    }

    private void setTableRow(TreeTableRow<S> treeTableRow) {
        this.tableRow.set(treeTableRow);
    }

    public final TreeTableRow<S> getTableRow() {
        return (TreeTableRow)this.tableRow.get();
    }

    public final ReadOnlyObjectProperty<TreeTableRow<S>> tableRowProperty() {
        return this.tableRow.getReadOnlyProperty();
    }

    @Deprecated(since="17")
    public final TreeTableRow<S> getTreeTableRow() {
        return this.getTableRow();
    }

    TreeTablePosition<S, T> getEditingCellAtStartEdit() {
        return this.editingCellAtStartEdit;
    }

    @Override
    public void startEdit() {
        if (this.isEditing()) {
            return;
        }
        TreeTableView<S> treeTableView = this.getTreeTableView();
        TreeTableColumn<S, T> treeTableColumn = this.getTableColumn();
        Object object = this.getTableRow();
        if (!this.isEditable() || treeTableView != null && !treeTableView.isEditable() || treeTableColumn != null && !treeTableColumn.isEditable() || object != null && !((Cell)object).isEditable()) {
            return;
        }
        if (!this.lockItemOnEdit) {
            this.updateItem(-1);
        }
        super.startEdit();
        if (!this.isEditing()) {
            return;
        }
        this.editingCellAtStartEdit = new TreeTablePosition<S, T>(treeTableView, this.getIndex(), treeTableColumn);
        if (treeTableColumn != null) {
            object = new TreeTableColumn$CellEditEvent<S, Object>(treeTableView, this.editingCellAtStartEdit, TreeTableColumn.editStartEvent(), null);
            Event.fireEvent(treeTableColumn, (Event)object);
        }
        if (treeTableView != null) {
            treeTableView.edit(this.editingCellAtStartEdit.getRow(), (TreeTableColumn<S, ?>)this.editingCellAtStartEdit.getTableColumn());
        }
    }

    @Override
    public void commitEdit(T t2) {
        if (!this.isEditing()) {
            return;
        }
        super.commitEdit(t2);
        TreeTableView treeTableView = this.getTreeTableView();
        if (this.getTableColumn() != null) {
            TreeTableColumn$CellEditEvent<S, T> treeTableColumn$CellEditEvent = new TreeTableColumn$CellEditEvent<S, T>(treeTableView, this.editingCellAtStartEdit, TreeTableColumn.editCommitEvent(), t2);
            Event.fireEvent(this.getTableColumn(), treeTableColumn$CellEditEvent);
        }
        this.updateItem(t2, false);
        if (treeTableView != null) {
            treeTableView.edit(-1, null);
            ControlUtils.requestFocusOnControlOnlyIfCurrentFocusOwnerIsChild(treeTableView);
        }
    }

    @Override
    public void cancelEdit() {
        if (!this.isEditing()) {
            return;
        }
        super.cancelEdit();
        Object object = this.getTreeTableView();
        if (object != null) {
            if (this.updateEditingIndex) {
                ((TreeTableView)object).edit(-1, null);
            }
            ControlUtils.requestFocusOnControlOnlyIfCurrentFocusOwnerIsChild(object);
        }
        if (this.getTableColumn() != null) {
            object = new TreeTableColumn$CellEditEvent<S, Object>(object, this.editingCellAtStartEdit, TreeTableColumn.editCancelEvent(), null);
            Event.fireEvent(this.getTableColumn(), (Event)object);
        }
    }

    @Override
    public void updateSelected(boolean bl2) {
        if (this.getTableRow() == null || this.getTableRow().isEmpty()) {
            return;
        }
        this.setSelected(bl2);
    }

    @Override
    void indexChanged(int n2, int n3) {
        super.indexChanged(n2, n3);
        if (!this.isEditing() || n3 != n2) {
            this.updateItem(n2);
            this.updateSelection();
            this.updateFocus();
            this.updateEditing();
        }
    }

    private void updateColumnIndex() {
        TreeTableView<S> treeTableView = this.getTreeTableView();
        TreeTableColumn<S, T> treeTableColumn = this.getTableColumn();
        this.columnIndex = treeTableView == null || treeTableColumn == null ? -1 : treeTableView.getVisibleLeafIndex(treeTableColumn);
        this.isLastVisibleColumn = this.getTableColumn() != null && this.columnIndex != -1 && this.columnIndex == treeTableView.getVisibleLeafColumns().size() - 1;
        this.pseudoClassStateChanged(PSEUDO_CLASS_LAST_VISIBLE, this.isLastVisibleColumn);
    }

    private void updateSelection() {
        if (this.isEmpty()) {
            return;
        }
        boolean bl2 = this.isSelected();
        if (!this.isInCellSelectionMode()) {
            if (bl2) {
                ((Cell)this).updateSelected(false);
            }
            return;
        }
        Object object = this.getTreeTableView();
        if (this.getIndex() == -1 || object == null) {
            return;
        }
        if ((object = ((TreeTableView)object).getSelectionModel()) == null) {
            ((Cell)this).updateSelected(false);
            return;
        }
        boolean bl3 = ((TableSelectionModel)object).isSelected(this.getIndex(), this.getTableColumn());
        if (bl2 == bl3) {
            return;
        }
        ((Cell)this).updateSelected(bl3);
    }

    private void updateFocus() {
        boolean bl2 = this.isFocused();
        if (!this.isInCellSelectionMode()) {
            if (bl2) {
                this.setFocused(false);
            }
            return;
        }
        Object object = this.getTreeTableView();
        if (this.getIndex() == -1 || object == null) {
            return;
        }
        if ((object = ((TreeTableView)object).getFocusModel()) == null) {
            this.setFocused(false);
            return;
        }
        this.setFocused(((TreeTableView$TreeTableViewFocusModel)object).isFocused(this.getIndex(), this.getTableColumn()));
    }

    private void updateEditing() {
        Object object = this.getTreeTableView();
        if (this.getIndex() == -1 || object == null) {
            if (this.isEditing()) {
                this.doCancelEdit();
            }
            return;
        }
        boolean bl2 = this.match((TreeTablePosition)(object = ((TreeTableView)object).getEditingCell()));
        if (bl2 && !this.isEditing()) {
            ((Cell)this).startEdit();
            return;
        }
        if (!bl2 && this.isEditing()) {
            this.doCancelEdit();
        }
    }

    private void doCancelEdit() {
        try {
            this.updateEditingIndex = false;
            ((Cell)this).cancelEdit();
            return;
        }
        finally {
            this.updateEditingIndex = true;
        }
    }

    private boolean match(TreeTablePosition treeTablePosition) {
        return treeTablePosition != null && treeTablePosition.getRow() == this.getIndex() && treeTablePosition.getTableColumn() == this.getTableColumn();
    }

    private boolean isInCellSelectionMode() {
        TreeTableView<S> treeTableView = this.getTreeTableView();
        if (treeTableView == null) {
            return false;
        }
        return (treeTableView = treeTableView.getSelectionModel()) != null && ((TableSelectionModel)((Object)treeTableView)).isCellSelectionEnabled();
    }

    private void updateItem(int n2) {
        Object object;
        if (this.currentObservableValue != null) {
            this.currentObservableValue.removeListener(this.weaktableRowUpdateObserver);
        }
        TreeTableView<S> treeTableView = this.getTreeTableView();
        TreeTableColumn<int, T> treeTableColumn = this.getTableColumn();
        int n3 = treeTableView == null ? -1 : this.getTreeTableView().getExpandedItemCount();
        int n4 = this.getIndex();
        boolean bl2 = this.isEmpty();
        Object t2 = this.getItem();
        TreeTableRow<S> treeTableRow = this.getTableRow();
        treeTableRow = treeTableRow == null ? null : treeTableRow.getItem();
        if ((n3 = n4 >= n3 ? 1 : 0) != 0 || n4 < 0 || this.columnIndex < 0 || !this.isVisible() || treeTableColumn == null || !treeTableColumn.isVisible() || treeTableView.getRoot() == null) {
            if (!bl2 && t2 != null || this.isFirstRun || n3 != 0) {
                this.updateItem(null, true);
                this.isFirstRun = false;
            }
            return;
        }
        this.currentObservableValue = ((TableColumnBase)treeTableColumn).getCellObservableValue(n4);
        TreeTableView<S> treeTableView2 = treeTableView = this.currentObservableValue == null ? null : (TreeTableView<S>)this.currentObservableValue.getValue();
        if (n2 != n4 || this.isItemChanged(t2, treeTableView) || (object = this.oldRowItemRef != null ? (Object)this.oldRowItemRef.get() : null) == null || !object.equals(treeTableRow)) {
            this.updateItem(treeTableView, false);
        }
        this.oldRowItemRef = new WeakReference<TreeTableRow<S>>(treeTableRow);
        if (this.currentObservableValue == null) {
            return;
        }
        this.currentObservableValue.addListener(this.weaktableRowUpdateObserver);
    }

    @Override
    protected void layoutChildren() {
        if (this.itemDirty) {
            this.updateItem(-1);
            this.itemDirty = false;
        }
        super.layoutChildren();
    }

    public final void updateTreeTableView(TreeTableView<S> treeTableView) {
        this.setTreeTableView(treeTableView);
    }

    public final void updateTableRow(TreeTableRow<S> treeTableRow) {
        this.setTableRow(treeTableRow);
    }

    public final void updateTableColumn(TreeTableColumn<S, T> treeTableColumn) {
        TreeTableColumn<S, T> treeTableColumn2 = this.getTableColumn();
        if (treeTableColumn2 != null) {
            treeTableColumn2.getStyleClass().removeListener(this.weakColumnStyleClassListener);
            this.getStyleClass().removeAll((Collection<?>)treeTableColumn2.getStyleClass());
            treeTableColumn2.idProperty().removeListener(this.weakColumnIdListener);
            treeTableColumn2.styleProperty().removeListener(this.weakColumnStyleListener);
            String string = this.getId();
            String string2 = this.getStyle();
            if (string != null && string.equals(treeTableColumn2.getId())) {
                this.setId(null);
            }
            if (string2 != null && string2.equals(treeTableColumn2.getStyle())) {
                this.setStyle("");
            }
        }
        this.setTableColumn(treeTableColumn);
        if (treeTableColumn != null) {
            this.getStyleClass().addAll((Collection<String>)treeTableColumn.getStyleClass());
            treeTableColumn.getStyleClass().addListener(this.weakColumnStyleClassListener);
            treeTableColumn.idProperty().addListener(this.weakColumnIdListener);
            treeTableColumn.styleProperty().addListener(this.weakColumnStyleListener);
            this.possiblySetId(treeTableColumn.getId());
            this.possiblySetStyle(treeTableColumn.getStyle());
        }
    }

    @Deprecated(since="17")
    public final void updateTreeTableRow(TreeTableRow<S> treeTableRow) {
        this.updateTableRow(treeTableRow);
    }

    @Deprecated(since="17")
    public final void updateTreeTableColumn(TreeTableColumn<S, T> treeTableColumn) {
        this.updateTableColumn(treeTableColumn);
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new TreeTableCellSkin(this);
    }

    private void possiblySetId(String string) {
        if (this.getId() == null || this.getId().isEmpty()) {
            this.setId(string);
        }
    }

    private void possiblySetStyle(String string) {
        if (this.getStyle() == null || this.getStyle().isEmpty()) {
            this.setStyle(string);
        }
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objectArray) {
        switch (accessibleAttribute) {
            case ROW_INDEX: {
                return this.getIndex();
            }
            case COLUMN_INDEX: {
                return this.columnIndex;
            }
            case SELECTED: {
                if (this.isInCellSelectionMode()) {
                    return this.isSelected();
                }
                if (this.getTableRow() == null) {
                    return null;
                }
                return this.getTableRow().isSelected();
            }
        }
        return super.queryAccessibleAttribute(accessibleAttribute, objectArray);
    }

    @Override
    public void executeAccessibleAction(AccessibleAction object, Object ... objectArray) {
        switch (TreeTableCell$3.$SwitchMap$javafx$scene$AccessibleAction[((Enum)object).ordinal()]) {
            case 1: {
                object = this.getTreeTableView();
                if (object == null) break;
                if ((object = ((TreeTableView)object).getFocusModel()) != null) {
                    ((TreeTableView$TreeTableViewFocusModel)object).focus(this.getIndex(), this.getTableColumn());
                }
                return;
            }
            default: {
                super.executeAccessibleAction((AccessibleAction)((Object)object), objectArray);
            }
        }
    }
}

