/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import java.util.Collections;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn$1;
import javafx.scene.control.TreeTableColumn$2;
import javafx.scene.control.TreeTableColumn$3;
import javafx.scene.control.TreeTableColumn$4;
import javafx.scene.control.TreeTableColumn$5;
import javafx.scene.control.TreeTableColumn$6;
import javafx.scene.control.TreeTableColumn$CellDataFeatures;
import javafx.scene.control.TreeTableColumn$CellEditEvent;
import javafx.scene.control.TreeTableColumn$SortType;
import javafx.scene.control.TreeTableView;
import javafx.scene.control.skin.NestedTableColumnHeader;
import javafx.scene.control.skin.TableColumnHeader;
import javafx.scene.control.skin.TableHeaderRow;
import javafx.scene.control.skin.TreeTableViewSkin;
import javafx.util.Callback;

public class TreeTableColumn<S, T>
extends TableColumnBase<TreeItem<S>, T>
implements EventTarget {
    private static final EventType<?> EDIT_ANY_EVENT = new EventType<Event>(Event.ANY, "TREE_TABLE_COLUMN_EDIT");
    private static final EventType<?> EDIT_START_EVENT = new EventType(TreeTableColumn.editAnyEvent(), "EDIT_START");
    private static final EventType<?> EDIT_CANCEL_EVENT = new EventType(TreeTableColumn.editAnyEvent(), "EDIT_CANCEL");
    private static final EventType<?> EDIT_COMMIT_EVENT = new EventType(TreeTableColumn.editAnyEvent(), "EDIT_COMMIT");
    public static final Callback<TreeTableColumn<?, ?>, TreeTableCell<?, ?>> DEFAULT_CELL_FACTORY = new TreeTableColumn$1();
    private EventHandler<TreeTableColumn$CellEditEvent<S, T>> DEFAULT_EDIT_COMMIT_HANDLER = treeTableColumn$CellEditEvent -> {
        TreeItem treeItem = treeTableColumn$CellEditEvent.getRowValue();
        if (treeItem == null) {
            return;
        }
        if ((treeItem = this.getCellObservableValue(treeItem)) instanceof WritableValue) {
            ((WritableValue)((Object)treeItem)).setValue(treeTableColumn$CellEditEvent.getNewValue());
        }
    };
    private ListChangeListener<TreeTableColumn<S, ?>> columnsListener = new TreeTableColumn$2(this);
    private WeakListChangeListener<TreeTableColumn<S, ?>> weakColumnsListener = new WeakListChangeListener(this.columnsListener);
    private final ObservableList<TreeTableColumn<S, ?>> columns = FXCollections.observableArrayList();
    private ReadOnlyObjectWrapper<TreeTableView<S>> treeTableView = new ReadOnlyObjectWrapper(this, "treeTableView");
    private ObjectProperty<Callback<TreeTableColumn$CellDataFeatures<S, T>, ObservableValue<T>>> cellValueFactory;
    private final ObjectProperty<Callback<TreeTableColumn<S, T>, TreeTableCell<S, T>>> cellFactory;
    private ObjectProperty<TreeTableColumn$SortType> sortType;
    private ObjectProperty<EventHandler<TreeTableColumn$CellEditEvent<S, T>>> onEditStart;
    private ObjectProperty<EventHandler<TreeTableColumn$CellEditEvent<S, T>>> onEditCommit;
    private ObjectProperty<EventHandler<TreeTableColumn$CellEditEvent<S, T>>> onEditCancel;
    private static final String DEFAULT_STYLE_CLASS = "table-column";

    public static <S, T> EventType<TreeTableColumn$CellEditEvent<S, T>> editAnyEvent() {
        return EDIT_ANY_EVENT;
    }

    public static <S, T> EventType<TreeTableColumn$CellEditEvent<S, T>> editStartEvent() {
        return EDIT_START_EVENT;
    }

    public static <S, T> EventType<TreeTableColumn$CellEditEvent<S, T>> editCancelEvent() {
        return EDIT_CANCEL_EVENT;
    }

    public static <S, T> EventType<TreeTableColumn$CellEditEvent<S, T>> editCommitEvent() {
        return EDIT_COMMIT_EVENT;
    }

    public TreeTableColumn() {
        TreeTableColumn treeTableColumn = this;
        this.cellFactory = new TreeTableColumn$3(treeTableColumn, treeTableColumn, "cellFactory", DEFAULT_CELL_FACTORY);
        this.getStyleClass().add(DEFAULT_STYLE_CLASS);
        TreeTableColumn treeTableColumn2 = this;
        treeTableColumn2.setOnEditCommit(treeTableColumn2.DEFAULT_EDIT_COMMIT_HANDLER);
        ((TableColumnBase)this).getColumns().addListener(this.weakColumnsListener);
        this.treeTableViewProperty().addListener(object -> {
            for (TreeTableColumn treeTableColumn : ((TableColumnBase)this).getColumns()) {
                treeTableColumn.setTreeTableView(this.getTreeTableView());
            }
        });
    }

    public TreeTableColumn(String string) {
        this();
        this.setText(string);
    }

    public final ReadOnlyObjectProperty<TreeTableView<S>> treeTableViewProperty() {
        return this.treeTableView.getReadOnlyProperty();
    }

    final void setTreeTableView(TreeTableView<S> treeTableView) {
        this.treeTableView.set(treeTableView);
    }

    public final TreeTableView<S> getTreeTableView() {
        return (TreeTableView)this.treeTableView.get();
    }

    public final void setCellValueFactory(Callback<TreeTableColumn$CellDataFeatures<S, T>, ObservableValue<T>> callback) {
        this.cellValueFactoryProperty().set(callback);
    }

    public final Callback<TreeTableColumn$CellDataFeatures<S, T>, ObservableValue<T>> getCellValueFactory() {
        if (this.cellValueFactory == null) {
            return null;
        }
        return (Callback)this.cellValueFactory.get();
    }

    public final ObjectProperty<Callback<TreeTableColumn$CellDataFeatures<S, T>, ObservableValue<T>>> cellValueFactoryProperty() {
        if (this.cellValueFactory == null) {
            this.cellValueFactory = new SimpleObjectProperty<Callback<TreeTableColumn$CellDataFeatures<S, T>, ObservableValue<T>>>(this, "cellValueFactory");
        }
        return this.cellValueFactory;
    }

    public final void setCellFactory(Callback<TreeTableColumn<S, T>, TreeTableCell<S, T>> callback) {
        this.cellFactory.set(callback);
    }

    public final Callback<TreeTableColumn<S, T>, TreeTableCell<S, T>> getCellFactory() {
        return (Callback)this.cellFactory.get();
    }

    public final ObjectProperty<Callback<TreeTableColumn<S, T>, TreeTableCell<S, T>>> cellFactoryProperty() {
        return this.cellFactory;
    }

    public final ObjectProperty<TreeTableColumn$SortType> sortTypeProperty() {
        if (this.sortType == null) {
            this.sortType = new SimpleObjectProperty<TreeTableColumn$SortType>(this, "sortType", TreeTableColumn$SortType.ASCENDING);
        }
        return this.sortType;
    }

    public final void setSortType(TreeTableColumn$SortType treeTableColumn$SortType) {
        this.sortTypeProperty().set(treeTableColumn$SortType);
    }

    public final TreeTableColumn$SortType getSortType() {
        if (this.sortType == null) {
            return TreeTableColumn$SortType.ASCENDING;
        }
        return (TreeTableColumn$SortType)((Object)this.sortType.get());
    }

    public final void setOnEditStart(EventHandler<TreeTableColumn$CellEditEvent<S, T>> eventHandler) {
        this.onEditStartProperty().set(eventHandler);
    }

    public final EventHandler<TreeTableColumn$CellEditEvent<S, T>> getOnEditStart() {
        if (this.onEditStart == null) {
            return null;
        }
        return (EventHandler)this.onEditStart.get();
    }

    public final ObjectProperty<EventHandler<TreeTableColumn$CellEditEvent<S, T>>> onEditStartProperty() {
        if (this.onEditStart == null) {
            TreeTableColumn treeTableColumn = this;
            this.onEditStart = new TreeTableColumn$4(treeTableColumn, treeTableColumn, "onEditStart");
        }
        return this.onEditStart;
    }

    public final void setOnEditCommit(EventHandler<TreeTableColumn$CellEditEvent<S, T>> eventHandler) {
        this.onEditCommitProperty().set(eventHandler);
    }

    public final EventHandler<TreeTableColumn$CellEditEvent<S, T>> getOnEditCommit() {
        if (this.onEditCommit == null) {
            return null;
        }
        return (EventHandler)this.onEditCommit.get();
    }

    public final ObjectProperty<EventHandler<TreeTableColumn$CellEditEvent<S, T>>> onEditCommitProperty() {
        if (this.onEditCommit == null) {
            TreeTableColumn treeTableColumn = this;
            this.onEditCommit = new TreeTableColumn$5(treeTableColumn, treeTableColumn, "onEditCommit");
        }
        return this.onEditCommit;
    }

    public final void setOnEditCancel(EventHandler<TreeTableColumn$CellEditEvent<S, T>> eventHandler) {
        this.onEditCancelProperty().set(eventHandler);
    }

    public final EventHandler<TreeTableColumn$CellEditEvent<S, T>> getOnEditCancel() {
        if (this.onEditCancel == null) {
            return null;
        }
        return (EventHandler)this.onEditCancel.get();
    }

    public final ObjectProperty<EventHandler<TreeTableColumn$CellEditEvent<S, T>>> onEditCancelProperty() {
        if (this.onEditCancel == null) {
            TreeTableColumn treeTableColumn = this;
            this.onEditCancel = new TreeTableColumn$6(treeTableColumn, treeTableColumn, "onEditCancel");
        }
        return this.onEditCancel;
    }

    @Override
    public final ObservableList<TreeTableColumn<S, ?>> getColumns() {
        return this.columns;
    }

    @Override
    public final ObservableValue<T> getCellObservableValue(int n2) {
        if (n2 < 0) {
            return null;
        }
        TreeTableView<S> treeTableView = this.getTreeTableView();
        if (treeTableView == null || n2 >= treeTableView.getExpandedItemCount()) {
            return null;
        }
        TreeItem<S> treeItem = treeTableView.getTreeItem(n2);
        return this.getCellObservableValue(treeItem);
    }

    @Override
    public final ObservableValue<T> getCellObservableValue(TreeItem<S> object) {
        Callback<TreeTableColumn$CellDataFeatures<S, T>, ObservableValue<T>> callback = this.getCellValueFactory();
        if (callback == null) {
            return null;
        }
        TreeTableView<S> treeTableView = this.getTreeTableView();
        if (treeTableView == null) {
            return null;
        }
        object = new TreeTableColumn$CellDataFeatures(treeTableView, this, object);
        return callback.call((TreeTableColumn$CellDataFeatures<S, T>)object);
    }

    @Override
    public String getTypeSelector() {
        return "TreeTableColumn";
    }

    @Override
    public Styleable getStyleableParent() {
        return this.getTreeTableView();
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return TreeTableColumn.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Node getStyleableNode() {
        void var2_3;
        if (!(this.getTreeTableView().getSkin() instanceof TreeTableViewSkin)) {
            return null;
        }
        Object object = (TreeTableViewSkin)this.getTreeTableView().getSkin();
        Object node2 = null;
        for (Node node : ((SkinBase)object).getChildren()) {
            if (!(node instanceof TableHeaderRow)) continue;
            TableHeaderRow tableHeaderRow = (TableHeaderRow)node;
        }
        object = null;
        for (Node node : var2_3.getChildren()) {
            if (!(node instanceof NestedTableColumnHeader)) continue;
            object = (NestedTableColumnHeader)node;
        }
        return this.scan((TableColumnHeader)object);
    }

    private TableColumnHeader scan(TableColumnHeader tableColumnHeader) {
        if (this.equals(tableColumnHeader.getTableColumn())) {
            return tableColumnHeader;
        }
        if (tableColumnHeader instanceof NestedTableColumnHeader) {
            tableColumnHeader = (NestedTableColumnHeader)tableColumnHeader;
            for (int i2 = 0; i2 < ((NestedTableColumnHeader)tableColumnHeader).getColumnHeaders().size(); ++i2) {
                TableColumnHeader tableColumnHeader2 = this.scan((TableColumnHeader)((NestedTableColumnHeader)tableColumnHeader).getColumnHeaders().get(i2));
                if (tableColumnHeader2 == null) continue;
                return tableColumnHeader2;
            }
        }
        return null;
    }
}

