/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.WeakListChangeListener;
import javafx.css.PseudoClass;
import javafx.event.EventTarget;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.Cell;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.Skin;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTablePosition;
import javafx.scene.control.TreeTableRow$1;
import javafx.scene.control.TreeTableRow$2;
import javafx.scene.control.TreeTableRow$3;
import javafx.scene.control.TreeTableRow$4;
import javafx.scene.control.TreeTableView;
import javafx.scene.control.TreeTableView$EditEvent;
import javafx.scene.control.TreeTableView$TreeTableViewSelectionModel;
import javafx.scene.control.skin.TreeTableRowSkin;

public class TreeTableRow<T>
extends IndexedCell<T> {
    private final ListChangeListener<Integer> selectedListener = listChangeListener$Change -> this.updateSelection();
    private final InvalidationListener focusedListener = observable -> this.updateFocus();
    private final InvalidationListener editingListener = observable -> this.updateEditing();
    private final InvalidationListener leafListener = new TreeTableRow$1(this);
    private boolean oldExpanded;
    private final InvalidationListener treeItemExpandedInvalidationListener = observable -> {
        boolean bl2 = ((BooleanProperty)observable).get();
        this.pseudoClassStateChanged(EXPANDED_PSEUDOCLASS_STATE, bl2);
        this.pseudoClassStateChanged(COLLAPSED_PSEUDOCLASS_STATE, !bl2);
        if (bl2 != this.oldExpanded) {
            this.notifyAccessibleAttributeChanged(AccessibleAttribute.EXPANDED);
        }
        this.oldExpanded = bl2;
    };
    private final WeakListChangeListener<Integer> weakSelectedListener = new WeakListChangeListener<Integer>(this.selectedListener);
    private final WeakInvalidationListener weakFocusedListener = new WeakInvalidationListener(this.focusedListener);
    private final WeakInvalidationListener weakEditingListener = new WeakInvalidationListener(this.editingListener);
    private final WeakInvalidationListener weakLeafListener = new WeakInvalidationListener(this.leafListener);
    private final WeakInvalidationListener weakTreeItemExpandedInvalidationListener = new WeakInvalidationListener(this.treeItemExpandedInvalidationListener);
    private ReadOnlyObjectWrapper<TreeItem<T>> treeItem;
    private ObjectProperty<Node> disclosureNode;
    private ReadOnlyObjectWrapper<TreeTableView<T>> treeTableView;
    private int index;
    private boolean isFirstRun;
    private static final String DEFAULT_STYLE_CLASS = "tree-table-row-cell";
    private static final PseudoClass EXPANDED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("expanded");
    private static final PseudoClass COLLAPSED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("collapsed");

    public TreeTableRow() {
        TreeTableRow treeTableRow = this;
        this.treeItem = new TreeTableRow$2(treeTableRow, treeTableRow, "treeItem");
        this.disclosureNode = new SimpleObjectProperty<Node>(this, "disclosureNode");
        TreeTableRow treeTableRow2 = this;
        this.treeTableView = new TreeTableRow$3(treeTableRow2, treeTableRow2, "treeTableView");
        this.index = -1;
        this.isFirstRun = true;
        this.getStyleClass().addAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setAccessibleRole(AccessibleRole.TREE_TABLE_ROW);
    }

    private void setTreeItem(TreeItem<T> treeItem) {
        this.treeItem.set(treeItem);
    }

    public final TreeItem<T> getTreeItem() {
        return (TreeItem)this.treeItem.get();
    }

    public final ReadOnlyObjectProperty<TreeItem<T>> treeItemProperty() {
        return this.treeItem.getReadOnlyProperty();
    }

    public final void setDisclosureNode(Node node) {
        this.disclosureNodeProperty().set(node);
    }

    public final Node getDisclosureNode() {
        return (Node)this.disclosureNode.get();
    }

    public final ObjectProperty<Node> disclosureNodeProperty() {
        return this.disclosureNode;
    }

    private void setTreeTableView(TreeTableView<T> treeTableView) {
        this.treeTableView.set(treeTableView);
    }

    public final TreeTableView<T> getTreeTableView() {
        return (TreeTableView)this.treeTableView.get();
    }

    public final ReadOnlyObjectProperty<TreeTableView<T>> treeTableViewProperty() {
        return this.treeTableView.getReadOnlyProperty();
    }

    @Override
    void indexChanged(int n2, int n3) {
        this.index = this.getIndex();
        this.updateItem();
        this.updateSelection();
        this.updateFocus();
    }

    @Override
    public void startEdit() {
        TreeTableView<T> treeTableView = this.getTreeTableView();
        if (!this.isEditable() || treeTableView != null && !treeTableView.isEditable()) {
            return;
        }
        super.startEdit();
        if (treeTableView != null) {
            treeTableView.fireEvent(new TreeTableView$EditEvent<Object>((TreeTableView<Object>)treeTableView, TreeTableView.editStartEvent(), (TreeItem<Object>)this.getTreeItem(), this.getItem(), null));
            treeTableView.requestFocus();
        }
    }

    @Override
    public void commitEdit(T t2) {
        if (!this.isEditing()) {
            return;
        }
        TreeItem<T> treeItem = this.getTreeItem();
        TreeTableView<T> treeTableView = this.getTreeTableView();
        if (treeTableView != null) {
            treeTableView.fireEvent(new TreeTableView$EditEvent<T>(treeTableView, TreeTableView.editCommitEvent(), treeItem, this.getItem(), t2));
        }
        if (treeItem != null) {
            treeItem.setValue(t2);
            this.updateTreeItem(treeItem);
            this.updateItem(t2, false);
        }
        super.commitEdit(t2);
        if (treeTableView != null) {
            treeTableView.edit(-1, null);
            treeTableView.requestFocus();
        }
    }

    @Override
    public void cancelEdit() {
        if (!this.isEditing()) {
            return;
        }
        TreeTableView<T> treeTableView = this.getTreeTableView();
        if (treeTableView != null) {
            treeTableView.fireEvent(new TreeTableView$EditEvent<Object>((TreeTableView<Object>)treeTableView, TreeTableView.editCancelEvent(), (TreeItem<Object>)this.getTreeItem(), this.getItem(), null));
        }
        super.cancelEdit();
        if (treeTableView != null) {
            treeTableView.edit(-1, null);
            treeTableView.requestFocus();
        }
    }

    private void updateItem() {
        EventTarget eventTarget = this.getTreeTableView();
        if (eventTarget == null) {
            return;
        }
        boolean bl2 = this.index >= 0 && this.index < ((TreeTableView)eventTarget).getExpandedItemCount();
        TreeItem<T> treeItem = this.getTreeItem();
        boolean bl3 = this.isEmpty();
        if (bl2) {
            Object t2 = (eventTarget = ((TreeTableView)eventTarget).getTreeItem(this.index)) == null ? null : (Object)((TreeItem)eventTarget).getValue();
            this.updateTreeItem((TreeItem<T>)eventTarget);
            this.updateItem(t2, false);
            return;
        }
        if (!bl3 && treeItem != null || this.isFirstRun) {
            this.updateTreeItem(null);
            this.updateItem(null, true);
            this.isFirstRun = false;
        }
    }

    private void updateSelection() {
        boolean bl2;
        if (this.isEmpty()) {
            return;
        }
        if (this.index == -1 || this.getTreeTableView() == null) {
            return;
        }
        TreeTableView$TreeTableViewSelectionModel<T> treeTableView$TreeTableViewSelectionModel = this.getTreeTableView().getSelectionModel();
        if (treeTableView$TreeTableViewSelectionModel == null) {
            if (this.isSelected()) {
                this.updateSelected(false);
            }
            return;
        }
        boolean bl3 = bl2 = !treeTableView$TreeTableViewSelectionModel.isCellSelectionEnabled() && ((SelectionModel)treeTableView$TreeTableViewSelectionModel).isSelected(this.index);
        if (this.isSelected() != bl2) {
            this.updateSelected(bl2);
        }
    }

    private void updateFocus() {
        if (this.getIndex() == -1 || this.getTreeTableView() == null) {
            return;
        }
        if (this.getTreeTableView().getFocusModel() == null) {
            return;
        }
        TreeTableRow treeTableRow = this;
        treeTableRow.setFocused(treeTableRow.getTreeTableView().getFocusModel().isFocused(this.getIndex()));
    }

    private void updateEditing() {
        if (this.getIndex() == -1 || this.getTreeTableView() == null || this.getTreeItem() == null) {
            return;
        }
        TreeTablePosition<T, ?> treeTablePosition = this.getTreeTableView().getEditingCell();
        if (treeTablePosition != null && treeTablePosition.getTableColumn() != null) {
            return;
        }
        TreeTablePosition<T, ?> treeTablePosition2 = treeTablePosition = treeTablePosition == null ? null : treeTablePosition.getTreeItem();
        if (!this.isEditing() && this.getTreeItem().equals(treeTablePosition)) {
            ((Cell)this).startEdit();
            return;
        }
        if (this.isEditing() && !this.getTreeItem().equals(treeTablePosition)) {
            ((Cell)this).cancelEdit();
        }
    }

    public final void updateTreeTableView(TreeTableView<T> treeTableView) {
        this.setTreeTableView(treeTableView);
    }

    public final void updateTreeItem(TreeItem<T> treeItem) {
        TreeItem<T> treeItem2 = this.getTreeItem();
        if (treeItem2 != null) {
            treeItem2.leafProperty().removeListener(this.weakLeafListener);
        }
        this.setTreeItem(treeItem);
        if (treeItem != null) {
            treeItem.leafProperty().addListener(this.weakLeafListener);
        }
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new TreeTableRowSkin(this);
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute object, Object ... objectArray) {
        TreeItem<T> treeItem = this.getTreeItem();
        TreeTableView<T> treeTableView = this.getTreeTableView();
        switch (object) {
            case TREE_ITEM_PARENT: {
                if (treeItem == null) {
                    return null;
                }
                object = treeItem.getParent();
                if (object == null) {
                    return null;
                }
                int n2 = treeTableView.getRow((TreeItem<T>)object);
                return ((Node)treeTableView).queryAccessibleAttribute(AccessibleAttribute.ROW_AT_INDEX, n2);
            }
            case TREE_ITEM_COUNT: {
                if (treeItem == null) {
                    return 0;
                }
                if (!treeItem.isExpanded()) {
                    return 0;
                }
                return treeItem.getChildren().size();
            }
            case TREE_ITEM_AT_INDEX: {
                if (treeItem == null) {
                    return null;
                }
                if (!treeItem.isExpanded()) {
                    return null;
                }
                int n3 = (Integer)objectArray[0];
                if (n3 >= treeItem.getChildren().size()) {
                    return null;
                }
                TreeItem treeItem2 = (TreeItem)treeItem.getChildren().get(n3);
                if (treeItem2 == null) {
                    return null;
                }
                int n4 = treeTableView.getRow(treeItem2);
                return ((Node)treeTableView).queryAccessibleAttribute(AccessibleAttribute.ROW_AT_INDEX, n4);
            }
            case LEAF: {
                return treeItem == null ? true : treeItem.isLeaf();
            }
            case EXPANDED: {
                return treeItem == null ? false : treeItem.isExpanded();
            }
            case INDEX: {
                return this.getIndex();
            }
            case DISCLOSURE_LEVEL: {
                return treeTableView == null ? 0 : treeTableView.getTreeItemLevel(treeItem);
            }
        }
        return super.queryAccessibleAttribute((AccessibleAttribute)((Object)object), objectArray);
    }

    @Override
    public void executeAccessibleAction(AccessibleAction object, Object ... objectArray) {
        switch (TreeTableRow$4.$SwitchMap$javafx$scene$AccessibleAction[((Enum)object).ordinal()]) {
            case 1: {
                object = this.getTreeItem();
                if (object == null) break;
                ((TreeItem)object).setExpanded(true);
                return;
            }
            case 2: {
                object = this.getTreeItem();
                if (object == null) break;
                ((TreeItem)object).setExpanded(false);
                return;
            }
            default: {
                super.executeAccessibleAction((AccessibleAction)((Object)object), new Object[0]);
            }
        }
    }
}

