/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;

class TreeUtil {
    TreeUtil() {
    }

    static <T> int getExpandedDescendantCount(TreeItem<T> treeItem, boolean bl2) {
        if (treeItem == null) {
            return 0;
        }
        if (treeItem.isLeaf()) {
            return 1;
        }
        return treeItem.getExpandedDescendentCount(bl2);
    }

    static int updateExpandedItemCount(TreeItem treeItem, boolean bl2, boolean bl3) {
        if (treeItem == null) {
            return 0;
        }
        if (!treeItem.isExpanded()) {
            return 1;
        }
        int n2 = TreeUtil.getExpandedDescendantCount(treeItem, bl2);
        if (!bl3) {
            --n2;
        }
        return n2;
    }

    static <T> TreeItem<T> getItem(TreeItem<T> object, int n2, boolean bl2) {
        if (object == null) {
            return null;
        }
        if (n2 == 0) {
            return object;
        }
        if (n2 >= TreeUtil.getExpandedDescendantCount(object, bl2)) {
            return null;
        }
        if ((object = ((TreeItem)object).getChildren()) == null) {
            return null;
        }
        --n2;
        int n3 = object.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            TreeItem<T> treeItem = (TreeItem<T>)object.get(i2);
            if (n2 == 0) {
                return treeItem;
            }
            if (treeItem.isLeaf() || !treeItem.isExpanded()) {
                --n2;
                continue;
            }
            int n4 = TreeUtil.getExpandedDescendantCount(treeItem, bl2);
            if (n2 >= n4) {
                n2 -= n4;
                continue;
            }
            if ((treeItem = TreeUtil.getItem(treeItem, n2, bl2)) != null) {
                return treeItem;
            }
            --n2;
        }
        return null;
    }

    static <T> int getRow(TreeItem<T> treeItem, TreeItem<T> treeItem2, boolean bl2, boolean bl3) {
        if (treeItem == null) {
            return -1;
        }
        if (bl3 && treeItem.equals(treeItem2)) {
            return 0;
        }
        int n2 = 0;
        TreeItem<T> treeItem3 = treeItem;
        treeItem = treeItem.getParent();
        boolean bl4 = false;
        while (!treeItem3.equals(treeItem2) && treeItem != null) {
            if (!treeItem.isExpanded()) {
                bl4 = true;
                break;
            }
            ObservableList observableList = treeItem.children;
            int n3 = observableList.indexOf(treeItem3);
            for (int i2 = n3 - 1; i2 >= 0; --i2) {
                TreeItem treeItem4 = (TreeItem)observableList.get(i2);
                if (treeItem4 == null) continue;
                n2 += TreeUtil.getExpandedDescendantCount(treeItem4, bl2);
                if (!treeItem4.equals(treeItem2)) continue;
                if (!bl3) {
                    return -1;
                }
                return n2;
            }
            treeItem3 = treeItem;
            if ((treeItem = treeItem.getParent()) == null && !treeItem3.equals(treeItem2)) {
                return -1;
            }
            ++n2;
        }
        if (treeItem == null && n2 == 0 || bl4) {
            return -1;
        }
        if (bl3) {
            return n2;
        }
        return n2 - 1;
    }
}

