/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WeakChangeListener;
import javafx.event.EventHandler;
import javafx.event.WeakEventHandler;
import javafx.scene.AccessibleAttribute;
import javafx.scene.control.FocusModel;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeItem$TreeModificationEvent;
import javafx.scene.control.TreeView;
import javafx.scene.control.TreeView$TreeViewFocusModel$1;

class TreeView$TreeViewFocusModel<T>
extends FocusModel<TreeItem<T>> {
    private final TreeView<T> treeView;
    private final ChangeListener<TreeItem<T>> rootPropertyListener = (observableValue, treeItem, treeItem2) -> this.updateTreeEventListener((TreeItem<T>)treeItem, (TreeItem<T>)treeItem2);
    private final WeakChangeListener<TreeItem<T>> weakRootPropertyListener = new WeakChangeListener<TreeItem<TreeItem<T>>>(this.rootPropertyListener);
    private final InvalidationListener showRootListener;
    private EventHandler<TreeItem$TreeModificationEvent<T>> treeItemListener = new TreeView$TreeViewFocusModel$1(this);
    private WeakEventHandler<TreeItem$TreeModificationEvent<T>> weakTreeItemListener;

    public TreeView$TreeViewFocusModel(TreeView<T> treeView) {
        this.treeView = treeView;
        this.treeView.rootProperty().addListener(this.weakRootPropertyListener);
        this.updateTreeEventListener(null, treeView.getRoot());
        if (treeView.getExpandedItemCount() > 0) {
            ((FocusModel)this).focus(0);
        }
        this.showRootListener = observable -> {
            if (this.isFocused(0)) {
                ((FocusModel)this).focus(-1);
                ((FocusModel)this).focus(0);
            }
        };
        treeView.showRootProperty().addListener(new WeakInvalidationListener(this.showRootListener));
        this.focusedIndexProperty().addListener(observable -> treeView.notifyAccessibleAttributeChanged(AccessibleAttribute.FOCUS_ITEM));
    }

    private void updateTreeEventListener(TreeItem<T> treeItem, TreeItem<T> treeItem2) {
        if (treeItem != null && this.weakTreeItemListener != null) {
            treeItem.removeEventHandler(TreeItem.expandedItemCountChangeEvent(), this.weakTreeItemListener);
        }
        if (treeItem2 != null) {
            this.weakTreeItemListener = new WeakEventHandler<TreeItem$TreeModificationEvent<TreeItem$TreeModificationEvent<T>>>(this.treeItemListener);
            treeItem2.addEventHandler(TreeItem.expandedItemCountChangeEvent(), this.weakTreeItemListener);
        }
    }

    @Override
    protected int getItemCount() {
        if (this.treeView == null) {
            return -1;
        }
        return this.treeView.getExpandedItemCount();
    }

    @Override
    protected TreeItem<T> getModelItem(int n2) {
        if (this.treeView == null) {
            return null;
        }
        if (n2 < 0 || n2 >= this.treeView.getExpandedItemCount()) {
            return null;
        }
        return this.treeView.getTreeItem(n2);
    }

    @Override
    public void focus(int n2) {
        if (this.treeView.expandedItemCountDirty) {
            this.treeView.updateExpandedItemCount(this.treeView.getRoot());
        }
        super.focus(n2);
    }
}

