/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.cell;

import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Cell;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.cell.CellUtils$1;
import javafx.scene.control.cell.CellUtils$2;
import javafx.scene.control.cell.CellUtils$3;
import javafx.scene.control.skin.ComboBoxListViewSkin;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.util.StringConverter;

class CellUtils {
    static int TREE_VIEW_HBOX_GRAPHIC_PADDING = 3;
    private static final StringConverter<?> defaultStringConverter = new CellUtils$1();
    private static final StringConverter<?> defaultTreeItemStringConverter = new CellUtils$2();

    CellUtils() {
    }

    static <T> StringConverter<T> defaultStringConverter() {
        return defaultStringConverter;
    }

    static <T> StringConverter<TreeItem<T>> defaultTreeItemStringConverter() {
        return defaultTreeItemStringConverter;
    }

    private static <T> String getItemText(Cell<T> cell, StringConverter<T> stringConverter) {
        if (stringConverter == null) {
            if (cell.getItem() == null) {
                return "";
            }
            return cell.getItem().toString();
        }
        return stringConverter.toString(cell.getItem());
    }

    static Node getGraphic(TreeItem<?> treeItem) {
        if (treeItem == null) {
            return null;
        }
        return treeItem.getGraphic();
    }

    static <T> void updateItem(Cell<T> cell, StringConverter<T> stringConverter, ChoiceBox<T> choiceBox) {
        CellUtils.updateItem(cell, stringConverter, null, null, choiceBox);
    }

    static <T> void updateItem(Cell<T> cell, StringConverter<T> stringConverter, HBox hBox, Node node, ChoiceBox<T> choiceBox) {
        if (cell.isEmpty()) {
            cell.setText(null);
            cell.setGraphic(null);
            return;
        }
        if (cell.isEditing()) {
            if (choiceBox != null) {
                ((SelectionModel)choiceBox.getSelectionModel()).select(cell.getItem());
            }
            cell.setText(null);
            if (node != null) {
                hBox.getChildren().setAll((Node[])new Node[]{node, choiceBox});
                cell.setGraphic(hBox);
                return;
            }
            cell.setGraphic(choiceBox);
            return;
        }
        Cell<T> cell2 = cell;
        cell2.setText(CellUtils.getItemText(cell2, stringConverter));
        cell.setGraphic(node);
    }

    static <T> ChoiceBox<T> createChoiceBox(Cell<T> cell, ObservableList<T> object, ObjectProperty<StringConverter<T>> objectProperty) {
        object = new ChoiceBox<T>(object);
        ((Region)object).setMaxWidth(Double.MAX_VALUE);
        ((ChoiceBox)object).converterProperty().bind(objectProperty);
        ((ChoiceBox)object).showingProperty().addListener(arg_0 -> CellUtils.lambda$createChoiceBox$0((ChoiceBox)object, cell, arg_0));
        return object;
    }

    static <T> void updateItem(Cell<T> cell, StringConverter<T> stringConverter, TextField textField) {
        CellUtils.updateItem(cell, stringConverter, null, null, textField);
    }

    static <T> void updateItem(Cell<T> cell, StringConverter<T> stringConverter, HBox hBox, Node node, TextField textField) {
        if (cell.isEmpty()) {
            cell.setText(null);
            cell.setGraphic(null);
            return;
        }
        if (cell.isEditing()) {
            if (textField != null) {
                textField.setText(CellUtils.getItemText(cell, stringConverter));
            }
            cell.setText(null);
            if (node != null) {
                hBox.getChildren().setAll((Node[])new Node[]{node, textField});
                cell.setGraphic(hBox);
                return;
            }
            cell.setGraphic(textField);
            return;
        }
        Cell<T> cell2 = cell;
        cell2.setText(CellUtils.getItemText(cell2, stringConverter));
        cell.setGraphic(node);
    }

    static <T> void startEdit(Cell<T> cell, StringConverter<T> stringConverter, HBox hBox, Node node, TextField textField) {
        if (textField != null) {
            textField.setText(CellUtils.getItemText(cell, stringConverter));
        }
        cell.setText(null);
        if (node != null) {
            hBox.getChildren().setAll((Node[])new Node[]{node, textField});
            cell.setGraphic(hBox);
        } else {
            cell.setGraphic(textField);
        }
        textField.selectAll();
        textField.requestFocus();
    }

    static <T> void cancelEdit(Cell<T> cell, StringConverter<T> stringConverter, Node node) {
        Cell<T> cell2 = cell;
        cell2.setText(CellUtils.getItemText(cell2, stringConverter));
        cell.setGraphic(node);
    }

    static <T> TextField createTextField(Cell<T> cell, StringConverter<T> stringConverter) {
        TextField textField = new TextField(CellUtils.getItemText(cell, stringConverter));
        textField.setOnAction(actionEvent -> {
            if (stringConverter == null) {
                throw new IllegalStateException("Attempting to convert text input into Object, but provided StringConverter is null. Be sure to set a StringConverter in your cell factory.");
            }
            cell.commitEdit(stringConverter.fromString(textField.getText()));
            actionEvent.consume();
        });
        textField.setOnKeyReleased(keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ESCAPE) {
                cell.cancelEdit();
                keyEvent.consume();
            }
        });
        return textField;
    }

    static <T> void updateItem(Cell<T> cell, StringConverter<T> stringConverter, ComboBox<T> comboBox) {
        CellUtils.updateItem(cell, stringConverter, null, null, comboBox);
    }

    static <T> void updateItem(Cell<T> cell, StringConverter<T> stringConverter, HBox hBox, Node node, ComboBox<T> comboBox) {
        if (cell.isEmpty()) {
            cell.setText(null);
            cell.setGraphic(null);
            return;
        }
        if (cell.isEditing()) {
            if (comboBox != null) {
                ((SelectionModel)comboBox.getSelectionModel()).select(cell.getItem());
            }
            cell.setText(null);
            if (node != null) {
                hBox.getChildren().setAll((Node[])new Node[]{node, comboBox});
                cell.setGraphic(hBox);
                return;
            }
            cell.setGraphic(comboBox);
            return;
        }
        Cell<T> cell2 = cell;
        cell2.setText(CellUtils.getItemText(cell2, stringConverter));
        cell.setGraphic(node);
    }

    static <T> ComboBox<T> createComboBox(Cell<T> cell, ObservableList<T> object, ObjectProperty<StringConverter<T>> objectProperty) {
        object = new ComboBox<T>(object);
        ((ComboBox)object).converterProperty().bind(objectProperty);
        ((Region)object).setMaxWidth(Double.MAX_VALUE);
        ((Node)object).addEventFilter(KeyEvent.KEY_RELEASED, arg_0 -> CellUtils.lambda$createComboBox$3((ComboBox)object, cell, arg_0));
        ((ComboBox)object).getEditor().focusedProperty().addListener(arg_0 -> CellUtils.lambda$createComboBox$4((ComboBox)object, cell, arg_0));
        boolean bl2 = CellUtils.listenToComboBoxSkin(object, cell);
        if (!bl2) {
            ((Control)object).skinProperty().addListener(new CellUtils$3((ComboBox)object, cell));
        }
        return object;
    }

    private static <T> void tryComboBoxCommit(ComboBox<T> comboBox, Cell<T> cell) {
        StringConverter<T> stringConverter = comboBox.getConverter();
        if (comboBox.isEditable() && stringConverter != null) {
            comboBox = stringConverter.fromString(comboBox.getEditor().getText());
            cell.commitEdit(comboBox);
            return;
        }
        cell.commitEdit(comboBox.getValue());
    }

    private static <T> boolean listenToComboBoxSkin(ComboBox<T> comboBox, Cell<T> cell) {
        Object object = comboBox.getSkin();
        if (object != null && object instanceof ComboBoxListViewSkin) {
            object = (ComboBoxListViewSkin)object;
            if ((object = ((ComboBoxListViewSkin)object).getPopupContent()) != null && object instanceof ListView) {
                ((Node)object).addEventHandler(MouseEvent.MOUSE_RELEASED, mouseEvent -> cell.commitEdit(comboBox.getValue()));
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void lambda$createComboBox$4(ComboBox comboBox, Cell cell, Observable observable) {
        if (!comboBox.isFocused()) {
            CellUtils.tryComboBoxCommit(comboBox, cell);
        }
    }

    private static /* synthetic */ void lambda$createComboBox$3(ComboBox comboBox, Cell cell, KeyEvent keyEvent) {
        if (keyEvent.getCode() == KeyCode.ENTER) {
            CellUtils.tryComboBoxCommit(comboBox, cell);
            return;
        }
        if (keyEvent.getCode() == KeyCode.ESCAPE) {
            cell.cancelEdit();
        }
    }

    private static /* synthetic */ void lambda$createChoiceBox$0(ChoiceBox choiceBox, Cell cell, Observable observable) {
        if (!choiceBox.isShowing()) {
            cell.commitEdit(choiceBox.getSelectionModel().getSelectedItem());
        }
    }
}

