/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.cell;

import java.lang.ref.WeakReference;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.scene.Node;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.cell.DefaultTreeCell$1;
import javafx.scene.layout.HBox;

class DefaultTreeCell<T>
extends TreeCell<T> {
    private HBox hbox;
    private WeakReference<TreeItem<T>> treeItemRef;
    private InvalidationListener treeItemGraphicListener = observable -> {
        DefaultTreeCell defaultTreeCell = this;
        defaultTreeCell.updateDisplay(defaultTreeCell.getItem(), this.isEmpty());
    };
    private InvalidationListener treeItemListener = new DefaultTreeCell$1(this);
    private WeakInvalidationListener weakTreeItemGraphicListener = new WeakInvalidationListener(this.treeItemGraphicListener);
    private WeakInvalidationListener weakTreeItemListener = new WeakInvalidationListener(this.treeItemListener);

    public DefaultTreeCell() {
        this.treeItemProperty().addListener(this.weakTreeItemListener);
        if (this.getTreeItem() != null) {
            this.getTreeItem().graphicProperty().addListener(this.weakTreeItemGraphicListener);
        }
    }

    void updateDisplay(T t2, boolean bl2) {
        if (t2 == null || bl2) {
            this.hbox = null;
            this.setText(null);
            this.setGraphic(null);
            return;
        }
        TreeItem treeItem = this.getTreeItem();
        if (treeItem != null && treeItem.getGraphic() != null) {
            if (t2 instanceof Node) {
                this.setText(null);
                if (this.hbox == null) {
                    this.hbox = new HBox(3.0);
                }
                this.hbox.getChildren().setAll((Node[])new Node[]{treeItem.getGraphic(), (Node)t2});
                DefaultTreeCell defaultTreeCell = this;
                defaultTreeCell.setGraphic(defaultTreeCell.hbox);
                return;
            }
            this.hbox = null;
            this.setText(t2.toString());
            this.setGraphic(treeItem.getGraphic());
            return;
        }
        this.hbox = null;
        if (t2 instanceof Node) {
            this.setText(null);
            this.setGraphic((Node)t2);
            return;
        }
        this.setText(t2.toString());
        this.setGraphic(null);
    }

    @Override
    public void updateItem(T t2, boolean bl2) {
        super.updateItem(t2, bl2);
        this.updateDisplay(t2, bl2);
    }
}

