/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.control.ListenerHelper;
import com.sun.javafx.scene.control.behavior.AccordionBehavior;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Accordion;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TitledPane;
import javafx.scene.control.skin.TitledPaneSkin;
import javafx.scene.shape.Rectangle;

public class AccordionSkin
extends SkinBase<Accordion> {
    private TitledPane firstTitledPane;
    private Rectangle clipRect;
    private boolean forceRelayout = false;
    private boolean relayout = false;
    private double previousHeight = 0.0;
    private TitledPane expandedPane = null;
    private TitledPane previousPane = null;
    private Map<TitledPane, ChangeListener<Boolean>> listeners = new HashMap<TitledPane, ChangeListener<Boolean>>();
    private final BehaviorBase<Accordion> behavior;

    public AccordionSkin(Accordion accordion) {
        super(accordion);
        this.behavior = new AccordionBehavior(accordion);
        ListenerHelper listenerHelper = ListenerHelper.get(this);
        listenerHelper.addListChangeListener(accordion.getPanes(), listChangeListener$Change -> {
            if (this.firstTitledPane != null) {
                this.firstTitledPane.getStyleClass().remove("first-titled-pane");
            }
            if (!accordion.getPanes().isEmpty()) {
                this.firstTitledPane = (TitledPane)accordion.getPanes().get(0);
                this.firstTitledPane.getStyleClass().add("first-titled-pane");
            } else {
                this.firstTitledPane = null;
            }
            this.getChildren().setAll((Collection<Node>)accordion.getPanes());
            while (listChangeListener$Change.next()) {
                this.removeTitledPaneListeners(listChangeListener$Change.getRemoved());
                this.initTitledPaneListeners(listChangeListener$Change.getAddedSubList());
            }
            this.forceRelayout = true;
        });
        if (!accordion.getPanes().isEmpty()) {
            this.firstTitledPane = (TitledPane)accordion.getPanes().get(0);
            this.firstTitledPane.getStyleClass().add("first-titled-pane");
        }
        this.clipRect = new Rectangle(accordion.getWidth(), accordion.getHeight());
        ((Accordion)this.getSkinnable()).setClip(this.clipRect);
        this.initTitledPaneListeners(accordion.getPanes());
        this.getChildren().setAll((Collection<Node>)accordion.getPanes());
        ((Parent)((Accordion)this.getSkinnable())).requestLayout();
        listenerHelper.addChangeListener(((Accordion)this.getSkinnable()).widthProperty(), number -> this.clipRect.setWidth(((Accordion)this.getSkinnable()).getWidth()));
        listenerHelper.addChangeListener(((Accordion)this.getSkinnable()).heightProperty(), number -> {
            this.clipRect.setHeight(((Accordion)this.getSkinnable()).getHeight());
            this.relayout = true;
        });
    }

    @Override
    public void dispose() {
        if (this.getSkinnable() == null) {
            return;
        }
        AccordionSkin accordionSkin = this;
        accordionSkin.removeTitledPaneListeners(((Accordion)accordionSkin.getSkinnable()).getPanes());
        if (this.behavior != null) {
            this.behavior.dispose();
        }
        super.dispose();
    }

    @Override
    protected double computeMinHeight(double d2, double d3, double d4, double d5, double d6) {
        double d7 = 0.0;
        if (this.expandedPane != null) {
            d7 = 0.0 + ((Node)this.expandedPane).minHeight(d2);
        }
        if (this.previousPane != null && !this.previousPane.equals(this.expandedPane)) {
            d7 += ((Node)this.previousPane).minHeight(d2);
        }
        for (Node node : this.getChildren()) {
            TitledPane titledPane = (TitledPane)node;
            if (titledPane.equals(this.expandedPane) || titledPane.equals(this.previousPane)) continue;
            Skin<?> skin = ((TitledPane)node).getSkin();
            if (skin instanceof TitledPaneSkin) {
                TitledPaneSkin titledPaneSkin = (TitledPaneSkin)skin;
                d7 += titledPaneSkin.getTitleRegionSize(d2);
                continue;
            }
            d7 += ((Node)titledPane).minHeight(d2);
        }
        return d7 + d3 + d5;
    }

    @Override
    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        double d7 = 0.0;
        if (this.expandedPane != null) {
            d7 = 0.0 + ((Node)this.expandedPane).prefHeight(d2);
        }
        if (this.previousPane != null && !this.previousPane.equals(this.expandedPane)) {
            d7 += ((Node)this.previousPane).prefHeight(d2);
        }
        for (Node node : this.getChildren()) {
            TitledPane titledPane = (TitledPane)node;
            if (titledPane.equals(this.expandedPane) || titledPane.equals(this.previousPane)) continue;
            Skin<?> skin = ((TitledPane)node).getSkin();
            if (skin instanceof TitledPaneSkin) {
                TitledPaneSkin titledPaneSkin = (TitledPaneSkin)skin;
                d7 += titledPaneSkin.getTitleRegionSize(d2);
                continue;
            }
            d7 += ((Node)titledPane).prefHeight(d2);
        }
        return d7 + d3 + d5;
    }

    @Override
    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        boolean bl2 = this.forceRelayout || this.relayout && this.previousHeight != d5;
        this.forceRelayout = false;
        this.previousHeight = d5;
        double d6 = 0.0;
        for (TitledPane titledPane : ((Accordion)this.getSkinnable()).getPanes()) {
            if (titledPane.equals(this.expandedPane)) continue;
            TitledPaneSkin titledPaneSkin = (TitledPaneSkin)titledPane.getSkin();
            d6 += this.snapSizeY(titledPaneSkin.getTitleRegionSize(d4));
        }
        double d7 = d5 - d6;
        for (TitledPane titledPane : ((Accordion)this.getSkinnable()).getPanes()) {
            double d8;
            Skin<?> skin = titledPane.getSkin();
            if (skin instanceof TitledPaneSkin) {
                ((TitledPaneSkin)skin).setMaxTitledPaneHeightForAccordion(d7);
                d8 = this.snapSizeY(((TitledPaneSkin)skin).getTitledPaneHeightForAccordion());
            } else {
                d8 = ((Node)titledPane).prefHeight(d4);
            }
            ((Node)titledPane).resize(d4, d8);
            boolean bl3 = true;
            if (!bl2 && this.previousPane != null && this.expandedPane != null) {
                ObservableList<TitledPane> observableList = ((Accordion)this.getSkinnable()).getPanes();
                int n2 = observableList.indexOf(this.previousPane);
                int n3 = observableList.indexOf(this.expandedPane);
                int n4 = observableList.indexOf(titledPane);
                if (n2 < n3 ? n4 <= n3 : n2 <= n3 || n4 <= n2) {
                    titledPane.relocate(d2, d3);
                    d3 += d8;
                    bl3 = false;
                }
            }
            if (!bl3) continue;
            titledPane.relocate(d2, d3);
            d3 += d8;
        }
    }

    private void initTitledPaneListeners(List<? extends TitledPane> object) {
        object = object.iterator();
        while (object.hasNext()) {
            TitledPane titledPane;
            titledPane.setExpanded((titledPane = (TitledPane)object.next()) == ((Accordion)this.getSkinnable()).getExpandedPane());
            if (titledPane.isExpanded()) {
                this.expandedPane = titledPane;
            }
            ChangeListener<Boolean> changeListener = this.expandedPropertyListener(titledPane);
            titledPane.expandedProperty().addListener(changeListener);
            this.listeners.put(titledPane, changeListener);
        }
    }

    private void removeTitledPaneListeners(List<? extends TitledPane> object) {
        object = object.iterator();
        while (object.hasNext()) {
            TitledPane titledPane = (TitledPane)object.next();
            if (!this.listeners.containsKey(titledPane)) continue;
            titledPane.expandedProperty().removeListener(this.listeners.get(titledPane));
            this.listeners.remove(titledPane);
        }
    }

    private ChangeListener<Boolean> expandedPropertyListener(TitledPane titledPane) {
        return (object, bl2, bl3) -> {
            this.previousPane = this.expandedPane;
            object = (Accordion)this.getSkinnable();
            if (bl3.booleanValue()) {
                if (this.expandedPane != null) {
                    this.expandedPane.setExpanded(false);
                }
                if (titledPane != null) {
                    ((Accordion)((Object)object)).setExpandedPane(titledPane);
                }
                this.expandedPane = ((Accordion)((Object)object)).getExpandedPane();
                return;
            }
            this.expandedPane = null;
            ((Accordion)((Object)object)).setExpandedPane(null);
        };
    }
}

