/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.control.ListenerHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonBar$ButtonData;
import javafx.scene.control.SkinBase;
import javafx.scene.control.skin.ButtonBarSkin$1;
import javafx.scene.control.skin.ButtonBarSkin$Spacer;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;

public class ButtonBarSkin
extends SkinBase<ButtonBar> {
    private static final double GAP_SIZE = 10.0;
    private static final String CATEGORIZED_TYPES = "LRHEYNXBIACO";
    private static final double DO_NOT_CHANGE_SIZE = Double.MAX_VALUE;
    private HBox layout;
    private InvalidationListener buttonDataListener = observable -> this.layoutButtons();

    public ButtonBarSkin(ButtonBar buttonBar) {
        super(buttonBar);
        this.layout = new ButtonBarSkin$1(this, 10.0);
        this.layout.setAlignment(Pos.CENTER);
        this.layout.getStyleClass().add("container");
        this.getChildren().add(this.layout);
        this.layoutButtons();
        ListenerHelper listenerHelper = ListenerHelper.get(this);
        this.updateButtonListeners(buttonBar.getButtons(), true);
        listenerHelper.addListChangeListener(buttonBar.getButtons(), listChangeListener$Change -> {
            while (listChangeListener$Change.next()) {
                this.updateButtonListeners(listChangeListener$Change.getRemoved(), false);
                this.updateButtonListeners(listChangeListener$Change.getAddedSubList(), true);
            }
            this.layoutButtons();
        });
        listenerHelper.addChangeListener(buttonBar.buttonOrderProperty(), string -> this.layoutButtons());
        listenerHelper.addChangeListener(buttonBar.buttonMinWidthProperty(), number -> this.resizeButtons());
    }

    @Override
    public void dispose() {
        if (this.getSkinnable() == null) {
            return;
        }
        ButtonBarSkin buttonBarSkin = this;
        buttonBarSkin.updateButtonListeners(((ButtonBar)buttonBarSkin.getSkinnable()).getButtons(), false);
        this.getChildren().remove(this.layout);
        super.dispose();
    }

    private void updateButtonListeners(List<? extends Node> object, boolean bl2) {
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = (Node)object.next();
                if (!(object2 = ((Node)object2).getProperties()).containsKey("javafx.scene.control.ButtonBar.ButtonData") || (object2 = (ObjectProperty)object2.get("javafx.scene.control.ButtonBar.ButtonData")) == null) continue;
                if (bl2) {
                    object2.addListener(this.buttonDataListener);
                    continue;
                }
                object2.removeListener(this.buttonDataListener);
            }
        }
    }

    private void layoutButtons() {
        Iterator iterator = (ButtonBar)this.getSkinnable();
        Object object = ((ButtonBar)((Object)iterator)).getButtons();
        double d2 = ((ButtonBar)((Object)iterator)).getButtonMinWidth();
        iterator = ((ButtonBar)this.getSkinnable()).getButtonOrder();
        this.layout.getChildren().clear();
        if (iterator == null) {
            throw new IllegalStateException("ButtonBar buttonOrder string can not be null");
        }
        if (((String)((Object)iterator)).equals("")) {
            ButtonBarSkin$Spacer.DYNAMIC.add(this.layout, true);
            iterator = object.iterator();
            while (iterator.hasNext()) {
                object = (Node)iterator.next();
                this.sizeButton((Node)object, d2, Double.MAX_VALUE, Double.MAX_VALUE);
                this.layout.getChildren().add((Node)object);
                HBox.setHgrow((Node)object, Priority.NEVER);
            }
            return;
        }
        this.doButtonOrderLayout((String)((Object)iterator));
    }

    private void doButtonOrderLayout(String object) {
        Object object2;
        boolean bl2;
        Object object3;
        int n2;
        Object object4 = (ButtonBar)this.getSkinnable();
        ObservableList<Node> observableList = ((ButtonBar)object4).getButtons();
        double d2 = ((ButtonBar)object4).getButtonMinWidth();
        object4 = this.buildButtonMap(observableList);
        object = ((String)object).toCharArray();
        int n3 = 0;
        ButtonBarSkin$Spacer buttonBarSkin$Spacer = ButtonBarSkin$Spacer.NONE;
        for (n2 = 0; n2 < ((Object)object).length; ++n2) {
            boolean bl3;
            object3 = object[n2];
            bl2 = n3 <= 0 && n3 >= observableList.size() - 1;
            boolean bl4 = bl3 = !this.layout.getChildren().isEmpty();
            if (object3 == 43) {
                buttonBarSkin$Spacer = buttonBarSkin$Spacer.replace(ButtonBarSkin$Spacer.DYNAMIC);
                continue;
            }
            if (object3 == 95 && bl3) {
                buttonBarSkin$Spacer = buttonBarSkin$Spacer.replace(ButtonBarSkin$Spacer.FIXED);
                continue;
            }
            object2 = (List)object4.get(String.valueOf((char)object3).toUpperCase());
            if (object2 == null) continue;
            buttonBarSkin$Spacer.add(this.layout, bl2);
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                this.sizeButton(node, d2, Double.MAX_VALUE, Double.MAX_VALUE);
                this.layout.getChildren().add(node);
                HBox.setHgrow(node, Priority.NEVER);
                ++n3;
            }
            buttonBarSkin$Spacer = buttonBarSkin$Spacer.replace(ButtonBarSkin$Spacer.NONE);
        }
        n2 = 0;
        object3 = observableList.size();
        for (bl2 = false; bl2 < object3; bl2 += 1) {
            Node node = (Node)observableList.get(bl2 ? 1 : 0);
            if (!(node instanceof Button) || !((Button)node).isDefaultButton()) continue;
            node.requestFocus();
            n2 = 1;
            break;
        }
        if (n2 == 0) {
            for (bl2 = false; bl2 < object3; bl2 += 1) {
                Node node = (Node)observableList.get(bl2 ? 1 : 0);
                object2 = ButtonBar.getButtonData(node);
                if (object2 == null || !object2.isDefaultButton()) continue;
                node.requestFocus();
                return;
            }
        }
    }

    private void resizeButtons() {
        Node node;
        Object object = (ButtonBar)this.getSkinnable();
        double d2 = ((ButtonBar)object).getButtonMinWidth();
        object = ((ButtonBar)object).getButtons();
        double d3 = d2;
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            node = (Node)iterator.next();
            if (!ButtonBar.isButtonUniformSize(node)) continue;
            d3 = Math.max(node.prefWidth(-1.0), d3);
        }
        iterator = object.iterator();
        while (iterator.hasNext()) {
            node = (Node)iterator.next();
            if (!ButtonBar.isButtonUniformSize(node)) continue;
            this.sizeButton(node, Double.MAX_VALUE, d3, Double.MAX_VALUE);
        }
    }

    private void sizeButton(Node node, double d2, double d3, double d4) {
        if (node instanceof Region) {
            node = (Region)node;
            if (d2 != Double.MAX_VALUE) {
                ((Region)node).setMinWidth(d2);
            }
            if (d3 != Double.MAX_VALUE) {
                ((Region)node).setPrefWidth(d3);
            }
            if (d4 != Double.MAX_VALUE) {
                ((Region)node).setMaxWidth(d4);
            }
        }
    }

    private String getButtonType(Node object) {
        if ((object = ButtonBar.getButtonData((Node)object)) == null) {
            object = ButtonBar$ButtonData.OTHER;
        }
        Object object2 = object = ((String)(object = ((ButtonBar$ButtonData)((Object)object)).getTypeCode())).length() > 0 ? ((String)object).substring(0, 1) : "";
        if (CATEGORIZED_TYPES.contains(((String)object).toUpperCase())) {
            return object;
        }
        return ButtonBar$ButtonData.OTHER.getTypeCode();
    }

    private Map<String, List<Node>> buildButtonMap(List<? extends Node> object) {
        HashMap<String, List<Node>> hashMap = new HashMap<String, List<Node>>();
        object = object.iterator();
        while (object.hasNext()) {
            Node node = (Node)object.next();
            if (node == null) continue;
            String string = this.getButtonType(node);
            ArrayList<Node> arrayList = (ArrayList<Node>)hashMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<Node>();
                hashMap.put(string, arrayList);
            }
            arrayList.add(node);
        }
        return hashMap;
    }
}

